/*****************************************************************************/
/*  Retrieve interface for E3      Ralph Yozzo                               */
/*                                                                           */
/*  Acknowledgements                                                         */
/*  Bryan Lewis significantly improved the handling of the c_pgdn and        */
/*  c_pgup key.                                                              */
/*                                                                           */
/*  retrieves commands from the hidden file "coms.e".                        */
/*  this avoids the need for endless uparrows and/or downarrows.             */
/*  this simulates the ? operator in RETRIEVE.COM by Jack Gersbach           */
/*  Have you ever tried to recall a command in E and repeatedly              */
/*  pressed the uparrow. Sometimes it would be just as fast and less         */
/*  keystrokes to retype the command.                                        */
/*  Well, Retrieve is for you.                                               */
/*                                                                           */
/*  Retrieve will search through your stacked commands and                   */
/*  return a match to the command line.                                      */
/*  You can also clear the command stack.                                    */
/*                                                                           */
/*  Defined keys:                                                            */
/*  The following keys have been reprogrammed while commandstate is true.    */
/*  (i.e., the cursor is on the commandline).  They retain their             */
/*  orginal function otherwise.                                              */
/*                                                                           */
/*  ctrl-pgup - clears the command stack                                     */
/*  ctrl-pgdn - deletes the current command from the command stack           */
/*                                                                           */
/*  examples                                                                 */
/*  r myte                                                                   */
/*  retrieves commands such as "mytecopy a:retrieve.e h:retrieve e a"        */
/*  r /c                                                                     */
/*  this will clear the command stack                                        */
/*  note:                                                                    */
/*  The locate commands below will use a ascii 1 as a delimiter.             */
/*  So the smilely faces that you see in the file on the PC are not          */
/*  a mistake, but an ingenious method to guard against the user             */
/*  passing a parameter which contains a delimiter.  Credit goes to          */
/*  Bryan Lewis.  (I know you're saying what if the user wants to search     */
/*  for ascii one) hopefully, this occurs rarely :-)                        */
/*****************************************************************************/
/*  Modified by Larry Margolis to be simpler, by using COMSFILEID.  Also,    */
/*  omitted the Ctrl-pgup - I hated accidentally deleting my past commands.  */
/*  Deleted ryedit routine.  Now done by activating fileids.                 */
/*****************************************************************************/
/*  Modified by Larry Margolis to define two commands.  The first, R, does   */
/*  what it always did.  The second, RF, does a Retrieve, but matching the   */
/*  command only if found starting in the First column.                      */
/*****************************************************************************/
/*  Many thanks to Tom Rogers for some of the ideas in the latest modification*/
/*****************************************************************************/

/****************************************************************************
   Included is the implementation of RETRIEVE's CTRL-W function in E3
     added by Dan Kardell.  Taken from Russ Williams old retrieve macro.
     (Placed on Ctrl-Y, since Ctrl-W was already in use.)
 *****************************************************************************/
/*  Modified by Larry Margolis to remove screen flashing and greatly         */
/*  optimize the retrieve window.                                            */
/*****************************************************************************/
-- Sat Jun 24 07:55:36 pm 1989
--  Retrieve's Windowing function has been modified by Larry Margolis.
--  The '?' operator has been added to E for all versions greater than
--  4.11

/*
 *   universal ANSICHARS
 *   delimiter=chr(verify(ANSICHARS,LocateTarget)-1)
 *   "L" delimiter||LocateTarget||delimiter
 *
 *   we will convert the unique delimiter to the algorithm
 *   above.
 *
 *  Many thanks to Jim Hurley for pointing out the idea above.
 */
/*
 * c_minus - will delete the current command
 *      and will repeat the most recent 'r' command
 *      This is used in the following scenario.
 *      The command stack contains:
 *         cl c:\short\path\filename.c
 *         cl c:\very\long\path\and\filename.c
 *      We wish to retrieve "cl c:\very\long\path\and\filename.c"
 *      and 'r' returns "cl c:\short\path\filename.c"
 *      Our solution is to press c_minus
 *      This avoids the need to type 'r cl c:\'
 *
 *      This is effectively a "find next" match.
 */

def c_minus
 universal RETRIEVE_argument
 call RETRIEVE_delete_entry()
 call coms_retrieve( RETRIEVE_argument )

/*
 * rr - will repeat the most recent 'r' command.
 *      This is used in the following scenario.
 *      The command stack contains:
 *         cl c:\short\path\filename.c
 *         cl c:\very\long\path\and\filename.c
 *      We wish to retrieve "cl c:\very\long\path\and\filename.c"
 *      and 'r' returns "cl c:\short\path\filename.c"
 *      Our solution is to delete "cl c:\short\path\filename.c"
 *      using Ctrl-PgDn and then issuing the 'rr' command.
 *      This avoids the need to type 'r cl c:\'
 */
defc rr
 universal RETRIEVE_argument
 call coms_retrieve( RETRIEVE_argument , 'r' )

compile if EVERSION < '4.12'
defc r =
compile else
defc r,? =                              -- the '?' command is now valid in e
compile endif
   call coms_retrieve(arg(1))
defc rf = call coms_retrieve(arg(1),'f')

defproc coms_retrieve=
   universal comsfileid
   universal RETRIEVE_argument
   if arg(1)='' then
      call remove('r')
      sayerror 'Retrieve commands [/c]=clear stack [string]=search '
      return 1
   endif
   getfileid fileid
   activatefile comsfileid
   call psave_mark(savemark)    -- LAM:  save user's previous mark, if any
   if arg(1)='/c' then
      top
      unmark
      mark_line
      bottom
      mark_line
      call pdelete_mark()
      call prestore_mark(savemark)    -- LAM:  restore user's previous mark.
      sayerror CMD_STACK_CLEAR__MSG  -- LAM:  Sayerror restores top level ring.
      return 1
   endif
   RETRIEVE_argument = arg(1)

   call remove('r'arg(2) arg(1))  -- Delete the command just typed (that called us).

   top
   if arg(2) then
      call pset_mark(1,.last,1,length(arg(1)),'BLOCK',comsfileid)
      m = 'm'
   else
      m = ''
   endif
   'xcom L 'arg(1)'c'm   /* unused character ascii 1 for search delimiter */
   lrc = rc
   call prestore_mark(savemark)    -- LAM:  restore user's previous mark.
   activatefile fileid
   if lrc<>0 then
      sayerror -273  -- 'String not found'
      return 1
   endif
   getline line,comsfileid.line,comsfileid
   setcommand line,length(line)+1,1

;delete Retrieve command
;remove the "r xxx" from the coms.e file
;where xxx is argument supplied by the user
defproc remove(comm)       -- LAM:  coms.e need not be active file.
   universal comsfileid
   getline nline,comsfileid.last,comsfileid
   if substr(nline,1,length(comm))=comm then
      deleteline comsfileid.last,comsfileid
   endif

/*   LAM:  I pressed ctrl-PgUp without realizing I was on the command line
           too many times.  Very annoying.  Can still do "R /C" to delete.
def c_pgup=
   if command_state() then   /* if press c_pgup on the command line */
      'r /c'
   else
      .cursory=1              /* in data area, do the old c_pgup key */
   endif
*/

def c_pgdn=  -- LAM:  Changed so we never leave the active file.
 call RETRIEVE_delete_entry()

defproc RETRIEVE_delete_entry
   universal comsfileid
   if command_state() then   /* if press c_pgdn on the command line */
      getcommand cur_cmd_line
      getline coms_cmd_line,comsfileid.line,comsfileid
      if cur_cmd_line=coms_cmd_line then
         deleteline comsfileid.line,comsfileid
         if comsfileid.last=0 then   /* list is empty */
;;          'r /c'         -- LAM:  Why clear?  already empty.
            sayerror CMD_STACK_EMPTY__MSG
            setcommand ''  -- LAM: Clear the command line.
            return
         endif
                 /* get next line after deletion, like Retrieve.Com */
;                   LAM:  Note:  deleteline leaves .line on previous line.
         newline=min(comsfileid.line+1,comsfileid.last)
         getline line,newline,comsfileid
         comsfileid.line=newline
         setcommand line,1,1
      endif
   else
      .cursory=.windowheight  /* do the old c_pgdn key */
   endif

/****************************************************************************
   Included is the implementation of RETRIEVE's CTRL-W function in E3
     added by Dan Kardell.  Taken from Russ Williams old retrieve macro
 ***************************************************************************/

;def c_w=  c_w is already used by EOS2
def c_y=
   call RETRIEVE_window()

defproc RETRIEVE_window
   newwindow 'e /w /n coms.e'
   call sizepopup(45,11,35,15,1)
   bottom
   line=select_a_command()
   sayerror 0
   line
   cursorcommand

defproc select_a_command
   call psave_mark(save_mark)
   cursor_data
   begin_line
   return_str=''
   sayerror '* RETRIEVE * ,=scroll  ENTER=execute  ESC=quit  F10=get cmd Ctrl-F10=Clear all'
   loop
      markline
      k=getkey()
      if k=esc then
         leave
      endif
      if k=up & .line<>1 then
         unmark; up
      elseif k=down then
         unmark; down
      elseif k=pgup then
         unmark; page_up
      elseif k=pgdn then
         unmark; page_down
      elseif k=c_home or k=home then
         unmark; top
      elseif k=c_end or k=end then
         unmark; bottom
      elseif k=c_F10 then
         top
         unmark
         mark_line
         bottom
         mark_line
         call pdelete_mark()
      elseif k=c_backspace then
         delete_mark; down
      elseif k=f10 then
         getline line
         cursor_command
         begin_line; erase_end_line
         keyin line
         Leave
      elseif k=enter then
         getline return_str
         leave
      endif
   endloop
   call prestore_mark(save_mark)
   .modify=0
   'xcom q'
   return return_str

