/*
 * Name         shell
 *
 * Author       Ralph Yozzo
 *
 * Purpose      These commands provide an interface to the internal
 *              shell processor of E.
 *              The shell processor allows one to execute programs
 *              which use the standard input,output and error file handles
 *              (known as (stdin, stdout and stderr) to "C" programmers)
 *              AS IF the program interfaced directly with the E buffers.
 *
 *              This means that stdout and stderr direct output into
 *              an E memory image of a file (also, known as an E buffer)
 *              rather than an actual disk file.
 *
 * Application  We may wish to compile in one window and continue editing
 *              in another window.  The functions provided here give us
 *              this ability.
 *
 * Example      The following command will invoke the "C" compiler
 *              asynchronously (in other words, we do not wait for the
 *              command to complete before returning control to the user).
 *
 *              shell cl ourfile.c
 *
 * Example      Since we are sending our commands to the command interpreter
 *              we may build any command that is valid.
 *              For example,
 *
 *              shell dir & tree
 *              is valid.
 *
 * Extensions   Now that we have access to the error file of a compiler
 *              during the compilation process, we can extend E to
 *              provide a next_error function (not shown here).
 *              The next_error function would place us on the next error
 *              and allow us to correct it before the compilation is
 *              completed.
 *
 * Interface    shell
 *              - is provided in order to initially send a command to
 *                command interpreter.
 *
 *              shell_write
 *              - allows us to write to the input pipe of the child process
 *                - This is useful for command which require input.
 *                  For example,
 *
 *                  shell time
 *
 *                   would require a
 *
 *                  shell_write 12:00
 *
 *                   in order to set the time.
 *
 *              shell_kill
 *              - allows us to kill the child process
 *
 * Modifications
 *  08/31/88
 *   - added a windowing option
 *     (The credit for this change goes to Bryan Lewis)
 */
defc shell
compile if EVERSION < 5
   savetof = top_of_file_fixed
   top_of_file_fixed = 0
compile endif
   getfileid OriginalFileIdentification
   call openshellwindow()
   line=.line; .cursory=.windowheight; line     /* newtop */
   refresh
   getfileid ShellFileIdentification
   call shell(arg(1),1,ShellFileIdentification)
   sayerror 0                                /* Erase "New file" message. */
compile if EVERSION < 5
   top_of_file_fixed = savetof
compile endif

defproc openshellwindow=
   /* Snazzier:  pop a window with a dummy file, insert text into it. */
   getfileid shell_fid, '.shell'   /* If already exists, reuse it. */
   if shell_fid = '' then
      /* jbl 12/30/88:  just edit the file, no window.
       *newwindow 'E /w /n .shell'                         /* Create pop-up */
       *sayerror 0                             /* Erase "New file" message. */
       *call sizepopup(1,1,screenwidth(),screenheight()%2,1) /* top of screen.*/
       */
      'E /n .shell'
      sayerror 0
      call SHELL_fill()
   else
      activatefile shell_fid
   endif
-- .windowoverlap=1

defc shellprefix=
   uparg=upcase(arg(1))
   if uparg=ON__MSG or uparg=1 then
      'xcom shellprefix 1'
   elseif uparg=OFF__MSG or uparg='0' then
      'xcom shellprefix 0'
   else
      sayerror INVALID_ARG__MSG ON_OFF__MSG')'
      stop
   endif


defc shell_hidden,sh
   getfileid OriginalFileIdentification
   'e /n .sh'
   if rc= -282 then  -- sayerror("New file")
      call SHELL_fill()
   endif
   line=.line; .cursory=.windowheight; line      /*@ newtop */
   getfileid ShellFileIdentification
   call shell(arg(1),ShellFileIdentification.last,ShellFileIdentification)
   activatefile OriginalFileIdentification

defc shell_write,shw
   call shell_write(arg(1))

defc shell_kill,shk
   call shell_kill()

defproc SHELL_fill
 for i = 1 to .windowheight
  insertline ''
 endfor
