NAME
     fastmail - quick batch mail interface to a single address

SYNOPSIS
     fastmail [-b bcc-list] [-c cc-list] [-d] [-f fromname] [-r  replyto]  [-s
     subject] filename address-list

DESCRIPTION
     Fastmail is a low-level interface to the mail system  that  allows  batch
     processing  of  mail.   It's intended for mailing to very large groups of
     people in a staggered fashion.

     The starting options are;

     -b bcc-list This allows a list of people to receive blind-carbon  copies,
                 or  BCCs,  of  the  message.   This list should be full email
                 addresses.

     -c cc-list  This allows a list of people to  receive  carbon  copies,  or
                 CCs,  of  the  message.   This  list  should  be  full  email
                 addresses.

     -d          Debug.  This is helpful for strange, unfriendly  errors  from
                 the program (etc).

     -f from     This overrides the users name in the From: line, so  that  if
                 the  user  was  x@y,  and their name was MrX then the default
                 From: line would be "From: x@y (MrX)".  Using "-f  Joe"  when
                 invoking this, though, would change it to "From: x@y (Joe)"

     -r replyto  Occasionally, you might send mail but want the replies to  go
                 to  a  different  address  (very  common with mailing lists).
                 There is a header for this purpose called  "Reply-To:"  which
                 can  be utilized by using this starting option.  For example,
                 we could send mail with a reply-to to list-request  by  using
                 "-r list-request".  The header generated would then be of the
                 form "Reply-To: list-request".

     -s subject  The subject  of  the  message  is  specified  by  using  this
                 starting option.

EXAMPLE
     Let's say we're user "big" on machine  "big-vax"  and  we  have  a  shell
     script called 'batch-mail' that contains the following lines:

        #
        # Batch Mail - batch mailing of a file to a LOT of users
        #
        # Usage: batch-mail "from" "subject" filename

        sender_copy = $LOGIN
        replto = "The-Mr-Big-list"

        fastmail -b $sender_copy -r $replyto -f "$1" -s "$2" $3 person1
        sleep 10
        fastmail -r $replyto -f "$1" -s "$2" $3 person2
        sleep 10
        fastmail -r $replyto -f "$1" -s "$2" $3 person3
        sleep 10
        fastmail -r $replyto -f "$1" -s "$2" $3 person4

        < etc >

     with the invocation:

        batch-mail "Mr. Big" "Warning to all" warning.text

     would mail a  copy  of  the  'warning.text'  file  to  person1,  person2,
     person3,  etc.  "$LOGIN" will also receive a copy of the first message in
     the mail, silently.  Each resultant message will include the headers:

         From: big-vax!big (Mr. Big)
         Subject: Warning to all
         Reply-To: The-Mr-Big-list

     This  program  should  turn  out  to  be  considerably  faster  than  the
     alternative methods of accomplishing this task.

FILES
     /usr/lib/sendmail       sendmail transport if available
     /bin/rmail              transport if no sendmail
     /tmp/fastmail.$$        temporary file

AUTHOR
     Dave Taylor, Hewlett-Packard Laboratories

SEE ALSO
     sendmail(1), rmail(1), elm(1L)

BUG REPORTS TO
     Syd Weinstein elm@DSI.COM (dsinc!elm)

COPYRIGHTS
     (c) Copyright 1986, 1987 by Dave Taylor
     (c) Copyright 1988, 1989, 1990 by The USENET Community Trust
