#include <stdlib.h>
#include <iostream.h>
#include <fstream.h>
#include <string.h>
#include <signal.h>

#include "mailto.h"
#include "smtpsession.h"
#include "smtpsession.hpp"

int main(int argc, char* argv[])
{
    char *hname, *argtype, *argdata, *argtemp, *frname, *toname, *dfname,
         *mvar, *pstring, *ulistfile;
    USHORT rport;
    BOOL noDateHeader=FALSE;
    SMTPSession *ss;
    int i, slen;

    #ifdef __MINGW32__
        WSADATA winjunk;
    #endif

    rport=25;

    hname = new char[TSIZE];
    pstring = new char[TSIZE];
    argtype = new char[TSIZE];
    argdata = new char[TSIZE];
    argtemp = new char[TSIZE];
    frname = new char[TSIZE];
    toname = new char[TSIZE];
    dfname = new char[TSIZE];
    ulistfile = new char[TSIZE];

    memset(hname, 0, TSIZE);
    memset(pstring, 0, TSIZE);
    memset(frname, 0, TSIZE);
    memset(toname, 0, TSIZE);
    memset(dfname, 0, TSIZE);
    memset(ulistfile, 0, TSIZE);

    mvar=getenv("SMTPHOST");
    if (mvar!=NULL)
        strcpy(hname, mvar);

    for (i=1; i<argc; i++)
        {
        if (strlen(argv[i])<3)
            {
            cout << endl << "Invalid option (" << argv[i] << ")." << endl;
            Usage();
            }
        memset(argtype, 0, TSIZE);
        memset(argdata, 0, TSIZE);
        memset(argtemp, 0, TSIZE);
        strncpy(argtype, argv[i], 2);
        strcpy(argdata, argv[i]+2);
        if (!strcmpi(argtype, "/s") || !strcmpi(argtype, "-s"))
            {
            strcpy(argtemp, argdata);
            if (strchr(argtemp, ':')==NULL)
                {
                strcpy(hname, argdata);
                }
            else
                {
                char *toktemp;
                toktemp=strtok(argtemp, ":");
                strcpy(hname, toktemp);
                toktemp=strtok(NULL, ":");
                if (toktemp==NULL)
                    {
                    cout << endl << "Invalid server:port combination ("
                         << argdata << ")." << endl;
                    Usage();
                    }
                strcpy(pstring, toktemp);
                rport=(USHORT)atoi(pstring);
                if (rport==0)
                    {
                    cout << endl << "Invalid port string (" << pstring << ")." << endl;
                    Usage();
                    }
                }
            }
        else if (!strcmpi(argtype, "/f") || !strcmpi(argtype, "-f"))
            {
            strcpy(frname, argdata);
            }
        else if (!strcmpi(argtype, "/t") || !strcmpi(argtype, "-t"))
            {
            strcpy(toname, argdata);
            }
        else if (!strcmpi(argtype, "/d") || !strcmpi(argtype, "-d"))
            {
            strcpy(dfname, argdata);
            }
        else if (!strcmpi(argtype, "/u") || !strcmpi(argtype, "-u"))
            {
            strcpy(ulistfile, argdata);
            }
        else if ((!strcmpi(argtype, "/n") || !strcmpi(argtype, "-n")) &&
                !strcmpi(argdata, "d"))
            {
            noDateHeader=TRUE;            
            }
        else if (!strcmpi(argtype, "/h") || !strcmpi(argtype, "-h") ||
                 !strcmpi(argtype, "/?") || !strcmpi(argtype, "-?"))
            {
            Usage();
            }
        else
            {
            cout << endl << "Invalid option (" << argv[i] << ")." << endl;
            Usage();
            }
        }

    if (!strcmp(hname, "") || !strcmp(frname, "") || !strcmp(dfname, ""))
        Usage();

    if (!strcmp(toname, "") && !strcmp(ulistfile, ""))
        Usage();

    #ifdef __MINGW32__
        WSAStartup(0x0101, &winjunk);
    #endif

    ss = new SMTPSession;

    ss->setHost(hname);
    ss->setPort(rport);

    cout << endl;

    cout << "Connecting to " << hname << " on port " << rport << "... " << flush;
    if (!ss->openConnection())
        {
        SMTPFailure(ss->failureCause());
        cout << "Failed" << endl;
        return 1;
        }
    cout << "Done" << endl;

    if (!ss->sendSender(frname))
        {
        SMTPFailure(ss->failureCause());
        return 1;
        }

    if (strcmp(ulistfile, "")!=0)
        {
        ifstream ufile;
        char uname[256];

        ufile.open(ulistfile, ios::nocreate | ios::in);
        if (ufile.fail())
            {
            SMTPFailure(SMTPS_FAILURE_LOCALOPENFAILURE);
            return 1;
            }

        while (!ufile.eof())
            {
            ufile.getline(uname, sizeof(uname)-1);
            if (!ufile.eof())
                {
                if (!ss->sendReceiver(uname))
                    {
                    SMTPFailure(ss->failureCause());
                    return 1;
                    }
                }
            }
        ufile.close();
        }
    else
        {
        if (!ss->sendReceiver(toname))
            {
            SMTPFailure(ss->failureCause());
            return 1;
            }
        }

    if (!ss->sendMailData(dfname, noDateHeader))
        {
        SMTPFailure(ss->failureCause());
        return 1;
        }
    cout << endl;
    if (!ss->sendClose())
        {
        SMTPFailure(ss->failureCause());
        return 1;
        }

    #ifdef __linux__
    cout << endl;
    #endif

    delete[] argtype;
    delete[] argdata;
    delete[] argtemp;
    delete[] dfname;
    delete[] frname;
    delete[] toname;
    delete[] hname;

    return 0;
}

void Usage(void)
{
    cout << endl << "Usage:  mailto <options>" << endl << endl;
    cout << "Options:" << endl << endl;
    cout << "/s<smtp server> - SMTP server to use" << endl;
    cout << "/f<from address> - from e-mail address" << endl;
    cout << "/t<to address> - to e-mail address" << endl;
    cout << "/d<filename> - file containing mail data to send" << endl;
    cout << "/u<filename> - file containing list of addresses" << endl;
    cout << "/nd - do not generate Date header line" << endl;
    cout << endl << "Ex. mailto /ssmtp.myisp.com /fme@myisp.com /tyou@yourisp.com /dmsg.txt" << endl;
    #ifdef __linux__
    cout << endl;
    #endif
    exit(1);
}

void SMTPFailure(ULONG fcause)
{
    switch(fcause)
        {
        case SMTPS_FAILURE_NONE:

            break;

        case SMTPS_FAILURE_UNKNOWN:

            cout << "There was an unspecified error." << endl;
            break;

        case SMTPS_FAILURE_SOCKET:

            cout << "A socket failure was encountered." << endl;
            break;

        case SMTPS_FAILURE_COMMAND:

            cout << "The SMTP command has failed." << endl;
            break;

        case SMTPS_FAILURE_UNKNOWN_HOST:

            cout << "Unable to resolve hostname." << endl;
            break;

        case SMTPS_FAILURE_NOCONNECT:

            cout << "Unable to connect to remote host." << endl;
            break;

        case SMTPS_FAILURE_LOCALOPENFAILURE:

            cout << "Unable to open local file." << endl;
            break;

        case SMTPS_FAILURE_OUTOFMEMORY:

            cout << "Out of memory." << endl;
            break;
        
        case SMTPS_FAILURE_TIMEOUT:

            cout << "Timed out waiting for host." << endl;
            break;

        case SMTPS_FAILURE_CONNTIMEOUT:

            cout << "Timed out trying to connect." << endl;
            break;

        default:

            break;
        }
    return;
}
