/* Copyright (c)1996 Kari Jackson for InnoVal Systems Solutions, Inc. */
/* To copy or move *.POP files to another directory without */
/* overwriting existing files by the same names */
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
signal on syntax name NoREXX
call SysLoadFuncs
signal on syntax name Syntax
signal on halt name Halt
'@ECHO OFF'
parse arg firstarg secondarg thirdarg .
if firstarg='' then do
   say ""
   say "Parameters:"
   say "-----------"
   say "1.  Source file specification:  If a directory name, the program will add"
   say "    *.POP to the end of it.  If not a directory, the program will add"
   say "    .POP to the end of it unless it already ends with .POP."
   say "2.  Target file specification:  A directory name.  If omitted, the files"
   say "    will be copied to the current directory.  If specified directory does"
   say "    not exist, it will be created, with permission."
   say "3.  Add an /M switch to the end of the command if you want to move the"
   say "    files rather than copying them."
   exit
end
move=0
first.0=1
if length(firstarg)=3 & right(firstarg,2)=':\' then first.1=left(firstarg,2)
else call sysfiletree firstarg,'first','DO'
if firstarg\="*" & first.0>1 then do
   say ""
   say "Parameter ("firstarg") not understood...."
   say "Multiple directories by that name exist:"
   say ""
   do i=1 to first.0
      say first.i
   end
   exit
end
if firstarg\="*" & first.0=1 then source=first.1'\*.POP'
if firstarg="*" | first.0=0 then do
   if translate(right(firstarg,4))='.POP' then source=firstarg
   else source=firstarg'.POP'
end
select
   when translate(secondarg)='/M' then do
      move=1
      target=directory()
   end
   when secondarg='' then target=directory()
   otherwise do
      target=secondarg
      check.0=1
      if (length(target)=3 & right(target,2)=':\')|(length(target)=2 & right(target,1)=":") then check.1=target
      else call sysfiletree target,'check','DO'
      if check.0>1 then do
         say ""
         say "Parameter ("target") not understood...."
         say "Multiple directories by that name exist:"
         say ""
         do i=1 to check.0
            say check.i
         end
         exit
      end
      if check.0=0 then do
         say ""
         say "Directory ("target") does not exist.  Create it (Y/n)?"
         if translate(sysgetkey())='N' then exit
         if sysmkdir(target)>0 then do
            say ""
            say "Error ("result") trying to create directory ("target")."
            exit
         end
      end
      if check.0=1 then target=check.1
   end
end
if translate(thirdarg)='/M' then move=1
call sysfiletree source,'files','FO'
if files.0=0 then do
   say ""
   say "No" source "file(s) found."
   exit
end
say ""
if right(target,1)='\' then target=substr(target,1,length(target)-1)
do i=1 to files.0
   lastslash=lastpos('\',files.i)+1
   parse var files.i . =(lastslash) filename
   if stream(target'\'filename,'c','query exists')<>'' then do
      parse var filename filename '.' .
      parse var filename five 6 six 7 seven 8 eight
      if length(eight)>1 then do
         say ""
         say "Filename ("filename") is longer than eight characters;"
         say "this is not valid for a *.POP file name.  Skipping this file...."
         say ""
         iterate
      end
      okay=0
      filename=translate(filename)
      characters='0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ'
      origpos6=pos(six,characters)
      origpos7=pos(seven,characters)
      origpos8=pos(eight,characters)
      newpos6=origpos6
      newpos7=origpos7
      newchar6=six
      newchar7=seven
      do j=1 to 36 until okay=1
         do k=1 to 36 until okay=1
            do l=1 to 36 until okay=1
               newpos8=(origpos8+l)//36
               if newpos8=0 then newpos8=36
               newchar8=substr(characters,newpos8,1)
               filename=five||newchar6||newchar7||newchar8
               if stream(target'\'filename'.POP','c','query exists')='' then okay=1
            end
            newpos7=(origpos7+k)//36
            if newpos7=0 then newpos7=36
            newchar7=substr(characters,newpos7,1)
         end
         newpos6=(origpos6+j)//36
         if newpos6=0 then newpos6=36
         newchar6=substr(characters,newpos6,1)
      end
      if okay=0 then do
         say ""
         say "There are already 46,656 files in the" target
         say "directory with" five"???.POP filenames!"
         exit
      end
      filename=filename'.POP'
   end
   say files.i "-->" target'\'filename
   'copy' files.i target'\'filename
   if rc=0 & move=1 then call sysfiledelete files.i
end
exit
Syntax:
  say 'Error' rc 'in line' sigl':' errortext(rc)
  say sigl':' sourceline(sigl)
  exit
return
Halt:
   say 'CopyPop.CMD interrupted by Ctrl-C, ShutDown, or closing of WorkArea.'
   exit
return
NoREXX:
   say 'Unable to load the REXXUtil functions.  Either the REXXUTIL.DLL file'
   say 'is not on the LIBPATH or REXX support is not installed on this system.'
   exit
return
