/*
 * This file is (C) Chris Wohlgemuth 2001
 *
 * It's part of the RexxMail class for even better WPS
 * integration of RexxMail (http://www.degeus.com).
 *
 * http://www.geocities.com/SiliconValley/Sector/5785/
 */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#define INCL_WINSYS
#define INCL_WINWORKPLACE

#define INCL_WPCLASS
#define INCL_GPILCIDS
#define INCL_GPIPRIMITIVES
#define INCL_GPIBITMAPS
#define INCL_DOS
#define INCL_DOSERRORS
#define INCL_WINTIMER
#define INCL_DOSMISC

#include "mailfile.hh"
#include <os2.h>

#include <string.h>//for strcpy
#include <stdio.h>   // for sprintf
#include <stdlib.h>
 
#include "mailfile.h"
#include "wpclsmgr.hh"

/**************************************************************/
/*                                                            */
/*  Return the class title.                                   */
/*                                                            */
/**************************************************************/
PSZ M_CWMailFile::wpclsQueryTitle()
{
	return MAILCLASS_TITLE;
}

/**************************************************************/
/*                                                            */
/* Overriden function: wpclsCreateDefaultTemplates()          */
/*                                                            */
/* This class doesn't need a default template. So tell the    */
/* WPS we create our own template or otherwise the templates  */
/* folder will do it.                                         */
/*                                                            */
/**************************************************************/
BOOL M_CWMailFile::wpclsCreateDefaultTemplates(WPObject* Folder)
{
  /* Tell the WPS we create our own templates */
  return TRUE;
}

/**************************************************************/
/*                                                            */
/*  Initialize the class:                                     */
/*                                                            */
/*  Get the INI file and read the NLS strings for the         */
/*  column titles.                                            */
/*  Prepare the static structs for the details view.          */
/*                                                            */
/**************************************************************/
void M_CWMailFile::wpclsInitData()
{
  somId mySomId;
  USHORT i,rc;
  PCLASSFIELDINFO pCfi;
  PSZ pszModule;
  HINI hIni=0;
  ULONG ulRc;
  char* found;
  char path[CCHMAXPATH];
  FILE * file;

  if((mySomId=somIdFromString("wpclsInitData"))!=NULLHANDLE) {
    ((somTD_M_WPObject_wpclsInitData)
     somParentNumResolve(__ClassObject->somGetPClsMtabs(),
                         1,
                         __ClassObject->    
                         somGetMethodToken(mySomId))                    
     )(this);
    SOMFree(mySomId);
  }
  else 
    M_WPDataFile::wpclsInitData();


  /* Get the class module */
  pszModule=((WPClassManager*)SOMClassMgrObject)->wpModuleForClass("M_CWMailFile");
#if 0
  file=fopen("G:\\Projects_working\\MailClass\\debug.txt","a");
  fwrite(pszModule, sizeof(char), strlen(pszModule),file);
  fclose(file);
#endif
  if(pszModule) {
    /* Open the mailclass ini file */
    strncpy(path,pszModule,sizeof(path));
    path[CCHMAXPATH-1]=0;

    do {
      COUNTRYINFO countryInfo= {0};
      COUNTRYCODE country= {0};
      ULONG ulInfoLen=0;

      /* Get the country code of our system to find the right language */
      ulRc=DosQueryCtryInfo(sizeof(countryInfo),&country,&countryInfo,&ulInfoLen);
      
      if(ulRc!=NO_ERROR)
        break; /* Use default strings */

      found=strrchr(path,'\\');
      if(!found)
        break;

      found++;
      *found=0;

      /* Build INI file name */
      strncat(path,MAILCLASS_LANGUAGEININAME,CCHMAXPATH-strlen(path)-1);
      
      /* Open ini-file */
      hIni=PrfOpenProfile(WinQueryAnchorBlock(HWND_DESKTOP),path);
      if(hIni) {
        sprintf(path,"%03d",countryInfo.country);/* Create application key, it's the countrycode */

        /* Read the column titles */
        PrfQueryProfileString(hIni,path,"subject","Subject",chrSubject,sizeof(chrSubject));        
        chrSubject[SIZE_TITLE-1]=0;
        pszMailColTitles[0]=chrSubject;

        PrfQueryProfileString(hIni,path,"from","From",chrFrom,sizeof(chrFrom));        
        chrFrom[SIZE_TITLE-1]=0;
        pszMailColTitles[1]=chrFrom;

        PrfQueryProfileString(hIni,path,"to","To",chrTo,sizeof(chrTo));        
        chrTo[SIZE_TITLE-1]=0;
        pszMailColTitles[2]=chrTo;

        PrfQueryProfileString(hIni,path,"cc","CC",chrCC,sizeof(chrCC));        
        chrCC[SIZE_TITLE-1]=0;
        pszMailColTitles[3]=chrCC;

        PrfQueryProfileString(hIni,path,"bcc","BCC",chrBCC,sizeof(chrBCC));        
        chrBCC[SIZE_TITLE-1]=0;
        pszMailColTitles[4]=chrBCC;

        PrfQueryProfileString(hIni,path,"date","Date",chrDate,sizeof(chrDate));        
        chrDate[SIZE_TITLE-1]=0;
        pszMailColTitles[5]=chrDate;

        PrfQueryProfileString(hIni,path,"attachment","Attach",chrAttach,sizeof(chrAttach));        
        chrAttach[SIZE_TITLE-1]=0;
        pszMailColTitles[6]=chrAttach;

        /* Read the NLV strings for attachment yes/no */
        PrfQueryProfileString(hIni,path,"yes","Yes",chrAttachYes,sizeof(chrAttachYes));        
        chrAttachYes[SIZE_ATTACHMENT-1]=0;

        PrfQueryProfileString(hIni,path,"no","No",chrAttachNo,sizeof(chrAttachNo));        
        chrAttachNo[SIZE_ATTACHMENT-1]=0;

        if(hIni)PrfCloseProfile(hIni);
      }
      break;
    }while(TRUE);
  }

  /* Setup the static data for the details view */
  for(i=0,pCfi=cfiFieldInfo;i<NUM_MAIL_FIELDS;i++,pCfi++)
    {
      memset((PCH)pCfi,0,sizeof(CLASSFIELDINFO));

      pCfi->cb=sizeof(CLASSFIELDINFO);
      pCfi->flData=CFA_LEFT|CFA_SEPARATOR|CFA_FIREADONLY;
      pCfi->flTitle=CFA_CENTER|CFA_SEPARATOR|CFA_HORZSEPARATOR|CFA_STRING|CFA_FITITLEREADONLY;
      pCfi->pNextFieldInfo=pCfi+1;
      pCfi->pTitleData=(PVOID)pszMailColTitles[i];
      pCfi->flCompare=COMPARE_SUPPORTED|SORTBY_SUPPORTED;

      switch(i)
        {
        case 0: /* Subject */
          pCfi->flData|=CFA_STRING;
          pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(MAILDETAILS,pszSubject));
          pCfi->ulLenFieldData=sizeof(PSZ);
          pCfi->DefaultComparison=CMP_EQUAL;
          break;
        case 1: /* From */
          pCfi->flData|=CFA_STRING;
          pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(MAILDETAILS,pszFrom));
          pCfi->ulLenFieldData=sizeof(PSZ);
          pCfi->DefaultComparison=CMP_EQUAL;
          break;
        case 2: /* To */
          pCfi->flData|=CFA_STRING;
          pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(MAILDETAILS,pszTo));
          pCfi->ulLenFieldData=sizeof(PSZ);
          pCfi->DefaultComparison=CMP_EQUAL;
          break;
        case 3: /* CC */
          pCfi->flData|=CFA_STRING;
          pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(MAILDETAILS,pszCC));
          pCfi->ulLenFieldData=sizeof(PSZ);
          pCfi->DefaultComparison=CMP_EQUAL;
          break;
        case 4: /* BCC */
          pCfi->flData|=CFA_STRING;
          pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(MAILDETAILS,pszBCC));
          pCfi->ulLenFieldData=sizeof(PSZ);
          pCfi->DefaultComparison=CMP_EQUAL;
          break;
        case 5: /* Date */
          pCfi->flData|=CFA_STRING;
          pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(MAILDETAILS,pszDate));
          pCfi->ulLenFieldData=sizeof(PSZ);
          pCfi->DefaultComparison=CMP_EQUAL;
          break;
        case 6: /* Attachment */
          pCfi->flData|=CFA_STRING;
          pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(MAILDETAILS,pszAttachment));
          pCfi->ulLenFieldData=sizeof(PSZ);
          pCfi->DefaultComparison=CMP_EQUAL;
        }/* switch(i) */
    }/* for() */
  cfiFieldInfo[NUM_MAIL_FIELDS-1].pNextFieldInfo=NULL;
}


/**************************************************************/
/*                                                            */
/* The WPS asks for the details info to be shown in details   */
/* view.                                                      */
/*                                                            */
/**************************************************************/
ULONG M_CWMailFile::wpclsQueryDetailsInfo(PCLASSFIELDINFO *pClassFieldInfo, PULONG pSize)
{
  somId mySomId;
  ULONG cParentColumns;
  PCLASSFIELDINFO pCfi;
  int i;

  /* Call parent. This call works even if the parent class is replaced. */
  if((mySomId=somIdFromString("wpclsQueryDetailsInfo"))!=NULLHANDLE) {
    cParentColumns=((somTD_M_WPObject_wpclsQueryDetailsInfo)
              somParentNumResolve(__ClassObject->somGetPClsMtabs(),
                                  1,
                                  __ClassObject->    
                                  somGetMethodToken(mySomId))                    
              )(this,pClassFieldInfo, pSize);
    SOMFree(mySomId);
  }
  else 
    cParentColumns=M_WPDataFile::wpclsQueryDetailsInfo(pClassFieldInfo, pSize);

  if(pSize)
    *pSize+=sizeof(MAILDETAILS);

  if(pClassFieldInfo)
    {
      if(*pClassFieldInfo)
        {
          pCfi=*pClassFieldInfo;
          for(i=0; i<cParentColumns;i++)
            pCfi=(pCfi->pNextFieldInfo ? pCfi->pNextFieldInfo: pCfi);

          pCfi->pNextFieldInfo=cfiFieldInfo;
        }
      else
        *pClassFieldInfo=cfiFieldInfo;
    }

  return cParentColumns+NUM_MAIL_FIELDS;
}

/**************************************************************/
/*                                                            */
/* A folder opened in details view. The WPS asks the object   */
/* for the data to be shown in each column of the details     */
/* view.                                                      */
/*                                                            */
/**************************************************************/
BOOL CWMailFile::wpQueryDetailsData(PVOID *ppDetailsData, PULONG pcp)
{
  BOOL rcParent;
  somId mySomId;
  PMAILDETAILS pMailDetails;

  /* Call parent. This call works even if the parent class is replaced. */
  if((mySomId=somIdFromString("wpQueryDetailsData"))!=NULLHANDLE) {
    rcParent=((somTD_WPObject_wpQueryDetailsData)
              somParentNumResolve(__ClassObject->somGetPClsMtabs(),
                                  1,
                                  __ClassObject->    
                                  somGetMethodToken(mySomId))                    
              )(this, ppDetailsData, pcp);
    SOMFree(mySomId);
  }
  else 
    rcParent=WPDataFile::wpQueryDetailsData(ppDetailsData, pcp);

  /* The WPS asks for data to be displayed */
  if(ppDetailsData)
    {
      /* Fill the structure with the info to be displayed */      
      pMailDetails=(PMAILDETAILS)*ppDetailsData;  
      pMailDetails->pszSubject=chrSubject;
      pMailDetails->pszFrom=chrFrom;
      pMailDetails->pszTo=chrTo;
      pMailDetails->pszCC=chrCC;
      pMailDetails->pszBCC=chrBCC;
      pMailDetails->pszDate=chrDate;
      pMailDetails->pszAttachment=chrAttachment;

      *ppDetailsData=((PBYTE) (*ppDetailsData))+sizeof(*pMailDetails);  
    }
  else
    {
      /* Buffer size is queried */
      if(pcp)
        *pcp+=sizeof(*pMailDetails);
    }
  return TRUE;
}


/**************************************************************/
/*                                                            */
/* The RexxMail skript uses setup strings to setup a mailfile */
/* object. All the info to be shown in details view like      */
/* 'From', 'To', 'CC' etc. is given to the object by this     */
/* means. Doing it this way the object itself doesn't have to */
/* parse the mail. This is already done in the RexxMail       */
/* skript (and much better than it may be done here).         */
/* This data will be saved in the instance data.              */
/*                                                            */
/**************************************************************/
/*
  New setup strings for this class:

  REXXMAILDATE:     preformatted date
  REXXMAILFROM:     
  REXXMAILTO
  REXXMAILCC
  REXXMAILBCC
  REXXMAILSUBJECT
  REXXMAILATTACHMENT
  REXXMAILREFRESH

 */

BOOL CWMailFile::wpSetup(PSZ pSetupString)
{
  BOOL rcParent;
  somId mySomId;
  char buffer[CCHMAXPATH+5];
  ULONG bufferSize;
  WPFolder* wpFolder;

  /* Subject */
  if(wpScanSetupString(pSetupString, SETUP_SUBJECT, NULL,&bufferSize))
    {
      /* buffersize contains the length of the string */
      if(bufferSize>sizeof(chrSubject)) {
        memset(chrSubject, '.', sizeof(chrSubject));
        chrSubject[SIZE_SUBJECT-1]=0;
        bufferSize=sizeof(chrSubject)-4; 
      }
      else {
        memset(chrSubject, 0, sizeof(chrSubject));
        bufferSize=sizeof(chrSubject);
      }
      wpScanSetupString(pSetupString, SETUP_SUBJECT, buffer,&bufferSize);
      memcpy(chrSubject,buffer,strlen(buffer));
    }

  /* From */
  if(wpScanSetupString(pSetupString, SETUP_FROM, NULL,&bufferSize))
    {
      /* buffersize contains the length of the string */
      if(bufferSize>sizeof(chrFrom)) {
        memset(chrFrom, '.', sizeof(chrFrom));
        chrFrom[SIZE_FROM-1]=0;
        bufferSize=sizeof(chrFrom)-4; 
      }
      else {
        memset(chrFrom, 0, sizeof(chrFrom));
        bufferSize=sizeof(chrFrom);
      }
      wpScanSetupString(pSetupString, SETUP_FROM, buffer,&bufferSize);
      memcpy(chrFrom,buffer,strlen(buffer));
    }

  /* To */
  if(wpScanSetupString(pSetupString, SETUP_TO, NULL,&bufferSize))
    {
      /* buffersize contains the length of the string */
      if(bufferSize>sizeof(chrTo)) {
        memset(chrTo, '.', sizeof(chrTo));
        chrTo[SIZE_TO-1]=0;
        bufferSize=sizeof(chrTo)-4; 
      }
      else {
        memset(chrTo, 0, sizeof(chrTo));
        bufferSize=sizeof(chrTo); 
      }
      wpScanSetupString(pSetupString, SETUP_TO, buffer,&bufferSize);
      memcpy(chrTo,buffer,strlen(buffer));
    }

  /* CC */
  if(wpScanSetupString(pSetupString, SETUP_CC, NULL,&bufferSize))
    {
      /* buffersize contains the length of the string */
      if(bufferSize>sizeof(chrCC)) {
        memset(chrCC, '.', sizeof(chrCC));
        chrCC[SIZE_CC-1]=0;
        bufferSize=sizeof(chrCC)-4; 
      }
      else {
        memset(chrCC, 0, sizeof(chrCC));
        bufferSize=sizeof(chrCC); 
      }
      wpScanSetupString(pSetupString, SETUP_CC, buffer,&bufferSize);
      memcpy(chrCC,buffer,strlen(buffer));
    }

  
  /* BCC */
  if(wpScanSetupString(pSetupString, SETUP_BCC, NULL,&bufferSize))
    {
      /* buffersize contains the length of the string */
      if(bufferSize>sizeof(chrBCC)) {
        memset(chrBCC, '.', sizeof(chrBCC));
        chrBCC[SIZE_BCC-1]=0;
        bufferSize=sizeof(chrBCC)-4; 
      }
      else {
        memset(chrBCC, 0, sizeof(chrBCC));
        bufferSize=sizeof(chrBCC); 
      }
      wpScanSetupString(pSetupString, SETUP_BCC, buffer,&bufferSize);
      memcpy(chrBCC,buffer,strlen(buffer));
    }

  /* Date */
  if(wpScanSetupString(pSetupString, SETUP_DATE, NULL,&bufferSize))
    {
      /* buffersize contains the length of the string */
      if(bufferSize>sizeof(chrDate)) {
        memset(chrDate, '.', sizeof(chrDate));
        chrDate[SIZE_DATE-1]=0;
        bufferSize=sizeof(chrDate)-4; 
      }
      else {
        memset(chrDate, 0, sizeof(chrDate));
        bufferSize=sizeof(chrDate); 
      }
      wpScanSetupString(pSetupString, SETUP_DATE, buffer,&bufferSize);
      memcpy(chrDate,buffer,strlen(buffer));
    }

  /* Attachment Yes/no */
  if(wpScanSetupString(pSetupString, SETUP_ATTACHMENT, NULL,&bufferSize))
    {
      /* buffersize contains the length of the string */
      if(bufferSize>sizeof(chrAttachment)) {
        memset(chrAttachment, '.', sizeof(chrAttachment));
        chrAttachment[SIZE_ATTACHMENT-1]=0;
        bufferSize=sizeof(chrAttachment)-4; 
      }
      else {
        memset(chrAttachment, 0, sizeof(chrAttachment));
        bufferSize=sizeof(chrAttachment); 
      }
      wpScanSetupString(pSetupString, SETUP_ATTACHMENT, buffer,&bufferSize);
      if(!stricmp(buffer,"yes"))/* Use NLV */
        memcpy(chrAttachment,chrAttachYes,strlen(chrAttachYes));
      else if(!stricmp(buffer,"no"))/* Use NLV */
        memcpy(chrAttachment,chrAttachNo,strlen(chrAttachNo));
      else/* Another string */
        memcpy(chrAttachment,buffer,strlen(buffer));
    }

  /* Refresh */
  bufferSize=sizeof(buffer); 
  if(wpScanSetupString(pSetupString, SETUP_REFRESH, buffer,&bufferSize))
    {
      wpRefresh(0,NULL);  
    }
  
  /* Call parent. This call works even if the parent class is replaced. */
  if((mySomId=somIdFromString("wpSetup"))!=NULLHANDLE) {
    rcParent=((somTD_WPObject_wpSetup)
              somParentNumResolve(__ClassObject->somGetPClsMtabs(),
                                  1,
                                  __ClassObject->    
                                  somGetMethodToken(mySomId))                    
              )(this,pSetupString);
    SOMFree(mySomId);
  }
  else 
    rcParent=WPDataFile::wpSetup(pSetupString);
  
  return rcParent;
}

/**************************************************************/
/*                                                            */
/* Some initializations after first creating an object.       */
/*                                                            */
/**************************************************************/
BOOL CWMailFile::wpSetupOnce(PSZ pSetupString)
{
  BOOL rcParent;
  somId mySomId;


  chrSubject[0]=0;
  chrFrom[0]=0;
  chrTo[0]=0;
  chrCC[0]=0;
  chrBCC[0]=0;
  chrDate[0]=0;
  chrAttachment[0]=0;
  
  /* Call parent. This call works even if the parent class is replaced. */
  if((mySomId=somIdFromString("wpSetupOnce"))!=NULLHANDLE) {
    rcParent=((somTD_WPObject_wpSetupOnce)
              somParentNumResolve(__ClassObject->somGetPClsMtabs(),
                                  1,
                                  __ClassObject->    
                                  somGetMethodToken(mySomId))                    
              )(this,pSetupString);
    SOMFree(mySomId);
  }
  else 
    rcParent=WPDataFile::wpSetupOnce(pSetupString);

  return rcParent;
}

/**************************************************************/
/*                                                            */
/* Save the instance data (From, To, CC etc.)                 */
/*                                                            */
/**************************************************************/
BOOL CWMailFile::wpSaveState()
{
  BOOL rc;
  somId mySomId;

  /* Save 'Subject' instance data*/
  if(!wpSaveString("CWMailFile",IDKEY_SUBJECT,chrSubject))
    rc=FALSE; /* Not used yet */

  /* Save 'From' instance data*/
  if(!wpSaveString("CWMailFile",IDKEY_FROM,chrFrom))
    rc=FALSE; /* Not used yet */

  /* Save 'To' instance data*/
  if(!wpSaveString("CWMailFile",IDKEY_TO,chrTo))
    rc=FALSE; /* Not used yet */

  /* Save 'CC' instance data*/
  if(!wpSaveString("CWMailFile",IDKEY_CC,chrCC))
    rc=FALSE; /* Not used yet */

  /* Save 'BCC' instance data*/
  if(!wpSaveString("CWMailFile",IDKEY_BCC,chrBCC))
    rc=FALSE; /* Not used yet */

  /* Save 'Date' instance data*/
  if(!wpSaveString("CWMailFile",IDKEY_DATE,chrDate))
    rc=FALSE; /* Not used yet */

  /* Save 'Attachment' instance data*/
  if(!wpSaveString("CWMailFile",IDKEY_ATTACHMENT,chrAttachment))
    rc=FALSE; /* Not used yet */

  /* Call parent. This call works even if the parent class is replaced. */
  if((mySomId=somIdFromString("wpSaveState"))!=NULLHANDLE) {
    rc=((somTD_WPObject_wpSaveState)
        somParentNumResolve(__ClassObject->somGetPClsMtabs(),
                            1,
                            __ClassObject->    
                            somGetMethodToken(mySomId))                    
        )(this);
    SOMFree(mySomId);
    return rc;
  }
  else 
    return WPDataFile::wpSaveState();

}

/**************************************************************/
/*                                                            */
/* We are awake, get the instance data (From, To, CC etc.)    */
/*                                                            */
/**************************************************************/
BOOL CWMailFile::wpRestoreState(ULONG ulReserved)
{
  BOOL rc;
  somId mySomId;
  ULONG keyLength;

  keyLength=sizeof(chrSubject);
  if(!wpRestoreString("CWMailFile",IDKEY_SUBJECT,chrSubject,&keyLength))
    strcpy(chrSubject,"");

  keyLength=sizeof(chrFrom);
  if(!wpRestoreString("CWMailFile",IDKEY_FROM,chrFrom,&keyLength))
    strcpy(chrFrom,"");

  keyLength=sizeof(chrTo);
  if(!wpRestoreString("CWMailFile",IDKEY_TO,chrTo,&keyLength))
    strcpy(chrTo,"");

  keyLength=sizeof(chrCC);
  if(!wpRestoreString("CWMailFile",IDKEY_CC,chrCC,&keyLength))
    strcpy(chrCC,"");

  keyLength=sizeof(chrBCC);
  if(!wpRestoreString("CWMailFile",IDKEY_BCC,chrBCC,&keyLength))
    strcpy(chrBCC,"");

  keyLength=sizeof(chrDate);
  if(!wpRestoreString("CWMailFile",IDKEY_DATE,chrDate,&keyLength))
    strcpy(chrDate,"");

  keyLength=sizeof(chrAttachment);
  if(!wpRestoreString("CWMailFile",IDKEY_ATTACHMENT,chrAttachment,&keyLength))
    strcpy(chrAttachment,"");

  /* Call parent. This call works even if the parent class is replaced. */
  if((mySomId=somIdFromString("wpRestoreState"))!=NULLHANDLE) {
    rc=((somTD_WPObject_wpRestoreState)
        somParentNumResolve(__ClassObject->somGetPClsMtabs(),
                            1,
                            __ClassObject->    
                            somGetMethodToken(mySomId))                    
        )(this, ulReserved);
    SOMFree(mySomId);
    return rc;
  }
  else 
    return WPDataFile::wpRestoreState(ulReserved);

}









