/*****************************************************************************/
/* IBM Internal Use Only                                                     */
/* Copyright (c) IBM Corp 1997                                               */
/*---------------------------------------------------------------------------*/
/* File        : userPreference.hpp                                          */
/* Contains    : The class to handle the user preference.                    */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* History                                                                   */
/*---------------------------------------------------------------------------*/
/* Date        | Event                                   | Person            */
/*---------------------------------------------------------------------------*/
/* 1997-06-17  | Created                                 | FB                */
/* 1997-11-07  | Inspected for Win32 comp.               | FB                */
/*****************************************************************************/

#ifndef _USER_PREFERENCE_HPP_
#define _USER_PREFERENCE_HPP_

#include <istring.hpp>
#include <iframe.hpp>
#include <icmdhdr.hpp>
#include <ipushbut.hpp>
#include <ientryfd.hpp>
#include <iradiobt.hpp>
#include <istattxt.hpp>
#include <imcelcv.hpp>
#include <inotebk.hpp>
#include <icheckbx.hpp>
#include <icombobx.hpp>
#include <iselhdr.hpp>
#include <ictlevt.hpp>
#include <imoushdr.hpp>

class TAGUserIni;
class TAGUserSelect;
class IMouseClickEvent;
class TAGUserMouse;

class TAGUserPM : public IFrameWindow
                , public ICommandHandler
{
  private:
  //* Privat members.     ****************************************************
  TAGUserIni&    _userIni;
  TAGUserSelect* _select;
  IPushButton*   _ppbBrowse;
  IPushButton*   _ppbOk    ;
  IPushButton*   _ppbCancel;
  IPushButton*   _ppbAddTagline;
  IPushButton*   _ppbRemoveTagline;

  IEntryField*   _pefTagfiles;
  IEntryField*   _pefNewline;
  IEntryField*   _pefManualTag;
  IEntryField*   _pefPause;
  IEntryField*   _pefXMailer;
  IEntryField*   _pefXNews  ;
  IEntryField*   _pefxtagText;
  IEntryField*   _pefname;
  IEntryField*   _pefkey;
  IEntryField*   _pefAnonymousName;
  IEntryField*   _pefAnonymousEmail;


  IStaticText*   _pstTagfiles ;
  IStaticText*   _pstNewline  ;
  IStaticText*   _pstManualTag;
  IStaticText*   _pstPause;
  IStaticText*   _pstXMailer;
  IStaticText*   _pstXNews  ;
  IStaticText*   _pstAdvertise;
  IStaticText*   _pstXTags  ;
  IStaticText*   _pstRegistered;
  IStaticText*   _pstWindowList;
  IStaticText*   _pstHome;
  IStaticText*   _pstAnonymousName;
  IStaticText*   _pstAnonymousEmail;

  IRadioButton*  _prbRandom;
  IRadioButton*  _prbSequential;

  ICheckBox*     _pcbWysiwyg;
  ICheckBox*     _pcbRemoveXMailer;
  ICheckBox*     _pcbRemoveXNews;
  ICheckBox*     _pcbAdvertise;
  ICheckBox*     _pcbWindowList;
  ICheckBox*     _pcbNoReplace;

  IComboBox*     _pcbxtags;

  TAGUserMouse*  _pmouseHdr;
  Boolean        _saveIni;
  enum BrowseOption { tagFile, netscapeIni };
  //* Private functions *****************************************************
  IMultiCellCanvas* insertButtons(IMultiCellCanvas* pParentOwner);
  INotebook*        insertNotebookPages(IMultiCellCanvas* pParentOwner);
  IMultiCellCanvas* insertFilePage(INotebook* pParentOwner);
  IMultiCellCanvas* insertAnonymousPage(INotebook* pParentOwner);
  IMultiCellCanvas* insertNetscapePage(INotebook* pParentOwner);
//  IMultiCellCanvas* insertXPage(INotebook* pParentOwner);
  IMultiCellCanvas* insertRegister(INotebook* pParentOwner);
  IMultiCellCanvas* insertUserPage(INotebook* pParentOwner);
  IMultiCellCanvas* insertAbout(INotebook* pParentOwner);
  Boolean           handleOk();
  void              handleBrowse(TAGUserPM::BrowseOption browseOption = TAGUserPM::tagFile);
  //* Protected ***********************************************************
  protected:
     virtual Boolean command(ICommandEvent& cmdEvt);
  //* Public declarations ****************************************************
  public:
    //* Constuctor ***********************************************************
    TAGUserPM(TAGUserIni& aUserIni);
    //* Destructor ***********************************************************
    //* Public functions *****************************************************
    void              layout();
    Boolean           saveIni() {return _saveIni;}
};

class TAGUserSelect : public ISelectHandler
{
  private:
  IStaticText*  _pstNewline;
  IStaticText*  _pstXMailer;
  IStaticText*  _pstXNews  ;
  IEntryField*  _pefNewline;
  IEntryField*  _pefXMailer;
  IEntryField*  _pefXNews  ;
  ICheckBox*    _pcbNoReplace;
  ICheckBox*    _pcbRemoveXMailer;
  ICheckBox*    _pcbRemoveXNews;
  protected:
  virtual Boolean selected(IControlEvent &ctlEvt);
  public:
    //* Public functions.
    TAGUserSelect& newline      (IEntryField* entryfield) {_pefNewline       = entryfield; return *this;}
    TAGUserSelect& xmailer      (IEntryField* entryfield) {_pefXMailer       = entryfield; return *this;}
    TAGUserSelect& xnews        (IEntryField* entryfield) {_pefXNews         = entryfield; return *this;}
    TAGUserSelect& newline      (IStaticText* staticText) {_pstNewline       = staticText; return *this;}
    TAGUserSelect& xmailer      (IStaticText* staticText) {_pstXMailer       = staticText; return *this;}
    TAGUserSelect& xnews        (IStaticText* staticText) {_pstXNews         = staticText; return *this;}
    TAGUserSelect& noReplace    (ICheckBox*   checkBox  ) {_pcbNoReplace     = checkBox  ; return *this;}
    TAGUserSelect& removeXMailer(ICheckBox*   checkBox  ) {_pcbRemoveXMailer = checkBox  ; return *this;}
    TAGUserSelect& removeXNews  (ICheckBox*   checkBox  ) {_pcbRemoveXNews   = checkBox  ; return *this;}
};

class TAGUserMouse : public IMouseHandler
{
  private:
  //* Privat members.     ****************************************************
  IStaticText*      _pstHome;
  //* Privat functions.   ****************************************************
  void loadNetscape();
  //* Protected ***********************************************************
  protected:
    virtual Boolean mouseClicked(IMouseClickEvent& mouseEvt);
  //* Public declarations ****************************************************
  public:
    //* Constuctor ***********************************************************
    TAGUserMouse(IStaticText* home) : _pstHome(home) {}
};
#endif
