/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*

   Adds a new newsgroup to the set of newsgroups that we are
   fetching with the news-to-mail feed.  This script adds the
   new entries to the WEASEL.INI and MAJOR.INI files (so that
   you don't have to run Weasel's Setup to add a new user and
   Major Major's Admin program to add a new mailing list), and
   updates the configuration file.

      Author:       Peter Moylan (peter@ee.newcastle.edu.au)
      Started:      12 February 2001
      Last revised: 13 February 2001

   Assumption:
      This script assumes that it is in a subdirectory of the
      Major Major directory.  (It needs this assumption to
      find the MAJOR.INI file.)  If this is not true, you
      need to modify part of the script below.

   Usage:
      addgroup groupname cfgfile

      The cfgfile parameter is the name of the configuration
      file.  If it is omitted, we assume "getnews.cfg".
      See CFG.DOC for the format of the configuration file.

*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/

/****************************************************************/
/*                       MAIN PROGRAM                           */
/****************************************************************/

parse arg group cfgfile
IF cfgfile = '' THEN cfgfile = 'getnews.cfg'
IF group = '' THEN
    DO
        SAY "Example: addgroup alt.test"
        EXIT
    END

CALL RxFuncAdd SysLoadFuncs, rexxutil, sysloadfuncs
CALL SysLoadFuncs

/* Create a new Major Major mailing list. */

MajorDir = '..'
inifile = MajorDir||'\MAJOR.INI'
call SysIni inifile, group, 'Abbreviation', LEFT(group, 8)
call SysIni inifile, group, 'Nonsub', '02'X
call SysIni inifile, group, 'FilterProg', DIRECTORY()||'\feedtonews.cmd'
SAY 'New mailing list 'group' created.'

/* Create a new Weasel user. */

Nul = '00'X
WeaselDir = STRIP(LINEIN(cfgfile), 'T', '\')
CALL STREAM cfgfile, 'C', 'CLOSE'
inifile = WeaselDir||'\WEASEL.INI'
CALL SysIni inifile, group, 'Password', Nul
SAY 'Weasel mail account for 'group' created.'

/* Give the new group a mail directory.  */

MailDir = SysIni(inifile, '$SYS', 'MailRoot')
j = POS(Nul,MailDir)
IF j > 0 THEN MailDir = LEFT(MailDir, j-1)
MailDir = STRIP(MailDir)
MailDir = TRANSLATE(MailDir, '\', '/')||group
IF SysMkDir(MailDir) \= 0 THEN
    DO
        SAY "Could not create the group's mail directory"
        SAY "     "MailDir
        SAY "You should do this manually"
    END
ELSE
    SAY 'Mail directory 'MailDir' created.'

/* Add a new line to the configuration file. */

DO UNTIL STREAM(tmpfile, 'C', 'QUERY EXISTS') = ''
    tmpfile = SysTempFileName("?????.tmp")
END
CALL LINEOUT tmpfile, group' '0
CALL STREAM tmpfile, 'C', 'CLOSE'
'@copy 'cfgfile'+'tmpfile' 'cfgfile' >nul'
'@del 'tmpfile

EXIT

