/* pmsig.cmd,v 1.3 1998-10-11 10:35:39-04 rl Exp */

/*****************************************************************************
 *                                                                           *
 *  pmsig.cmd                                                                * 
 *  Generate signature files for PMMail and PMINews from master files        * 
 *  1997-11-13, Rolf Lochbuehler                                             * 
 *                                                                           *
 *****************************************************************************/


/* User specific default values */

/* Default directories (all uppercase!) */
DEFAULT_MASTER_DIR = 'E:\UTIL\SIGNATURE'
DEFAULT_MAIL_DIR = 'E:\SOUTHSDE\PMMAIL'
DEFAULT_NEWS_DIR = 'E:\SOUTHSDE\PMINEWS'

/* Default signatures */
DEFAULT_PMMAIL_SIG = 'Email'
DEFAULT_PMINEWS_SIG = 'News'


/* You don't need to modify anything below this */
/* line, unless you want to change the program */

call rxfuncadd 'sysfiledelete', 'rexxutil', 'sysfiledelete'
call rxfuncadd 'sysfiletree', 'rexxutil', 'sysfiletree'
call rxfuncadd 'sysputea', 'rexxutil', 'sysputea'

PROG_NAME = 'PMSig'
PROG_CALL = 'pmsig'

/* Return values */
RET_NO_ERR = 0
RET_NO_MASTER_SIGS = 1
RET_NO_MASTER_DIR = 2
RET_HELP = 3

parse arg opt
upperopt = translate( opt )

/* Print help if requested */
n = wordpos( '/H', upperopt ) 
if n = 0 then 
  n = wordpos( '-H', upperopt )
if n > 0 then
  do
  call help
  exit RET_HELP
  end

/* Set default signature for PMMail */
n = wordpos( '/M', upperopt )
if n = 0 then 
  n = wordpos( '-M', upperopt )
if n > 0 then
  defmail = word( opt, n+1 )
else
  defmail = DEFAULT_PMMAIL_SIG
say 'Default signature for PMMail is' defmail

/* Set default signature for PMINews */
n = wordpos( '/N', upperopt )
if n = 0 then 
  n = wordpos( '-N', upperopt )
if n > 0 then
  defnews = word( opt, n+1 )
else
  defnews = DEFAULT_PMINEWS_SIG
say 'Default signature for PMINews is' defnews

/* Set master directory */
n = wordpos( '/S', upperopt )
if n = 0 then 
  n = wordpos( '-S', upperopt )
if n > 0 then
  masterdir = word( opt, n+1 )
else
  masterdir = DEFAULT_MASTER_DIR
say 'Master directory is' masterdir

/* Set PMMail directory */
n = wordpos( '/T', upperopt )
if n = 0 then 
  n = wordpos( '-T', upperopt )
if n > 0 then
  maildir = word( opt, n+1 )
else
  maildir = DEFAULT_MAIL_DIR
say 'PMMail directory is' maildir

/* Set PMINews directory */
n = wordpos( '/U', upperopt )
if n = 0 then 
  n = wordpos( '-U', upperopt )
if n > 0 then
  newsdir = word( opt, n+1 )
else
  newsdir = DEFAULT_NEWS_DIR
say 'PMINews directory is' newsdir

currentdir = directory()
if translate(directory(masterdir)) <> masterdir then
  do
  say '*PMSig Error* Cannot find directory' masterdir
  exit RET_NO_MASTER_DIR
  end

/* Get master signature files */
call sysfiletree '*', 'master', 'fo'

if master.0 = 0 then
  do
  say '*PMSIG Error* No master signature files in directory' masterdir
  exit RET_NO_MASTER_SIGS
  end

call mailsig maildir, defmail
call newssig newsdir, defnews

call directory( currentdir )

exit RET_NOERR


/*****************************************************************************
 *                                                                           *
 *  mailsig()                                                                * 
 *  Make signature files for PMMail                                          * 
 *                                                                           *
 *****************************************************************************/
mailsig : procedure expose master.

  parse arg maildir, defsig 
  
  /* Get account names */
  call sysfiletree maildir'\*.act', 'account', 'do'

  if account.0 > 0 then
    do

    if account.0 = 1 then
      say 'Generating signatures for PMMail ('account.0 'acccount)'
    else
      say 'Generating signatures for PMMail ('account.0 'acccounts)'

    do aidx = 1 to account.0

      accountname = filespec( 'name', account.aidx )

      siglist = account.aidx'\sigs\sigs.lst'

      /* Delete old signature list */
      call sysfiledelete siglist

      /* Delete old signature files */
      call sysfiletree account.aidx'\sigs\sig*.txt', 'oldsig', 'fo'
      if oldsig.0 > 0 then
        do u = 1 to oldsig.0 
          call sysfiledelete oldsig.u
        end

      call stream siglist, 'command', 'open write'

      /* Copy signature files and make entries in signature list */
      do midx = 1 to master.0
        newsig = account.aidx'\sigs\sig'midx'.txt'
        newshort = accountname'\sigs\sig'midx'.txt'
        /* ??? syscopyobject didn't work here, don't know why */
        '@copy' '"'master.midx'"' newsig '1>nul 2>nul'   
        sigfilename = translate( filespec( 'name', newsig ) )
        longname = "DFFF00000100FDFF"x || d2c(length(sigfilename)) || "00"x || sigfilename
        call sysputea newsig, '.LONGNAME', longname
        name = filespec( 'name', master.midx )
        if translate(defsig) = translate(name) then 
          default = '1'
        else                    
          default = '0'
        call lineout siglist, name || '' || translate(newshort) || '' || default || ''
      end

      call stream siglist, 'command', 'close'

    end   /* end do */

    end   /* end if */

  return


/*****************************************************************************
 *                                                                           *
 *  newssig()                                                                * 
 *  Make signature files for PMINews                                         * 
 *                                                                           *
 *****************************************************************************/
newssig : procedure expose master.

  parse arg newsdir, defsig 
  
  /* Get grouplist names */
  call sysfiletree newsdir'\*.gl', 'glist', 'do'

  if glist.0 > 0 then
    do

    if glist.0 = 1 then
      say 'Generating signatures for PMINews ('glist.o 'grouplist)'
    else
      say 'Generating signatures for PMINews ('glist.0 'grouplists)'

    do gidx = 1 to glist.0

      glistname = filespec( 'name', glist.gidx )

      siglist = glist.gidx'\sigs\sigs.lst'

      /* Delete old signature list */
      call sysfiledelete siglist

      /* Delete old signature files */
      call sysfiletree glist.gidx'\sigs\sig*.txt', 'oldsig', 'fo'
      if oldsig.0 > 0 then
        do i = 1 to oldsig.0 
          call sysfiledelete oldsig.i
        end

      call stream siglist, 'command', 'open write'

      /* Copy signature files and make entries in signature list */
      do midx = 1 to master.0
        newsig = glist.gidx'\sigs\sig'midx'.txt'
        newshort = glistname'\sigs\sig'midx'.txt'
        /* ??? syscopyobject didn't work here, don't know why */
        '@copy' '"'master.midx'"' newsig '1>nul 2>nul'   
        sigfilename = translate( filespec( 'name', newsig ) )
        longname = "DFFF00000100FDFF"x || d2c(length(sigfilename)) || "00"x || sigfilename
        call sysputea newsig, '.LONGNAME', longname
        name = filespec( 'name', master.midx )
        if translate(defsig) = translate(name) then 
          default = '1'
        else                    
          default = '0'
        call lineout siglist, name || '' || translate(newshort) || '' || default || ''
      end

      call stream siglist, 'command', 'close'

    end   /* end do */

    end   /* end if */

  return


/*****************************************************************************
 *                                                                           *
 *  help()                                                                   * 
 *  Print help                                                               * 
 *                                                                           *
 *****************************************************************************/
help : procedure expose PROG_NAME PROG_CALL DEFAULT_PMMAIL_SIG DEFAULT_PMINEWS_SIG DEFAULT_MASTER_DIR DEFAULT_MAIL_DIR DEFAULT_NEWS_DIR
  say ''
  say PROG_NAME' 1.3, Rolf Lochbuehler <rolf@together.net>'
  say 'Purpose:'
  say '  Generate PMINews and PMMail signature files from master signature files in a'
  say '  single directory'
  say 'Usage:'
  say '  'PROG_CALL' [/h]'
  say '  'PROG_CALL' [/m Sig] [/n Sig] [/s Dir] [/t Dir] [/u Dir]'
  say 'Arguments:'
  say '  /h       Print this help'
  say '  /m Sig   Name of the default signature for PMMail (default: 'DEFAULT_PMMAIL_SIG')'
  say '  /n Sig   Name of the default signature for PMINews (default: 'DEFAULT_PMINEWS_SIG')'
  say '  /s Dir   Directory with master signature files (default: 'DEFAULT_MASTER_DIR')'
  say '  /t Dir   PMMail root directory (default: 'DEFAULT_MAIL_DIR')'
  say '  /u Dir   PMINews root directory (default: 'DEFAULT_NEWS_DIR')'
  say 'Example:'
  say '  'PROG_CALL' /m Cool /n Anti-Spam /s c:\signatures'
  say 'Bugs:'
  say '  Will not handle directory names as arguments correctly, if they contain'
  say '  spaces.'
  say 'Note:'
  say '  You may change the default settings by editing the source code. See the'
  say '  DEFAULT_* variables at the beginning of the script.'
  return

