/*           Install the Vice/2-Folder 
*/
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
 call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
 call SysLoadFuncs
'cls'
say ''
Say 'Installation of Desktop-Objects for KC-Emu/2'
Say '--------------------------------------------'
Say ''
Say 'KC-Emu is the KC Emulator'
Say ' (c) by the Authors'
Say ''
say 'This program and all files are released under the GPL.'
Say 'For Information see ''COPYING''.'
say ''
/* Get curent directory */
origdir = directory()
curdir  = origdir
say 'Current directory is' curdir
say ''
/* ----- KC-Emu/2 Folder ----- */
say 'Creating a Kc-Emu/2 folder on the desktop...'
setupstring="OBJECTID=<KCEMU2>;" ||,
            "ICONFILE="   || curdir ||"\icons\folder1.ico;" ||,
            "ICONNFILE=1,"|| curdir ||"\icons\folder2.ico"
if SysCreateObject("WPFolder","KC-Emu/2","<WP_DESKTOP>",setupstring,"update")<>1 then
do
    say '!!! Can''t create the folder. Exiting...'
    say ''
    exit
end
/* ----- KC-Emu/2 Program Objects ----- */
say 'Creating Program objects...'
CALL createProgram "KC-85/4", 'kc-emu2.exe', '-4', '*.kcc' 
CALL createProgram "KC-85/3", 'kc-emu2.exe', '-3', '*.kcc'
CALL createProgram "KC-85/1", 'kc-emu2.exe', '-1', ''
setupstring='EXENAME=e.exe;PARAMETERS='curdir'\kc-emu2.log'
if SysCreateObject("WPProgram","log-File","<KCEMU2>",setupstring,"update")<>1 then
do
    say '!!! Can''t create a program object for log-file.'
    say ''
end
setupstring='EXENAME=e.exe;PARAMETERS='curdir'\kc-emu2.cfg'
if SysCreateObject("WPProgram","cfg-file","<KCEMU2>",setupstring,"update")<>1 then
do
    say '!!! Can''t create a program object for cfg-file.'
    say ''
end
/* ----- KC-Emu/2 Documentation ----- */
say 'Creating objects for documentation...'
if SysCreateObject("WPFolder","Documentation","<KCEMU2>","OBJECTID=<KCEMU2_DOC>","update")<>1 then
do
    say '!!! Can''t create the subfolder. Exiting...'
    say ''
    exit
end
if SysCreateObject("WPFolder","Read me!","<KCEMU2_DOC>","OBJECTID=<KCEMU2_README>","update")<>1 then
do
    say '!!! Can''t create the subfolder. Exiting...'
    say ''
    exit
end
curdir = directory(origdir'\doc\readme')
CALL createShadow "<KCEMU2_README>", 'AUTHORS'
CALL createShadow "<KCEMU2_README>", 'COPYING'
CALL createShadow "<KCEMU2_README>", 'NEWS'
CALL createShadow "<KCEMU2_README>", 'README'
say 'Creating a KC-Emu/2 subfolder ''Online''...'
if SysCreateObject("WPFolder","KC-Emu Online","<KCEMU2_DOC>","OBJECTID=<KCEMU2_ONLINE>","update")<>1 then
do
    say '!!! Can''t create the subfolder. Exiting...'
    say ''
    exit
end
if SysCreateObject("WPUrl","KC-Emu Homepage","<KCEMU2_ONLINE>","URL=http://","update")<>1 then
do
    say '!!! Can''t create a html object for HTML Documatation'
end
if SysCreateObject("WPUrl","KC-Emu/2 Homepage","<KCEMU2_ONLINE>","URL=http://www.d4m.de/kcemu2/","update")<>1 then
do
    say '!!! Can''t create a html object for HTML Documatation'
end
curdir = directory(origdir)
/* Open the KC-Emu/2 folder */
rc=SysSetObjectData("<KCEMU2>","OPEN=DEFAULT")
say ''
say 'Installation succesful.'
say ''
say 'Remark: It is not necessary to reboot. The installation script'
say 'does nothing else than creating desctop object. Uninstallation'
say 'can be done by removing the Vice2-Folder easily.'
say ''
exit
createProgram:
    /* STARTUPDIR needed for Drag&Drop */
    setupstring='EXENAME='curdir'\'ARG(2)';PARAMETERS='ARG(3)';STARTUPDIR='curdir';ASSOCFILTER='ARG(4)
    /*    say 'Creating an object for 'ARG(2)'...'*/
    if SysCreateObject("WPProgram",ARG(1),"<KCEMU2>",setupstring,"update")<>1 then
    do
        say '!!! Can''t create a program object for 'ARG(1)
        say ''
    end
    RETURN
    
createProgramIcon:
    /* STARTUPDIR needed for Drag&Drop */
    setupstring='EXENAME='curdir'\'ARG(2)';ICONFILE='curdir'\icons\'ARG(3)';PARAMETERS='ARG(4)';STARTUPDIR='curdir';ASSOCFILTER='ARG(5)
    /*    say 'Creating an object for 'ARG(2)'...'*/
    if SysCreateObject("WPProgram",ARG(1),"<KCEMU2>",setupstring,"update")<>1 then
    do
        say '!!! Can''t create a program object for 'ARG(1)
        say ''
    end
    RETURN
    
createShadow:
/*    say 'Creating shadow for 'ARG(2)'...'*/
    setupstring='SHADOWID='curdir'\'ARG(2)
    if SysCreateObject("WPShadow",ARG(2),ARG(1),setupstring,"update")<>1 then
    do
        say '!!! Can''t create the shadow for 'curdir'\'ARG(2)
        say ''
    end
    RETURN
