// ---------------------------------------------------------------------------
//	M88 - PC-8801 Emulator.
//	Copyright (C) cisc 1997, 1999.
// ---------------------------------------------------------------------------
//	$Id: draw.h,v 1.3 1999/03/28 06:54:09 cisc Exp $

#if !defined(common_draw_h)
#define common_draw_h

#include "types.h"
#include "misc.h"

// ---------------------------------------------------------------------------

class Draw
{
public:
	struct Palette
	{
		uint8 red, green, blue, rsvd;
	};

	struct Region
	{
		void Reset() { top = 999; bottom = -1; }
		bool Valid() { return top <= bottom; }
		void Update(int t, int b)
		{
			top = Min(top, t), bottom = Max(bottom, b);
		}

		int top, bottom;
	};

public:
	Draw() {}
	virtual ~Draw() {}

	virtual bool Init(uint width, uint height, uint bpp) = 0;
	virtual bool Cleanup() = 0;

	virtual bool Lock(uint8** pimage, int* pbpl) = 0;
	virtual bool Unlock() = 0;
	
	virtual void Resize(uint width, uint height) = 0;
	virtual void DrawScreen(const Region& region) = 0;
	virtual void SetPalette(uint index, uint nents, const Palette* pal) = 0;
	virtual bool ReadyToDraw() = 0;
};

#endif // common_draw_h
