// ---------------------------------------------------------------------------
//	FM Sound Generator
//	Copyright (C) cisc 1998, 1999.
// ---------------------------------------------------------------------------
//	$Id: fmgeninl.h,v 1.4 1999/07/22 15:55:44 cisc Exp $

#ifndef FM_GEN_INL_H
#define FM_GEN_INL_H

// ---------------------------------------------------------------------------
//	萔̂Q
//	
#define FM_PI			3.14159265358979323846

#define FM_EGCBITS		18			// eg  count ̃Vtgl
#define FM_LFOCBITS		20
#define FM_PGBITS		9

#define FM_ISHIFT		11
#define FM_ARRATE		0xdb000
#define FM_DRRATE		0xbd3000

#define FM_RATIOBITS	8

// ---------------------------------------------------------------------------
//	Operator
//
inline FM::Operator::Operator()
{
	// EG Part
	ar = dr = sr = rr = ksr = 0;

	// PG Part
	multiple = 0;
	detune = 0;
	
	Reset();
}

//	
inline void FM::Operator::Reset()
{
	// EG part
	tllinear = 0;
	tl = tll = 127;
	ShiftPhase(off);

	// PG part
	pgcount = 0;

	// OP part
	out = out2 = 0;
}

//	tB[hobNobt@NA
inline void FM::Operator::ResetFB()
{
	out = out2 = 0;
}

//	L[I
inline void FM::Operator::KeyOn()
{
	if (phase == release || phase == off)
	{
		ShiftPhase(attack);
		out = out2 = 0;
		pgcount = 0;
	}
}

//	L[It
inline void	FM::Operator::KeyOff()
{
	ShiftPhase(release);
}

//	Iy[^͏o͂𔭐Ă邩H
inline int FM::Operator::IsOn()
{
	return phase - off;
}

//	Detune (0-7)
inline void FM::Operator::SetDT(uint dt)		{ detune = dt * 0x20; }

//	Multiple (0-15)
inline void FM::Operator::SetMULTI(uint mul)	{ multiple = mul; }

//	Total Level (0-127) (0.75dB step)
inline void FM::Operator::SetTL(uint _tl, bool csm)
{
	if (!csm)
		tl = _tl;
	tll = _tl;
}

//	Attack Rate (0-63)
inline void FM::Operator::SetAR(uint _ar)		{ ar = _ar;  }

//	Decay Rate (0-63)
inline void FM::Operator::SetDR(uint _dr)		{ dr = _dr; }

//	Sustain Rate (0-63)
inline void FM::Operator::SetSR(uint _sr)		{ sr = _sr; }

//	Sustain Level (0-127)
inline void FM::Operator::SetSL(uint _sl)		{ sl = _sl; }

//	Release Rate (0-63)
inline void FM::Operator::SetRR(uint _rr)		{ rr = _rr; }

//	Keyscale (0-3)
inline void FM::Operator::SetKS(uint _ks)		{ ks = _ks; }

//	SSG-type Envelop (0-15)
inline void FM::Operator::SetSSGEC(uint ssgec)	{ ssgtype = ssgec; }

inline void FM::Operator::SetDPBN(uint _dp, uint _bn)
{
	dp = _dp, bn = _bn;
}

inline void FM::Operator::SetAMON(bool on)		{ amon = on;  }

//inline void FM::Operator::SetMode(bool modu)	{ modulator = modu; }

// ---------------------------------------------------------------------------
//	4-op Channel

//	ZtEtB[hobN[g̐ݒ (0-7)
inline void FM::Channel4::SetFB(uint feedback)
{
	fb = fbtable[feedback];
}

//	OPNA n LFO ̐ݒ
inline void FM::Channel4::SetMS(uint ms)
{
	ams = amtable[(ms >> 4) & 3];
	pms = pmtable[ms & 7];
}

#endif // FM_GEN_INL_H
