// ---------------------------------------------------------------------------
//	M88 - PC-88 Emulator.
//	Copyright (C) cisc 1998.
// ---------------------------------------------------------------------------
//  DMAC (uPD8257) ̃G~[V
// ---------------------------------------------------------------------------
//	$Id: pd8257.h,v 1.5 1999/03/17 01:04:23 cisc Exp $

#if !defined(PC88_PD8257_H)
#define PC88_PD8257_H

#include "device.h"

namespace PC8801
{

class PD8257 : public Device  
{
public:
	enum IDOut
	{
		reset=0, setaddr, setcount, setmode
	};
	enum IDIn
	{
		getaddr, getcount, getstat
	};

public:
	PD8257(const ID&);
	~PD8257();
	
	bool Connect(uint8* mem, uint addr, uint length);
	
	void Reset(uint=0, uint=0);
	void SetAddr (uint port, uint data);
	void SetCount(uint port, uint data);
	void SetMode (uint, uint data);
	uint GetAddr (uint port);
	uint GetCount(uint port);
	uint GetStatus(uint);
	
	uint RequestRead(uint bank, uint8* data, uint nbytes);
	bool Enabled(uint bank) { return !!(enabled & (1 << bank)); }

	const Descriptor* GetDesc() const { return &descriptor; } 

private:
	bool autoinit;
	bool ff;
	uint8 status;
	uint8 enabled;
	uint addr[4];
	int count[4];
	uint ptr[4];
	uint8 mode[4];

	uint8* memory;
	uint mbegin;
	uint mend;

	static const Descriptor descriptor;
	static const InFuncPtr indef[];
	static const OutFuncPtr outdef[];
};

} // namespace PC8801

#endif // PC88_PD8257_H
