// ---------------------------------------------------------------------------
//	PC-8801 emulator
//	Copyright (C) cisc 1999.
// ---------------------------------------------------------------------------
//	$Id: subsys.h,v 1.3 1999/04/04 01:17:50 cisc Exp $

#ifndef pc88_subsys_h
#define pc88_subsys_h

#include "device.h"
#include "fdc.h"
#include "pio.h"

namespace PC8801
{

class SubSystem : public Device
{
public:
	enum
	{
		reset = 0,  
		m_set0, m_set1, m_set2, m_setcw, 
		s_set0, s_set1, s_set2, s_setcw,
	};
	enum
	{
		intack = 0, 
		m_read0, m_read1, m_read2, s_read0, s_read1, s_read2
	};

public:
	SubSystem(const ID& id);
	~SubSystem();
	bool Init(Bus* bus);

	void Reset(uint=0, uint=0);
	uint IntAck(uint);
	bool IsBusy();

	void M_Set0(uint, uint data);
	void M_Set1(uint, uint data);
	void M_Set2(uint, uint data);
	void M_SetCW(uint, uint data);
	uint M_Read0(uint);
	uint M_Read1(uint);
	uint M_Read2(uint);

	void S_Set0(uint, uint data);
	void S_Set1(uint, uint data);
	void S_Set2(uint, uint data);
	void S_SetCW(uint, uint data);
	uint S_Read0(uint);
	uint S_Read1(uint);
	uint S_Read2(uint);

	const Descriptor* GetDesc() const { return &descriptor; }

private:
	bool InitMemory();
	bool LoadROM();
	void PatchROM();

	Bus* bus;
	uint8* rom;
	uint8* ram;
	uint8* dummy;
	PIO piom, pios;
	uint idlecount;

private:
	static const Descriptor descriptor;
	static const InFuncPtr  indef[];
	static const OutFuncPtr outdef[];
};

} // namespace PC8801

#endif // pc88_subsys_h
