// ---------------------------------------------------------------------------
//  M88 - PC-8801 emulator
//  Copyright (C) cisc 1998, 1999.
// ---------------------------------------------------------------------------
//  $Id: 88config.h,v 1.7 1999/06/28 12:08:55 cisc Exp $

#if !defined(win32_88config_h)
#define win32_88config_h

#include "pc88/config.h"
#include "instthnk.h"
#include "88config.h"

// ---------------------------------------------------------------------------

namespace PC8801
{

void SaveConfig(Config* cfg, const char* inifile, bool writedefault);
void LoadConfig(Config* cfg, const char* inifile, bool applydefault);
void LoadConfigDirectory(Config* cfg, const char* inifile, const char* entry);

class WinConfig
{
public:
    WinConfig();
    ~WinConfig();

#ifdef __OS2__
    bool Show(HWND, Config* config);
#else
    bool Show(HINSTANCE, HWND, Config* config);
    bool ProcMsg(MSG& msg);
#endif
    bool IsOpen() { return !!hwndps; }
    void Close();

private:
    enum Index { cpu=0, screen, sound, soundvol, switches, function, env, term };

#ifdef __OS2__
#else
    void FillInPropPage(PROPSHEETPAGE* psp, int iddlg, void* dlgproc);
#endif

#ifdef __OS2__
#else
    int PropProc(HWND, UINT, LPARAM);

    static int _cdecl PropProcGate(WinConfig*, HWND, UINT, LPARAM);

    // CPUPage
    BOOL CPUPage(HWND, UINT, WPARAM, LPARAM);
    BOOL CPUPageCommand(HWND hdlg, HWND hwctl, UINT nc, UINT id);
    void CPUPageUpdate(HWND hdlg);
    void CPUPageUpdateSlider(HWND hdlg);
    static BOOL _cdecl CPUPageGate(WinConfig*, HWND, UINT, WPARAM, LPARAM);

    // ScreenPage
    BOOL ScreenPage(HWND, UINT, WPARAM, LPARAM);
    BOOL ScreenPageCommand(HWND hdlg, HWND hwctl, UINT nc, UINT id);
    void ScreenPageUpdate(HWND hdlg);
    static BOOL _cdecl ScreenPageGate(WinConfig*, HWND, UINT, WPARAM, LPARAM);

    // FunctionPage
    BOOL FunctionPage(HWND, UINT, WPARAM, LPARAM);
    BOOL FunctionPageCommand(HWND hdlg, HWND hwctl, UINT nc, UINT id);
    void FunctionPageUpdate(HWND hdlg);
    static BOOL _cdecl FunctionPageGate(WinConfig*, HWND, UINT, WPARAM, LPARAM);

    // SoundPage
    BOOL SoundPage(HWND, UINT, WPARAM, LPARAM);
    BOOL SoundPageCommand(HWND hdlg, HWND hwctl, UINT nc, UINT id);
    void SoundPageUpdate(HWND hdlg);
    static BOOL _cdecl SoundPageGate(WinConfig*, HWND, UINT, WPARAM, LPARAM);

    // SoundVolumePage
    BOOL SoundVolumePage(HWND, UINT, WPARAM, LPARAM);
    BOOL SoundVolumePageCommand(HWND hdlg, HWND hwctl, UINT nc, UINT id);
    void SoundVolumePageUpdateSlider(HWND hdlg);
    static BOOL _cdecl SoundVolumePageGate(WinConfig*, HWND, UINT, WPARAM, LPARAM);
    void InitVolumeSlider(HWND hdlg, UINT id, int val);
    void SoundSetVolumeText(HWND hdlg, int id, int val);

    // SwitchPage
    BOOL SwitchPage(HWND, UINT, WPARAM, LPARAM);
    BOOL SwitchPageCommand(HWND hdlg, HWND hwctl, UINT nc, UINT id);
    void SwitchPageUpdate(HWND hdlg);
    static BOOL _cdecl SwitchPageGate(WinConfig*, HWND, UINT, WPARAM, LPARAM);

    // SwitchPage
    BOOL EnvPage(HWND, UINT, WPARAM, LPARAM);
    BOOL EnvPageCommand(HWND hdlg, HWND hwctl, UINT nc, UINT id);
    void EnvPageUpdate(HWND hdlg);
    static BOOL _cdecl EnvPageGate(WinConfig*, HWND, UINT, WPARAM, LPARAM);
#endif

    // thunks
#ifdef __OS2__
#else
    InstanceThunk propproc;
    InstanceThunk cpupage;
    InstanceThunk screenpage;
    InstanceThunk functionpage;
    InstanceThunk soundpage;
    InstanceThunk soundvolpage;
    InstanceThunk switchpage;
    InstanceThunk envpage;
#endif

    //
    HWND hwndparent;
    HWND hwndps;
#ifdef __OS2__
#else
    HINSTANCE hinst;
#endif
    Config config;
    Config orgconfig;
    int page;
};

}

#endif // !defined(win32_88config_h)
