// ---------------------------------------------------------------------------
//  M88 - PC8801 emulator
//  Copyright (C) cisc 1998, 1999.
// ---------------------------------------------------------------------------
//  DirectDraw ɂSʕ`
// ---------------------------------------------------------------------------
//  $Id: DrawDDS.cpp,v 1.3 1999/07/15 12:39:26 cisc Exp $

#include "headers.h"
#include "misc.h"
#include "DrawDDS.h"

#define RELCOM(x)  if (x) x->Release(), x=0; else 0

// ---------------------------------------------------------------------------
//  \z
//
#ifdef __OS2__
WinDrawDDS::WinDrawDDS(bool force480)
{
//    ddraw = 0;
//    ddsscrn = 0;
//    ddcscrn = 0;
//    ddpal = 0;
//    ddswork = 0;
    palchanged = false;
    image = 0;
    bpl = 0;
    guimode = true;
    lines = force480 ? 480 : 0;
}
#else
WinDrawDDS::WinDrawDDS(bool force480)
{
    ddraw = 0;
    ddsscrn = 0;
    ddcscrn = 0;
    ddpal = 0;
    ddswork = 0;
    palchanged = false;
    image = 0;
    bpl = 0;
    guimode = true;
    lines = force480 ? 480 : 0;
}
#endif

// ---------------------------------------------------------------------------
//  j
//
WinDrawDDS::~WinDrawDDS()
{
    Cleanup();
}

// ---------------------------------------------------------------------------
//  
//
#ifdef __OS2__
bool WinDrawDDS::Init(HWND hwindow)
{
    hwnd = hwindow;

    image = new uint8[640*400];
    bpl = 640;
    screenheight = 400;
    if (!image) return false;
    memset(image, 0x40, 640*400);

    if (!CreateDD2()) return false;

//    if (DD_OK != ddraw->SetCooperativeLevel
//                        (hwnd, DDSCL_EXCLUSIVE | DDSCL_FULLSCREEN | DDSCL_ALLOWREBOOT))
//        return false;

    if (!SetScreenMode()) return false;

    if (!CreateDDS()) return false;

    CreateDDPalette();

    guimode = true;
    SetGUIMode(false);
    return true;
}
#else
bool WinDrawDDS::Init(HWND hwindow)
{
    hwnd = hwindow;

    image = new uint8[640*400];
    bpl = 640;
    screenheight = 400;
    if (!image) return false;
    memset(image, 0x40, 640*400);

    if (!CreateDD2()) return false;

    if (DD_OK != ddraw->SetCooperativeLevel
                        (hwnd, DDSCL_EXCLUSIVE | DDSCL_FULLSCREEN | DDSCL_ALLOWREBOOT))
        return false;

    if (!SetScreenMode()) return false;

    if (!CreateDDS()) return false;

    CreateDDPalette();

    guimode = true;
    SetGUIMode(false);
    return true;
}
#endif

// ---------------------------------------------------------------------------
//  Cleanup
//
#ifdef __OS2__
bool WinDrawDDS::Cleanup()
{
    delete[] image; image = 0;
    return true;
}
#else
bool WinDrawDDS::Cleanup()
{
    if (ddraw)
    {
        ddraw->SetCooperativeLevel(hwnd, DDSCL_NORMAL);
    }
    RELCOM(ddpal);
    RELCOM(ddcscrn);
    RELCOM(ddswork);
    RELCOM(ddsscrn);
    RELCOM(ddraw);
    delete[] image; image = 0;
    return true;
}
#endif
// ---------------------------------------------------------------------------
//  DirectDraw2 
//
#ifdef __OS2__
bool WinDrawDDS::CreateDD2()
{
    return true;
}
#else
bool WinDrawDDS::CreateDD2()
{
    LPDIRECTDRAW ddraw1;
    if (DD_OK != DirectDrawCreate(0, &ddraw1, 0))
        return false;
    if (S_OK != ddraw1->QueryInterface(IID_IDirectDraw2, (void**)&ddraw))
        return false;
    return true;
}
#endif
// ---------------------------------------------------------------------------
//  Surface 
//
#ifdef __OS2__
bool WinDrawDDS::CreateDDS()
{
    return true;
}
#else
bool WinDrawDDS::CreateDDS()
{
    // \T[tFX쐬
    DDSURFACEDESC ddsd;
    memset(&ddsd, 0, sizeof(DDSURFACEDESC));
    ddsd.dwSize = sizeof(ddsd);
    ddsd.dwFlags = DDSD_CAPS;
    ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE;

    if (DD_OK != ddraw->CreateSurface(&ddsd, &ddsscrn, 0))
        return false;

    // Nbp[쐬
    if (DD_OK != ddraw->CreateClipper(0, &ddcscrn, 0))
        return false;

    ddcscrn->SetHWnd(0, hwnd);

    // ƗpT[tFX쐬
    memset(&ddsd, 0, sizeof(DDSURFACEDESC));
    ddsd.dwSize = sizeof(ddsd);
    ddsd.dwFlags = DDSD_WIDTH | DDSD_HEIGHT | DDSD_CAPS;
    ddsd.dwWidth = 640;
    ddsd.dwHeight = 400;
    ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN;

    if (DD_OK != ddraw->CreateSurface(&ddsd, &ddswork, 0))
        return false;

    return true;
}
#endif

// ---------------------------------------------------------------------------
//  pbg
//
#ifdef __OS2__
bool WinDrawDDS::CreateDDPalette()
{
    return true;
}
#else
bool WinDrawDDS::CreateDDPalette()
{
    int i;

    HDC hdc = GetDC(hwnd);
    GetSystemPaletteEntries(hdc, 0, 256, palentry);
    ReleaseDC(hwnd, hdc);

    for (i=0x40; i<0xd0; i++)
    {
        palentry[i].peFlags = PC_RESERVED | PC_NOCOLLAPSE;
    }
    if (DD_OK == ddraw->CreatePalette(DDPCAPS_8BIT, palentry, &ddpal, 0))
    {
        ddsscrn->SetPalette(ddpal);
    }
    return true;
}
#endif
// ---------------------------------------------------------------------------
//  `
//
#ifdef __OS2__
void WinDrawDDS::DrawScreen(int top, int bottom, bool refresh)
{
    RECTL rect;
    rect.xLeft = 0;
    rect.yTop = top;
    rect.xRight = 640;
    rect.yBottom = bottom+1;

    if (palchanged)
    {
        palchanged = false;
//        ddpal->SetEntries(0, 0x40, 0x90, &palentry[64]);
    }

    if (refresh)
    {
        refresh = false;
        rect.yTop = 0, rect.yBottom = 400;
//        FillBlankArea();
    }


    // Ɨ̈XV
    if (rect.yTop <= rect.yBottom)
    {
//        if (DDERR_SURFACELOST == ddswork->IsLost())
//        {
//            if (!RestoreSurface())
//                return;
//            return;
//        }
//        else
//        {
//            DDSURFACEDESC ddsd;
//            memset(&ddsd, 0, sizeof(ddsd));
//            ddsd.dwSize = sizeof(ddsd);
//            if (DD_OK != ddswork->Lock(&rect, &ddsd, 0, 0))
//                return;

//            const uint8* src = image + rect.top * 640;
//            uint8* dest = (uint8*) ddsd.lpSurface;

//            for (int y=rect.top; y<=rect.bottom; y++)
//            {
//                memcpy(dest, src, rect.right-rect.left);
//                src += 640;
//                dest += ddsd.lPitch;
//            }

//            ddswork->Unlock(0);
//        }
    }

    if (rect.yTop <= rect.yBottom)
    {
        if (guimode)
        {
//            RECT rectdest;
//            rectdest.left = 0 + rect.left;
//            rectdest.right = 0 + rect.right;
//            rectdest.top = (lines - 400) / 2 + rect.top;
//            rectdest.bottom = (lines - 400) / 2 + rect.bottom;

//            if (DDERR_SURFACELOST == ddsscrn->Blt(&rectdest, ddswork, &rect, 0, 0))
//            {
//                RestoreSurface();
//            }
        }
        else
        {
//            if (DDERR_SURFACELOST == ddsscrn->BltFast
//                (0, (lines-400)/2+rect.top, ddswork, &rect, DDBLTFAST_NOCOLORKEY))
//            {
//                RestoreSurface();
//            }
//
        }
    }
}
#else
void WinDrawDDS::DrawScreen(int top, int bottom, bool refresh)
{
    RECT rect;
    rect.left = 0;
    rect.top = top;
    rect.right = 640;
    rect.bottom = bottom;

    if (palchanged)
    {
        palchanged = false;
        ddpal->SetEntries(0, 0x40, 0x90, &palentry[64]);
    }

    if (refresh)
    {
        refresh = false;
        rect.top = 0, rect.bottom = 399;
        FillBlankArea();
    }

    // Ɨ̈XV
    if (rect.top <= rect.bottom)
    {
        if (DDERR_SURFACELOST == ddswork->IsLost())
        {
            if (!RestoreSurface())
                return;
            return;
        }
        else
        {
            DDSURFACEDESC ddsd;
            memset(&ddsd, 0, sizeof(ddsd));
            ddsd.dwSize = sizeof(ddsd);
            if (DD_OK != ddswork->Lock(&rect, &ddsd, 0, 0))
                return;

            const uint8* src = image + rect.top * 640;
            uint8* dest = (uint8*) ddsd.lpSurface;

            for (int y=rect.top; y<=rect.bottom; y++)
            {
                memcpy(dest, src, rect.right-rect.left);
                src += 640;
                dest += ddsd.lPitch;
            }

            ddswork->Unlock(0);
        }
    }

    if (rect.top <= rect.bottom)
    {
        rect.bottom++;
        if (guimode)
        {
            RECT rectdest;
            rectdest.left = 0 + rect.left;
            rectdest.right = 0 + rect.right;
            rectdest.top = (lines - 400) / 2 + rect.top;
            rectdest.bottom = (lines - 400) / 2 + rect.bottom;

            if (DDERR_SURFACELOST == ddsscrn->Blt(&rectdest, ddswork, &rect, 0, 0))
            {
                RestoreSurface();
            }
        }
        else
        {
            if (DDERR_SURFACELOST == ddsscrn->BltFast
                (0, (lines-400)/2+rect.top, ddswork, &rect, DDBLTFAST_NOCOLORKEY))
            {
                RestoreSurface();
            }

        }
    }
}
#endif

// ---------------------------------------------------------------------------
//  WM_QUERYNEWPALETTE
//
void WinDrawDDS::QueryNewPalette()
{
}

// ---------------------------------------------------------------------------
//  pbgݒ
//
#ifdef __OS2__
void WinDrawDDS::SetPalette(PALETTEENTRY* pe)
{
}
#else
void WinDrawDDS::SetPalette(PALETTEENTRY* pe)
{
    for (int i=0; i<0x90; i++)
    {
        palentry[i+0x40].peRed = pe[i].peRed;
        palentry[i+0x40].peBlue = pe[i].peBlue;
        palentry[i+0x40].peGreen = pe[i].peGreen;
    }
    palchanged = true;
}
#endif
// ---------------------------------------------------------------------------
//  ʃC[W̎gpv
//
bool WinDrawDDS::Lock(uint8** pimage, int* pbpl)
{
    *pimage = image;
    *pbpl = bpl;
    return true;
}

// ---------------------------------------------------------------------------
//  ʃC[W̎gpI
//
bool WinDrawDDS::Unlock()
{
    return true;
}

// ---------------------------------------------------------------------------
//  ʃ[h؂ւ
//
#ifdef __OS2__
bool WinDrawDDS::SetScreenMode()
{
    return true;
}
#else
bool WinDrawDDS::SetScreenMode()
{
    DDSURFACEDESC ddsd;
    memset(&ddsd, 0, sizeof(ddsd));
    ddsd.dwSize = sizeof(ddsd);
    ddsd.dwFlags = DDSD_WIDTH;
    ddsd.dwWidth = 640;

    if (!lines)
    {
        if (DD_OK != ddraw->EnumDisplayModes(0, &ddsd, reinterpret_cast<LPVOID>(this), EDMCallBack))
            return false;
        if (!lines)
            return false;
    }

    if (DD_OK != ddraw->SetDisplayMode(640, lines, 8, 0, 0))
        return false;

    return true;
}
#endif

#ifdef __OS2__
#else
HRESULT WINAPI WinDrawDDS::EDMCallBack(LPDDSURFACEDESC pddsd, LPVOID context)
{
    WinDrawDDS* wd = reinterpret_cast<WinDrawDDS*> (context);

    if (pddsd->ddpfPixelFormat.dwRGBBitCount == 8)
    {
        if (pddsd->dwHeight == 400)
        {
            wd->lines = 400;
            return DDENUMRET_CANCEL;
        }
        if (pddsd->dwHeight == 480 && !wd->lines)
        {
            wd->lines = 480;
        }
    }
    return DDENUMRET_OK;
}
#endif

// ---------------------------------------------------------------------------
//  XgT[tFX߂
//
#ifdef __OS2__
bool WinDrawDDS::RestoreSurface()
{
    return true;
}
#else
bool WinDrawDDS::RestoreSurface()
{
    if (DD_OK != ddsscrn->Restore() || DD_OK != ddswork->Restore())
        return false;

    // ƃT[tFX̒g
    DDSURFACEDESC ddsd;
    memset(&ddsd, 0, sizeof(ddsd));
    ddsd.dwSize = sizeof(ddsd);
    if (DD_OK != ddswork->Lock(0, &ddsd, 0, 0))
        return false;

    const uint8* src = image;
    uint8* dest = (uint8*) ddsd.lpSurface;

    for (int y=0; y<=399; y++)
    {
        memcpy(dest, src, 640);
        src += 640;
        dest += ddsd.lPitch;
    }
    ddswork->Unlock(0);

    // Primary Surface ̒g
    FillBlankArea();

    RECT rectsrc;
    rectsrc.left = 0;       rectsrc.top = 0;
    rectsrc.right = 640;    rectsrc.bottom = 400;

    RECT rectdest;
    rectdest.left = 0 + rectsrc.left;
    rectdest.right = 0 + rectsrc.right;
    rectdest.top = (lines - 400) / 2 + rectsrc.top;
    rectdest.bottom = (lines - 400) / 2 + rectsrc.bottom;

    if (DD_OK != ddsscrn->Blt(&rectdest, ddswork, &rectsrc, 0, 0))
        return false;
    return true;
}
#endif

// ---------------------------------------------------------------------------
//  \̈
//
#ifdef __OS2__
void WinDrawDDS::FillBlankArea()
{
    if (lines > 400)
    {
    }
}
#else
void WinDrawDDS::FillBlankArea()
{
    if (lines > 400)
    {
        DDBLTFX ddbltfx;
        ddbltfx.dwSize = sizeof(ddbltfx);
        ddbltfx.dwFillColor = 0;

        RECT rect;
        rect.left = 0;      rect.top = 0;
        rect.right = 640;   rect.bottom = (lines-400)/2;
        ddsscrn->Blt(&rect, NULL, NULL, DDBLT_COLORFILL, &ddbltfx);

        rect.top = (lines+400) / 2 + (400 - screenheight);
        rect.bottom = lines;
        ddsscrn->Blt(&rect, NULL, NULL, DDBLT_COLORFILL, &ddbltfx);
    }
}
#endif

// ---------------------------------------------------------------------------
//  GUI [h؂ւ
//
#ifdef __OS2__
void WinDrawDDS::SetGUIMode(bool newguimode)
{
    if (newguimode != guimode)
    {
        guimode = newguimode;
    }
}
#else
void WinDrawDDS::SetGUIMode(bool newguimode)
{
    if (newguimode != guimode)
    {
        guimode = newguimode;
        if (guimode)
        {
            ddsscrn->SetClipper(ddcscrn);
        }
        else
        {
            ddsscrn->SetClipper(0);

            FillBlankArea();

            RECT rectsrc;
            rectsrc.left = 0;       rectsrc.top = 0;
            rectsrc.right = 640;    rectsrc.bottom = screenheight;

            RECT rectdest;
            rectdest.left = 0 + rectsrc.left;
            rectdest.right = 0 + rectsrc.right;
            rectdest.top = (lines - 400) / 2 + rectsrc.top;
            rectdest.bottom = (lines - 400) / 2 + rectsrc.bottom;

            ddsscrn->Blt(&rectdest, ddswork, &rectsrc, 0, 0);
        }
    }
}
#endif

// ---------------------------------------------------------------------------
//  \̈ݒ肷
//
void WinDrawDDS::Resize(uint w, uint h)
{
    screenheight = h;
}

