// ---------------------------------------------------------------------------
//  M88 - PC88 emulator
//  Copyright (C) cisc 1998, 1999.
// ---------------------------------------------------------------------------
//  GDI ɂʕ`
// ---------------------------------------------------------------------------
//  $Id: DrawGDI.h,v 1.2 1999/03/28 06:56:41 cisc Exp $

#if !defined(win32_drawgdi_h)
#define win32_drawgdi_h

// ---------------------------------------------------------------------------

#include "WinDraw.h"

class WinDrawGDI : public WinDrawSub
{
public:
    WinDrawGDI();
    ~WinDrawGDI();

    bool Init(HWND hwnd);
    void Resize(uint width, uint height);
    bool Cleanup();
    void SetPalette(PALETTEENTRY* pal);
    void QueryNewPalette();
    void DrawScreen(int top, int bottom, bool refresh);
    bool Lock(uint8** pimage, int* pbpl);
    bool Unlock();

private:
    struct BI256        // BITMAPINFO
    {
#ifdef __OS2__
        BITMAPINFOHEADER2 header;
        RGB2 colors[256];
#else
        BITMAPINFOHEADER header;
        RGBQUAD colors[256];
#endif
    };

private:
    bool    MakeBitmap();

    HBITMAP hbitmap;
    uint8*  bitmapimage;
    HWND    hwnd;
    uint8*  image;
    int     bpl;
    uint    height;
    bool    updatepal;
    BI256   binfo;
};

#endif // !defined(win32_drawgdi_h)
