// ---------------------------------------------------------------------------
//  M88 - PC-8801 Emulator
//  Copyright (C) cisc 1998, 1999.
// ---------------------------------------------------------------------------
//  generic file io class
// ---------------------------------------------------------------------------
//  $Id: file.h,v 1.3 1999/03/24 23:27:20 cisc Exp $

#if !defined(win32_file_h)
#define win32_file_h

#include "headers.h"
#include "types.h"

// ---------------------------------------------------------------------------

class FileIO
{
public:
    enum Flags
    {
        open        = 0x000001,
        readonly    = 0x000002,
        create      = 0x000004,
    };

    enum SeekMethod
    {
        begin = 0, current = 1, end = 2,
    };

public:
    FileIO();
    FileIO(const char* filename, uint flg = 0);
    virtual ~FileIO();

    bool Open(const char* filename, uint flg = 0);
    bool CreateNew(const char* filename);
    bool Reopen(uint flg = 0);
    void Close();

    int32 Read(void* dest, int32 len);
    int32 Write(const void* src, int32 len);
    bool Seek(int32 fpos, SeekMethod method);
    int32 Tellp();
    bool SetEndOfFile();

    uint GetFlags() { return flags; }
    void SetLogicalOrigin(int32 origin) { lorigin = origin; }

private:
#ifndef __OS2__
    HANDLE hfile;
#else
    HFILE hfile;
#endif
    uint flags;
    uint32 lorigin;
    char path[MAX_PATH];

    FileIO(const FileIO&);
    const FileIO& operator=(const FileIO&);
};

#endif // !defined(FILE_H__52E5CBD2_FC06_11D1_BCAF_00A0C90AC9DA__INCLUDED_)
