// ---------------------------------------------------------------------------
//  M88 - PC-8801 emulator
//  Copyright (C) cisc 1998, 1999.
// ---------------------------------------------------------------------------
//  NewDisk Dialog Box for M88
// ---------------------------------------------------------------------------
//  $Id: newdisk.h,v 1.3 1999/06/28 12:08:56 cisc Exp $

#if !defined(WIN32_NEWDISK_H)
#define WIN32_NEWDISK_H

#include "types.h"
#include "instthnk.h"

// ---------------------------------------------------------------------------

class WinNewDisk
{
public:
    enum DiskType
    {
        MD2D=0, MD2DD, MD2HD
    };
public:
    WinNewDisk();
    ~WinNewDisk() {}

#ifdef __OS2__
    bool Show(HWND);
#else
    bool Show(HINSTANCE, HWND);
#endif
    const char* GetTitle() { return info.title; }
    DiskType GetType() { return info.type; }
    bool DoFormat() { return info.basicformat; }

    struct DiskInfo
    {
        char title[20];
        DiskType type;
        bool basicformat;
    };

private:
#ifdef __OS2__
    static MRESULT EXPENTRY DlgProc(HWND, ULONG, MPARAM, MPARAM);
#else
    BOOL DlgProc(HWND, UINT, WPARAM, LPARAM);
    static BOOL _cdecl DlgProcGate(WinNewDisk*, HWND, UINT, WPARAM, LPARAM);

    InstanceThunk dlgproc;
#endif
    DiskInfo info;
};

#endif // !defined(WIN32_NEWDISK_H)
