// ---------------------------------------------------------------------------
//  M88 - PC-8801 emulator
//  Copyright (C) cisc 1998, 1999.
// ---------------------------------------------------------------------------
//  User Interface for Win32
// ---------------------------------------------------------------------------
//  $Id: ui.h,v 1.18 1999/07/10 10:14:03 cisc Exp $

#ifndef win_ui_h
#define win_ui_h

#include "types.h"
#include "instthnk.h"
#include "wincore.h"
#include "WinDraw.h"
#include "WinKeyIF.h"
#include "88config.h"
#include "newdisk.h"
#include "soundmon.h"
#include "memmon.h"
#include "codemon.h"

// ---------------------------------------------------------------------------

class WinUI
{
public:
#ifdef __OS2__
    WinUI();
#else
    WinUI(HINSTANCE hinst);
#endif
    ~WinUI();

#ifdef __OS2__
    bool InitWindow();
#else
    bool InitWindow(int nwinmode);
#endif
    int  Main(const char* cmdline);
    uint GetMouseButton() { return mousebutton; }
    HWND GetHWnd() { return hwnd; }

private:
    struct DiskInfo
    {
#ifdef __OS2__
        HWND hmenu;
#else
        HMENU hmenu;
#endif
        int currentdisk;
        int idchgdisk;
        bool readonly;
        char filename[MAX_PATH];
    };

#ifdef __OS2__
    typedef BOOL (* PENABLEIME)(HWND, BOOL);
#else
    typedef BOOL (WINAPI* PENABLEIME)(HWND, BOOL);
#endif

private:
    bool InitM88(const char* cmdline);
    void CleanupM88();
#ifdef __OS2__
    static MRESULT EXPENTRY WinProcGate(HWND, ULONG, MPARAM, MPARAM);
#else
    static LRESULT _stdcall WinProcGate(WinUI*, HWND, UINT, WPARAM, LPARAM);
#endif
    void ReportError();
    void Reset();

    void ApplyConfig();
    void ApplyCommandLine(const char* cmdline);

    void ToggleDisplayMode();
    void ChangeDisplayType(bool savepos);

    void GetDLLAddress();
    bool EnableIME(HWND hwnd, BOOL flag);

    void ChangeDiskImage(HWND hwnd, int drive);
    bool OpenDiskImage(int drive, const char* filename, bool readonly, int id, bool create);
    void OpenDiskImage(const char* filename);
    bool SelectDisk(uint drive, int id, bool menuonly);
    bool CreateDiskMenu(uint drive);

    void ShowStatusWindow();
    void ResizeWindow(uint width, uint height);
    void SetGUIFlag(bool);

    void CaptureScreen();

#ifdef __OS2__
    HWND hwnd;
    HWND hwndMenu;
    HWND hwndDrive[2];
    HWND hwndFrame;
    HWND hwndClient;
    UINT timerid;
    PENABLEIME penableime;
#else
    InstanceThunk winproc;
    HWND hwnd;
    HINSTANCE hinst;
    HACCEL accel;
    UINT timerid;
    PENABLEIME penableime;
#endif

    bool report;
    bool haspalette;
    volatile bool active;
    bool background;
    bool fullscreen;

    uint displaychangedtime;
    uint resetwindowsize;

#ifdef __OS2__
    HAB   hab;
    HMQ   hmq;
#else
    DWORD wstyle;
#endif

    POINT point;
    DiskInfo diskinfo[2];

    bool capturemouse;
    uint mousebutton;

    WinCore core;
    WinDraw draw;
    PC8801::WinKeyIF keyif;
    PC8801::Config config;
    PC8801::WinConfig winconfig;
    WinNewDisk newdisk;
    OPNMonitor opnmon;
    PC8801::MemoryMonitor memmon;
    PC8801::CodeMonitor codemon;
    DiskManager* diskmgr;

private:
#ifdef __OS2__
#define WPARAM  MPARAM
#define LPARAM  MPARAM
#define LRESULT MRESULT
#endif
    uint M88ChangeDisplay(HWND, WPARAM, LPARAM);
    uint M88ChangeVolume(HWND, WPARAM, LPARAM);
    uint M88ApplyConfig(HWND, WPARAM, LPARAM);
    uint M88SendKeyState(HWND, WPARAM, LPARAM);
    uint WmDropFiles(HWND, WPARAM, LPARAM);
    uint WmDisplayChange(HWND, WPARAM, LPARAM);
    uint WmKeyDown(HWND, WPARAM, LPARAM);
    uint WmKeyUp(HWND, WPARAM, LPARAM);
    uint WmSysKeyDown(HWND, WPARAM, LPARAM);
    uint WmSysKeyUp(HWND, WPARAM, LPARAM);
    uint WmInitMenu(HWND, WPARAM, LPARAM);
    uint WmQueryNewPalette(HWND, WPARAM, LPARAM);
    uint WmPaletteChanged(HWND, WPARAM, LPARAM);
    uint WmActivate(HWND, WPARAM, LPARAM);
    uint WmTimer(HWND, WPARAM, LPARAM);
    uint WmClose(HWND, WPARAM, LPARAM);
    uint WmCreate(HWND, WPARAM, LPARAM);
    uint WmDestroy(HWND, WPARAM, LPARAM);
    uint WmPaint(HWND, WPARAM, LPARAM);
#ifdef __OS2__
    uint WmCommand(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
#else
    uint WmCommand(HWND, WPARAM, LPARAM);
#endif
    uint WmSize(HWND, WPARAM, LPARAM);
    uint WmDrawItem(HWND, WPARAM, LPARAM);
    uint WmEnterMenuLoop(HWND, WPARAM, LPARAM);
    uint WmExitMenuLoop(HWND, WPARAM, LPARAM);
    uint WmLButtonDown(HWND, WPARAM, LPARAM);
    uint WmLButtonUp(HWND, WPARAM, LPARAM);
    uint WmRButtonDown(HWND, WPARAM, LPARAM);
    uint WmRButtonUp(HWND, WPARAM, LPARAM);
    uint WmEnterSizeMove(HWND, WPARAM, LPARAM);
    uint WmExitSizeMove(HWND, WPARAM, LPARAM);
#ifdef __OS2__
    MRESULT WinProc(HWND, ULONG, MPARAM, MPARAM);
#else
    LRESULT WinProc(HWND, UINT, WPARAM, LPARAM);
#endif
};

#endif // WIN_UI_H
