/* REXX: adding URL to PM Downloader */

/* Load RexxUtil functions, we need SysWaitNamedPipe() */
call rxFuncAdd "SysLoadFuncs" , "RexxUtil" , "SysLoadFuncs"
call SysLoadFuncs

/* Name of control pipe */
pname = "\PIPE\PMDOWNLOADER"

/* Get argument from command line (need some workaround here) */
"@SET ADDURLTMP=%1"
url=VALUE("ADDURLTMP",,"OS2ENVIRONMENT")

/* If no URL is given, exit with errorlevel 1 */
if url="" then do
    say "Usage: addurl <URL>"
    exit 1
end

os2rc=0

/* Loop */
do forever
    /* Try open control pipe for writing */
    opret = stream(pname,"C","open write")
    if opret == "READY:" then do
        /* Pipe opened, write URL to pipe */
        call lineout pname,url
        /* Close pipe */
        call lineout pname
        /* All done, exit with errorlevel 0 */
        say "URL "||url||" added."
        exit 0
    end
    
    /* Pipe not opened, opret contains something like "NOTREADY:errorcode"
       Parse opret to get errorcode */
    parse value opret with pstate ":" os2rc
    
    /* OS/2 errorcode 231 indicates pipe busy, and we call SysWaitNamedPipe
       to wait when pipe become available */
    if os2rc=231 then do
        os2rc = SysWaitNamedPipe( pname , -1 )

        /* Non-zero return value indicates error, pipe not available */
        if os2rc\=0 then leave
    end
    else leave  /* Another error, pipe not available */

    /* retry loop after calling SysWaitNamedPipe */
end

/* Loop is ended, which indicates error */
/* Print error message and errorcode and exit with errorlevel 1 */
/* To get more info on specific errorcode, type in command window
   "help <errorcode>", where <errorcode> is OS/2 error number */
say "Can't open pipe '"||pname||"', rc: "||os2rc||"."
exit 1

