#include "infowindow.h"
#include "ui_infowindow.h"
#include <QMessageBox>
#include <QtDebug>

const int BUILD_VERS = 110719;

InfoWindow::InfoWindow(QDialog *parent) :
        QDialog(parent),
        ui(new Ui::InfoWindow)
{
    ui->setupUi(this);
    translate();

    //moves the window to the center of the screen
    this->move( (QApplication::desktop()->width() / 2) - (this->width()/2)-230,
                (QApplication::desktop()->height() / 2) - (this->height() / 2) );
}

InfoWindow::~InfoWindow()
{
    delete ui;
    delete http;
    delete byteArray;
    delete buffer;
}

void InfoWindow::on_pb_cancel_clicked()
{
    this->close();
}

void InfoWindow::translate()
{
    ui->retranslateUi(this);
}

void InfoWindow::on_pb_update_clicked()
{
    ui->pb_update->setDisabled(true);

    QUrl url("http://neroniuos.bplaced.net/qtcumber/buildvers");

    http = new QHttp;

    byteArray = new QByteArray;
    buffer = new QBuffer(byteArray);

    buffer->open(QIODevice::WriteOnly);

    http->setHost(url.host(), 80);
    http->get(url.path(), buffer);

    connect( http, SIGNAL(requestFinished(int,bool)),
             this, SLOT(httpRequestFinished(int,bool)) );
}

void InfoWindow::httpRequestFinished(int requestId, bool error)
{
    ui->pb_update->setEnabled(true);

    int buildvers = 0;

    if( byteArray->count() <= 0 )
        return;

    QString str(*byteArray);

    buildvers = str.toInt();

    if( BUILD_VERS < buildvers )
        QMessageBox::information( 0, tr("New version available"),
                                  tr("Download the new version <a href=\"http://neroniuos.bplaced.net/qtcumber/\">here</a>") );
    else
        QMessageBox::information( 0, tr("Up to date"),
                                  tr("No new version available.") );
}
