#include <QtGui/QApplication>
#include "mainwindow.h"

int main(int argc, char *argv[])
{
    QApplication a(argc, argv);

    QFile res(":/fonts/font/ubuntu.ttf");
    res.open(QIODevice::ReadOnly);
    QFontDatabase::addApplicationFontFromData(res.readAll());
    res.close();
    QFont font("ubuntu", 12);
    QApplication::setFont(font);

    QSettings settings(QObject::tr("%1/save.ini").arg(qApp->applicationDirPath()),QSettings::IniFormat);

    // if no ini exists -> create
    if( !QFile::exists(qApp->applicationDirPath() + "/save.ini") )
    {
        QDir dlDir( qApp->applicationDirPath() );
        dlDir.cdUp();
        if( !dlDir.cd("downloads") )
        {
            dlDir.mkdir("downloads");
            dlDir.cd("downloads");
        }

        settings.setValue( "filesavepath", dlDir.path() );
        settings.setValue("language", "english");

        for( int i = 0; i < 10; i++ )
        {
            settings.setValue(QObject::tr("ipaddr/%1").arg(i), "");
            settings.setValue(QObject::tr("naddr/%1").arg(i), "");
        }
    }

    // ### translation
    QTranslator translator;
    translator.load( "../languages/" + settings.value("language", "english").toString() );
    qApp->installTranslator(&translator);
    // ###############

    ConnWindow cW;

    if( cW.exec() != 0 )    // if ConnectionWindow closed by the "X"
        exit(0);

    MainWindow w( cW.getSimpleNet() );  //object of MainWindow with simplenetwork-class as parameter

    w.show();               //opens the MainWindow

    return a.exec();
}
