#       Program:        nmake.mak                      15 May 1989
#       Author:         Andrew H. Derbyshire
#                       Kendra Electronic Wonderworks
#                       P. O. Box 132
#                       Arlington, MA 02174
#       Function:       Build UUPC/extended from source files
#       Processor:      Microsoft nmake
#       External files: MASM            (8088 Assembler)
#                       CL              (Microsoft C 6.0 compiler)
#                       LINK or         (MS-DOS Linker)
#                       LINK386         (OS/2 Linker)
#                       Input source files.
#
#       Copyright (c) 1989-1994 by Kendra Electronic Wonderworks;
#       all rights reserved except those explicitly granted by
#       the UUPC/extended license.
#
#       nmk /nologo /s /f nmake.mak prodr
#       nmake /nologo /s /f nmake.mak prodp
#       nmake /nologo /s /f nmake.mak prodn
#
#       $Id: nmake.mak 1.75 1994/10/23 23:38:47 ahd Exp $
#
#       $Log: nmake.mak $
#       Revision 1.75  1994/10/23  23:38:47  ahd
#       Transform library names in executable before installing into prod
#
#       Revision 1.74  1994/05/30  02:18:25  ahd
#       Go to version 1.12k
#       More complete build for uupcdll.dll (it doesn't work, oh well)
#
#       Revision 1.73  1994/05/23  21:40:46  dmwatt
#       Add Windows NT utilities
#       Add UUCICO without TCP/IP for OS/2 32 bit
#
#       Revision 1.72  1994/03/20  00:51:12  ahd
#       Drop extra copy of UUPORT from archive list
#       Correct archive names to 1 2 3 from 2 3 4 suffixes
#       Go to version 1.12j
#
#       Revision 1.72  1994/03/20  00:51:12  ahd
#       Drop extra copy of UUPORT from archive list
#       Correct archive names to 1 2 3 from 2 3 4 suffixes
#       Go to version 1.12j
#
#       Revision 1.71  1994/03/12  04:29:58  dmwatt
#       Move OTHERLIBS to after link commands
#
#       Revision 1.70  1994/03/09  02:20:52  ahd
#       Add missing UUTRAF.EXE to prod build list
#
#       Revision 1.69  1994/03/09  02:17:11  ahd
#       Build DLL with one COPY command, not a COPY and a move, to keep
#       possibly bad copy of the original simple name from being created
#
#       Revision 1.68  1994/03/09  01:50:08  ahd
#       Don't rename RTL if only debugging
#
#       Revision 1.67  1994/03/07  06:04:32  ahd
#       Additional multi-platofrm clean-up
#
#       Revision 1.66  1994/03/06  12:37:13  dmwatt
#       Correct Windows NT support
#
#       Revision 1.65  1994/03/06  12:26:04  ahd
#       Make movement of files to prod implicit rules
#
#     Revision 1.64  1994/03/05  21:06:21  ahd
#     Revamp for multiple environments with unique include files
#
#         Revision 1.63  1994/02/16  02:23:05  ahd
#         Delete header include defs until we figure out why it doesn't work!
#
#         Revision 1.62  1994/02/14  01:02:17  ahd
#         Use external header makefile
#
#         Revision 1.61  1994/02/13  04:43:58  ahd
#         Add pnews command
#
#         Revision 1.60  1994/01/18  13:26:29  ahd
#         Go to version 1.12i
#         Add pnews.cmd to install script
#
#         Revision 1.59  1994/01/06  12:43:52  ahd
#         Version 1.12h
#
#         Revision 1.58  1994/01/04  05:46:48  ahd
#         Add missing suffix to NT lib names
#
#         Revision 1.57  1994/01/02  04:31:43  ahd
#         Go to version 1.12g
#
#         Revision 1.56  1994/01/01  18:55:46  ahd
#         Annual copyright update
#
#         Revision 1.55  1993/12/30  03:09:41  ahd
#         Make NT library list generic enough to work with original NT SDK
#
#         Revision 1.54  1993/12/29  03:29:19  dmwatt
#         Add suspend support to UUCICO
#         Add UUPORT in support of suspend functions
#         Make NT use multi-threaded libraries to allow clean aborts of UUCICO
#
#         Revision 1.52  1993/12/02  13:47:28  ahd
#         'e' protocol support
#
#         Revision 1.51  1993/11/30  04:16:57  ahd
#         Version 1.12f
#         Suppress warning from commented variable
#
#         Revision 1.50  1993/11/21  04:45:03  ahd
#         Add UUTRAF
#
#         Revision 1.49  1993/11/20  14:47:34  rommel
#         Add UUTRAF
#
#         Revision 1.48  1993/11/08  04:46:16  ahd
#         Make unique execute.c for OS/2
#
#         Revision 1.47  1993/11/06  17:53:21  rhg
#         Drive Drew nuts by submitting cosmetic changes mixed in with bug fixes
#
#         Revision 1.46  1993/10/31  11:55:32  ahd
#         Don't delete libraries if not in TMP directory
#         Delete libraries by name, don't delete all libraries in LIBDIR
#
#         Revision 1.45  1993/10/31  02:22:05  ahd
#         Restore auto-build of def file to insure version is included
#
#         Revision 1.44  1993/10/30  22:25:50  rommel
#         Add new modules genhist and inews
#
#         Revision 1.43  1993/10/28  00:17:05  ahd
#         Go to version 1.12e
#
#         Revision 1.42  1993/10/24  22:33:03  ahd
#         Add missing real mode executables, based on change from rhg
#
#         Revision 1.41  1993/10/24  12:48:06  ahd
#         Update CCOPT
#
#         Revision 1.40  1993/10/13  01:46:52  ahd
#         Go to 1.12d
#
#         Revision 1.39  1993/10/09  19:32:59  ahd
#         Correct path of uuportp.exe
#
#         Revision 1.38  1993/10/05  12:27:03  ahd
#         Begin the adventure of 1.12c

.SUFFIXES: .c .asm .zip .obj .dll .ico .bat .cmd

# *--------------------------------------------------------------------*
# *     Note:   By default, this file generates code for 80286         *
# *             systems and above.  If you are generating              *
# *             UUPC/extended for a 8088 system, remove the /G2        *
# *             option from the CCOPT= line, below                     *
# *--------------------------------------------------------------------*

# *--------------------------------------------------------------------*
# *   Our release number.  This is updated each time we ship it        *
# *   out to some unsuspecting user, or sometimes when we do a         *
# *   major fix even if we don't ship it out to the lusers.  ANY       *
# *   VERSION NOT DONE ON kendra SHOULD BE TAGGED AS N.NNAm, WHERE     *
# *   N.NNA IS THE NUMBER UUPC was shipped as, and 'm' any string      *
# *   to indentify your special version.  Just upping the              *
# *   distributed version number will confuse you AND me.              *
# *--------------------------------------------------------------------*

VERS = 1.12k

# *--------------------------------------------------------------------*
# *                    Determine the OS de jour.                       *
# *--------------------------------------------------------------------*

!ifndef OS
!if "$(CC)" == "icc"
OS=OS/2_32_Bit
!else
!if "$(OS2_SHELL)" != ""
OS=OS/2_16_Bit
!else
OS=DOS
!endif
!endif
!endif

# *--------------------------------------------------------------------*
# *      Pull in our OS specific defines from the external file        *
# *--------------------------------------------------------------------*

!if "$(OS)" == "Windows_NT"
!include <ntwin32.mak>
!include "nmakewnt.mak"
!endif
!if "$(OS)" == "OS/2_32_Bit"
!include "nmakos22.mak"
!endif
!if "$(OS)" == "OS/2_16_Bit"
!include "nmakos21.mak"
!endif
!if "$(OS)" == "DOS"
!include "nmakedos.mak"
!endif

# *--------------------------------------------------------------------*
# *            User specified include file (if specified)              *
# *--------------------------------------------------------------------*

!ifdef UUPCNMK
!include $(UUPCNMK)
!endif

# *--------------------------------------------------------------------*
# *   Various directories.  The TMP directory is not defined here;     *
# *   rather we expect it to be defined as part of the user's          *
# *   environment variables                                            *
# *--------------------------------------------------------------------*

MAIL    = $(SRCSLASH)mail
UTIL    = $(SRCSLASH)util
UUCP    = $(SRCSLASH)uucp
RNEWS   = $(SRCSLASH)rnews
UULIB   = $(SRCSLASH)lib
TEST    = $(SRCSLASH)test
UUCICO  = $(SRCSLASH)uucico
UUTRAF  = $(SRCSLASH)uutraf
SCRIPTS = $(SRCSLASH)scripts

!ifndef OBJ
OBJ=obj$(ZIPID)$(MODEL)
!endif

!ifndef SBR
SBR     = $(SRCSLASH)sbr
!endif

!ifndef LIBDIR
LIBDIR=$(OBJ)
!endif

!ifndef ZIPDIR
ZIPDIR=$(SRCSLASH)$(VERS)
!endif

# *--------------------------------------------------------------------*
# *                        Various file names                          *
# *--------------------------------------------------------------------*

!ifndef ZIPPREFIX
ZIPPREFIX=$(ZIPDIR)\UPC$(VERS:1.=)
!endif

LIBCOMM  = $(LIBDIR)\uupc$(ZIPID)$(MODEL).lib

WORKFILE = $(TMP)\UUPCTEMP.TMP
!ifdef OS2
DEFFILE  = $(SRCSLASH)UUPCOS$(ZIPID)$(MODEL).DEF
!endif

# *--------------------------------------------------------------------*
# *      Why are the variables 2 3 4 but the files actually 1 2 3?     *
# *      Because prior to the great renaming of release 1.12b, the     *
# *      OS/2 main archive was UUPCxxx2.ZIP, and the secondary         *
# *      archives were numbered in sequence from that.                 *
# *--------------------------------------------------------------------*

ZIPV2 = $(ZIPPREFIX)$(ZIPID)1.zip
ZIPV3 = $(ZIPPREFIX)$(ZIPID)2.zip
ZIPV4 = $(ZIPPREFIX)$(ZIPID)3.zip

# *--------------------------------------------------------------------*
# *        The names of various object files that we create.           *
# *--------------------------------------------------------------------*

TIMESTMP = $(OBJ)\timestmp.obj

LIBCOMMLIST =$(OBJ)\active.obj $(OBJ)\arbmath.obj $(OBJ)\arpadate.obj   \
             $(OBJ)\bugout.obj $(OBJ)\catcher.obj $(OBJ)\chdir.obj      \
             $(OBJ)\checkptr.obj $(OBJ)\configur.obj $(OBJ)\dater.obj   \
             $(OBJ)\dos2unix.obj $(OBJ)\execute.obj $(OBJ)\expath.obj   \
             $(OBJ)\export.obj $(OBJ)\filebkup.obj $(OBJ)\fopen.obj     \
             $(OBJ)\getargs.obj $(OBJ)\getopt.obj $(OBJ)\getseq.obj     \
             $(OBJ)\hostable.obj $(OBJ)\hostatus.obj $(OBJ)\hostrset.obj\
             $(OBJ)\import.obj $(OBJ)\importng.obj $(OBJ)\kanjicnv.obj  \
             $(OBJ)\lock.obj $(OBJ)\logger.obj $(OBJ)\mkdir.obj         \
             $(OBJ)\mkfilenm.obj $(OBJ)\mkmbox.obj $(OBJ)\mktempnm.obj  \
             $(OBJ)\normaliz.obj $(OBJ)\printerr.obj $(OBJ)\printmsg.obj\
             $(OBJ)\pushpop.obj $(OBJ)\readnext.obj $(OBJ)\rename.obj   \
             $(OBJ)\safeio.obj $(OBJ)\safeout.obj $(OBJ)\security.obj   \
             $(OBJ)\ssleep.obj $(OBJ)\stater.obj $(OBJ)\strpool.obj     \
             $(OBJ)\trumpet.obj $(OBJ)\usertabl.obj $(OBJ)\usrcatch.obj \
             $(OBJ)\validcmd.obj $(LIBOSLIST) $(TIMESTMP)

# *--------------------------------------------------------------------*
# *             Object file lists for specific programs                *
# *--------------------------------------------------------------------*

MAILOBJ = $(OBJ)\mail.obj $(OBJ)\address.obj $(OBJ)\mailblib.obj \
          $(OBJ)\maillib.obj $(OBJ)\mlib.obj $(OBJ)\mailsend.obj \
          $(OBJ)\alias.obj

UUCPOBJ = $(OBJ)\address.obj $(OBJ)\uucp.obj

RNEWSOBJ  = $(OBJ)\rnews.obj $(OBJ)\history.obj $(OBJ)\idx.obj $(OBJ)\hdbm.obj
EXPIREOBJ = $(OBJ)\expire.obj $(OBJ)\history.obj $(OBJ)\idx.obj $(OBJ)\hdbm.obj
GENHISTOBJ= $(OBJ)\genhist.obj $(OBJ)\history.obj $(OBJ)\idx.obj $(OBJ)\hdbm.obj

RMAILOBJ = $(OBJ)\address.obj $(OBJ)\rmail.obj $(OBJ)\sysalias.obj \
           $(OBJ)\deliver.obj

UUCICOOBJ1 =$(OBJ)\checktim.obj $(OBJ)\commlib.obj $(OBJ)\dcp.obj  \
         $(OBJ)\dcpfpkt.obj $(OBJ)\dcpgpkt.obj $(OBJ)\dcplib.obj   \
         $(OBJ)\dcpstats.obj $(OBJ)\dcpsys.obj $(OBJ)\dcpxfer.obj  \
         $(OBJ)\modem.obj $(OBJ)\nbstime.obj $(OBJ)\script.obj     \
         $(OBJ)\uucico.obj

RNOBJ1=$(OBJ)\addng.obj $(OBJ)\art.obj $(OBJ)\artio.obj $(OBJ)\artsrch.obj\
       $(OBJ)\backpage.obj $(OBJ)\bits.obj $(OBJ)\cheat.obj $(OBJ)\final.obj
RNOBJ2=$(OBJ)\head.obj $(OBJ)\help.obj $(OBJ)\init.obj $(OBJ)\intrp.obj\
       $(OBJ)\kfile.obj $(OBJ)\last.obj $(OBJ)\ng.obj $(OBJ)\ngdata.obj
RNOBJ3=$(OBJ)\ngsrch.obj $(OBJ)\ngstuff.obj $(OBJ)\only.obj $(OBJ)\rcln.obj\
       $(OBJ)\rcstuff.obj $(OBJ)\respond.obj $(OBJ)\rn.obj $(OBJ)\search.obj\
       $(OBJ)\sw.obj $(OBJ)\term.obj $(OBJ)\util.obj $(OBJ)\uudecode.obj \
       $(OBJ)\rnpclib.obj
RNOBJ=$(RNOBJ1) $(RNOBJ2) $(RNOBJ3)

NEWSETUPOBJ=$(OBJ)\newsetup.obj $(OBJ)\rnlib.obj

UUTRAFOBJ = $(OBJ)\uutraf.obj $(OBJ)\version.obj $(OBJ)\alist.obj\
            $(OBJ)\list.obj $(OBJ)\llist.obj

# *--------------------------------------------------------------------*
# *      Lists of programs to built for various pseudo targets         *
# *--------------------------------------------------------------------*
EXEC =   expire.exe fmt.exe genhist.exe gensig.exe inews.exe mail.exe \
         novrstrk.exe rmail.exe rnews.exe uucico.exe uucp.exe         \
         uuname.exe uupoll.exe uuport.exe uustat.exe uusub.exe        \
         uutraf.exe uux.exe uuxqt.exe $(EXTRAT)

INSTALL2= $(PROD)\mail.exe $(PROD)\rmail.exe $(PROD)\uuxqt.exe    \
          $(PROD)\uucico.exe $(PROD)\uuport.exe $(EXTRA2)

INSTALL3= $(PROD)\uucp.exe $(PROD)\uuname.exe $(PROD)\uupoll.exe  \
          $(PROD)\uustat.exe $(PROD)\uusub.exe                    \
          $(PROD)\uux.exe $(PROD)\gensig.exe $(PROD)\novrstrk.exe \
          $(PROD)\fmt.exe $(EXTRA3)

INSTALL4= $(PROD)\rnews.exe $(PROD)\expire.exe $(PROD)\genhist.exe \
          $(PROD)\inews.exe $(PROD)\uutraf.exe $(EXTRA4)

INSTALLRS=$(PROD)\su.bat $(PROD)\uuio.bat $(PROD)\uuclean.bat\
          $(PROD)\waiting.bat

!if "$(OS)" == "DOS"
INSTALLS= $(INSTALLRS) $(EXTRAS)
!else
INSTALLS= $(INSTALLRS:.bat=.cmd) $(EXTRAS)
!endif

INSTALL= $(INSTALL2) $(INSTALL3) $(INSTALL4) $(INSTALLS)

# *--------------------------------------------------------------------*
# *   Source browser files; because of space limitations, these        *
# *   are not always generated unless you change the C compiler        *
# *   options.                                                         *
# *--------------------------------------------------------------------*

# *--------------------------------------------------------------------*
# *     This needs to be expanded to *all* the OBJ files ... but      *
# *     not today, as the Wonderworks doesn't use it.                  *
# *--------------------------------------------------------------------*
SBRS = $(LIBDOSLIST:obj=sbr)

# *--------------------------------------------------------------------*
# *                   And, of course, our makefile                     *
# *--------------------------------------------------------------------*

!ifndef MAKEFILE
MAKEFILE = $(SRCSLASH)nmake.mak
!endif

README=    docs\00readme.now

# *--------------------------------------------------------------------*
# *                      C compiler and options                        *
# *--------------------------------------------------------------------*

!ifndef CC
CC      = cl
!endif

{$(UULIB)}.c{$(OBJ)}.obj:
        $(CC) $(CCOPT) $<

{$(MAIL)}.c{$(OBJ)}.obj:
        $(CC) $(CCOPT) $<

{$(RN)}.c{$(OBJ)}.obj:
        $(CC) $(CCOPT) /W3 $<

{$(RNEWS)}.c{$(OBJ)}.obj:
        $(CC) $(CCOPT) $<

{$(TEST)}.c{$(OBJ)}.obj:
        $(CC) $(CCOPT) $<

{$(UUCICO)}.c{$(OBJ)}.obj:
        $(CC) $(CCOPT) $<

{$(UUCICO)}.asm{$(OBJ)}.obj:
        $(MASM) $(MASMOPTS) $(UUCICO)\$(@B) ,$@;

{$(UUCP)}.c{$(OBJ)}.obj:
        $(CC) $(CCOPT) $<

{$(UTIL)}.c{$(OBJ)}.obj:
        $(CC) $(CCOPT) $<

{$(UUTRAF)}.c{$(OBJ)}.obj:
        $(CC) -DSYSVR3 -DUUPC -I$(UUTRAF) $(CCOPT) /W3 $<

{.}.exe{$(PROD)}.exe:
!ifdef NODEBUG
!if "$(OS)" == "OS/2_32_Bit"
        dllrname $? $(RTLDLL:.dll=)=$(DLLNAME:.dll=)
        msgbind <<
>$@
<$(MSGFILE)
*
<<
!endif
!endif
        - $(ERASE) $@
        move $? $@

!if "$(OS)" == "OS/2_32_Bit"
{$(DLLDIR)}.dll{$(DLLPROD)}.dll:
        copy $? $@
!endif

{$(SCRIPTS)}.bat{$(PROD)}.bat:
        copy $? $@

!if "$(OS)" == "Windows_NT"
{$(SCRIPTS)}.bat{$(PROD)}.cmd:
        copy $? $@
!else
{$(SCRIPTS)}.cmd{$(PROD)}.cmd:
        copy $? $@
!endif
{docs}.ico{$(PROD)}.ico:
        copy $? $@

{docs}.ico{.}.ico:
        @echo Suppressed copy from $? to $@

# *--------------------------------------------------------------------*
# *            ZIP, for creating the distributed archive               *
# *--------------------------------------------------------------------*

!ifndef ZIP
ZIP     = zip
!endif

!ifndef ZIPOPT1
ZIPOPT1 = -o -9 -u -@
!endif

!ifndef ZIPOPT2
ZIPOPT2 = -j $(ZIPOPT1)
!endif

# *--------------------------------------------------------------------*
# *                Begin rules for building modules.                   *
# *--------------------------------------------------------------------*

# *--------------------------------------------------------------------*
# *        The first definition is the one built by default.           *
# *--------------------------------------------------------------------*

test:   $(OBJ) $(EXEC)

prod:   $(OBJ) $(EXEC) $(INSTALL) regen

qprod:  $(OBJ) $(INSTALL)

install:        zip

zip:    clean $(OBJ) qzip

qzip:
        $(MAKE) -f $(MAKEFILE) NODEBUG=1 $(ZIPV2) $(ZIPV3) $(ZIPV4) regen

# *--------------------------------------------------------------------*
# *          Do a purge of various temporary output files.             *
# *--------------------------------------------------------------------*

clean:  xclean
        - $(ERASE) $(SRCSLASH)*.bak
        - $(ERASE) *.map
        - $(ERASE) $(WORKFILE)

# *--------------------------------------------------------------------*
# *      Do a clean of just executable files and related files.        *
# *--------------------------------------------------------------------*

xclean:
        - $(ERASE) $(OBJ)\*.obj
        - $(ERASE) $(OBJ)\*.exe
        - $(ERASE) $(LIBCOMM)
        - $(ERASE) $(SRCSLASH)*.obj
        - $(ERASE) $(SRCSLASH)*.exe
        - $(ERASE) $(SBR)\*.sbr

# *--------------------------------------------------------------------*
# *               The commands to actually link files                  *
# *--------------------------------------------------------------------*

comm34.exe:   $(OBJ)\comm34.obj $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)

inews.exe:    $(OBJ)\inews.obj $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)

fmt.exe:      $(OBJ)\fmt.obj $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)

gensig.exe:   $(OBJ)\gensig.obj $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)

novrstrk.exe: $(OBJ)\novrstrk.obj $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)

uuname.exe:   $(OBJ)\uuname.obj $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)

uupoll.exe:   $(OBJ)\uupoll.obj $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)

uuport.exe:   $(OBJ)\uuport.obj $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)

uustat.exe:   $(OBJ)\uustat.obj $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)

uusub.exe:    $(OBJ)\uusub.obj $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)

uux.exe:      $(OBJ)\uux.obj $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)

uuxqt.exe:    $(OBJ)\uuxqt.obj $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)

# *--------------------------------------------------------------------*
# *      DOS specific module builds, which use response files to       *
# *      get around command line length limits                         *
# *--------------------------------------------------------------------*

!if "$(OS)" == "DOS"

expire.exe:     $(EXPIREOBJ) $(LIBCOMM)
        $(LINKER) $(LINKOPT) @<<
$(EXPIREOBJ)
$@,,$(LIBCOMM);
<<

genhist.exe:     $(GENHISTOBJ) $(LIBCOMM)
        $(LINKER) $(LINKOPT) @<<
$(GENHISTOBJ)
$@,,$(LIBCOMM);
<<

mail.exe:     $(MAILOBJ) $(LIBCOMM)
        $(LINKER) $(LINKOPT) @<<
$(MAILOBJ)
$@,,$(LIBCOMM);
<<

newsetup.exe:        $(NEWSETUPOBJ) $(LIBCOMM)
        $(LINKER) $(LINKOPT) @<<
$(NEWSETUPOBJ)
$@,,$(LIBCOMM);
<<

rmail.exe:     $(RMAILOBJ) $(LIBCOMM)
        $(LINKER) $(LINKOPT) @<<
$(RMAILOBJ)
$@,,$(LIBCOMM);
<<

rn.exe:        $(RNOBJ) $(LIBCOMM)
        $(LINKER) $(LINKOPT) @<<
$(RNOBJ1)+
$(RNOBJ2)+
$(RNOBJ3)
$@,,$(LIBCOMM);
<<

rnews.exe:     $(RNEWSOBJ) $(LIBCOMM)
        $(LINKER) $(LINKOPT) @<<
$(RNEWSOBJ)
$@,,$(LIBCOMM);
<<

uucico.exe:     $(UUCICOOBJ1) $(UUCICOOBJ3)\
                  $(LIBCOMM)
        $(LINKER) $(LINKOPT) @<<
$(UUCICOOBJ1:   =+^
)+
$(UUCICOOBJ3)
$@,,$(LIBCOMM);
<<

uucp.exe:     $(UUCPOBJ) $(LIBCOMM)
        $(LINKER) $(LINKOPT) @<<
$(UUCPOBJ)
$@,,$(LIBCOMM);
<<

uutraf.exe:      $(UUTRAFOBJ) $(LIBCOMM)
        $(LINKER) $(LINKOPT) @<<
$(UUTRAFOBJ)
$@,,$(LIBCOMM);
<<

testulib.exe:   $(OBJ)\testulib.obj $(OBJ)\ulib.obj $(OBJ)\comm.obj \
                $(LIBCOMM)
        $(LINKER) $(LINKOPT) @<<
$(OBJ)\testulib.obj $(OBJ)\ulib.obj $(OBJ)\comm.obj
$@,,$(LIBCOMM);
<<

!else

# *--------------------------------------------------------------------*
# *      Non-DOS module builds, which exploit OS/2 and Windows/NT      *
# *      longer command line to specify all the modules on the         *
# *      command line.                                                 *
# *--------------------------------------------------------------------*

expire.exe:   $(EXPIREOBJ) $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)

genhist.exe:  $(GENHISTOBJ) $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)

mail.exe:     $(MAILOBJ) $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)

newsetup.exe: $(NEWSETUPOBJ) $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)

rn.exe:        $(RNOBJ) $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)

rmail.exe:     $(RMAILOBJ) $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)

rnews.exe:     $(RNEWSOBJ) $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)

uucico.exe:   $(UUCICOOBJ1) $(UUCICOOBJ2) $(UUCICOOBJ3) \
              $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)

# *--------------------------------------------------------------------*
# *                  UUCICO without TCP/IP support                     *
# *--------------------------------------------------------------------*

uucicon.exe:  $(UUCICOOBJ1:commlib=commlibn) $(UUCICOOBJ2) $(UUCICOOBJX) \
              $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)

uucp.exe:     $(UUCPOBJ) $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)

uutraf.exe:   $(UUTRAFOBJ) $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)

!if "$(OS)" == "Windows_NT"
regsetup.exe: $(OBJ)\regsetup.obj $(LIBCOMM) $(DEFFILE)
        $(CC) $(LDOPT) $** $(OTHERLIBS)

uupcdll.dll:  $(OBJ)\uupcdll.obj uupcdll.exp
#        $(CC) /LD $(LDOPT) $** $(OTHERLIBS) -link -entry:DllMain -map:$(@B).map -force
         $(CC) /LD $(LDOPT) $** $(OTHERLIBS:libcmt=crtdll) -link -entry:DllMain -map:$(@B).map -force

uupcdll.exp:    uupcdll.def
        lib32 /out:$(@:exp=lib)  /machine:$(CPU) /def:$(@:exp=def)

uupcdll.def : nmake.mak nmakewnt.mak
        copy << $@
LIBRARY $(@B) BASE=000D0000
DESCRIPTION 'UUPC/extended $(VERS)  Copyright (c) 1989-1994 Kendra Electronic Wonderworks, All Rights Reserved'
CODE    execute,read
EXPORTS
        UUPCGetNewsSpoolSize
        UUPCGetParm
        UUPCInit
        UUPCSendMail
<<

dlltest.exe:  $(OBJ)/dlltest.obj
        $(CC) $(LDOPT) $** $(OTHERLIBS)

!endif
!endif

# *--------------------------------------------------------------------*
# *                          The zip files                             *
# *--------------------------------------------------------------------*

$(ZIPV2):  $(INSTALL2) $(README)
       - mkdir $(SRCSLASH)$(VERS)
       -12 $(ZIP) $(ZIPOPT2) $@ < <<
       $(?: =^
       )
<<
       $(ZIP) -z $@  < <<
Kendra Electronic Wonderworks: UUPC/extended $(VERS) $(OS:_= ) executables (1 of 3)

Changes and Compilation Copyright (c) 1989-1994 by Kendra Electronic
Wonderworks.  May be distributed freely if original source and documentation
files are included.  Please direct all questions on UUPC/extended to
help@kew.com.
<<

$(ZIPV3):  $(INSTALL3) $(INSTALLS) $(README)
       - mkdir $(SRCSLASH)$(VERS)
       -12 $(ZIP) $(ZIPOPT2) $@ < <<
       $(?: =^
       )
<<
       $(ZIP) -z $@  < <<
Kendra Electronic Wonderworks: UUPC/extended $(VERS) $(OS:_= ) executables (2 of 3)

Changes and Compilation Copyright (c) 1989-1994 by Kendra Electronic
Wonderworks.  May be distributed freely if original source and documentation
files are included.  Please direct all questions on UUPC/extended to
help@kew.com.
<<

$(ZIPV4):  $(INSTALL4) $(README)
       - mkdir $(SRCSLASH)$(VERS)
       -12 $(ZIP) $(ZIPOPT2) $@ < <<
       $(?: =^
       )
<<
       $(ZIP) -z $@  < <<
Kendra Electronic Wonderworks: UUPC/extended $(VERS) $(OS:_= ) executables (3 of 3)

Changes and Compilation Copyright (c) 1989-1994 by Kendra Electronic
Wonderworks.  May be distributed freely if original source and documentation
files are included.  Please direct all questions on UUPC/extended to
help@kew.com.
<<


# *--------------------------------------------------------------------*
# *                     Handle shared libraries                        *
# *--------------------------------------------------------------------*

!ifdef DLLNAME

!if "$(DLLPROD)" == "$(DLLDIR)"
!error Prod DLL directory "$(DLLPROD)" must not equal input directory
!endif

$(DLLPROD)\$(DLLNAME):      $(DLLDIR)\$(RTLDLL)
        - erase $@
        copy $? $@
        dllrname /n /q $@ $(?B)=$(@B)
!endif

# *--------------------------------------------------------------------*
# *                    Build the object libraries                      *
# *--------------------------------------------------------------------*

!if "$(OS)" == "Windows_NT"

$(LIBCOMM): $(LIBCOMMLIST)
         lib32 /out:$@ @<<
$(LIBCOMMLIST)
<<

!else
$(LIBCOMM): $(LIBCOMMLIST)
        lib /nologo /noignorecase $@ @<<
-+$(?: =&^
-+)
nul;
<<

!endif

# *--------------------------------------------------------------------*
# *     The timestamp module has a reference to this MAKEFILE,         *
# *     which insures whenever we change the version number the        *
# *     time stamp gets re-generated.                                  *
# *--------------------------------------------------------------------*

$(TIMESTMP): $(MAKEFILE) $(REGEN) \
             nmakedos.mak nmakos22.mak nmakewnt.mak nmakos21.mak

# *--------------------------------------------------------------------*
# *     Header file with our version number for timestmp.c             *
# *--------------------------------------------------------------------*


$(UULIB)\win32ver.h: $(MAKEFILE) $(REGEN)
        copy << $@
/*--------------------------------------------------------------------*/
/*         DO NOT EDIT -- AUTOMATICALLY GENERATED BY MAKEFILE         */
/*--------------------------------------------------------------------*/

#define UUPCV "$(VERS)"         /* UUPC/extended version number */
<<

# *--------------------------------------------------------------------*
# *     Force a regeneration of the time stamp/version module.         *
# *--------------------------------------------------------------------*

regen:  $(UULIB)\timestmp.c
        - if exist $(LIBCOMM) $(ERASE) $(LIBCOMM)
        - $(ERASE) $(OBJ)\timestmp.obj

# *--------------------------------------------------------------------*
# *         Generate the source browser database for the PWB           *
# *--------------------------------------------------------------------*

$(MAKEFILE).bsc: $(SBRS)
        pwbrmake @<<
/o $(MAKEFILE).bsc $(SBRS)
<<

$(OBJ):
        - mkdir $@

# *--------------------------------------------------------------------*
# *      Definition file.  Built dynamically so it automatically       *
# *      includes the correct version nuber.                           *
# *--------------------------------------------------------------------*

!ifdef DEFFILE
$(DEFFILE):     $(MAKEFILE) nmakos22.mak nmakos21.mak
       copy << $@
NAME WINDOWCOMPAT NEWFILES
DESCRIPTION 'UUPC/extended $(VERS), Changes Copyright (c) 1989-1994 Kendra Electronic Wonderworks, All Rights Reserved'
PROTMODE
STACKSIZE $(STACKSIZE)
SEGMENTS
  '_MSGSEG32' CLASS 'CODE' LOADONCALL
<<
!endif

# *--------------------------------------------------------------------*
# *      Lastly, include the rules for building the object             *
# *      files.  This line can be deleted, but then you lose the       *
# *      automatic recompiles when header files are updated.           *
# *--------------------------------------------------------------------*

!include "nmakeinc.mak"
