/*--------------------------------------------------------------------*/
/*    C R E A T . C                                                   */
/*                                                                    */
/*    Support routines for UUPC/extended                              */
/*                                                                    */
/*    Changes Copyright 1990, 1991 (c) Andrew H. Derbyshire           */
/*                                                                    */
/*    History:                                                        */
/*       21Nov1991 Break out of lib.c                          ahd    */
/*--------------------------------------------------------------------*/

#include "uupcmoah.h"

#include <fcntl.h>
#include <io.h>

/*--------------------------------------------------------------------*/
/*                    UUPC/extended include files                     */
/*--------------------------------------------------------------------*/

/*--------------------------------------------------------------------*/
/*    C R E A T                                                       */
/*                                                                    */
/*    Create a file with the specified mode                           */
/*--------------------------------------------------------------------*/

int CREAT(const char *name, const int mode, const char ftyp)
{

   char *last;
   char *path;
   int results;

   /* are we opening for write or append */
#ifndef __GCC__
   FILEMODE(ftyp);
#endif
   results = creat(name, mode);

   if (results != -1)
      return results;

   /* see if we need to make any intermediate directories */
   path = normalize( name );

   if ((last = strrchr(path, '/')) != nil(char))
   {
      *last = '\0';
      MKDIR(path);
   }

   /* now try open again */
   return creat(name, mode);

} /*CREAT*/
