/***
 * FTP mirroring tool, Aug 28, 1997
 *
 *  Usage:  Place ftpme.cmd in a directory structure that you would like to
 *          send.  When ftpme.cmd is executed, it will send the entire contents
 *          of the directory that it was placed in, including all subdirectories
 *          and the files contained within them, to the destination specified
 *          on the command line.
 *
 *          ftpme host userid password send-directory
 *          where host - the destination machine
 *                userid - kind of self explanatory!
 *                password - kind of self explanatory!
 *                send-directory - the directory to send the files to.  If you
 *                   are sending to the default directory for your login, just
 *                   enter a . ( period ) to signinfy the current directory.
 *
 * This has been released as freeware, so please use as you see fit, all that I
 * ask in return is a message letting me know that you are using my software. I
 * can be reached at starfield@stealthmail.com
 *
 * I intend to extend this little script to include the retrieval of an entire
 * directory structure of an FTP site.  I also intend to first add a text mode
 * interface, followed later by a GUI.  Unfortunately, I do not know when I
 * will be doing this, as I am going back to school in 1 week and will not have
 * much time to
 *
 *    === DISCLAIMER ===
 *
 * I allow you to use and distribute FTPME freely under the condition that I
 * am in no way responsible for any damage or loss you may suffer.
 *
 * Michael S. Chajkowski, starfield@stealthmail.com
 ***/

parse arg Host UserID Password RootDir

if testCmdLn( Host, UserID, Password, RootDir ) then
   return 1

if LoadRexxUtil() then
   return 1

if loadrxFTP() then
   return 1

call Init_Logon

if SysFileTree( '*', '_dir', 'DS' ) then do
   say( "error: could not read the local directory" )
   call logout
   return 1
   end

if ftpCHDir( RootDir ) = 0 then do
   call filePut
   do i = 1 to _dir.0
      parse var _dir.i x '\' y '\' path
      if navDir( path ) = 1 then do
         say( "error: could not complete process" )
         call logout
         return 1
         end
      end
   end
else do
   say( "error: invalid FTP directory, please correct and try again x" )
   call logout
   return 1
   end

rc = ftpDelete( 'ftpme.cmd' )

call logout

return 0


/***
 * Navigate through and create directory structure
 * on remote FTP site.  Mirror FTP cd on local machine
 * and PUT files when deepest dir level achieved
 ***/
navDir: PROCEDURE

   arg path

   upDir = '..'

   if pos( '\', path ) > 0 then do  /* check if at deepest dir level */
      parse var path root '\' path  /* if not, parse for the current dir and subsequent dirs */
      if ftpCHDir( root ) = 0 then do   /* check for valid FTP cd, if valid keep going, if not ... */
         '@cd 'root
         if navDir( path ) = 1 then do
            say( "error: could not complete process" )
            call logout
            return 1
            end
         rc = ftpCHDir( upDir ) /* this directory MUST exist, so no error check */
         '@cd 'upDir
         end
      else do
         say( "error: invalid FTP directory, please correct and try again" )
         call logout
         return 1
         end
      end
   else do

      if ftpMKDir( path ) = 0 then      /* check for valid directory creation and navigation */
         if ftpCHDir( path ) = 0 then
            '@cd 'path
         else do
            logout
            return 1
         end
      else do
         logout
         return 1
      end

      if filePut() = 1 then do
         say( "error: could not copy files"
         logout
         return 1
         end

      rc = ftpCHDir( upDir )
      '@cd 'upDir
      end

return 0


/***
 * Login to the ftp site and set binary mode
 ***/
Init_Logon:                                  /* initialize RXFTP environment */
   say( "Logging into the host system, please wait ..." )
   rc = FtpSetUser( Host, Userid, Password ) /* attach to the remote ftp site */
   rc = FtpSetBinary("b")                    /* set the mode to BINARY */

   return


/***
 * Log off of the FTP server
 ***/
logout:

   rc = ftpLogoff()

   return


/***
 * Test the command line for valid number of arguments and
 * for a '?' (denoting the user wants help)
 ***/
testCmdLn: PROCEDURE

   parse arg hst, usr, pas, roo

   if hst = '' | usr = '' | pas = '' | roo = '' | pos( '?', hst ) > 0 then do
      say( "usage:" )
      say( "ftpme HOST USERNAME PASSWORD FTPDirectory" )
      say( "-- for current FTP dir, use a single period --" )
      return 1
      end

   return 0


/***
 * Load the RexxUtil function library, testing for
 * proper completion of task
 ***/
filePut:

   if SysFileTree( '*', '_file', 'F' ) = 0 then /* check for proper file list retrieval */
      do i = 1 to _file.0                       /* strip unnecissary information from the file list */
         parse var _file.i trash ':' trash ':' source
         source = 'd:'source
         dest = right( _file.i, ( length( _file.i ) - lastpos( '\', _file.i )))
         if ftpPut( source, dest ) <> 0 then do
            say( "error: could not PUT the file, make sure you" )
            say( "       have the proper permissions on the FTP server" )
            call logout
            return 1
            end
         end

   return 0


/***
 * Load the RexxUtil function library, testing for
 * proper completion of task
 ***/
LoadRexxUtil: PROCEDURE
   if RxFuncQuery( 'SysLoadFuncs' ) then do
      if rxFuncAdd( 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs' ) then do
         say "error: Couldn't load RexxUtil library!"
         return 1
         end

      call SysLoadFuncs
      end

   return 0


/***
 * Load the rxFTP function library, testing for
 * proper completion of task
 ***/
LoadrxFTP: PROCEDURE
   if RxFuncQuery( 'FtpLoadFuncs' ) then do
      if rxFuncAdd( 'FtpLoadFuncs', 'rxFTP', 'FtpLoadFuncs' ) then do
         say "error: Couldn't load rxFTP library!"
         return 1
         end

      call FtpLoadFuncs
      end

   return 0

