/**************************************************************
 *                                                            *
 *                   MainActor Rexx Script                    *
 *                                                            *
 *  Loads a project and converts it to MPEG-I (PAL)           *
 *  Can be customized in any way                              *
 *                                                            *
 *  Last modified: 09/09/97, Written by: Markus Moenig        *
 *                                                            *
 **************************************************************/

  say "Select Project ..."
  rc=LoadProject("")                               /* Load project ... */
  IF rc <> "0" THEN DO
   say "No project loaded! Exiting ..."            /* Failed, exiting ... */
   exit
  END 

  filename="c:\out"               /* Use "" to get a file-requester */
  format="MPEG-I"                 /* Change this to use another format, like "AVI" */
  codec="PAL"                     /* Use the codec which has "PAL" in its identifier */
  frames="AllFrames"              /* Use "SelectedFrames" if you only want to convert */
                                  /* the selected frames of the project */
  width=0                         /* Use original width */
  height=0                        /* Use original height */

  /* You could for example use width=352 and height=288 to make sure that the */
  /* created MPEG has the default PAL dimensions */

  say "Converting project to" format "..."

  TIME("R")                       /* Reset the timer */
  Save( filename, format, codec, frames, width, height ) /* Save it ... */

  say "Finished, needed" TIME("E") "seconds !"

  CloseProject()                  /* Closes the loaded project */
