enum eobj_chunk_id {
	EOBJ_CHUNK_MAIN		= 0x7777,

	EOBJ_CHUNK_VERSION	= 0x0900,
	EOBJ_CHUNK_FLAGS	= 0x0903,
	EOBJ_CHUNK_SURFACES_0	= 0x0905,	// old format
	EOBJ_CHUNK_SURFACES_1	= 0x0906,	// old format
	EOBJ_CHUNK_SURFACES_2	= 0x0907,
	EOBJ_CHUNK_MESHES	= 0x0910,
	EOBJ_CHUNK_0911		= 0x0911,	// ignored by AE
	EOBJ_CHUNK_USERDATA	= 0x0912,
	EOBJ_CHUNK_BONES_0	= 0x0913,	// old format
	EOBJ_CHUNK_MOTIONS	= 0x0916,
	EOBJ_CHUNK_SHADERS_0	= 0x0918,	// old format
	EOBJ_CHUNK_PARTITIONS_0	= 0x0919,	// old format
	EOBJ_CHUNK_TRANSFORM	= 0x0920,
	EOBJ_CHUNK_BONES_1	= 0x0921,
	EOBJ_CHUNK_REVISION	= 0x0922,	// file revision
	EOBJ_CHUNK_PARTITIONS_1	= 0x0923,
	EOBJ_CHUNK_MOTION_REFS	= 0x0924,
	EOBJ_CHUNK_LOD_REF	= 0x0925,	// LOD\Reference
};

enum eobj_clip_chunk_id {
	EOBJ_CLIP_VERSION_CHUNK	= 0x9000,
	EOBJ_CLIP_DATA_CHUNK	= 0x9001,
};

const uint16_t EMESH_VERSION = 0x11;

enum emesh_chunk_id {
	EMESH_CHUNK_VERSION	= 0x1000,
	EMESH_CHUNK_MESHNAME	= 0x1001,
	EMESH_CHUNK_FLAGS	= 0x1002,
	EMESH_CHUNK_BBOX	= 0x1004,
	EMESH_CHUNK_VERTS	= 0x1005,
	EMESH_CHUNK_FACES	= 0x1006,
	EMESH_CHUNK_VMAPS_0	= 0x1007,
	EMESH_CHUNK_VMREFS	= 0x1008,
	EMESH_CHUNK_SFACE	= 0x1009,
	EMESH_CHUNK_OPTIONS	= 0x1010,
	EMESH_CHUNK_VMAPS_1	= 0x1011,
	EMESH_CHUNK_VMAPS_2	= 0x1012,
	EMESH_CHUNK_SG		= 0x1013,
};

struct OBJFace
{
	int v0, vref0, v1, vref1, v2, vref2; 
};

struct VMRefs
{
	unsigned int tmap[3]; 
	unsigned int ind[3]; 
	unsigned int tx[3]; 
	unsigned int ty[3]; 
};

struct Faces
{
	unsigned int	count;
	OBJFace	*fcs;
};

struct submap
{
 unsigned int vmap_index; // link to map
 unsigned int index; // vmap index to uv/w
};

struct uvmap // 0x19 (25), 0x1008 EMESH_CHUNK_VMREFS, another one
{
 unsigned char count; 
 submap m[10];
};

#define MAX_T_LEN 32

// type = VMT_UV, dim = 2, polymap = 0 uv[],vert[]
// type = VMT_UV, dim = 2, polymap = 1 uv[],vert[],face[]
// type = VMT_WEIGHT, dim = 1 weights[],vert[]

struct txmap1 // BLOCK 0x1011
{
 char name[MAX_T_LEN]; // "Texture\0", or less, more
 unsigned char dim;
 unsigned char type; // when = 1, second block absent
 unsigned int txcount;
};

struct txmap2 // BLOCK 0x1012
{
 char name[MAX_T_LEN]; // "Texture\0", or less, more
 unsigned char dim;
 unsigned char polymap; // when = 1, third block exists
 unsigned char type; // when = 1, second block absent
 unsigned int txcount;
};

struct uvcoord // BLOCK 0x1012
{
 float u,v;
};

struct matpars // 0x0C (12) - BLOCK 0x0907
{
 unsigned int flags;
 unsigned int unk0;
 unsigned int unk1;
};
