/* Create WPS program object for Auto Adjust Photo, v1.1         */

/* New: with a JPEG.DLL in the same directory as AAPHOTO.CMD and */
/*      AAPHOTO.EXE, LIBPATHSTRICT and BEGINLIBPATH are used     */
/* New: error checks                                             */
/* New: delay after completion                                   */
/* New: uppercased name of AAPHOTO.EXE                           */

CALL RxFuncAdd 'SysCreateObject','RexxUtil','SysCreateObject'
CALL RxFuncAdd 'SysFileTree','RexxUtil','SysFileTree'
CALL RxFuncAdd 'SysSetObjectData','RexxUtil','SysSetObjectData'

SAY

dir=Directory()
exe='AAPHOTO.EXE'

IF Stream(exe,'C','QUERY EXISTS')='' THEN DO
   SAY 'Error: cannot find file' exe 'in directory' dir
   SAY
   CALL CharOut '','Press <ENTER>... '
   PULL .
   SAY
   EXIT
END

dll=''
res=SysFileTree('*.DLL','dll.','FO')
IF res<>0 THEN DO
   SAY 'Error: not enough available memory to query a list of all DLL files'
   SAY '       in the directory' dir
   SAY
   PULL .
   CALL CharOut '','Press <ENTER>... '
   SAY
   EXIT
END
IF dll.0>0 THEN DO
   dll='STARTUPDIR='||dir||';'
   IF Stream('JPEG.DLL','C','QUERY EXISTS')<>'' THEN dll=dll||'SET LIBPATHSTRICT=T;SET BEGINLIBPATH='||dir||';'
END

IF Right(dir,1)<>'\' THEN exe='\'||exe
exe=dir||exe

IF SysCreateObject('WPProgram','Auto Adjust Photo','<WP_DESKTOP>','EXENAME='||exe||';PARAMETERS="%*";'||dll||'MINIMIZED=YES;ASSOCFILTER=*.BMP,*.JP2,*.JPC,*.JPG,*.PGM,*.PNG,*.PPM,*.RAS;OBJECTID=<AutoAdjustPhoto>','R')=0 THEN DO 
   SAY 'Error: cannot create WPS program object for' exe
   SAY
   CALL CharOut '','Press <ENTER>... '
   PULL .
   SAY
   EXIT
END

SAY 'WPS program object Auto Adjust Photo created.'
SAY

okay=SysSetObjectData('<AutoAdjustPhoto>','ASSOCTYPE=Bitmap')
IF okay=1 THEN SAY 'Auto Adjust Photo associated with type Bitmap.'
IF okay=0 THEN SAY 'Warning: cannot associate Auto Adjust Photo with type Bitmap.'
okay=SysSetObjectData('<AutoAdjustPhoto>','ASSOCTYPE=JPG') 
IF okay=1 THEN SAY 'Auto Adjust Photo associated with type JPG.'
IF okay=0 THEN SAY 'Warning: cannot associate Auto Adjust Photo with type JPG.'
okay=SysSetObjectData('<AutoAdjustPhoto>','ASSOCTYPE=PNG Image') 
IF okay=1 THEN SAY 'Auto Adjust Photo associated with type PNG Image.'
IF okay=0 THEN SAY 'Warning: cannot associate Auto Adjust Photo with type PNG Image.'

SAY
CALL CharOut '','Press <ENTER>... '
PULL .
SAY

EXIT
