#ifndef INCL_STRING_HPP
#define INCL_STRING_HPP

/*****************************************************************************
*
*  string.hpp - string Utility functions
*
*  (C) Marcel Mueller, Fulda, Germany
*
****************************************************************************/

#include <string>
#include <stdarg.h>


/*****************************************************************************
*
*  overload global toupper with string extension
*
*****************************************************************************/
//std::string toupper(std::string s);

/*****************************************************************************
*
*  string trim function
*
*****************************************************************************/
std::string trim(std::string s);

/*****************************************************************************
*
*  string abbrevation test
*
*****************************************************************************/
bool starts_with(const std::string& s, const std::string& w);

/*****************************************************************************
*
*  sprintf to a string object, buffer overflow safe
*
*****************************************************************************/
std::string vstringf(const char* fmt, va_list ap);
std::string stringf(const char* fmt, ...);

#endif
