# ############################################################################ #
# 23.01.2012
# ############################################################################ #
# Copyright 2010-2012 Sergey Levin
# This file is part of crosti.
# Crosti is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# Crosti is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with crosti.  If not, see <http://www.gnu.org/licenses/>.

TEMPLATE = app
TARGET = crosti
VERSION = 1.13.3

TRANSLATIONS =  src/translations/crosti_ru.ts \
    src/translations/crosti_cs.ts \
    src/translations/crosti_it.ts \
    src/translations/crosti_fr.ts \
    src/translations/crosti_language.ts

OBJECTS_DIR = tmp
MOC_DIR = tmp
UI_DIR = tmp
data.path =
QT += svg
CONFIG += exceptions rtti thread


greaterThan(QT_MAJOR_VERSION, 4) {
    QT += widgets concurrent printsupport
}


#Use qmake "CONFIG+=staticbuild" for package release
staticbuild{
    message("Static build")
    DEFINES += QT_STATIC
    QTPLUGIN += qico qsvg
}


win32{
    DESTDIR = .
    RC_FILE = src/crosti.rc
    CONFIG(debug,debug|release):CONFIG += console warn_on
}

unix{# deb-package data
  DESTDIR = .
  CONFIG(release,debug|release){
    target.path = /usr/bin
    data.path = /usr/share/crosti
    data.files = changelog.txt \
        gpl.txt \
        readme.txt
    icon16.path = /usr/share/icons/hicolor/16x16/apps
    icon16.files = src/icons/16x16/crosti.png
    icon32.path = /usr/share/icons/hicolor/32x32/apps
    icon32.files = src/icons/32x32/crosti.png
    icon48.path = /usr/share/icons/hicolor/48x48/apps
    icon48.files = src/icons/48x48/crosti.png
    iconmime32.path = /usr/share/icons/hicolor/32x32/mimetypes
    iconmime32.files = src/icons/32x32/text-x-cst.png
    system.path = /usr/share/crosti/system
    system.files = system/*
    shortcut.path = /usr/share/applications
    shortcut.files = src/crosti.desktop
    mime.path = /usr/share/mime/packages
    mime.files = src/crosti.xml
    INSTALLS += target \
        data \
        system \
        shortcut \
        icon16 \
        icon32 \
        icon48 \
        mime \
        iconmime32
  }
}

DEFINES += APP_VERSION=\\\"$$VERSION\\\" \
    APP_NAME=\\\"$$TARGET\\\" \
    ORGANIZATION_NAME=\\\"SerjthWare\\\" \
    DATA_PATH=\\\"$$data.path\\\"

HEADERS += src/usrhcpp/mainwindow.h \
    src/usrhcpp/theme.h \
    src/usrhcpp/view.h \
    src/usrhcpp/imagefilter.h \
    src/usrhcpp/wizard.h \
    src/usrhcpp/colors.h \
    src/usrhcpp/history.h \
    src/usrhcpp/schemedata.h \
    src/usrhcpp/progressdialog.h \
    src/usrhcpp/info.h \
    src/usrhcpp/sprite.h \
    src/usrhcpp/previewlabel.h \
    src/usrhcpp/comboboxdelegate.h \
    src/usrhcpp/line.h \
    src/usrhcpp/toolbar.h \
    src/usrhcpp/cminimap.h \
    src/usrhcpp/cimageviewer.h \
    src/usrhcpp/cschemeviewer.h \
    src/usrhcpp/cviewer.h \
    src/usrhcpp/cviewportwatcher.h

SOURCES += src/usrhcpp/main.cpp \
    src/usrhcpp/mainwindow.cpp \
    src/usrhcpp/theme.cpp \
    src/usrhcpp/view.cpp \
    src/usrhcpp/imagefilter.cpp \
    src/usrhcpp/wizard.cpp \
    src/usrhcpp/schemedata.cpp \
    src/usrhcpp/progressdialog.cpp \
    src/usrhcpp/info.cpp \
    src/usrhcpp/previewlabel.cpp \
    src/usrhcpp/comboboxdelegate.cpp \
    src/usrhcpp/colors.cpp \
    src/usrhcpp/toolbar.cpp \
    src/usrhcpp/line.cpp \
    src/usrhcpp/history.cpp \
    src/usrhcpp/cminimap.cpp \
    src/usrhcpp/cimageviewer.cpp \
    src/usrhcpp/cschemeviewer.cpp \
    src/usrhcpp/cviewer.cpp \
    src/usrhcpp/cviewportwatcher.cpp

FORMS += src/forms/fmmain.ui \
    src/forms/fmview.ui \
    src/forms/fmprogramsettings.ui

