#include "CColorWidget.h"

#include <QtGui/QColor>
#include <QtGui/QPixmap>
#include <QtGui/QPainter>
#include <QtGui/QMouseEvent>
#include <QtGui/QColorDialog>

/*!
 \brief конструктор виджета для выбора цвета

 \param r параметр задающий цвет
 \param g параметр задающий цвет
 \param b параметр задающий цвет
*/
CColorWidget::CColorWidget(int r, int g, int b/*QObject *parent*/)// : QLabel(parent)
{
    setFrameStyle(QFrame::Raised | QFrame::Box);
    currentColor = new QColor(r, g, b);
    pixmapColor = new QPixmap(17, 17);
    painterColor = new QPainter(pixmapColor);
    painterColor->fillRect(0, 0, 17, 17, *currentColor);
    painterColor->end();
    setMargin(3);
    setAlignment(Qt::AlignHCenter);
    setPixmap(*pixmapColor);
}

/*!
 \brief установка текущего цвета для отображения

 \param color цвет для установки
*/
void CColorWidget::setColor(QColor color)
{
    *currentColor = color;
    painterColor->begin(pixmapColor);
    painterColor->fillRect(0, 0, 17, 17, *currentColor);
    painterColor->end();
    setPixmap(*pixmapColor);
}

/*!
 \brief обработчик нажатия левой кнопки мыши

 \param event обрабатываемое нажатие
*/
void CColorWidget::mousePressEvent(QMouseEvent *event)
{
    if(event->button() == Qt::LeftButton)
    {
        QColor color = QColorDialog::getColor(*currentColor, this);
        if(color.isValid())
        {
            setColor(color);
            emit sendColor(color);
        }
    }
}
