#include "FStoredSet.h"

#include <QtGui/QSpinBox>
#include <QtGui/QPushButton>
#include <QtGui/QGridLayout>

/*!
 \brief конструктор формы для задания размера истории

 \param currentSize текущий размер
 \param parent родитель
*/
FStoredSet::FStoredSet(int currentSize, QWidget *parent) : QDialog(parent)
{
    QGridLayout *gLayout = new QGridLayout(this);
    setButton = new QPushButton(tr("Set"));
    sizeSpinBox = new QSpinBox();
    sizeSpinBox->setValue(currentSize - 1);
    sizeSpinBox->setRange(0, 100);
    gLayout->addWidget(sizeSpinBox, 0, 0);
    gLayout->addWidget(setButton, 0, 1);
    setLayout(gLayout);
    layout()->setSizeConstraint(QLayout::SetFixedSize);
    loadSignals();
    show();
}

/*!
 \brief инициализация сигналов

*/
void FStoredSet::loadSignals()
{
    connect(setButton, SIGNAL(clicked()), this, SLOT(clickOK()));
}

/*!
 \brief обработчик кнопки setButton

*/
void FStoredSet::clickOK()
{
    emit newSize(sizeSpinBox->value() + 1);
    close();
}
