#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui/QMainWindow>
#include <QtGui/QPixmap>
#include <QtGui/QColor>
#include <QMimeData>

QT_BEGIN_NAMESPACE
class QWidget;
class QMenu;
class QAction;
class QStatusBar;
class QScrollArea;
class QToolButton;
class QToolBar;
class QSpinBox;
class QTabWidget;
class QGridLayout;
class QSlider;
QT_END_NAMESPACE

#include "CImageCV.h"
#include "CColorWidget.h"
#include "CPaletteWidget.h"
#include "ETools.h"
#include "FNewFile.h"
#include "FResizeImage.h"
#include "FStoredSet.h"
#include <TPalleteBar.h>

/*!
 \brief построение gui и реализация основных методов главной формы

*/
class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();

private:
    QAction *newAction, *exitAction, *openAction, *saveAsAction,
            *saveAction, *closeAction, *aboutAction, *aboutQtAction,
            *undoAction, *redoAction, *toBlackAction, *toNegative,
            *rotateAction, *resizeImageAction, *resizeAreaAction, *printAction,
            *paletteAction, *setUndoSizeAction,
            *cutAction, *copyAction, *pasteAction;
    QMenu *fileMenu, *editMenu, *filterMenu, *settingsMenu, *aboutMenu;
    QStatusBar* statBar;
    CColorWidget *colorSet, *brushSet;
    FNewFile *newImWindow;
    FResizeImage *resizeImWindow;
    FStoredSet *resizeStoredWindow;
    ETools activeTool;
    QSpinBox *spinTricknessSize;
    QToolBar *gadgetsBar;
    TPalleteBar *paletteBar;
    QPixmap pixmapCopy;
    QToolButton *buttonPen, *buttonLine, *buttonRectangle, *buttonEllipse,
                *buttonCursor, *buttonLastic, *buttonPipet, *buttonLoupe,
                *buttonSpray, *buttonFill, *buttonHand, *buttonSelect;
    QGridLayout *gadgetsLayout, *gadgetsSetsLayout;
    QWidget *gadgetsWidget, *gadgetsSetsWidget;
    QTabWidget *tabBar;
    QColor penColor, brushColor;
    QSlider *zoomSlider;
    int penSize;
    bool drawFlag;
    void loadActions();
    void loadMenu();
    void loadStatBar();
    void loadToolBars();
    void loadSignals();
    void allSetEnabled(bool);
    bool toContinue(int);
    bool checkUrl(const QMimeData*);
    void open(QString);

protected:
    void closeEvent(QCloseEvent*);
    void dropEvent(QDropEvent*);
    void dragEnterEvent(QDragEnterEvent*);
    void dragMoveEvent(QDragMoveEvent*);
    void dragLeaveEvent(QDragLeaveEvent*);

private slots:
    void createNew();
    void openFile();
    void saveAsFile();
    void saveFile();
    void sendToCloseFile();
    void closeFile(int);
    void activateTab(int);
    void about();
    void printImage();
    void resizeImage();
    void setNewSize(int, int);
    void resizeArea();
    void setNewAreaSize(int, int);
    void resizeStored();
    void setNewStoreSize(int);
    void setNew(int, int);
    void setPenTrickness(int);
    void setPenColor(const QColor&);
    void setBrush(const QColor&);
    void setBlackWhite();
    void setNegative();
    void setRotate();
    void setUndo();
    void setRedo();
    void setCursor(bool);
    void setLastic(bool);
    void setPen(bool);
    void setLine(bool);
    void setRectangle(bool);
    void setElliple(bool);
    void setPipet(bool);
    void setFill(bool);
    void setSpray(bool);
    void setLoupe(bool);
    void setSelect(bool);
    void setHand(bool);
    void setZoom(int);
    void setWait(bool);
    void setURButtons(bool, bool);
    void setScrollBarsPos(int, int);
    void viewPalette();
    void copyImage();
    void pasteImage();
    void cutImage();
    void allButtonUncheked();
};

#endif // MAINWINDOW_H
