%define name	gocr
%define version	0.38
%define release	1

%define prefix		%{_prefix}
%define _xprefix	/usr/X11R6
%define _xbindir	%{_xprefix}/bin

Summary:	Gocr is an OCR (Optical Character Recognition) program.
Name:		%{name}
Version:	%{version}
Release:	%{release}
URL:		http://jOCR.sourceforge.net/
License:	GPL
Group:		Graphics
Source0:	http://prdownloads.sourceforge.net/jocr/%{name}-%{version}.tar.gz
#Source1:	%{name}-16x16.xpm.bz2
#Source2:	%{name}-32x32.xpm.bz2
#Source3:	%{name}-48x48.xpm.bz2
#Patch0:         %{name}-DESTDIR.patch.bz2
#Patch1:         %{name}-paths.patch.bz2
#following packages are not really needed, but recommended
#BuildRequires:  libnetpbm1-devel
#BuildRequires:  gtk+-devel >= 1.2.8
BuildRequires:  transfig
BuildRoot:	%{_tmppath}/%{name}-buildroot

%description
GOCR is an optical character recognition program, released under the
GNU General Public License. It reads images in many formats (pnm, pbm,
pgm, ppm, some pcx and tga image files (or PNM from stdin); if
pnm-tools installed and running linux-like system you can also use
pnm.gz, pnm.bz2, png, jpg, tiff, gif, bmp and others) and outputs
a text file.


%package -n %{name}-devel
Summary:	Development tools for gocr.
Group:		Development/C

%description -n %{name}-devel
GOCR is an optical character recognition program, released under the
GNU General Public License. It reads images in many formats (pnm, pbm,
pgm, ppm, some pcx and tga image files (or PNM from stdin); if
pnm-tools installed and running linux-like system you can also use
pnm.gz, pnm.bz2, png, jpg, tiff, gif, bmp and others) and outputs
a text file.

If you want to develop programs which will manipulate gocr, you should 
install gocr-devel.  You'll also need to install the gocr package.


# not tested, what about gocr.tcl ???
#%package -n %{name}-gtk
#Summary:	Gtk+ frontend for gocr
#Group: 		Graphics
#Requires:	%{name} = %{version}
#BuildRequires:  libgtk+1.2-devel 
#
#%description -n %{name}-gtk
#GOCR is an optical character recognition program, released under the
#GNU General Public License. It reads images in many formats (pnm, pbm,
#pgm, ppm, some pcx and tga image files (or PNM from stdin); if
#pnm-tools installed and running linux-like system you can also use
#pnm.gz, pnm.bz2, png, jpg, tiff, gif, bmp and others) and outputs
#a text file.
#
#Gtk+-based frontend for gocr.

# rpm -bp unpacking sources and applaying patches
%prep
rm -rf $RPM_BUILD_ROOT

%setup -q
#%patch0 -p1
#%patch1 -p1

# rpm -bc build, after prep, invokes make
%build
%configure 
%make

cd frontend/gnome
rm config.cache
%configure --prefix=%{_xprefix} --bindir=%{_xbindir}
%make 
# rpm -bi  install-stage
%install

make install DESTDIR=$RPM_BUILD_ROOT

ln -sf gnome/mkinstalldirs frontend/mkinstalldirs
make -C frontend/gnome install DESTDIR=$RPM_BUILD_ROOT

#%post -n %name-gtk
#%{update_menus}
   
#%postun -n %name-gtk
#%{clean_menus}
   
%clean
rm -rf $RPM_BUILD_ROOT

# rpm -bl list check, check that every file exists
%files -n %{name}
%defattr(-, root, root)
%doc AUTHORS BUGS CREDITS HISTORY README REMARK.txt REVIEW TODO
%doc doc/{examples.txt,ocr.ps,unicode.txt}
%{_mandir}/man1/*
%attr(755,root,root) %{_bindir}/*

%files -n %{name}-devel
%defattr(-, root, root)
%doc AUTHORS
%{_libdir}/libPgm2asc.a
%{_includedir}/gocr.h

#%files -n %{name}-gtk
#%defattr(-, root, root)
#%doc frontend/gnome/{AUTHORS,README,TODO}
##%{_menudir}/*
##%{_iconsdir}/*
#%attr(755,root,root) %{_xbindir}/*

%changelog
* Tue Jan 29 2001 Joerg Schulenburg <jschulen@gmx.de> 0.3.6-1
- gocr.spec taken krom  Marcel Pol <mpol@gmx.net>

# check: rpm -ba --test gocr.spec
