<?php

/**
 * This class was made for Biber's screenshot utility titled "CScreenie" and
 * will later be modified to allow for uploads without CScreenie as well.
 *
 * @author whoami
 * @license http://www.gnu.org/licenses/gpl-3.0.txt GPLv3
 * @version WhoseUpload v1.0
 */

/* The uploadable files allowed mime types */
$allowedMimes = array("image/jpeg", "image/png", "image/gif");

/* The path on the server to which images should be uploaded to */
$uploadPath = "uploads/";

/* Set site name */
$siteName = 'WhoseUpload';

// DO NOT EDIT BELOW THIS LINE

/* The name of the image from the user */
$name = (isset($_FILES["file"]["name"]) ? $_FILES["file"]["name"] : '');

// DO NOT EDIT BELOW THIS LINE!

/* Creates a new unique name */
function genName($name)
{
	$name = substr($name, 0, 8) . substr(md5($name . microtime()), 0, 8);
	return $name;
}

/* Check if a file was submitted */
if(isset($_FILES["file"]))
{
	/* Get the size and other info on the image */
	$size = getimagesize($_FILES["file"]["tmp_name"]);
	
	/* Check if it's an allowed mime type */
	if(in_array($size['mime'], $allowedMimes))
	{
		/* Split the name by periods */
		$nameArray = explode(".", $name);
		
		/* Generate a new name */
		$newName = genName(substr($name, 0, strrpos($name, '.'))) .
						   substr($name, strrpos($name, '.'));
		
		/* Upload the file */
		move_uploaded_file($_FILES["file"]["tmp_name"], $uploadPath . $newName);
		echo $newName;
	}
	else
	{
		if($_SERVER['HTTP_USER_AGENT'] != "")
		{
			?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html>
<head>
<style type='text/css'>
    p {
	margin: 0 0 0 0;
	padding: 0 0 0 0;
    }
</style>
<title> <?php echo $siteName; ?> </title>
</head>
<body>
<p>MIME type not allowed! Please try again.</p>
<p style='font-size: 12px;'>Powered by WhoseUpload</p>
</body>
</html>
			<?php
		}
		else
		{
			echo "E_INVALIDTYPE";
		}
	}
}
else
{
    ?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html>
<head>
<style type='text/css'>
    p {
        margin: 0 0 0 0;
        padding: 0 0 0 0;
    }
</style>
<title> <?php echo $siteName; ?> </title>
</head>
<body>
<form action='' method='post' enctype='multipart/form-data'>
<p>Please enter a file:</p>
<p><input type='file' name='file' value=''/></p>
<p><input type='submit' name='submit' value='Upload' /></p>
<p style='font-size: 12px;'>Powered by WhoseUpload</p>
</form>
</body>
</html>
    <?php
}

?>
