/* REXX program to install Home/2 */

Call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
Call sysloadfuncs

Call SysCls

say "                       Welcome to the Home/2 installer."
say ""
say "This program will do the following:"
say ""
say "It will create a desktop folder with a program object for Home/2 and"
say "an object for the Readme file."
say ""

say "Should I continue? (Y/N)"
PARSE PULL reply
if reply = "N" | reply = "n" then exit

curdir = Directory()
/*
if SysDestroyObject("Home/2") Then
   Say "Home/2 object destroyed."
  Else Say "Home/2 object not destroyed"
if SysDestroyObject("Readme") Then
     Say "Readme object destroyed"
  Else Say "Readme object not destroyed"
if SysDestroyObject("Home/2") Then
     Say "Home/2 object destroyed."
   Else Say 'Could not destroy folder "Home/2"'
*/
Error = 0
            
if SysCreateObject("WPFolder", "Home/2", "<WP_DESKTOP>", "OBJECTID=<HOME/2_FOLDER>", "replace") then
  say "Home/2 Folder created ..."
else do
  say "Could not create Home/2 folder!"
  Error = 1
end

if SysCreateObject("WPProgram", "Home/2", "<HOME/2_FOLDER>", "EXENAME="curdir"\HOME2.EXE;STARTUPDIR="curdir, "replace") then
  say "Home/2 Program Object created ..."
else do
  say "Could not create Home/2 Program Object!"
  Error = 1
end

if SysCreateObject("WPProgram", "Readme", "<HOME/2_FOLDER>", "EXENAME=e.exe;PARAMETERS="curdir"\readme.doc", "replace") then
  say "Readme Object created ..."
else do
  say "Could not create Readme Object!"
  Error = 1
end

say ""
if Error then do
say "Some or all of the objects could not be automatically installed!"
end  
else do
say "All objects have been installed."
end
 
call SysDropFuncs
Exit