/* ----------------------------------  */
/* take text and melt it into a heart  */
/* REXX code 4/24/97 by Gregory Spath  */
/* enjoy :)                            */
/* ----------------------------------  */
/* To use:                             */
/* HEART [scroll] [text]               */
/*                                     */
/* if both scroll and text are         */
/* ommitted, a single character heart  */
/* is made using the value defined for */
/* an ASCII spacer below               */
/* ----------------------------------  */

parse arg scroll thetext

l=length(thetext)

/* The following line defines the character used as a spacer */
heart = "~"

if scroll="" then scroll = heart
scrolltest=left(scroll,1,1)
if c2d(scrolltest) < 48 | c2d(scrolltest) > 57 then do
	thetext = scroll||thetext
	scroll=trunc(length(thetext)/2)+1
end

if right(thetext,1)=" " then 
	thetext=left(thetext, length(thetext)-1)


/* make adjustments to text if necessary */
do while l<200
     thetext=thetext||heart||thetext
     l = length(thetext)
end


/* seed the output strings */
do i=1 to 20
     step = i * scroll
     output.i="                                        "
     overtext.i=substr(thetext, step)
end

/* make the heart */

data.1='09062606'
data.2='07102410'
data.3='05142214'
data.4='03172117'
data.5='0237'
data.6='0139'
data.7='0139'
data.8='0139'
data.9='0237'
data.10='0335'
data.11='0433'
data.12='0531'
data.13='0727'
data.14='0923'
data.15='1119'
data.16='1315'
data.17='1511'
data.18='1707'
data.19='1903'
data.20='2001'

do i = 1 to 4
     start1=substr(data.i, 1, 2)
     length1=substr(data.i, 3, 2)
     start2=substr(data.i, 5, 2)
     length2=substr(data.i, 7, 2)
     output.i=overlay(substr(overtext.i, start1), output.i, start1, length1)
     output.i=overlay(substr(overtext.i, start2), output.i, start2, length2)
end

do i = 5 to 20
     start1=substr(data.i, 1, 2)
     length1=substr(data.i, 3, 2)
     output.i=overlay(substr(overtext.i, start1), output.i, start1, length1)
end

do i = 1 to 20
   say output.i
end

