#include "jabber.h"

char *print_message(	char *from_id,
			char *from_user,
			char *subject,
			char *say,
			char *thread,
			char *ext,
			int priority,
			char *to_id,
			char *to_user,
			int flag)
{
	char *ret = NULL;
	char intbuff[20];

	DBUG("Printing Message","")
	ret = strgrow(ret,"<p_ type='message'",1,0);
	if(flag == CONN_TRANSPORT && from_id != NULL)
	{
		ret = strgrow(ret," from='",1,0);
		ret = strgrow(ret,tag_escape(from_id),1,1);
		ret = strgrow(ret,"'",1,0);
	}
	if(flag == CONN_TRANSPORT && from_user != NULL)
	{
		ret = strgrow(ret," nick='",1,0);
		ret = strgrow(ret,tag_escape(from_user),1,1);
		ret = strgrow(ret,"'",1,0);
	}
	if(flag == CONN_MULTI && to_id != NULL)
	{
		ret = strgrow(ret," for='",1,0);
		ret = strgrow(ret,tag_escape(to_id),1,1);
		ret = strgrow(ret,"'",1,0);
	}
	ret = strgrow(ret,">",1,0);
	if(flag == CONN_SINGLE && to_id != NULL)
	{
		ret = strgrow(ret,"<to",1,0);
		if(to_user != NULL)
		{
			ret = strgrow(ret," name='",1,0);
			ret = strgrow(ret,tag_escape(to_user),1,1);
			ret = strgrow(ret,"'",1,0);
		}
		ret = strgrow(ret,">",1,0);
		ret = strgrow(ret,tag_escape(to_id),1,1);
		ret = strgrow(ret,"</to>",1,0);
	}
	if((flag == CONN_MULTI || flag == CONN_SINGLE) && from_id != NULL)
	{
		ret = strgrow(ret,"<from",1,0);
		if(from_user != NULL)
		{
			ret = strgrow(ret," name='",1,0);
			ret = strgrow(ret,tag_escape(from_user),1,1);
			ret = strgrow(ret,"'",1,0);
		}
		ret = strgrow(ret,">",1,0);
		ret = strgrow(ret,tag_escape(from_id),1,1);
		ret = strgrow(ret,"</from>",1,0);
	}
	if(priority != 0)
	{
		ret = strgrow(ret,"<priority>",1,0);
		sprintf(intbuff,"%d",priority);
		ret = strgrow(ret,intbuff,1,0);
		ret = strgrow(ret,"</priority>",1,0);
	}
	if(thread != NULL)
	{
		ret = strgrow(ret,"<thread>",1,0);
		ret = strgrow(ret,tag_escape(thread),1,1);
		ret = strgrow(ret,"</thread>",1,0);
	}
	if(ext != NULL)
	{
		ret = strgrow(ret,"<ext>",1,0);
		ret = strgrow(ret,ext,1,0);
		ret = strgrow(ret,"</ext>",1,0);
	}
	if(subject != NULL)
	{
		ret = strgrow(ret,"<subject>",1,0);
		ret = strgrow(ret,tag_escape(subject),1,1);
		ret = strgrow(ret,"</subject>",1,0);
	}
	if(say != NULL)
	{
		ret = strgrow(ret,"<say>",1,0);
		ret = strgrow(ret,tag_escape(say),1,1);
		ret = strgrow(ret,"</say>",1,0);
	}
	ret = strgrow(ret,"</p_>",1,0);

	return ret;
}


char *print_status(char *from_id, char *from_user, char *say, char *status, int type, char *to_id, int flag)
{
	char *ret = NULL;

	DBUG("Printing Status from",from_id)
	ret = strgrow(ret,"<p_ type='status'",1,0);
	if(flag == CONN_TRANSPORT && from_id != NULL)
	{
		ret = strgrow(ret," from='",1,0);
		ret = strgrow(ret,tag_escape(from_id),1,1);
		ret = strgrow(ret,"'",1,0);
	}
	if(flag == CONN_TRANSPORT && from_user != NULL)
	{
		ret = strgrow(ret," nick='",1,0);
		ret = strgrow(ret,tag_escape(from_user),1,1);
		ret = strgrow(ret,"'",1,0);
	}
	if(flag == CONN_MULTI && to_id != NULL)
	{
		ret = strgrow(ret," for='",1,0);
		ret = strgrow(ret,tag_escape(to_id),1,1);
		ret = strgrow(ret,"'",1,0);
	}
	ret = strgrow(ret,">",1,0);
	if(flag == CONN_TRANSPORT && to_id != NULL)
	{
		ret = strgrow(ret,"<to>",1,0);
		ret = strgrow(ret,tag_escape(to_id),1,1);
		ret = strgrow(ret,"</to>",1,0);
	}
	if((flag == CONN_MULTI || flag == CONN_SINGLE) && from_id != NULL)
	{
		ret = strgrow(ret,"<from",1,0);
		if(from_user != NULL)
		{
			ret = strgrow(ret," name='",1,0);
			ret = strgrow(ret,tag_escape(from_user),1,1);
			ret = strgrow(ret,"'",1,0);
		}
		ret = strgrow(ret,">",1,0);
		ret = strgrow(ret,tag_escape(from_id),1,1);
		ret = strgrow(ret,"</from>",1,0);
	}
	if(say != NULL)
	{
		ret = strgrow(ret,"<say",1,0);
		if(type != STATUS_NORMAL)
		{
			ret = strgrow(ret," type='",1,0);
			if(type == STATUS_OFFLINE)
				ret = strgrow(ret,"offline",1,0);
			if(type == STATUS_ONLINE)
				ret = strgrow(ret,"online",1,0);
			ret = strgrow(ret,"'",1,0);
		}
		ret = strgrow(ret,">",1,0);
		ret = strgrow(ret,tag_escape(say),1,1);
		ret = strgrow(ret,"</say>",1,0);
	}
	if(status != NULL)
	{
		ret = strgrow(ret,"<status>",1,0);
		ret = strgrow(ret,tag_escape(status),1,1);
		ret = strgrow(ret,"</status>",1,0);
	}
	ret = strgrow(ret,"</p_>",1,0);

	return ret;
}



void deliver_roster(char *to_id, char *to_user, pair *par)
{
	char *ret = NULL;

	DBUG("Delivering Roster to ",to_id)

	ret = strgrow(ret,"<p_ type='roster'",1,0);
	if(to_id != NULL)
	{
		ret = strgrow(ret," for='",1,0);
		ret = strgrow(ret,tag_escape(to_id),1,1);
		ret = strgrow(ret,"'",1,0);
	}
	ret = strgrow(ret,">",1,0);
	while(par != NULL)
	{
		ret = strgrow(ret,"<group",1,0);
		if(par->val != NULL)
		{
			ret = strgrow(ret," name='",1,0);
			ret = strgrow(ret,tag_escape(par->val),1,1);
			ret = strgrow(ret,"'",1,0);
		}
		if(par->key == NULL)
		{
			ret = strgrow(ret,"/>",1,0);
		}else{
			ret = strgrow(ret,">",1,0);
			ret = strgrow(ret,tag_escape(par->key),1,1);
			ret = strgrow(ret,"</group>",1,0);
		}
		par = par->next;
	}
	ret = strgrow(ret,"</p_>",1,0);
	free(ret);
}



void deliver_connection(conn *c)
{
	char *buff = NULL;

	DBUG("Delivering Connection information to ",c->name)
	buff = strgrow(buff,"<p_ type='connection'><ver>",1,0);
	buff = strgrow(buff,"",1,0);
	buff = strgrow(buff,"</ver><protocol>",1,0);
	buff = strgrow(buff,"",1,0);
	buff = strgrow(buff,"</protocol></p_>",1,0);
	c->packets = packet_add(c->packets,buff,"");
	free(buff);
}



