#include "jabberbox.h"

conn *dispatch(char *p, conn *c)
{
	static tap tp = {NULL, &handle_packet, 0};
	conn *c_new = NULL;
	int s;
	transport *t;

	DBUG("DISPATCH",p);

	if(strcmp(p, "REMOVE") == 0)
	{
		DBUG("Removing connection", c->name);
		transport_del(transport_get(c));
		return NULL;
	}

	if(strcmp(p, "INIT") == 0)
	{
		DBUG("Initialization from IO loop", "");

		s = make_filesocket(pair_getval(etc.vars, "local"), 0);
		h_err(s, "file socket");
		h_err(listen(s, 5), "listen file");
		c_new = conn_add(c_new, s);
		c_new->type = CONN_LISTEN;
		c_new->name = strdup("local");

		/* need to add little loop to catch multiple <listen> directives */
		s = make_netsocket(DEFAULT_PORT, pair_getval(etc.vars, "listen"), 0);
		h_err(s, "net socket");
		h_err(listen(s, 5), "listen socket");
		c_new = conn_add(c_new, s);
		c_new->type = CONN_LISTEN;
		c_new->name = strdup("listen");

		return c_new;
	}

	t = transport_get(c);
	if(t == NULL) /* data from new connection, add into lookup table */
	{
		DBUG("Adding new transport",c->name);
		transport_add(c, 0);
		t = transports;
	}
	time(t->activity);

	DBUG("Processing normally","");

	tag_parse(&tp, p, t);

	/* final check, if any new transports have been connected and we need to let the io loop know */
	t = transports;
	while(t != NULL)
	{
		if(t->flag_new == 1)
		{
			t->flag_new = 0;
			return t->c;
		}
		t = t->next;
	}

	return NULL;
}

void handle_packet(tag *t, transport *trans)
{
	static tap tp = {NULL, NULL, 0};
	pair *par, *attr;
	transport *to, *send_to;
	char *str;
	conn *c = trans->c;
	char *name;
	tag *newtag;

	if(trans->type == TRANSPORT_LOCAL)
	{
		/* check for and handle the only special packet, handshake */
		name = pair_getval(t->attributes, "handshake");
		if(name != NULL)
		{
			par = pair_new(NULL,"r",NULL,0);
			tp.h_tag = &handle_handshake;
			tag_parse(&tp, t->contents, par);

			attr = par->next;
			while(attr != NULL)
			{
				if(strcmp(attr->key, "alias") == 0)
					lookup_add(attr->val, trans);
				attr = attr->next;
			}

			free_pair(par);
			free(c->name);
			c->name = strdup(name);

			/* pass this transport it's main config file section in return */
			par = pair_new(NULL, "type", "config", 0);
			newtag = tag_new("j", par, pair_getval(etc.transports, name), 1);
			c->packets = packet_add(c->packets, tag2str(newtag, 0), NULL);
			free_tag(newtag);
			free_pair(par);
			return;
		}
	}

	if(pair_get(t->attributes, "to") == NULL || pair_get(t->attributes, "from") == NULL)
		return;

	/* this is where the packet gets routed or bounced */
	to = resolve(pair_getval(t->attributes, "to"));
	if(to == NULL)
	{
		DBUG("Packet delivery failed, return to sender","");
		par = pair_new(NULL,"j",NULL,0);
		tp.h_tag = &handle_contents_error;
		tag_parse(&tp, t->contents, par);

		/* setting attributes on contained packet, renaming type='' if needed */
		/* type='error' error='error message' error_type='original type' */
		attr = pair_get(par, "type");
		if(attr != NULL)
		{
			par->next = pair_new(par->next, "error_type", attr->val, 0);
			free(attr->val);
			attr->val = strdup("error");
		}
		par->next = pair_new(par->next, "error", "Server Name Resolution Failed", 0); /* might be different error reasons in the future */
		free(t->contents);
		newtag = tag_new(par->key, par->next, par->val, 1);
		t->contents = tag2str(newtag, 0);
		free_tag(newtag);
		free_pair(par);

		send_to = trans;
	}else{
		send_to = to;
	}

	DBUG("Normal Delivery","");
	if(send_to->type == TRANSPORT_NET)
	{
		newtag = tag_new("r", t->attributes, t->contents, 1);
		str = tag2str(newtag, 0);
		free_tag(newtag);
	}else{
		str = strdup(t->contents);
	}
	send_to->c->packets = packet_add(send_to->c->packets, str, NULL);
	free(str);
}

void handle_contents_error(tag *t, pair *p)
{
	free(p->key);
	p->key = strdup(t->name);
	p->next = pair_dup(t->attributes);
	p->val = strdup(t->contents);
}

void handle_handshake(tag *t, pair *p)
{
	p->next = pair_new(p->next, t->name, t->contents, 0);
}

