
extern conn *transport;

/*
 * Structure for list of current connected online sessions known
 */
typedef struct session_struct
{
	char *id; /* actual username */
	char *user; /* nickname */
	conn *c;
	int mod; /*(MOD_BASIC||MOD_MYSQL||etc...)*/
	char *say;
	char *status;
	int flag_sendstatus;
	int flag_status;
	int priority;
	int security; /*(SEC_*)*/
	time_t *activity;
	time_t *start;
	struct session_struct *next;
	struct session_struct *lookup_next;
} session;

extern session *sessions;

/*
 * Structure that is passed around when decoding the protocol
 */
typedef struct
{
	conn *c;
	session *s;
	int type; /*(PAK_*)*/

	pair *par; /* message to or roster commands */

	char *version;
	char *protocol;
	char *id;
	char *user;
	char *pass;
	char *thread;
	char *subject;
	char *ext;
	char *say;
	char *status;
	int priority;
	int flag_type; /* STATUS_* */
	int flag_misc;

	/* for unparsed packages/misc */
	char *raw;
	char *raw_type;

} package;

/*
 *	Simple structure for modules to define their hook-in points
 */
typedef struct
{
	int module;
	void (*init)(pair *);
	int (*authenticate)(char *, char *);
	int (*notify)(char *, int);
	pair *(*status)(char *, int);
	pair *(*roster)(int, char *, char *, char *);
	pair *(*offline_message)(char *, pair *);
	pair *(*online_message)(char *);
	pair *(*search)(char *);
	void (*log)(char *);
} module;

extern module *modules[];
