#include "jabber.h"

void sig_die()
{
	DBUG("EXITING","")
	longjmp(env_io,1);
}

char *make_tag_quick(char *name, char *value)
{
	char *ret;

	if(value == NULL)
		return NULL;

	if(*value == '\0')
		return NULL;

	value = tag_escape(value);
	ret = malloc(strlen(name)*2 + strlen(value) + 6); 
	sprintf(ret,"<%s>%s</%s>",name,value,name);
	free(value);

	return ret;
}

/* should only get called once */
void do_config()
{
	static tap tp = {NULL, &handle_config_modules, 0};
	pair *p;
	module **m;
	int s;
	conn *c;
	char *str;

	DBUG("Config: module init","");
	if(pair_getval(etc.vars, "modules") != NULL)
	{
		p = pair_new(NULL,"modules",NULL,0);
		tag_parse(&tp, pair_getval(etc.vars, "modules"), p);

		for(m = modules; *m != NULL; m++)
		{
			if((*m)->init != NULL)
				(*m)->init(p->next);
		}
		free_pair(p);
	}

	DBUG("Config: network socket","");
	s = make_netsocket(DEFAULT_PORT, pair_getval(etc.vars, "listen"), 0);
	h_err(s, "creating network socket");
	h_err(listen(s, 5), "listening on network socket");
	c = conn_add(NULL, s);
	c->type = CONN_LISTEN;
	c->name = strdup("parent");
	transport = conn_append(transport, c); /* tricky way of adding it to the io loop w/o passing it back the right way */

	DBUG("Config: aliases","");
	str = strgrow(NULL,"<r handshake='",0,0);
	str = strgrow(str,DEFAULT_ID,1,0);
	str = strgrow(str,"'>",1,0);
	str = strgrow(str, make_tag_quick("alias",pair_getval(etc.vars, "name")),1,1);
	p = etc.vars;
	while(p != NULL)
	{
		if(p->key != NULL && strcmp(p->key, "alias") == 0)
			str = strgrow(str, make_tag_quick("alias",p->val),1,1);
		p = p->next;
	}
	str = strgrow(str, "</r>",1,0);
	transport->packets = packet_add(transport->packets, str, NULL);
	free(str);

}


/* for debugging */
void package_print(package *p)
{
	pair *par;
	switch(p->type)
	{
		case PACK_CONNECTION:
			printf("PC: ver[%s] proto[%s]\n",p->version,p->protocol);
			break;
		case PACK_LOGIN:
			printf("PL: user[%s] pass[%s] nick[%s]\n",p->id,p->pass,p->user);
			break;
		case PACK_MESSAGE:
			printf("PM: from[%s <%s>] ",p->user,p->id);
			par = p->par;
			while(par != NULL)
			{
				printf("to[%s <%s>] ",par->key,par->val);
				par = par->next;
			}
			printf("pri[%d] thr[%s] sub[%s] say[%s]\n",p->priority,p->thread,p->subject,p->say);
			break;
		case PACK_STATUS:
			printf("PS: type[%d] pri[%d] status[%s] say[%s]\n",p->flag_type,p->priority,p->status,p->say);
			break;
		case PACK_ROSTER:
			printf("PR: ");
			par = p->par;
			while(par != NULL)
			{
				if(par->flag == ROSTER_ADD)
					printf("add[%s <%s>] ",par->key,par->val);
				if(par->flag == ROSTER_REMOVE)
					printf("del[%s <%s>] ",par->key,par->val);
				if(par->flag == ROSTER_GET)
					printf("get[%s <%s>] ",par->key,par->val);
				par = par->next;
			}
			printf("\n");
			break;
		case PACK_LOGOUT:
			printf("PL: LOGOUT\n");
			break;
	}
}


package *package_init(conn *c)
{
	package *p;

	p = malloc(sizeof(package));
	p->c = c;
	p->s = NULL;
	p->par = NULL;
	p->type = PACK_UNKNOWN;
	p->version = NULL;
	p->protocol = NULL;
	p->id = NULL;
	p->pass = NULL;
	p->user = NULL;
	p->thread = NULL;
	p->subject = NULL;
	p->ext = NULL;
	p->say = NULL;
	p->status = NULL;
	p->priority = 0;
	p->flag_type = 0;
	p->flag_misc = 0;
	p->raw = NULL;
	p->raw_type = NULL;

	return p;
}

void free_package(package *p)
{
	free(p->version);
	free(p->protocol);
	free(p->id);
	free(p->pass);
	free(p->user);
	free(p->thread);
	free(p->subject);
	free(p->ext);
	free(p->say);
	free(p->status);
	free(p->raw);
	free(p->raw_type);
	free_pair(p->par);
	free(p);
}

