#include "jabberbox.h"

transport *transports = NULL;
lookup *lookups = NULL;

void lookup_add(char *name, transport *t)
{
	lookup *new;

	if(name == NULL)
		return;

	DBUG("LOOKUP: adding",name);

	new = malloc(sizeof(lookup));
	new->name = strdup(name);
	new->t = t;
	new->next = lookups;
	lookups = new;
}

lookup *lookup_get(char *name)
{
	lookup *lu = lookups;

	if(name == NULL)
		return NULL;

	DBUG("LOOKUP: fetching",name);

	while(lu != NULL)
	{
		if(strcmp(name, lu->name) == 0)
			return lu;
		lu = lu->next;
	}

	return NULL;
}

transport *lookup_gettransport(char *name)
{
	lookup *lu;

	lu = lookup_get(name);
	if(lu == NULL)
		return NULL;
	return lu->t;
}

transport *transport_get(conn *c)
{
	transport *next = transports;

	DBUG("TRANSPORT: fetching","");

	while(next != NULL)
	{
		if(next->c == c)
			return next;
		next = next->next;
	}
	return NULL;
}

void transport_add(conn *c, int NEW)
{
	transport *new;

	if(c == NULL)
		return;

	DBUG("TRANSPORT: adding",c->name);

	new = malloc(sizeof(transport));
	new->c = c;
	new->flag_new = NEW;
	if(c->ver != NULL && strcmp(c->ver, "local") == 0)
		new->type = TRANSPORT_LOCAL;
	else
		new->type = TRANSPORT_NET;
	new->activity = malloc(sizeof(time_t));
	new->start = malloc(sizeof(time_t));
	time(new->activity);
	time(new->start);
	new->next = transports;
	transports = new;
}

void transport_del(transport *t)
{
	lookup *lu, *prev;
	transport *loop, *tprev;

	if(t == NULL)
		return;

	DBUG("TRANSPORT: deleting","");

	lu = lookups;
	prev = NULL;
	while(lu != NULL)
	{
		if(lu->t != NULL && lu->t == t)
		{
			if(prev == NULL)
				lookups = lu->next;
			else
				prev->next = lu->next;

			free(lu->name);
			free(lu);

			/* we deleted one, start over and look for another */
			lu = lookups;
			prev = NULL;
			continue;
		}
		prev = lu;
		lu = lu->next;
	}

	/* now lets remove the actual transport */
	loop = transports;
	tprev = NULL;
	while(loop != NULL)
	{
		if(loop == t)
		{
			if(tprev == NULL)
				transports = loop->next;
			else
				tprev->next = loop->next;
			free(t->activity);
			free(t->start);
		}
		loop = loop->next;
	}
}

transport *resolve(char *name)
{
	transport *t;
	struct in_addr *addr;
	int s;
	conn *c = NULL;

	if(name == NULL)
		return NULL;

	DBUG("LOOKUP: resolving",name);

	t = lookup_gettransport(name);
	if(t != NULL)
		return t;

	addr = make_addr(name);
	if(addr == NULL)
		return NULL;

	DBUG("LOOKUP: resolved address",inet_ntoa(*addr));
	t = lookup_gettransport(inet_ntoa(*addr));
	if(t != NULL)
	{
		DBUG("LOOKUP: found existing transport","");
		lookup_add(name, t); /* this name resolves to this IP/transport, cache that */
		return t;
	}

	DBUG("LOOKUP: connect new transport","");
	s = make_netsocket(DEFAULT_PORT, name, 1);
	if(s > 0)
	{
		c = conn_add(c, s);
		c->name = strdup(name);
		transport_add(c, 1);
		lookup_add(name, transports);
		lookup_add(inet_ntoa(*addr), transports); /* so this transport can be reused for multiple names->one ip */
		return transports;
	}

	DBUG("LOOKUP: Failed!","");
	return NULL;
}

