/*******************************************************************
*                                                                  *
*  MODULE : combiners.c                                            *
*                                                                  *
*  Function:   Actual parameter functions for reductions/scatters  *
*                                                                  *
*******************************************************************/

void or_bools (i1, i2)   /* .OR., ANY */
int *i1, *i2;
{ if (*i2) *i1 = *i2;
}

void and_bools (i1, i2)  /* .AND., ALL */
int *i1, *i2;
{ if (!(*i2)) *i1 = *i2;
}

void neq_bools (i1, i2)   /* .NEQV., PARITY */
int *i1, *i2;
{ if (*i2) *i1 = !(*i1);
}

void add_ints (i1, i2)   /* +, SUM, COUNT */
int *i1, *i2;
{ *i1 = *i1 + *i2;
}

void mult_ints (i1, i2)   /* *, PRODUCT */
int *i1, *i2;
{ *i1 = *i1 * *i2;
}

void max_ints (i1, i2)    /* max, MAXVAL */
int *i1, *i2;
{ if (*i2 > *i1) *i1 = *i2; }

void min_ints (i1, i2)    /* min, MINVAL */
int *i1, *i2;
{ if (*i2 < *i1) *i1 = *i2; }

void and_ints (i1, i2)   /* IAND, AND */
int *i1, *i2;
{ *i1 = *i1 & *i2;
}

void or_ints (i1, i2)   /* IOR, OR */
int *i1, *i2;
{ *i1 = *i1 | *i2;
}

void eor_ints (i1, i2)   /* IEOR, EOR */
int *i1, *i2;
{ *i1 = *i1 ^ *i2;
}

void add_reals (f1, f2)   /* +, SUM */
float *f1, *f2;
{ *f1 = *f1 + *f2; }

void mult_reals (f1, f2)   /* *, PRODUCT */
float *f1, *f2;
{ *f1 = *f1 * *f2; }

void max_reals (f1, f2)    /* MAX, MAXVAL */
float *f1, *f2;
{ if (*f2 > *f1) *f1 = *f2; }

void min_reals (f1, f2)    /* MIN, MINVAL */
float *f1, *f2;
{ if (*f2 < *f1) *f1 = *f2; }

void add_doubles (f1, f2)    /* +, SUM */
double *f1, *f2;
{ *f1 = *f1 + *f2; }

void mult_doubles (f1, f2)   /* *, PRODUCT */
double *f1, *f2;
{ *f1 = *f1 * *f2; }

void max_doubles (f1, f2)    /* MAX, MAXVAL */
double *f1, *f2;
{ if (*f2 > *f1) *f1 = *f2; }

void min_doubles (f1, f2)    /* MIN, MINVAL */
double *f1, *f2;
{ if (*f2 < *f1) *f1 = *f2; }

void add_complexes (f1, f2)    /* +, SUM */
float f1[2], f2[2];
{ f1[0] = f1[0] + f2[0];  
  f1[1] = f1[1] + f2[1]; }

/*******************************************************************
*                                                                  *
*  reduction functions with saving position                        *
*                                                                  *
*******************************************************************/

void max_pos_ints (p1, p2, f1, f2)    /* MAX, MAXLOC */
int *p1, *p2;
int *f1, *f2;
{ if (*f2 > *f1)
     { *f1 = *f2; 
       *p1 = *p2;
     }
}

void min_pos_ints (p1, p2, f1, f2)    /* MIN, MINLOC */
int *p1, *p2;
int *f1, *f2;
{ if (*f2 < *f1)
     { *f1 = *f2; 
       *p1 = *p2;
     }
}

void max_pos_reals (p1, p2, f1, f2)    /* MAX, MAXLOC */
int *p1, *p2;
float *f1, *f2;
{ if (*f2 > *f1) 
     { *f1 = *f2; 
       *p1 = *p2;
     }
}

void min_pos_reals (p1, p2, f1, f2)    /* MIN, MINLOC */
int *p1, *p2;
float *f1, *f2;
{ if (*f2 < *f1)
     { *f1 = *f2; 
       *p1 = *p2;
     }
}

void max_pos_doubles (p1, p2, f1, f2)    /* MAX, MAXLOC */
int *p1, *p2;
double *f1, *f2;
{ if (*f2 > *f1)
     { *f1 = *f2; 
       *p1 = *p2;
     }
}

void min_pos_doubles (p1, p2, f1, f2)    /* MIN, MINLOC */
int *p1, *p2;
double *f1, *f2;
{ if (*f2 < *f1) 
     { *f1 = *f2; 
       *p1 = *p2;
     }
}

