/**************************************************************************
*                                                                         *
*  Author      : Falk Zimmermann, GMD, I1.HR                              *
*  Copyright   : GMD St. Augustin, Germany                                *
*  Date        : Jun 93                                                   *
*  Last Update : Jun 93                                                   *
*                                                                         *
*  This Module is part of the DALIB                                       *
*                                                                         *
*  Module      : transpose0.c                                             *
*                                                                         *
*  Function    : Transposing of a 2-dimensional replicated/host array     *
*                                                                         *
*  Export      : dalib_ltranspose_()                                      *
*                                                                         *
*  void dalib_ltranspose_ (target, source, N1, N2, size)                  *
*  unsigned char *source, *target;                                        *
*  int *N1, *N2;                                                          *
*  int *size;                                                             *
*                                                                         *
**************************************************************************/

# undef DEBUG

#include "system.h"


# define DIM 4       /* maximal supported dimension */


void dalib_ltranspose__ (target, source, N1, N2, size)
unsigned char *source, *target;
int *N1, *N2;
int *size;
{  int j,k,ofssou1,ofssou2,ofstar;

   ofssou1 = *N2 * *size;
   for (j=0;j < *N2;j++)
     { ofssou2 = j * *size;
       ofstar = j * *N1 * *size;
       for (k=0;k < *N1;k++)
	 dalib_memcpy (target+ofstar+k* *size,source+ofssou2+ofssou1*k,*size);
    }
}

