c      test program for dalib_cshift
c
      program test
      integer N, POS
      parameter (N=15)
      print *, 'Input POS (1-15) '
      read *, POS
      if (POS .ge. 1) then
         call test_shift1a (POS)
         call test_shift1b (POS)
         call test_shift21a (POS)
         call test_shift21b (POS)
         call test_shift22a (POS)
         call test_shift22b (POS)
      end if
      end

      subroutine test_shift1a (POS)
      parameter (N=15)
      integer A(N), HA(N), POS
      integer I
cmf$  layout HA(:host)
      forall (I=1:N) A(I) = I
      print *, 'TEST of CSHIFT (A, 1, POS)'
      HA = A
      print 10, HA
      A = cshift (A, 1, POS)
      HA = A
      print 11, HA
  10  format (' A        : ',20I3)
  11  format (' A (shf)  : ',20I3)
      end

      subroutine test_shift1b (POS)
      parameter (N=15)
      integer A(N), HA(N), POS
      integer I
cmf$  layout HA(:host)
      forall (I=1:N) A(I) = I
      print *, 'TEST of CSHIFT (A, 1, -POS)'
      HA = A
      print 10, HA
      A = cshift (A, 1, -POS)
      HA = A
      print 11, HA
  10  format (' A        : ',20I3)
  11  format (' A (shf)  : ',20I3)
      end

      subroutine test_shift21a (POS)
      parameter (N=15)
      integer A(4, N), HA(4, N), POS
      integer I, J
cmf$  layout HA(:host)
      forall (I=1:N,J=1:4) A(J,I) = I + J
      print *, 'TEST of CSHIFT (A, 1, POS)'
      HA = A
      do J = 1, 4
        print 10, HA(J,:)
      end do
      A = cshift (A, 1, POS)
      HA = A
      do J = 1, 4
        print 11, HA(J,:)
      end do
  10  format (' A        : ',20I3)
  11  format (' A (shf)  : ',20I3)
      end

      subroutine test_shift21b (POS)
      parameter (N=15)
      integer A(4, N), HA(4, N), POS
      integer I, J
cmf$  layout HA(:host)
      forall (I=1:N,J=1:4) A(J,I) = I + J
      print *, 'TEST of CSHIFT (A, 1, -POS)'
      HA = A
      do J = 1, 4
        print 10, HA(J,:)
      end do
      A = cshift (A, 1, -POS)
      HA = A
      do J = 1, 4
        print 11, HA(J,:)
      end do
  10  format (' A        : ',20I3)
  11  format (' A (shf)  : ',20I3)
      end

      subroutine test_shift22a (POS)
      parameter (N=15)
      integer A(4, N), HA(4, N), POS
      integer I, J
cmf$  layout HA(:host)
      forall (I=1:N,J=1:4) A(J,I) = I + J
      print *, 'TEST of CSHIFT (A, 2, POS)'
      HA = A
      do J = 1, 4
        print 10, HA(J,:)
      end do
      A = cshift (A, 2, POS)
      HA = A
      do J = 1, 4
        print 11, HA(J,:)
      end do
  10  format (' A        : ',20I3)
  11  format (' A (shf)  : ',20I3)
      end

      subroutine test_shift22b (POS)
      parameter (N=15)
      integer A(4, N), HA(4, N), POS
      integer I, J
cmf$  layout HA(:host)
      forall (I=1:N,J=1:4) A(J,I) = I + J
      print *, 'TEST of CSHIFT (A, 2, -POS)'
      HA = A
      do J = 1, 4
        print 10, HA(J,:)
      end do
      A = cshift (A, 2, -POS)
      HA = A
      do J = 1, 4
        print 11, HA(J,:)
      end do
  10  format (' A        : ',20I3)
  11  format (' A (shf)  : ',20I3)
      end

