/*************************************************************************
*                                                                        *
*  Name : fstrip.c                                                       *
*                                                                        *
*  Purpose : Splitting Fortran Source programs with longer lines         *
*                                                                        *
*  Author : James Cownie, Meiko, Bristol                                 *
*                                                                        *
*  Last Update : June 1993                                               *
*                                                                        *
*                                                                        *
*   The behaviour of this code was not actually safe. It will break      *
*   if it has to split lines with long character string definitions,     *
*   as it is not aware that that is what it is doing.                    *
*                                                                        *
*   It would actually be safer not to try to choose a good place to      *
*   split, but always split at the correct column, and ASSUME that the   *
*   Fortran compiler will re-assemble the lines at the same width.       *
*                                                                        *
*************************************************************************/

#include <stdio.h>    /* file handling */
#include <ctype.h>

#define MAXLEN 200

main (argc, argv)
int argc;
char **argv;
{
    char buffer [MAXLEN+100];
    FILE *infile, *outfile, *ptmp ;
    int c;
    int buflen;

    char infilename[100];
    char outfilename[100];
    char move[200];

    int  strip_length;

    if (argc < 2)
    {
       printf ("Correct Call is : \n");
       printf ("fstrip filename [strip_length]\n");
       exit (-1);
    }

    strcpy (infilename, argv[1]);

    strip_length = 132;

    if (argc >= 3)
    {
       sscanf (argv[2], "%d", &strip_length);
    }

    printf ("File %s will be stripped to length = %d\n",
           infilename, strip_length);

    if ((strip_length < 50) || (strip_length > 150))
    {
       printf ("strip_length must be in range [50 - 150]\n");
       exit (-1);
    }

    infile  = fopen (infilename, "r");

    if (infile == NULL)
    {
       printf ("Input File %s could not be opened\n", infilename);
       exit (-1);
    }

    strcpy (outfilename, "tmpxy07");

    outfile = fopen (outfilename, "w");

    if (outfile == NULL)
    {
       printf ("Output File %s could not be opened\n", outfilename);
       exit (-1);
    }

    buflen = 0;  /* actual buffer length */

    while ((c = fgetc(infile)) != EOF)
    {
       int i;

       if (c == '\n')
       { /* new line, print current line */
           for (i=0; i<buflen; i++)
        putc (buffer[i], outfile);
           putc ('\n', outfile);
           buflen = 0;
       }
       else
       { /* set new character */
           buffer[buflen++] = c;
           if (buflen == strip_length)
           {   /* find a place to break */
        for (c = buffer[buflen-1];buflen > 0;)
        {
            switch (c)
            {
         case ' ':    /* Characters on which to break */
         case '\t':
         case ',':
         case '(':
         case ')':
         case '+':
         case '-':
         case '*':
         case '/': break;

         default:  buflen -= 1;
                   c = buffer[buflen-1];
                   continue;
            }
            break;
        }
        /* If we can't find a good place to break it doesn't actually
         * matter, as we can just break anywhere provided we
         * fill to the right hand side.
         */
        if (buflen == 0)
            buflen = strip_length;

        /* buffer[0], ..., buffer[buflen-1], buffer[buflen], ..
           ---- printed   characters         -- next line   --- */
        /* print out buffer */
        for (i=0; i<buflen; i++)
            putc (buffer[i], outfile);
        putc ('\n', outfile);
        /* make continuation line */
        for (i=0;i<5;i++) buffer[i] = ' ';
        buffer[5] = '&';
        for (i=buflen;i<strip_length;i++)
            buffer[i-buflen+6] = buffer[i];
        /* fill in rest of line */
        buflen = strip_length-buflen+6;
           }
       }
    }

    /* print rest of the buffer (last line if no \n in input) */
    if (buflen > 0)
    {
       int i;

       for (i=0; i<buflen; i++)
           putc (buffer[i], outfile);
       putc ('\n', outfile);
    }

    fcloseall();

    sprintf (move, "mv %s %s", outfilename, infilename);
    system(move);
/*
    ptmp = popen (move,"w");
    pclose (ptmp);
*/
    exit(0);
}

