# include "Unparse.h"
# include "yyUnpars.w"
# include <stdio.h>
# if defined __STDC__ | defined __cplusplus
#  include <stdlib.h>
# else
   extern void exit ();
# endif
# include "Tree.h"

# define yyInline
# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 26 "FUnparse.puma"


# include "Tree.h"
# include "Idents.h"
# include "StringMe.h"

# define IndentLength 3    /* indent for nested statements */

# define LineFlag 0        /* 1 prints line comments */

static FILE * f;
int    indent;

unsigned char string[1024];  /* might be very long */

void FileUnparse (ef, t)
FILE *ef;
tTree t;
{ FILE *h;
  h = f;      /* save local file pointer */
  f = ef;     /* set external file */
  Unparse (t);
  f = h;
}

void ind ()
{ int i;
  for (i=0;i<indent+6;i++)
     fprintf (f," ");
}

void hpf_ind ()
{ int i;
  fprintf (f, "!HPF$ ");
  for (i=6;i<indent+6;i++)
     fprintf (f," ");
}

void label_ind (label)
int label;
{ int i;
  if (label == 0) ind ();
   else { fprintf (f,"%4d  ",label);
          for (i=0; i<indent;i++)
           fprintf (f," ");
        }
}

void cont_ind ()
{ int i;
  fprintf (f,"     $");
  for (i=0; i<indent;i++)
     fprintf (f," ");
}

void LCR (line)
int line;
{ if (LineFlag)
     fprintf (f," ! line=%d\n", line);
    else
     fprintf (f,"\n");
} /* LCR */

tIdent NoId ()
{ return (MakeIdent (" ",1));
}

void MyPrintString (f, str)
FILE *f;
char *str;
{ char *spos;
  spos = str;
  while (*spos != 0)
   { if (*spos == '\'')
       fprintf (f, "\'\'");
      else
       fprintf (f, "%c", *spos);
     spos++;
   }
}



static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Unparse, routine %s failed\n", yyFunction);
 exit (1);
}

void Unparse ARGS((tTree t));
static int Priority ARGS((tTree yyP1));
static void ComUnparse ARGS((tTree t));
static void UnparseElse ARGS((tTree t));
static void UnparseDoRange ARGS((tTree slice));
static void ExpUnparse ARGS((tTree t, int leftprio, int rightprio));
static void OpUnparse ARGS((tTree t));
static void FormatUnparse ARGS((tTree t));
static void LayoutUnparse ARGS((tTree t));
static bool IsItAllocatable ARGS((tTree t));
static int UP_List_Length ARGS((tTree t));
static void FormalParamUnparse ARGS((tTree t));
static void ParamUnparse ARGS((tTree t));
static void AttributeUnparse ARGS((tTree t));
static void AlignSpecUnparse ARGS((tTree t));
static void UseNameUnparse ARGS((tTree t));
static void GenSpecUnparse ARGS((tTree t));

void Unparse
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 122 "FUnparse.puma"

char *sindex;

  if (t == NoTree) return;
# line 126 "FUnparse.puma"
  {
# line 127 "FUnparse.puma"
   if (! ((t == NoTree))) goto yyL1;
  {
# line 128 "FUnparse.puma"
   fprintf (f, "<NoTree>");
  }
  }
   return;
yyL1:;


  switch (t->Kind) {
  case kCOMP_UNIT:
# line 131 "FUnparse.puma"
  {
# line 133 "FUnparse.puma"
   Unparse (t->COMP_UNIT.COMP_ELEMENTS);
  }
   return;

  case kDECL_LIST:
  if (t->DECL_LIST.Elem->Kind == kVAR_PARAM_DECL) {
  if (t->DECL_LIST.Next->Kind == kDECL_EMPTY) {
# line 142 "FUnparse.puma"
  {
# line 143 "FUnparse.puma"
   GetString (t->DECL_LIST.Elem->VAR_PARAM_DECL.Name, string);
# line 144 "FUnparse.puma"
   fprintf (f, "%s ", string);
  }
   return;

  }
# line 147 "FUnparse.puma"
  {
# line 148 "FUnparse.puma"
   GetString (t->DECL_LIST.Elem->VAR_PARAM_DECL.Name, string);
# line 149 "FUnparse.puma"
   fprintf (f, "%s, ", string);
# line 150 "FUnparse.puma"
   Unparse (t->DECL_LIST.Next);
  }
   return;

  }
# line 153 "FUnparse.puma"
  {
# line 154 "FUnparse.puma"
   Unparse (t->DECL_LIST.Elem);
# line 155 "FUnparse.puma"
   Unparse (t->DECL_LIST.Next);
  }
   return;

  case kDECL_EMPTY:
# line 158 "FUnparse.puma"
   return;

  case kPROGRAM_DECL:
# line 161 "FUnparse.puma"
  {
# line 162 "FUnparse.puma"
   ind ();
# line 163 "FUnparse.puma"
   GetString (t->PROGRAM_DECL.Name, string);
# line 164 "FUnparse.puma"
   fprintf (f, "PROGRAM %s \n", string);
# line 165 "FUnparse.puma"
   Unparse (t->PROGRAM_DECL.PROGRAM_BODY);
# line 166 "FUnparse.puma"
   fprintf (f, "\n");
  }
   return;

  case kPROC_DECL:
# line 169 "FUnparse.puma"
  {
# line 170 "FUnparse.puma"
   ind ();
# line 171 "FUnparse.puma"
   GetString (t->PROC_DECL.Name, string);
# line 172 "FUnparse.puma"
 if (t->PROC_DECL.IsRecursive) fprintf (f, "RECURSIVE ");
          if (t->PROC_DECL.IsPure) fprintf (f, "PURE ");
          if (t->PROC_DECL.HPFExtrinsic==1) fprintf (f, "EXTRINSIC (HPF) ");
          if (t->PROC_DECL.HPFExtrinsic==2) fprintf (f, "EXTRINSIC (HPF_LOCAL) ");

# line 177 "FUnparse.puma"
   fprintf (f, "SUBROUTINE %s (", string);
# line 178 "FUnparse.puma"
   FormalParamUnparse (t->PROC_DECL.FORMALS);
# line 179 "FUnparse.puma"
   fprintf (f, ")\n");
# line 180 "FUnparse.puma"
   Unparse (t->PROC_DECL.PROC_BODY);
# line 181 "FUnparse.puma"
   fprintf (f, "\n");
  }
   return;

  case kFUNC_DECL:
  if (t->FUNC_DECL.RESULT_TYPE->Kind == kDUMMY_TYPE) {
# line 184 "FUnparse.puma"
  {
# line 185 "FUnparse.puma"
   ind ();
# line 186 "FUnparse.puma"
 if (t->FUNC_DECL.IsRecursive) fprintf (f, "RECURSIVE ");
          if (t->FUNC_DECL.IsPure) fprintf (f, "PURE ");
          if (t->FUNC_DECL.HPFExtrinsic==1) fprintf (f, "EXTRINSIC (HPF) ");
          if (t->FUNC_DECL.HPFExtrinsic==2) fprintf (f, "EXTRINSIC (HPF_LOCAL) ");

# line 191 "FUnparse.puma"
   GetString (t->FUNC_DECL.Name, string);
# line 192 "FUnparse.puma"
   fprintf (f, "FUNCTION %s (", string);
# line 193 "FUnparse.puma"
   FormalParamUnparse (t->FUNC_DECL.FORMALS);
# line 194 "FUnparse.puma"
   fprintf (f, ")\n");
# line 195 "FUnparse.puma"
   Unparse (t->FUNC_DECL.FUNC_BODY);
# line 196 "FUnparse.puma"
   fprintf (f, "\n");
  }
   return;

  }
# line 199 "FUnparse.puma"
  {
# line 200 "FUnparse.puma"
   ind ();
# line 201 "FUnparse.puma"
 if (t->FUNC_DECL.IsRecursive) fprintf (f, "RECURSIVE ");
          if (t->FUNC_DECL.IsPure) fprintf (f, "PURE ");
          if (t->FUNC_DECL.HPFExtrinsic==1) fprintf (f, "EXTRINSIC (HPF) ");
          if (t->FUNC_DECL.HPFExtrinsic==2) fprintf (f, "EXTRINSIC (HPF_LOCAL) ");

# line 206 "FUnparse.puma"
   Unparse (t->FUNC_DECL.RESULT_TYPE);
# line 207 "FUnparse.puma"
   GetString (t->FUNC_DECL.Name, string);
# line 208 "FUnparse.puma"
   fprintf (f, " FUNCTION %s (", string);
# line 209 "FUnparse.puma"
   FormalParamUnparse (t->FUNC_DECL.FORMALS);
# line 210 "FUnparse.puma"
   fprintf (f, ")\n");
# line 211 "FUnparse.puma"
   Unparse (t->FUNC_DECL.FUNC_BODY);
# line 212 "FUnparse.puma"
   fprintf (f, "\n");
  }
   return;

  case kMODULE_DECL:
# line 215 "FUnparse.puma"
  {
# line 216 "FUnparse.puma"
   ind ();
# line 217 "FUnparse.puma"
   GetString (t->MODULE_DECL.Name, string);
# line 218 "FUnparse.puma"
   fprintf (f, "MODULE %s \n", string);
# line 219 "FUnparse.puma"
   Unparse (t->MODULE_DECL.MODULE_BODY);
# line 220 "FUnparse.puma"
   fprintf (f, "\n");
  }
   return;

  case kSTMT_FUNC_DECL:
# line 223 "FUnparse.puma"
  {
# line 224 "FUnparse.puma"
   ind ();
# line 225 "FUnparse.puma"
   GetString (t->STMT_FUNC_DECL.Name, string);
# line 226 "FUnparse.puma"
   fprintf (f, "%s (", string);
# line 227 "FUnparse.puma"
   Unparse (t->STMT_FUNC_DECL.FORMALS);
# line 228 "FUnparse.puma"
   fprintf (f, ") = ");
# line 229 "FUnparse.puma"
   Unparse (t->STMT_FUNC_DECL.FFUNC_BODY);
# line 230 "FUnparse.puma"
   fprintf (f, "\n");
  }
   return;

  case kEXT_PROC_DECL:
# line 233 "FUnparse.puma"
  {
# line 234 "FUnparse.puma"
   ind ();
# line 235 "FUnparse.puma"
   fprintf (f, "EXTERNAL ");
# line 236 "FUnparse.puma"
   GetString (t->EXT_PROC_DECL.Name, string);
# line 237 "FUnparse.puma"
   fprintf (f, "%s\n", string);
  }
   return;

  case kEXTERNAL_DECL:
# line 240 "FUnparse.puma"
  {
# line 241 "FUnparse.puma"
   ind ();
# line 242 "FUnparse.puma"
   GetString (t->EXTERNAL_DECL.Name, string);
# line 243 "FUnparse.puma"
   fprintf (f, "EXTERNAL %s\n", string);
  }
   return;

  case kINTRINSIC_DECL:
# line 246 "FUnparse.puma"
  {
# line 247 "FUnparse.puma"
   ind ();
# line 248 "FUnparse.puma"
   GetString (t->INTRINSIC_DECL.Name, string);
# line 249 "FUnparse.puma"
   fprintf (f, "INTRINSIC %s\n", string);
  }
   return;

  case kEXT_FUNC_DECL:
# line 252 "FUnparse.puma"
  {
# line 253 "FUnparse.puma"
   fprintf (f, "FUNCTION ");
# line 254 "FUnparse.puma"
   GetString (t->EXT_FUNC_DECL.Name, string);
# line 255 "FUnparse.puma"
   fprintf (f, "%s (", string);
# line 256 "FUnparse.puma"
   Unparse (t->EXT_FUNC_DECL.FORMALS);
# line 257 "FUnparse.puma"
   fprintf (f, ") : ");
# line 258 "FUnparse.puma"
   Unparse (t->EXT_FUNC_DECL.RESULT_TYPE);
# line 259 "FUnparse.puma"
   fprintf (f, "; external;\n");
  }
   return;

  case kVAL_PARAM_DECL:
# line 262 "FUnparse.puma"
  {
# line 263 "FUnparse.puma"
   GetString (t->VAL_PARAM_DECL.Name, string);
# line 264 "FUnparse.puma"
   fprintf (f, "%s: ", string);
# line 265 "FUnparse.puma"
   Unparse (t->VAL_PARAM_DECL.VAL);
# line 266 "FUnparse.puma"
   fprintf (f, "; ");
  }
   return;

  case kBOOL_CONSTANT:
  if (equalint (t->BOOL_CONSTANT.value, 1)) {
# line 269 "FUnparse.puma"
  {
# line 270 "FUnparse.puma"
   fprintf (f, ".TRUE.");
  }
   return;

  }
  if (equalint (t->BOOL_CONSTANT.value, 0)) {
# line 273 "FUnparse.puma"
  {
# line 274 "FUnparse.puma"
   fprintf (f, ".FALSE.");
  }
   return;

  }
  break;
  case kINT_CONSTANT:
# line 277 "FUnparse.puma"
  {
# line 278 "FUnparse.puma"
   fprintf (f, "%d", t->INT_CONSTANT.value);
  }
   return;

  case kREAL_CONSTANT:
# line 281 "FUnparse.puma"
  {
# line 282 "FUnparse.puma"
   StGetString (t->REAL_CONSTANT.value, string);
# line 283 "FUnparse.puma"
   MyPrintString (f, string);
  }
   return;

  case kDREAL_CONSTANT:
# line 286 "FUnparse.puma"
  {
# line 287 "FUnparse.puma"
   StGetString (t->DREAL_CONSTANT.value, string);
# line 288 "FUnparse.puma"
   MyPrintString (f, string);
  }
   return;

  case kCOMPLEX_CONSTANT:
# line 291 "FUnparse.puma"
  {
# line 292 "FUnparse.puma"
   StGetString (t->COMPLEX_CONSTANT.rvalue, string);
# line 293 "FUnparse.puma"
   MyPrintString (f, string);
# line 294 "FUnparse.puma"
   StGetString (t->COMPLEX_CONSTANT.ivalue, string);
# line 295 "FUnparse.puma"
   MyPrintString (f, string);
  }
   return;

  case kSTRING_CONSTANT:
# line 298 "FUnparse.puma"
  {
# line 299 "FUnparse.puma"
   StGetString (t->STRING_CONSTANT.value, string);
# line 300 "FUnparse.puma"
   fprintf (f, "\'");
# line 301 "FUnparse.puma"
   MyPrintString (f, string);
# line 302 "FUnparse.puma"
   fprintf (f, "\'");
  }
   return;

  case kVAR_DECL:
  if (t->VAR_DECL.VAL->Kind == kARRAY_TYPE) {
  if (t->VAR_DECL.VAL->ARRAY_TYPE.ARRAY_COMP_TYPE->Kind == kDUMMY_TYPE) {
# line 311 "FUnparse.puma"
  {
# line 312 "FUnparse.puma"
   ind ();
# line 313 "FUnparse.puma"
 if (   ((target_machine == SUPRENUM) || (target_machine == CM5))
              && IsItAllocatable (t->VAR_DECL.VAL)
             )
          {  fprintf (f,"ALLOCATABLE :: ");
             GetString (t->VAR_DECL.Name,string);
             fprintf (f," %s (",string);
             Unparse (t->VAR_DECL.VAL->ARRAY_TYPE.ARRAY_INDEX_TYPES);
             fprintf (f,")\n");
          }
          else
          {  fprintf (f,"DIMENSION ");
             GetString (t->VAR_DECL.Name,string);
             fprintf (f," %s (",string);
             Unparse (t->VAR_DECL.VAL->ARRAY_TYPE.ARRAY_INDEX_TYPES);
             fprintf (f,")\n");
          }

  }
   return;

  }
# line 332 "FUnparse.puma"
  {
# line 333 "FUnparse.puma"
   ind ();
# line 334 "FUnparse.puma"
   Unparse (t->VAR_DECL.VAL->ARRAY_TYPE.ARRAY_COMP_TYPE);
# line 335 "FUnparse.puma"
 if (   ((target_machine == SUPRENUM) || (target_machine == CM5))
              && IsItAllocatable (t->VAR_DECL.VAL)
             )
          {  fprintf (f,", ALLOCATABLE :: ");
             GetString (t->VAR_DECL.Name,string);
             fprintf (f," %s (",string);
             Unparse (t->VAR_DECL.VAL->ARRAY_TYPE.ARRAY_INDEX_TYPES);
             fprintf (f,")\n");
          }
          else
          {  GetString (t->VAR_DECL.Name,string);
             fprintf (f," %s (",string);
             Unparse (t->VAR_DECL.VAL->ARRAY_TYPE.ARRAY_INDEX_TYPES);
             fprintf (f,")\n");
          }

  }
   return;

  }
# line 353 "FUnparse.puma"
  {
# line 354 "FUnparse.puma"
   ind ();
# line 355 "FUnparse.puma"
   Unparse (t->VAR_DECL.VAL);
# line 356 "FUnparse.puma"
   GetString (t->VAR_DECL.Name, string);
# line 357 "FUnparse.puma"
   fprintf (f, " %s \n", string);
  }
   return;

  case kVAR_PARAM_DECL:
# line 360 "FUnparse.puma"
  {
# line 361 "FUnparse.puma"
   ind ();
# line 362 "FUnparse.puma"
   Unparse (t->VAR_PARAM_DECL.VAL);
# line 363 "FUnparse.puma"
   GetString (t->VAR_PARAM_DECL.Name, string);
# line 364 "FUnparse.puma"
   fprintf (f, " %s \n", string);
  }
   return;

  case kENTITY_DECL:
  if (t->ENTITY_DECL.ATTRIBUTES->DECL_LIST.Elem->Kind == kTYPESPEC_DECL) {
# line 367 "FUnparse.puma"
  {
# line 368 "FUnparse.puma"
   ind ();
# line 369 "FUnparse.puma"
   Unparse (t->ENTITY_DECL.ATTRIBUTES->DECL_LIST.Elem->TYPESPEC_DECL.VAL);
# line 370 "FUnparse.puma"
   AttributeUnparse (t->ENTITY_DECL.ATTRIBUTES->DECL_LIST.Next);
# line 371 "FUnparse.puma"
   GetString (t->ENTITY_DECL.Name, string);
# line 372 "FUnparse.puma"
   fprintf (f, " :: %s\n", string);
  }
   return;

  }
# line 375 "FUnparse.puma"
  {
# line 376 "FUnparse.puma"
   fprintf (f, "!HPF$ ");
# line 377 "FUnparse.puma"
   AttributeUnparse (t->ENTITY_DECL.ATTRIBUTES->DECL_LIST.Elem);
# line 378 "FUnparse.puma"
   AttributeUnparse (t->ENTITY_DECL.ATTRIBUTES->DECL_LIST.Next);
# line 379 "FUnparse.puma"
   GetString (t->ENTITY_DECL.Name, string);
# line 380 "FUnparse.puma"
   fprintf (f, " :: %s\n", string);
  }
   return;

  case kTEMPLATE_DECL:
  if (t->TEMPLATE_DECL.DIMENSIONS->Kind == kTYPE_EMPTY) {
# line 389 "FUnparse.puma"
  {
# line 390 "FUnparse.puma"
   GetString (t->TEMPLATE_DECL.Name, string);
# line 391 "FUnparse.puma"
   fprintf (f, "!HPF$ TEMPLATE %s\n", string);
  }
   return;

  }
# line 394 "FUnparse.puma"
  {
# line 395 "FUnparse.puma"
   GetString (t->TEMPLATE_DECL.Name, string);
# line 396 "FUnparse.puma"
   fprintf (f, "!HPF$ TEMPLATE %s (", string);
# line 397 "FUnparse.puma"
   Unparse (t->TEMPLATE_DECL.DIMENSIONS);
# line 398 "FUnparse.puma"
   fprintf (f, ")\n");
  }
   return;

  case kPROCESSORS_DECL:
  if (t->PROCESSORS_DECL.DIMENSIONS->Kind == kTYPE_EMPTY) {
# line 401 "FUnparse.puma"
  {
# line 402 "FUnparse.puma"
   GetString (t->PROCESSORS_DECL.Name, string);
# line 403 "FUnparse.puma"
   fprintf (f, "!HPF$ PROCESSORS %s\n", string);
  }
   return;

  }
# line 406 "FUnparse.puma"
  {
# line 407 "FUnparse.puma"
   GetString (t->PROCESSORS_DECL.Name, string);
# line 408 "FUnparse.puma"
   fprintf (f, "!HPF$ PROCESSORS %s (", string);
# line 409 "FUnparse.puma"
   Unparse (t->PROCESSORS_DECL.DIMENSIONS);
# line 410 "FUnparse.puma"
   fprintf (f, ")\n");
  }
   return;

  case kIMPLICIT_DECL:
  if (t->IMPLICIT_DECL.VAL->Kind == kDUMMY_TYPE) {
# line 413 "FUnparse.puma"
  {
# line 414 "FUnparse.puma"
   ind ();
# line 415 "FUnparse.puma"
   fprintf (f, "IMPLICIT none\n");
  }
   return;

  }
# line 418 "FUnparse.puma"
  {
# line 419 "FUnparse.puma"
   ind ();
# line 420 "FUnparse.puma"
   fprintf (f, "IMPLICIT ");
# line 421 "FUnparse.puma"
   Unparse (t->IMPLICIT_DECL.VAL);
# line 422 "FUnparse.puma"
   GetString (t->IMPLICIT_DECL.first, string);
# line 423 "FUnparse.puma"
   fprintf (f, " (%s-", string);
# line 424 "FUnparse.puma"
   GetString (t->IMPLICIT_DECL.last, string);
# line 425 "FUnparse.puma"
   fprintf (f, "%s)\n", string);
  }
   return;

  case kCOMMON_DECL:
  if (t->COMMON_DECL.IDS->Kind == kDECL_EMPTY) {
# line 428 "FUnparse.puma"
   return;

  }
# line 432 "FUnparse.puma"
  {
# line 433 "FUnparse.puma"
   GetString (t->COMMON_DECL.Name, string);
# line 434 "FUnparse.puma"
   ind ();
# line 435 "FUnparse.puma"
   fprintf (f, "COMMON /%s/", string);
# line 436 "FUnparse.puma"
   ComUnparse (t->COMMON_DECL.IDS);
# line 437 "FUnparse.puma"
   fprintf (f, "\n");
  }
   return;

  case kNAMELIST_DECL:
# line 440 "FUnparse.puma"
  {
# line 441 "FUnparse.puma"
   GetString (t->NAMELIST_DECL.Name, string);
# line 442 "FUnparse.puma"
   ind ();
# line 443 "FUnparse.puma"
   fprintf (f, "NAMELIST /%s/", string);
# line 444 "FUnparse.puma"
   ComUnparse (t->NAMELIST_DECL.IDS);
# line 445 "FUnparse.puma"
   fprintf (f, "\n");
  }
   return;

  case kEQV_DECL:
# line 448 "FUnparse.puma"
  {
# line 449 "FUnparse.puma"
   ind ();
# line 450 "FUnparse.puma"
   fprintf (f, "EQUIVALENCE (");
# line 451 "FUnparse.puma"
   Unparse (t->EQV_DECL.VARS);
# line 452 "FUnparse.puma"
   fprintf (f, ")\n");
  }
   return;

  case kUSE_DECL:
  if (t->USE_DECL.RENAMINGS->Kind == kDECL_EMPTY) {
# line 461 "FUnparse.puma"
  {
# line 462 "FUnparse.puma"
   ind ();
# line 463 "FUnparse.puma"
   GetString (t->USE_DECL.use, string);
# line 464 "FUnparse.puma"
   fprintf (f, "USE %s\n", string);
  }
   return;

  }
# line 467 "FUnparse.puma"
  {
# line 468 "FUnparse.puma"
   ind ();
# line 469 "FUnparse.puma"
   GetString (t->USE_DECL.use, string);
# line 470 "FUnparse.puma"
   fprintf (f, "USE %s , ", string);
# line 471 "FUnparse.puma"
   UseNameUnparse (t->USE_DECL.RENAMINGS);
# line 472 "FUnparse.puma"
   fprintf (f, "\n");
  }
   return;

  case kONLY_USE_DECL:
# line 475 "FUnparse.puma"
  {
# line 476 "FUnparse.puma"
   ind ();
# line 477 "FUnparse.puma"
   GetString (t->ONLY_USE_DECL.use, string);
# line 478 "FUnparse.puma"
   fprintf (f, "USE %s ONLY :: ", string);
# line 479 "FUnparse.puma"
   UseNameUnparse (t->ONLY_USE_DECL.NAMES);
# line 480 "FUnparse.puma"
   fprintf (f, "\n");
  }
   return;

  case kTYPE_DECL:
  if (t->TYPE_DECL.VAL->Kind == kRECORD_TYPE) {
# line 489 "FUnparse.puma"
  {
# line 490 "FUnparse.puma"
   ind ();
# line 491 "FUnparse.puma"
   GetString (t->TYPE_DECL.Name, string);
# line 492 "FUnparse.puma"
   fprintf (f, "TYPE %s\n", string);
# line 493 "FUnparse.puma"
 indent = indent + IndentLength;
# line 494 "FUnparse.puma"
   Unparse (t->TYPE_DECL.VAL->RECORD_TYPE.COMPONENTS);
# line 495 "FUnparse.puma"
 indent = indent - IndentLength;
# line 496 "FUnparse.puma"
   ind ();
# line 497 "FUnparse.puma"
   fprintf (f, "END TYPE\n");
  }
   return;

  }
  break;
  case kINTERFACE_DECL:
# line 506 "FUnparse.puma"
  {
# line 507 "FUnparse.puma"
   ind ();
# line 508 "FUnparse.puma"
   fprintf (f, "INTERFACE");
# line 509 "FUnparse.puma"
   GenSpecUnparse (t->INTERFACE_DECL.SPEC);
# line 510 "FUnparse.puma"
   fprintf (f, "\n");
# line 511 "FUnparse.puma"
   Unparse (t->INTERFACE_DECL.ITEMS);
# line 512 "FUnparse.puma"
   ind ();
# line 513 "FUnparse.puma"
   fprintf (f, "END INTERFACE\n\n");
  }
   return;

  case kDIMENSION_DECL:
# line 522 "FUnparse.puma"
  {
# line 523 "FUnparse.puma"
   ind ();
# line 524 "FUnparse.puma"
   GetString (t->DIMENSION_DECL.Name, string);
# line 525 "FUnparse.puma"
   fprintf (f, "DIMENSION %s (", string);
# line 526 "FUnparse.puma"
   Unparse (t->DIMENSION_DECL.INDEXES);
# line 527 "FUnparse.puma"
   fprintf (f, ")\n");
  }
   return;

  case kPARAMETER_DECL:
# line 530 "FUnparse.puma"
  {
# line 531 "FUnparse.puma"
   ind ();
# line 532 "FUnparse.puma"
   GetString (t->PARAMETER_DECL.Name, string);
# line 533 "FUnparse.puma"
   fprintf (f, "PARAMETER ( %s = ", string);
# line 534 "FUnparse.puma"
   Unparse (t->PARAMETER_DECL.VAL);
# line 535 "FUnparse.puma"
   fprintf (f, " )\n");
  }
   return;

  case kSAVE_DECL:
# line 538 "FUnparse.puma"
  {
# line 539 "FUnparse.puma"
   ind ();
# line 540 "FUnparse.puma"
   GetString (t->SAVE_DECL.Name, string);
# line 541 "FUnparse.puma"
   fprintf (f, "SAVE %s\n", string);
  }
   return;

  case kINTENT_DECL:
  if (equalint (t->INTENT_DECL.intent, 0)) {
# line 544 "FUnparse.puma"
  {
# line 545 "FUnparse.puma"
   ind ();
# line 546 "FUnparse.puma"
   GetString (t->INTENT_DECL.Name, string);
# line 547 "FUnparse.puma"
   fprintf (f, "INTENT(IN) %s\n", string);
  }
   return;

  }
  if (equalint (t->INTENT_DECL.intent, 1)) {
# line 550 "FUnparse.puma"
  {
# line 551 "FUnparse.puma"
   ind ();
# line 552 "FUnparse.puma"
   GetString (t->INTENT_DECL.Name, string);
# line 553 "FUnparse.puma"
   fprintf (f, "INTENT(OUT) %s\n", string);
  }
   return;

  }
  if (equalint (t->INTENT_DECL.intent, 2)) {
# line 556 "FUnparse.puma"
  {
# line 557 "FUnparse.puma"
   ind ();
# line 558 "FUnparse.puma"
   GetString (t->INTENT_DECL.Name, string);
# line 559 "FUnparse.puma"
   fprintf (f, "INTENT(INOUT) %s\n", string);
  }
   return;

  }
  break;
  case kOPTIONAL_DECL:
# line 562 "FUnparse.puma"
  {
# line 563 "FUnparse.puma"
   ind ();
# line 564 "FUnparse.puma"
   GetString (t->OPTIONAL_DECL.Name, string);
# line 565 "FUnparse.puma"
   fprintf (f, "OPTIONAL %s\n", string);
  }
   return;

  case kTARGET_DECL:
# line 568 "FUnparse.puma"
  {
# line 569 "FUnparse.puma"
   ind ();
# line 570 "FUnparse.puma"
   GetString (t->TARGET_DECL.Name, string);
# line 571 "FUnparse.puma"
   fprintf (f, "TARGET %s\n", string);
  }
   return;

  case kPOINTER_DECL:
# line 574 "FUnparse.puma"
  {
# line 575 "FUnparse.puma"
   ind ();
# line 576 "FUnparse.puma"
   GetString (t->POINTER_DECL.Name, string);
# line 577 "FUnparse.puma"
   fprintf (f, "POINTER %s\n", string);
  }
   return;

  case kPUBLIC_DECL:
# line 580 "FUnparse.puma"
  {
# line 581 "FUnparse.puma"
   ind ();
# line 582 "FUnparse.puma"
   GetString (t->PUBLIC_DECL.Name, string);
# line 583 "FUnparse.puma"
   fprintf (f, "PUBLIC %s\n", string);
  }
   return;

  case kPRIVATE_DECL:
# line 586 "FUnparse.puma"
  {
# line 587 "FUnparse.puma"
   ind ();
# line 588 "FUnparse.puma"
   GetString (t->PRIVATE_DECL.Name, string);
# line 589 "FUnparse.puma"
   fprintf (f, "PRIVATE %s\n", string);
  }
   return;

  case kALIGN_DECL:
  if (t->ALIGN_DECL.ALIGN_SOURCE->Kind == kBTE_EMPTY) {
# line 592 "FUnparse.puma"
  {
# line 593 "FUnparse.puma"
   GetString (t->ALIGN_DECL.Name, string);
# line 594 "FUnparse.puma"
   fprintf (f, "!HPF$ ALIGN %s WITH ", string);
# line 595 "FUnparse.puma"
   AlignSpecUnparse (t->ALIGN_DECL.ALIGN_SPEC);
# line 596 "FUnparse.puma"
   fprintf (f, "\n");
  }
   return;

  }
# line 599 "FUnparse.puma"
  {
# line 600 "FUnparse.puma"
   GetString (t->ALIGN_DECL.Name, string);
# line 601 "FUnparse.puma"
   fprintf (f, "!HPF$ ALIGN %s (", string);
# line 602 "FUnparse.puma"
   Unparse (t->ALIGN_DECL.ALIGN_SOURCE);
# line 603 "FUnparse.puma"
   fprintf (f, ") WITH ");
# line 604 "FUnparse.puma"
   AlignSpecUnparse (t->ALIGN_DECL.ALIGN_SPEC);
# line 605 "FUnparse.puma"
   fprintf (f, "\n");
  }
   return;

  case kDYNAMIC_DECL:
# line 608 "FUnparse.puma"
  {
# line 609 "FUnparse.puma"
   GetString (t->DYNAMIC_DECL.Name, string);
# line 610 "FUnparse.puma"
   fprintf (f, "!HPF$ DYNAMIC %s\n", string);
  }
   return;

  case kDISTRIBUTE_DECL:
# line 613 "FUnparse.puma"
  {
# line 614 "FUnparse.puma"
   GetString (t->DISTRIBUTE_DECL.Name, string);
# line 615 "FUnparse.puma"
   fprintf (f, "!HPF$ DISTRIBUTE %s ", string);
# line 616 "FUnparse.puma"
   LayoutUnparse (t->DISTRIBUTE_DECL.DISTRIBUTION);
# line 617 "FUnparse.puma"
 if (t->DISTRIBUTE_DECL.target != NoId())
            { GetString (t->DISTRIBUTE_DECL.target, string);
              fprintf (f," ONTO %s", string);
            }

# line 622 "FUnparse.puma"
   fprintf (f, "\n");
  }
   return;

  case kSEQUENCE_DECL:
# line 625 "FUnparse.puma"
  {
# line 626 "FUnparse.puma"
   hpf_ind ();
# line 627 "FUnparse.puma"
   GetString (t->SEQUENCE_DECL.Name, string);
# line 628 "FUnparse.puma"
   fprintf (f, "SEQUENCE %s\n", string);
  }
   return;

  case kNOSEQUENCE_DECL:
# line 631 "FUnparse.puma"
  {
# line 632 "FUnparse.puma"
   hpf_ind ();
# line 633 "FUnparse.puma"
   GetString (t->NOSEQUENCE_DECL.Name, string);
# line 634 "FUnparse.puma"
   fprintf (f, "NO SEQUENCE %s\n", string);
  }
   return;

  case kDATA_DECL:
# line 637 "FUnparse.puma"
  {
# line 638 "FUnparse.puma"
   ind ();
# line 639 "FUnparse.puma"
   fprintf (f, "DATA ");
# line 640 "FUnparse.puma"
   Unparse (t->DATA_DECL.VARS);
# line 641 "FUnparse.puma"
   fprintf (f, " / ");
# line 642 "FUnparse.puma"
   Unparse (t->DATA_DECL.VALS);
# line 643 "FUnparse.puma"
   fprintf (f, " / \n");
  }
   return;

  case kBLOCK_DATA_DECL:
# line 646 "FUnparse.puma"
  {
# line 647 "FUnparse.puma"
   ind ();
# line 648 "FUnparse.puma"
   GetString (t->BLOCK_DATA_DECL.Name, string);
# line 649 "FUnparse.puma"
   fprintf (f, "BLOCK DATA %s\n", string);
# line 650 "FUnparse.puma"
   Unparse (t->BLOCK_DATA_DECL.DATA_BODY);
# line 651 "FUnparse.puma"
   fprintf (f, "\n");
  }
   return;

  case kBODY_NODE:
  if (t->BODY_NODE.INTERNALS->Kind == kDECL_EMPTY) {
# line 660 "FUnparse.puma"
  {
# line 661 "FUnparse.puma"
   Unparse (t->BODY_NODE.DECLS);
# line 662 "FUnparse.puma"
   Unparse (t->BODY_NODE.STATS);
# line 663 "FUnparse.puma"
   ind ();
# line 664 "FUnparse.puma"
   fprintf (f, "END\n");
  }
   return;

  }
# line 667 "FUnparse.puma"
  {
# line 668 "FUnparse.puma"
   Unparse (t->BODY_NODE.DECLS);
# line 669 "FUnparse.puma"
   Unparse (t->BODY_NODE.STATS);
# line 670 "FUnparse.puma"
   ind ();
# line 671 "FUnparse.puma"
   fprintf (f, "CONTAINS\n");
# line 672 "FUnparse.puma"
   Unparse (t->BODY_NODE.INTERNALS);
# line 673 "FUnparse.puma"
   ind ();
# line 674 "FUnparse.puma"
   fprintf (f, "END\n");
  }
   return;

  case kACF_LIST:
# line 677 "FUnparse.puma"
  {
# line 678 "FUnparse.puma"
   Unparse (t->ACF_LIST.Elem);
# line 679 "FUnparse.puma"
 if (t->ACF_LIST.Next != NoTree)
             Unparse (t->ACF_LIST.Next);

  }
   return;

  case kACF_EMPTY:
# line 684 "FUnparse.puma"
   return;

  case kACF_BASIC:
# line 687 "FUnparse.puma"
  {
# line 688 "FUnparse.puma"
   label_ind (t->ACF_BASIC.Label);
# line 689 "FUnparse.puma"
   Unparse (t->ACF_BASIC.BASIC_STMT);
# line 690 "FUnparse.puma"
   LCR (t->ACF_BASIC.Line);
  }
   return;

  case kACF_DUMMY:
# line 693 "FUnparse.puma"
  {
# line 694 "FUnparse.puma"
   label_ind (t->ACF_DUMMY.Label);
# line 695 "FUnparse.puma"
   fprintf (f, "CONTINUE");
# line 696 "FUnparse.puma"
   LCR (t->ACF_DUMMY.Line);
  }
   return;

  case kACF_WHILE:
# line 699 "FUnparse.puma"
  {
# line 700 "FUnparse.puma"
   label_ind (t->ACF_WHILE.Label);
# line 701 "FUnparse.puma"
   fprintf (f, "DO WHILE (");
# line 702 "FUnparse.puma"
   Unparse (t->ACF_WHILE.WHILE_EXP);
# line 703 "FUnparse.puma"
   fprintf (f, ")");
# line 704 "FUnparse.puma"
   LCR (t->ACF_WHILE.Line);
# line 705 "FUnparse.puma"
 indent = indent + 2;
# line 706 "FUnparse.puma"
   Unparse (t->ACF_WHILE.WHILE_BODY);
# line 707 "FUnparse.puma"
 indent = indent - 2;
# line 708 "FUnparse.puma"
   ind ();
# line 709 "FUnparse.puma"
   fprintf (f, "END DO\n");
  }
   return;

  case kACF_DO:
# line 712 "FUnparse.puma"
  {
# line 713 "FUnparse.puma"
   label_ind (t->ACF_DO.Label);
# line 714 "FUnparse.puma"
   fprintf (f, "DO ");
# line 715 "FUnparse.puma"
   Unparse (t->ACF_DO.DO_ID);
# line 716 "FUnparse.puma"
   fprintf (f, "=");
# line 717 "FUnparse.puma"
   UnparseDoRange (t->ACF_DO.DO_RANGE);
# line 718 "FUnparse.puma"
   LCR (t->ACF_DO.Line);
# line 719 "FUnparse.puma"
 indent = indent + IndentLength;
# line 720 "FUnparse.puma"
   Unparse (t->ACF_DO.DO_BODY);
# line 721 "FUnparse.puma"
 indent = indent - IndentLength;
# line 722 "FUnparse.puma"
   ind ();
# line 723 "FUnparse.puma"
   fprintf (f, "END DO\n");
  }
   return;

  case kACF_DOLOCAL:
# line 726 "FUnparse.puma"
  {
# line 727 "FUnparse.puma"
   fprintf (f, "!HPF$ INDEPENDENT, LOCAL_ACCESS\n");
# line 728 "FUnparse.puma"
   label_ind (t->ACF_DOLOCAL.Label);
# line 729 "FUnparse.puma"
   fprintf (f, "DO ");
# line 730 "FUnparse.puma"
   Unparse (t->ACF_DOLOCAL.DOLOCAL_ID);
# line 731 "FUnparse.puma"
   fprintf (f, "=");
# line 732 "FUnparse.puma"
   UnparseDoRange (t->ACF_DOLOCAL.DOLOCAL_RANGE);
# line 733 "FUnparse.puma"
   LCR (t->ACF_DOLOCAL.Line);
# line 734 "FUnparse.puma"
 indent = indent + IndentLength;
# line 735 "FUnparse.puma"
   Unparse (t->ACF_DOLOCAL.DOLOCAL_BODY);
# line 736 "FUnparse.puma"
 indent = indent - IndentLength;
# line 737 "FUnparse.puma"
   ind ();
# line 738 "FUnparse.puma"
   fprintf (f, "END DO\n");
  }
   return;

  case kACF_DOALL:
# line 741 "FUnparse.puma"
  {
# line 742 "FUnparse.puma"
   fprintf (f, "!HPF$ INDEPENDENT NEW(");
# line 743 "FUnparse.puma"
   Unparse (t->ACF_DOALL.DOALL_NEW);
# line 744 "FUnparse.puma"
   fprintf (f, ")\n");
# line 745 "FUnparse.puma"
   label_ind (t->ACF_DOALL.Label);
# line 746 "FUnparse.puma"
   fprintf (f, "DO ");
# line 747 "FUnparse.puma"
   Unparse (t->ACF_DOALL.DOALL_ID);
# line 748 "FUnparse.puma"
   fprintf (f, "=");
# line 749 "FUnparse.puma"
   UnparseDoRange (t->ACF_DOALL.DOALL_RANGE);
# line 750 "FUnparse.puma"
   LCR (t->ACF_DOALL.Line);
# line 751 "FUnparse.puma"
 indent = indent + IndentLength;
# line 752 "FUnparse.puma"
   Unparse (t->ACF_DOALL.DOALL_BODY);
# line 753 "FUnparse.puma"
 indent = indent - IndentLength;
# line 754 "FUnparse.puma"
   ind ();
# line 755 "FUnparse.puma"
   fprintf (f, "END DO\n");
  }
   return;

  case kACF_DOVEC:
# line 758 "FUnparse.puma"
  {
# line 759 "FUnparse.puma"
   fprintf (f, "cdir$ ivdep\n");
# line 760 "FUnparse.puma"
   label_ind (t->ACF_DOVEC.Label);
# line 761 "FUnparse.puma"
   fprintf (f, "DO ");
# line 762 "FUnparse.puma"
   Unparse (t->ACF_DOVEC.DOVEC_ID);
# line 763 "FUnparse.puma"
   fprintf (f, "=");
# line 764 "FUnparse.puma"
   UnparseDoRange (t->ACF_DOVEC.DOVEC_RANGE);
# line 765 "FUnparse.puma"
   LCR (t->ACF_DOVEC.Line);
# line 766 "FUnparse.puma"
 indent = indent + IndentLength;
# line 767 "FUnparse.puma"
   Unparse (t->ACF_DOVEC.DOVEC_BODY);
# line 768 "FUnparse.puma"
 indent = indent - IndentLength;
# line 769 "FUnparse.puma"
   ind ();
# line 770 "FUnparse.puma"
   fprintf (f, "END DO\n");
  }
   return;

  case kACF_FORALL:
# line 773 "FUnparse.puma"
  {
# line 774 "FUnparse.puma"
   label_ind (t->ACF_FORALL.Label);
# line 775 "FUnparse.puma"
   fprintf (f, "FORALL (");
# line 776 "FUnparse.puma"
   Unparse (t->ACF_FORALL.FORALL_ID);
# line 777 "FUnparse.puma"
   fprintf (f, "=");
# line 778 "FUnparse.puma"
   Unparse (t->ACF_FORALL.FORALL_RANGE);
# line 779 "FUnparse.puma"
   fprintf (f, ")");
# line 780 "FUnparse.puma"
   LCR (t->ACF_FORALL.Line);
# line 781 "FUnparse.puma"
 indent = indent + IndentLength;
# line 782 "FUnparse.puma"
   Unparse (t->ACF_FORALL.FORALL_BODY);
# line 783 "FUnparse.puma"
 indent = indent - IndentLength;
# line 784 "FUnparse.puma"
   ind ();
# line 785 "FUnparse.puma"
   fprintf (f, "END FORALL\n");
  }
   return;

  case kACF_LOOP:
# line 788 "FUnparse.puma"
  {
# line 789 "FUnparse.puma"
   label_ind (t->ACF_LOOP.Label);
# line 790 "FUnparse.puma"
   fprintf (f, "DO WHILE (.true.)");
# line 791 "FUnparse.puma"
   LCR (t->ACF_LOOP.Line);
# line 792 "FUnparse.puma"
 indent = indent + IndentLength;
# line 793 "FUnparse.puma"
   Unparse (t->ACF_LOOP.LOOP_BODY);
# line 794 "FUnparse.puma"
 indent = indent - IndentLength;
# line 795 "FUnparse.puma"
   ind ();
# line 796 "FUnparse.puma"
   fprintf (f, "END DO\n");
  }
   return;

  case kACF_IF:
# line 799 "FUnparse.puma"
  {
# line 800 "FUnparse.puma"
   label_ind (t->ACF_IF.Label);
# line 801 "FUnparse.puma"
   fprintf (f, "IF (");
# line 802 "FUnparse.puma"
   Unparse (t->ACF_IF.IF_EXP);
# line 803 "FUnparse.puma"
   fprintf (f, ") THEN");
# line 804 "FUnparse.puma"
   LCR (t->ACF_IF.Line);
# line 805 "FUnparse.puma"
 indent = indent + IndentLength;
# line 806 "FUnparse.puma"
   Unparse (t->ACF_IF.THEN_PART);
# line 807 "FUnparse.puma"
 indent = indent - IndentLength;
# line 808 "FUnparse.puma"
   UnparseElse (t->ACF_IF.ELSE_PART);
# line 809 "FUnparse.puma"
   ind ();
# line 810 "FUnparse.puma"
   fprintf (f, "END IF\n");
  }
   return;

  case kACF_WHERE:
  if (t->ACF_WHERE.FALSE_PART->Kind == kACF_EMPTY) {
# line 813 "FUnparse.puma"
  {
# line 814 "FUnparse.puma"
   label_ind (t->ACF_WHERE.Label);
# line 815 "FUnparse.puma"
   fprintf (f, "WHERE (");
# line 816 "FUnparse.puma"
   Unparse (t->ACF_WHERE.WHERE_EXP);
# line 817 "FUnparse.puma"
   fprintf (f, ")");
# line 818 "FUnparse.puma"
   LCR (t->ACF_WHERE.Line);
# line 819 "FUnparse.puma"
 indent = indent + IndentLength;
# line 820 "FUnparse.puma"
   Unparse (t->ACF_WHERE.TRUE_PART);
# line 821 "FUnparse.puma"
 indent = indent - IndentLength;
# line 822 "FUnparse.puma"
   ind ();
# line 823 "FUnparse.puma"
   fprintf (f, "END WHERE\n");
  }
   return;

  }
# line 826 "FUnparse.puma"
  {
# line 827 "FUnparse.puma"
   label_ind (t->ACF_WHERE.Label);
# line 828 "FUnparse.puma"
   fprintf (f, "WHERE (");
# line 829 "FUnparse.puma"
   Unparse (t->ACF_WHERE.WHERE_EXP);
# line 830 "FUnparse.puma"
   fprintf (f, ")");
# line 831 "FUnparse.puma"
   LCR (t->ACF_WHERE.Line);
# line 832 "FUnparse.puma"
 indent = indent + IndentLength;
# line 833 "FUnparse.puma"
   Unparse (t->ACF_WHERE.TRUE_PART);
# line 834 "FUnparse.puma"
 indent = indent - IndentLength;
# line 835 "FUnparse.puma"
   ind ();
# line 836 "FUnparse.puma"
   fprintf (f, " ELSEWHERE\n");
# line 837 "FUnparse.puma"
 indent = indent + IndentLength;
# line 838 "FUnparse.puma"
   Unparse (t->ACF_WHERE.FALSE_PART);
# line 839 "FUnparse.puma"
 indent = indent - IndentLength;
# line 840 "FUnparse.puma"
   ind ();
# line 841 "FUnparse.puma"
   fprintf (f, "END WHERE\n");
  }
   return;

  case kACF_CASE:
# line 844 "FUnparse.puma"
  {
# line 845 "FUnparse.puma"
   label_ind (t->ACF_CASE.Label);
# line 846 "FUnparse.puma"
   fprintf (f, "SELECT CASE (");
# line 847 "FUnparse.puma"
   Unparse (t->ACF_CASE.CASE_EXP);
# line 848 "FUnparse.puma"
   fprintf (f, ")");
# line 849 "FUnparse.puma"
   LCR (t->ACF_CASE.Line);
# line 850 "FUnparse.puma"
 indent = indent + 2;
# line 851 "FUnparse.puma"
   Unparse (t->ACF_CASE.CASE_ALTS);
# line 852 "FUnparse.puma"
   ind ();
# line 853 "FUnparse.puma"
   fprintf (f, "DEFAULT \n");
# line 854 "FUnparse.puma"
 indent = indent + 2;
# line 855 "FUnparse.puma"
   Unparse (t->ACF_CASE.CASE_OTHERWISE);
# line 856 "FUnparse.puma"
 indent = indent - 4;
# line 857 "FUnparse.puma"
   ind ();
# line 858 "FUnparse.puma"
   fprintf (f, "END SELECT\n");
  }
   return;

  case kACF_ON:
# line 861 "FUnparse.puma"
  {
# line 862 "FUnparse.puma"
   label_ind (0);
# line 863 "FUnparse.puma"
   fprintf (f, "! following stmt ON ");
# line 864 "FUnparse.puma"
   Unparse (t->ACF_ON.ON_VAR);
# line 865 "FUnparse.puma"
   fprintf (f, "\n");
# line 866 "FUnparse.puma"
 indent = indent + IndentLength;
# line 867 "FUnparse.puma"
   Unparse (t->ACF_ON.ON_STMT);
# line 868 "FUnparse.puma"
 indent = indent - IndentLength;
  }
   return;

  case kSELECTED_ACF_LIST:
# line 871 "FUnparse.puma"
  {
# line 872 "FUnparse.puma"
   Unparse (t->SELECTED_ACF_LIST.Elem);
# line 873 "FUnparse.puma"
   Unparse (t->SELECTED_ACF_LIST.Next);
  }
   return;

  case kSELECTED_ACF_EMPTY:
# line 876 "FUnparse.puma"
   return;

  case kSELECTED_ACF_NODE:
  if (t->SELECTED_ACF_NODE.SELECT_LIST->Kind == kBTE_LIST) {
  if (t->SELECTED_ACF_NODE.SELECT_LIST->BTE_LIST.Elem->Kind == kSLICE_EXP) {
# line 879 "FUnparse.puma"
  {
# line 880 "FUnparse.puma"
   ind ();
# line 881 "FUnparse.puma"
   fprintf (f, "CASE (");
# line 882 "FUnparse.puma"
 if (t->SELECTED_ACF_NODE.SELECT_LIST->BTE_LIST.Elem->SLICE_EXP.START->Kind != kDUMMY_EXP)
             Unparse (t->SELECTED_ACF_NODE.SELECT_LIST->BTE_LIST.Elem->SLICE_EXP.START);
# line 884 "FUnparse.puma"
   fprintf (f, ":");
# line 885 "FUnparse.puma"
 if (t->SELECTED_ACF_NODE.SELECT_LIST->BTE_LIST.Elem->SLICE_EXP.STOP->Kind != kDUMMY_EXP)
             Unparse (t->SELECTED_ACF_NODE.SELECT_LIST->BTE_LIST.Elem->SLICE_EXP.STOP);
# line 887 "FUnparse.puma"
   fprintf (f, ")\n");
# line 888 "FUnparse.puma"
 indent += 2;
# line 889 "FUnparse.puma"
   Unparse (t->SELECTED_ACF_NODE.SELECT_ACFS);
# line 890 "FUnparse.puma"
 indent -= 2;
  }
   return;

  }
# line 893 "FUnparse.puma"
  {
# line 894 "FUnparse.puma"
   ind ();
# line 895 "FUnparse.puma"
   fprintf (f, "CASE (");
# line 896 "FUnparse.puma"
   Unparse (t->SELECTED_ACF_NODE.SELECT_LIST->BTE_LIST.Elem);
# line 897 "FUnparse.puma"
   fprintf (f, ")\n");
# line 898 "FUnparse.puma"
 indent += 2;
# line 899 "FUnparse.puma"
   Unparse (t->SELECTED_ACF_NODE.SELECT_ACFS);
# line 900 "FUnparse.puma"
 indent -= 2;
  }
   return;

  }
  break;
  case kACF_ENTRY:
  if (t->ACF_ENTRY.ENTRY_DECL->Kind == kFUNC_DECL) {
# line 903 "FUnparse.puma"
  {
# line 905 "FUnparse.puma"
   ind ();
# line 906 "FUnparse.puma"
   GetString (t->ACF_ENTRY.ENTRY_DECL->FUNC_DECL.Name, string);
# line 907 "FUnparse.puma"
   fprintf (f, "ENTRY %s (", string);
# line 908 "FUnparse.puma"
   Unparse (t->ACF_ENTRY.ENTRY_DECL->FUNC_DECL.FORMALS);
# line 909 "FUnparse.puma"
   fprintf (f, ")");
# line 910 "FUnparse.puma"
   LCR (t->ACF_ENTRY.Line);
  }
   return;

  }
  if (t->ACF_ENTRY.ENTRY_DECL->Kind == kPROC_DECL) {
# line 913 "FUnparse.puma"
  {
# line 914 "FUnparse.puma"
   ind ();
# line 915 "FUnparse.puma"
   GetString (t->ACF_ENTRY.ENTRY_DECL->PROC_DECL.Name, string);
# line 916 "FUnparse.puma"
   fprintf (f, "ENTRY %s (", string);
# line 917 "FUnparse.puma"
   Unparse (t->ACF_ENTRY.ENTRY_DECL->PROC_DECL.FORMALS);
# line 918 "FUnparse.puma"
   fprintf (f, ")");
# line 919 "FUnparse.puma"
   LCR (t->ACF_ENTRY.Line);
  }
   return;

  }
  break;
  }


  switch (t->Kind) {
  case kACF_NODE:
  case kACF_WHERE:
  case kACF_SWITCH:
  case kACF_ALTER:
  case kACF_REPEAT:
  case kACF_WITH:
  case kACF_BODY:
  case kACF_FLOW_GRAPH:
  case kACF_ENTRY:
# line 925 "FUnparse.puma"
  {
# line 926 "FUnparse.puma"
   label_ind (t->ACF_NODE.Label);
# line 927 "FUnparse.puma"
   fprintf (f, "Statement");
# line 928 "FUnparse.puma"
   LCR (t->ACF_NODE.Line);
  }
   return;

  case kASSIGN_STMT:
# line 939 "FUnparse.puma"
  {
# line 940 "FUnparse.puma"
   Unparse (t->ASSIGN_STMT.ASSIGN_VAR);
# line 941 "FUnparse.puma"
   fprintf (f, " = ");
# line 942 "FUnparse.puma"
   Unparse (t->ASSIGN_STMT.ASSIGN_EXP);
  }
   return;

  case kPTR_ASSIGN_STMT:
# line 945 "FUnparse.puma"
  {
# line 946 "FUnparse.puma"
   Unparse (t->PTR_ASSIGN_STMT.ASSIGN_VAR);
# line 947 "FUnparse.puma"
   fprintf (f, " => ");
# line 948 "FUnparse.puma"
   Unparse (t->PTR_ASSIGN_STMT.ASSIGN_EXP);
  }
   return;

  case kLABEL_ASSIGN_STMT:
# line 951 "FUnparse.puma"
  {
# line 952 "FUnparse.puma"
   fprintf (f, "ASSIGN %d TO ", t->LABEL_ASSIGN_STMT.assign_label);
# line 953 "FUnparse.puma"
   Unparse (t->LABEL_ASSIGN_STMT.LABEL_VAR);
  }
   return;

  case kFORMAT_STMT:
# line 956 "FUnparse.puma"
  {
# line 957 "FUnparse.puma"
   fprintf (f, "FORMAT ");
# line 958 "FUnparse.puma"
   FormatUnparse (t->FORMAT_STMT.FORMAT_PARAMS);
  }
   return;

  case kSTOP_STMT:
  if (t->STOP_STMT.STOP_CONST->Kind == kDUMMY_EXP) {
# line 961 "FUnparse.puma"
  {
# line 962 "FUnparse.puma"
   fprintf (f, "STOP");
  }
   return;

  }
# line 965 "FUnparse.puma"
  {
# line 966 "FUnparse.puma"
   fprintf (f, "STOP ");
# line 967 "FUnparse.puma"
   Unparse (t->STOP_STMT.STOP_CONST);
  }
   return;

  case kEXIT_STMT:
# line 970 "FUnparse.puma"
  {
# line 971 "FUnparse.puma"
 if (t->EXIT_STMT.loopid == NoId ())
             fprintf (f,"EXIT");
           else
             { GetString (t->EXIT_STMT.loopid, string);
               fprintf (f,"EXIT %s", string);
             }

  }
   return;

  case kCYCLE_STMT:
# line 980 "FUnparse.puma"
  {
# line 981 "FUnparse.puma"
 if (t->CYCLE_STMT.loopid == NoId ())
             fprintf (f,"CYCLE");
           else
             { GetString (t->CYCLE_STMT.loopid, string);
               fprintf (f,"CYCLE %s", string);
             }

  }
   return;

  case kRETURN_STMT:
  if (t->RETURN_STMT.RETURN_EXP->Kind == kDUMMY_EXP) {
# line 990 "FUnparse.puma"
  {
# line 991 "FUnparse.puma"
   fprintf (f, "RETURN");
  }
   return;

  }
# line 994 "FUnparse.puma"
  {
# line 995 "FUnparse.puma"
   fprintf (f, "RETURN ");
# line 996 "FUnparse.puma"
   Unparse (t->RETURN_STMT.RETURN_EXP);
  }
   return;

  case kASS_GOTO_STMT:
  if (t->ASS_GOTO_STMT.LABELS->Kind == kLABEL_EMPTY) {
# line 999 "FUnparse.puma"
  {
# line 1000 "FUnparse.puma"
   fprintf (f, "GOTO ");
# line 1001 "FUnparse.puma"
   Unparse (t->ASS_GOTO_STMT.GOTO_VAR);
  }
   return;

  }
# line 1004 "FUnparse.puma"
  {
# line 1005 "FUnparse.puma"
   fprintf (f, "GOTO ");
# line 1006 "FUnparse.puma"
   Unparse (t->ASS_GOTO_STMT.GOTO_VAR);
# line 1007 "FUnparse.puma"
   fprintf (f, " (");
# line 1008 "FUnparse.puma"
   Unparse (t->ASS_GOTO_STMT.LABELS);
# line 1009 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  case kGOTO_STMT:
# line 1012 "FUnparse.puma"
  {
# line 1013 "FUnparse.puma"
   fprintf (f, "GOTO %d", t->GOTO_STMT.GOTO_LABEL);
  }
   return;

  case kCOMP_GOTO_STMT:
# line 1016 "FUnparse.puma"
  {
# line 1017 "FUnparse.puma"
   fprintf (f, "GOTO (");
# line 1018 "FUnparse.puma"
   Unparse (t->COMP_GOTO_STMT.GOTO_LABELS);
# line 1019 "FUnparse.puma"
   fprintf (f, ") ");
# line 1020 "FUnparse.puma"
   Unparse (t->COMP_GOTO_STMT.GOTO_EXP);
  }
   return;

  case kLABEL_LIST:
  if (t->LABEL_LIST.Next->Kind == kLABEL_EMPTY) {
# line 1023 "FUnparse.puma"
  {
# line 1024 "FUnparse.puma"
   fprintf (f, "%d", t->LABEL_LIST.Elem);
  }
   return;

  }
# line 1027 "FUnparse.puma"
  {
# line 1028 "FUnparse.puma"
   fprintf (f, "%d, ", t->LABEL_LIST.Elem);
# line 1029 "FUnparse.puma"
   Unparse (t->LABEL_LIST.Next);
  }
   return;

  case kCOMP_IF_STMT:
# line 1032 "FUnparse.puma"
  {
# line 1033 "FUnparse.puma"
   fprintf (f, "IF (");
# line 1034 "FUnparse.puma"
   Unparse (t->COMP_IF_STMT.IF_EXP);
# line 1035 "FUnparse.puma"
   fprintf (f, ") ");
# line 1036 "FUnparse.puma"
   fprintf (f, "%d , %d , %d", t->COMP_IF_STMT.IF_LT_LABEL, t->COMP_IF_STMT.IF_EQ_LABEL, t->COMP_IF_STMT.IF_GT_LABEL);
  }
   return;

  case kREDUCE_STMT:
# line 1039 "FUnparse.puma"
  {
# line 1040 "FUnparse.puma"
   GetString (t->REDUCE_STMT.RED_FUNC->PROC_OBJ.Ident, string);
# line 1041 "FUnparse.puma"
   fprintf (f, "REDUCE (%s,", string);
# line 1042 "FUnparse.puma"
   ParamUnparse (t->REDUCE_STMT.RED_PARAMS);
# line 1043 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  case kCALL_STMT:
# line 1046 "FUnparse.puma"
  {
# line 1047 "FUnparse.puma"
   GetString (t->CALL_STMT.CALL_ID->PROC_OBJ.Ident, string);
# line 1048 "FUnparse.puma"
   fprintf (f, "call %s (", string);
# line 1049 "FUnparse.puma"
   ParamUnparse (t->CALL_STMT.CALL_PARAMS);
# line 1050 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  case kALLOCATE_STMT:
# line 1053 "FUnparse.puma"
  {
# line 1054 "FUnparse.puma"
   fprintf (f, "ALLOCATE (");
# line 1055 "FUnparse.puma"
   Unparse (t->ALLOCATE_STMT.PARAMS);
# line 1056 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  case kDEALLOCATE_STMT:
# line 1059 "FUnparse.puma"
  {
# line 1060 "FUnparse.puma"
   fprintf (f, "DEALLOCATE (");
# line 1061 "FUnparse.puma"
   Unparse (t->DEALLOCATE_STMT.PARAMS);
# line 1062 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  case kNULLIFY_STMT:
# line 1065 "FUnparse.puma"
  {
# line 1066 "FUnparse.puma"
   fprintf (f, "NULLIFY (");
# line 1067 "FUnparse.puma"
   Unparse (t->NULLIFY_STMT.PARAMS);
# line 1068 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  case kALIGN_STMT:
# line 1071 "FUnparse.puma"
  {
# line 1072 "FUnparse.puma"
   fprintf (f, "REALIGN ");
# line 1073 "FUnparse.puma"
   Unparse (t->ALIGN_STMT.ALIGNEE);
# line 1074 "FUnparse.puma"
   fprintf (f, " WITH ");
# line 1075 "FUnparse.puma"
   AlignSpecUnparse (t->ALIGN_STMT.ALIGN_SPEC);
  }
   return;

  case kDISTRIBUTE_STMT:
# line 1078 "FUnparse.puma"
  {
# line 1079 "FUnparse.puma"
   fprintf (f, "REDISTRIBUTE ");
# line 1080 "FUnparse.puma"
   Unparse (t->DISTRIBUTE_STMT.DISTRIBUTEE);
# line 1081 "FUnparse.puma"
   LayoutUnparse (t->DISTRIBUTE_STMT.DISTRIBUTION);
# line 1082 "FUnparse.puma"
 if (t->DISTRIBUTE_STMT.target != NoId())
            { GetString (t->DISTRIBUTE_STMT.target, string);
              fprintf (f," ONTO %s", string);
            }

  }
   return;

  case kIO_STMT:
  if (equaltIdent (t->IO_STMT.ID->PROC_OBJ.Ident, MakeIdent ("PRINT", 5))) {
  if (t->IO_STMT.IO_ITEMS->Kind == kBTP_EMPTY) {
# line 1095 "FUnparse.puma"
  {
# line 1097 "FUnparse.puma"
 fprintf (f,"PRINT ");
          Unparse (t->IO_STMT.IO_SPECS);

  }
   return;

  }
  }
  if (equaltIdent (t->IO_STMT.ID->PROC_OBJ.Ident, MakeIdent ("PRINT", 5))) {
# line 1102 "FUnparse.puma"
  {
# line 1103 "FUnparse.puma"
 fprintf (f,"PRINT ");
          Unparse (t->IO_STMT.IO_SPECS);
          fprintf (f,",");

          Unparse (t->IO_STMT.IO_ITEMS);

  }
   return;

  }
  if (equaltIdent (t->IO_STMT.ID->PROC_OBJ.Ident, MakeIdent ("READ", 4))) {
  if (t->IO_STMT.IO_SPECS->Kind == kBTP_LIST) {
  if (t->IO_STMT.IO_SPECS->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (t->IO_STMT.IO_SPECS->BTP_LIST.Elem->VAR_PARAM.V->Kind == kADDR) {
  if (t->IO_STMT.IO_SPECS->BTP_LIST.Elem->VAR_PARAM.V->ADDR.E->Kind == kDUMMY_EXP) {
  if (t->IO_STMT.IO_SPECS->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 1111 "FUnparse.puma"
  {
# line 1113 "FUnparse.puma"
 fprintf (f,"READ *, ");
          Unparse (t->IO_STMT.IO_ITEMS);

  }
   return;

  }
  }
  }
  }
  }
  }
  if (equaltIdent (t->IO_STMT.ID->PROC_OBJ.Ident, MakeIdent ("READ", 4))) {
  if (t->IO_STMT.IO_SPECS->Kind == kBTP_LIST) {
  if (t->IO_STMT.IO_SPECS->BTP_LIST.Elem->Kind == kVALUE_PARAM) {
  if (t->IO_STMT.IO_SPECS->BTP_LIST.Elem->VALUE_PARAM.E->Kind == kDUMMY_EXP) {
  if (t->IO_STMT.IO_SPECS->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 1118 "FUnparse.puma"
  {
# line 1120 "FUnparse.puma"
 fprintf (f,"READ *, ");
          Unparse (t->IO_STMT.IO_ITEMS);

  }
   return;

  }
  }
  }
  }
  }
  if (equaltIdent (t->IO_STMT.ID->PROC_OBJ.Ident, MakeIdent ("READ", 4))) {
# line 1125 "FUnparse.puma"
  {
# line 1126 "FUnparse.puma"
 fprintf (f,"READ (");
          Unparse (t->IO_STMT.IO_SPECS);
          fprintf (f,") ");
          Unparse (t->IO_STMT.IO_ITEMS);

  }
   return;

  }
  if (equaltIdent (t->IO_STMT.ID->PROC_OBJ.Ident, MakeIdent ("WRITE", 5))) {
# line 1133 "FUnparse.puma"
  {
# line 1134 "FUnparse.puma"
 fprintf (f,"WRITE (");
          Unparse (t->IO_STMT.IO_SPECS);
          fprintf (f,") ");
          Unparse (t->IO_STMT.IO_ITEMS);

  }
   return;

  }
  if (equaltIdent (t->IO_STMT.ID->PROC_OBJ.Ident, MakeIdent ("OPEN", 4))) {
# line 1141 "FUnparse.puma"
  {
# line 1142 "FUnparse.puma"
 fprintf (f,"OPEN (");
          Unparse (t->IO_STMT.IO_SPECS);
          fprintf (f,") ");
          Unparse (t->IO_STMT.IO_ITEMS);

  }
   return;

  }
  if (equaltIdent (t->IO_STMT.ID->PROC_OBJ.Ident, MakeIdent ("CLOSE", 5))) {
# line 1149 "FUnparse.puma"
  {
# line 1150 "FUnparse.puma"
 fprintf (f,"CLOSE (");
          Unparse (t->IO_STMT.IO_SPECS);
          fprintf (f,") ");
          Unparse (t->IO_STMT.IO_ITEMS);

  }
   return;

  }
  if (equaltIdent (t->IO_STMT.ID->PROC_OBJ.Ident, MakeIdent ("REWIND", 6))) {
# line 1157 "FUnparse.puma"
  {
# line 1158 "FUnparse.puma"
 fprintf (f,"REWIND (");
          Unparse (t->IO_STMT.IO_SPECS);
          fprintf (f,") ");
          Unparse (t->IO_STMT.IO_ITEMS);

  }
   return;

  }
  if (equaltIdent (t->IO_STMT.ID->PROC_OBJ.Ident, MakeIdent ("BACKSPACE", 9))) {
# line 1165 "FUnparse.puma"
  {
# line 1166 "FUnparse.puma"
 fprintf (f,"BACKSPACE (");
          Unparse (t->IO_STMT.IO_SPECS);
          fprintf (f,") ");
          Unparse (t->IO_STMT.IO_ITEMS);

  }
   return;

  }
  if (equaltIdent (t->IO_STMT.ID->PROC_OBJ.Ident, MakeIdent ("INQUIRE", 7))) {
# line 1173 "FUnparse.puma"
  {
# line 1174 "FUnparse.puma"
 fprintf (f,"INQUIRE (");
          Unparse (t->IO_STMT.IO_SPECS);
          fprintf (f,") ");
          Unparse (t->IO_STMT.IO_ITEMS);

  }
   return;

  }
# line 1181 "FUnparse.puma"
  {
# line 1182 "FUnparse.puma"
   GetString (t->IO_STMT.ID->PROC_OBJ.Ident, string);
# line 1183 "FUnparse.puma"
 fprintf (f,"%s is unknown io-statement",string);

  }
   return;

  case kBTP_LIST:
  if (t->BTP_LIST.Next->Kind == kBTP_LIST) {
# line 1193 "FUnparse.puma"
  {
# line 1194 "FUnparse.puma"
   Unparse (t->BTP_LIST.Elem);
# line 1195 "FUnparse.puma"
   fprintf (f, ",");
# line 1196 "FUnparse.puma"
   Unparse (t->BTP_LIST.Next);
  }
   return;

  }
  if (t->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 1199 "FUnparse.puma"
  {
# line 1200 "FUnparse.puma"
   Unparse (t->BTP_LIST.Elem);
  }
   return;

  }
  break;
  case kBTP_EMPTY:
# line 1203 "FUnparse.puma"
   return;

  case kNAMED_PARAM:
# line 1206 "FUnparse.puma"
  {
# line 1207 "FUnparse.puma"
   GetString (t->NAMED_PARAM.Name, string);
# line 1208 "FUnparse.puma"
   fprintf (f, "%s=", string);
# line 1209 "FUnparse.puma"
   Unparse (t->NAMED_PARAM.VAL);
  }
   return;

  case kVAR_PARAM:
# line 1212 "FUnparse.puma"
  {
# line 1213 "FUnparse.puma"
   Unparse (t->VAR_PARAM.V);
  }
   return;

  case kVALUE_PARAM:
# line 1216 "FUnparse.puma"
  {
# line 1217 "FUnparse.puma"
   Unparse (t->VALUE_PARAM.E);
  }
   return;

  case kRETURN_PARAM:
# line 1220 "FUnparse.puma"
  {
# line 1221 "FUnparse.puma"
   fprintf (f, "*%d", t->RETURN_PARAM.label);
  }
   return;

  case kPROC_PARAM:
# line 1224 "FUnparse.puma"
  {
# line 1225 "FUnparse.puma"
   Unparse (t->PROC_PARAM.P);
  }
   return;

  case kFUNC_PARAM:
# line 1228 "FUnparse.puma"
  {
# line 1229 "FUnparse.puma"
   Unparse (t->FUNC_PARAM.F);
  }
   return;

  case kPROC_OBJ:
# line 1232 "FUnparse.puma"
  {
# line 1233 "FUnparse.puma"
   GetString (t->PROC_OBJ.Ident, string);
# line 1234 "FUnparse.puma"
   fprintf (f, "%s", string);
  }
   return;

  case kBTE_LIST:
  if (t->BTE_LIST.Next->Kind == kBTE_EMPTY) {
# line 1243 "FUnparse.puma"
  {
# line 1244 "FUnparse.puma"
   Unparse (t->BTE_LIST.Elem);
  }
   return;

  }
# line 1247 "FUnparse.puma"
  {
# line 1248 "FUnparse.puma"
   Unparse (t->BTE_LIST.Elem);
# line 1249 "FUnparse.puma"
   fprintf (f, ",");
# line 1250 "FUnparse.puma"
   Unparse (t->BTE_LIST.Next);
  }
   return;

  case kBTE_EMPTY:
# line 1253 "FUnparse.puma"
   return;

  case kDUMMY_EXP:
# line 1256 "FUnparse.puma"
  {
# line 1256 "FUnparse.puma"
   ExpUnparse (t, 0, 0);
  }
   return;

  case kCONST_EXP:
# line 1257 "FUnparse.puma"
  {
# line 1257 "FUnparse.puma"
   ExpUnparse (t, 0, 0);
  }
   return;

  case kVAR_EXP:
# line 1258 "FUnparse.puma"
  {
# line 1258 "FUnparse.puma"
   ExpUnparse (t, 0, 0);
  }
   return;

  case kOP_EXP:
# line 1259 "FUnparse.puma"
  {
# line 1259 "FUnparse.puma"
   ExpUnparse (t, 0, 0);
  }
   return;

  case kOP1_EXP:
# line 1260 "FUnparse.puma"
  {
# line 1260 "FUnparse.puma"
   ExpUnparse (t, 0, 0);
  }
   return;

  case kTYPE_EXP:
# line 1261 "FUnparse.puma"
  {
# line 1261 "FUnparse.puma"
   ExpUnparse (t, 0, 0);
  }
   return;

  case kARRAY_EXP:
# line 1262 "FUnparse.puma"
  {
# line 1262 "FUnparse.puma"
   ExpUnparse (t, 0, 0);
  }
   return;

  case kSLICE_EXP:
# line 1263 "FUnparse.puma"
  {
# line 1263 "FUnparse.puma"
   ExpUnparse (t, 0, 0);
  }
   return;

  case kFUNC_CALL_EXP:
# line 1264 "FUnparse.puma"
  {
# line 1264 "FUnparse.puma"
   ExpUnparse (t, 0, 0);
  }
   return;

  case kDO_EXP:
# line 1265 "FUnparse.puma"
  {
# line 1265 "FUnparse.puma"
   ExpUnparse (t, 0, 0);
  }
   return;

  case kNAMED_EXP:
# line 1266 "FUnparse.puma"
  {
# line 1266 "FUnparse.puma"
   ExpUnparse (t, 0, 0);
  }
   return;

  case kBTV_LIST:
  if (t->BTV_LIST.Next->Kind == kBTV_LIST) {
# line 1274 "FUnparse.puma"
  {
# line 1275 "FUnparse.puma"
   Unparse (t->BTV_LIST.Elem);
# line 1276 "FUnparse.puma"
   fprintf (f, ",");
# line 1277 "FUnparse.puma"
   Unparse (t->BTV_LIST.Next);
  }
   return;

  }
  if (t->BTV_LIST.Next->Kind == kBTV_EMPTY) {
# line 1280 "FUnparse.puma"
  {
# line 1281 "FUnparse.puma"
   Unparse (t->BTV_LIST.Elem);
  }
   return;

  }
  break;
  case kBTV_EMPTY:
# line 1284 "FUnparse.puma"
   return;

  case kLOOP_VAR:
# line 1287 "FUnparse.puma"
  {
# line 1288 "FUnparse.puma"
   Unparse (t->LOOP_VAR.LOOP_VARNAME);
  }
   return;

  case kUSED_VAR:
# line 1291 "FUnparse.puma"
  {
# line 1292 "FUnparse.puma"
   Unparse (t->USED_VAR.VARNAME);
  }
   return;

  case kINDEXED_VAR:
# line 1295 "FUnparse.puma"
  {
# line 1296 "FUnparse.puma"
   Unparse (t->INDEXED_VAR.IND_VAR);
# line 1297 "FUnparse.puma"
   fprintf (f, "(");
# line 1298 "FUnparse.puma"
   Unparse (t->INDEXED_VAR.IND_EXPS);
# line 1299 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  case kSUBSTRING_VAR:
# line 1302 "FUnparse.puma"
  {
# line 1303 "FUnparse.puma"
   Unparse (t->SUBSTRING_VAR.IND_VAR);
# line 1304 "FUnparse.puma"
   fprintf (f, "(");
# line 1305 "FUnparse.puma"
   Unparse (t->SUBSTRING_VAR.IND_EXP);
# line 1306 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  case kADDR:
# line 1309 "FUnparse.puma"
  {
# line 1310 "FUnparse.puma"
   Unparse (t->ADDR.E);
  }
   return;

  case kSELECTED_VAR:
# line 1313 "FUnparse.puma"
  {
# line 1314 "FUnparse.puma"
   Unparse (t->SELECTED_VAR.SELEC_VAR);
# line 1315 "FUnparse.puma"
   fprintf (f, " %% ");
# line 1316 "FUnparse.puma"
   Unparse (t->SELECTED_VAR.SELECTOR);
  }
   return;

  case kDO_VAR:
  if (t->DO_VAR.RANGE->SLICE_EXP.INC->Kind == kDUMMY_EXP) {
# line 1319 "FUnparse.puma"
  {
# line 1320 "FUnparse.puma"
   fprintf (f, "(");
# line 1321 "FUnparse.puma"
   Unparse (t->DO_VAR.BODY);
# line 1322 "FUnparse.puma"
   fprintf (f, ", ");
# line 1323 "FUnparse.puma"
   Unparse (t->DO_VAR.DO_ID);
# line 1324 "FUnparse.puma"
   fprintf (f, "=");
# line 1325 "FUnparse.puma"
   Unparse (t->DO_VAR.RANGE->SLICE_EXP.START);
# line 1326 "FUnparse.puma"
   fprintf (f, ",");
# line 1327 "FUnparse.puma"
   Unparse (t->DO_VAR.RANGE->SLICE_EXP.STOP);
# line 1328 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  }
# line 1331 "FUnparse.puma"
  {
# line 1332 "FUnparse.puma"
   fprintf (f, "(");
# line 1333 "FUnparse.puma"
   Unparse (t->DO_VAR.BODY);
# line 1334 "FUnparse.puma"
   fprintf (f, ", ");
# line 1335 "FUnparse.puma"
   Unparse (t->DO_VAR.DO_ID);
# line 1336 "FUnparse.puma"
   fprintf (f, "=");
# line 1337 "FUnparse.puma"
   Unparse (t->DO_VAR.RANGE->SLICE_EXP.START);
# line 1338 "FUnparse.puma"
   fprintf (f, ",");
# line 1339 "FUnparse.puma"
   Unparse (t->DO_VAR.RANGE->SLICE_EXP.STOP);
# line 1340 "FUnparse.puma"
   fprintf (f, ",");
# line 1341 "FUnparse.puma"
   Unparse (t->DO_VAR.RANGE->SLICE_EXP.INC);
# line 1342 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  case kTYPE_LIST:
  if (t->TYPE_LIST.Next->Kind == kTYPE_LIST) {
# line 1351 "FUnparse.puma"
  {
# line 1352 "FUnparse.puma"
   Unparse (t->TYPE_LIST.Elem);
# line 1353 "FUnparse.puma"
   fprintf (f, ",");
# line 1354 "FUnparse.puma"
   Unparse (t->TYPE_LIST.Next);
  }
   return;

  }
  if (t->TYPE_LIST.Next->Kind == kTYPE_EMPTY) {
# line 1357 "FUnparse.puma"
  {
# line 1358 "FUnparse.puma"
   Unparse (t->TYPE_LIST.Elem);
  }
   return;

  }
  break;
  case kTYPE_ID:
# line 1361 "FUnparse.puma"
  {
# line 1362 "FUnparse.puma"
   fprintf (f, "TYPE (");
# line 1363 "FUnparse.puma"
   Unparse (t->TYPE_ID.ID);
# line 1364 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  case kSTRING_TYPE:
  if (t->STRING_TYPE.LENGTH->Kind == kCONST_EXP) {
  if (t->STRING_TYPE.LENGTH->CONST_EXP.C->Kind == kINT_CONSTANT) {
  if (equalint (t->STRING_TYPE.LENGTH->CONST_EXP.C->INT_CONSTANT.value, - 1)) {
# line 1367 "FUnparse.puma"
  {
# line 1368 "FUnparse.puma"
   fprintf (f, "CHARACTER*");
  }
   return;

  }
  }
  }
  if (t->STRING_TYPE.LENGTH->Kind == kDUMMY_EXP) {
# line 1371 "FUnparse.puma"
  {
# line 1372 "FUnparse.puma"
   fprintf (f, "CHARACTER*(*)");
  }
   return;

  }
# line 1375 "FUnparse.puma"
  {
# line 1376 "FUnparse.puma"
   fprintf (f, "CHARACTER*");
# line 1377 "FUnparse.puma"
   Unparse (t->STRING_TYPE.LENGTH);
  }
   return;

  case kARRAY_TYPE:
# line 1380 "FUnparse.puma"
  {
# line 1381 "FUnparse.puma"
   Unparse (t->ARRAY_TYPE.ARRAY_COMP_TYPE);
# line 1382 "FUnparse.puma"
   fprintf (f, " (", string);
# line 1383 "FUnparse.puma"
   Unparse (t->ARRAY_TYPE.ARRAY_INDEX_TYPES);
# line 1384 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  case kRECORD_TYPE:
# line 1387 "FUnparse.puma"
  {
# line 1388 "FUnparse.puma"
   fprintf (f, "RECORD\n");
# line 1389 "FUnparse.puma"
 indent += 8;
# line 1390 "FUnparse.puma"
   Unparse (t->RECORD_TYPE.COMPONENTS);
# line 1391 "FUnparse.puma"
   ind ();
# line 1392 "FUnparse.puma"
 indent -= 8;
# line 1393 "FUnparse.puma"
   fprintf (f, "END");
  }
   return;

  case kINDEX_TYPE:
  if (equalint (t->INDEX_TYPE.left_overlap, 0)) {
  if (equalint (t->INDEX_TYPE.right_overlap, 0)) {
# line 1396 "FUnparse.puma"
  {
# line 1397 "FUnparse.puma"
   Unparse (t->INDEX_TYPE.LOWER);
# line 1398 "FUnparse.puma"
   fprintf (f, ":");
# line 1399 "FUnparse.puma"
   Unparse (t->INDEX_TYPE.UPPER);
  }
   return;

  }
  }
# line 1402 "FUnparse.puma"
  {
# line 1403 "FUnparse.puma"
   Unparse (t->INDEX_TYPE.LOWER);
# line 1404 "FUnparse.puma"
   fprintf (f, ":");
# line 1405 "FUnparse.puma"
   Unparse (t->INDEX_TYPE.UPPER);
# line 1406 "FUnparse.puma"
   fprintf (f, "[%d:%d]", t->INDEX_TYPE.left_overlap, t->INDEX_TYPE.right_overlap);
  }
   return;

  case kDYNAMIC:
  if (equalint (t->DYNAMIC.left_overlap, 0)) {
  if (equalint (t->DYNAMIC.right_overlap, 0)) {
# line 1409 "FUnparse.puma"
  {
# line 1410 "FUnparse.puma"
   fprintf (f, ":");
  }
   return;

  }
  }
# line 1413 "FUnparse.puma"
  {
# line 1414 "FUnparse.puma"
   fprintf (f, ":");
# line 1415 "FUnparse.puma"
   fprintf (f, "[%d:%d]", t->DYNAMIC.left_overlap, t->DYNAMIC.right_overlap);
  }
   return;

  case kINTEGER_TYPE:
# line 1418 "FUnparse.puma"
  {
# line 1419 "FUnparse.puma"
   fprintf (f, "INTEGER*%d", t->INTEGER_TYPE.size);
  }
   return;

  case kBOOLEAN_TYPE:
# line 1422 "FUnparse.puma"
  {
# line 1423 "FUnparse.puma"
   fprintf (f, "LOGICAL*%d", t->BOOLEAN_TYPE.size);
  }
   return;

  case kCOMPLEX_TYPE:
# line 1426 "FUnparse.puma"
  {
# line 1427 "FUnparse.puma"
   fprintf (f, "COMPLEX*%d", t->COMPLEX_TYPE.size);
  }
   return;

  case kREAL_TYPE:
# line 1430 "FUnparse.puma"
  {
# line 1431 "FUnparse.puma"
   fprintf (f, "REAL*%d", t->REAL_TYPE.size);
  }
   return;

  case kTYPE_OBJ:
# line 1434 "FUnparse.puma"
  {
# line 1435 "FUnparse.puma"
   GetString (t->TYPE_OBJ.Ident, string);
# line 1436 "FUnparse.puma"
   fprintf (f, "%s", string);
  }
   return;

  case kREC_COMP:
# line 1439 "FUnparse.puma"
  {
# line 1440 "FUnparse.puma"
   GetString (t->REC_COMP.Ident, string);
# line 1441 "FUnparse.puma"
   fprintf (f, "%s", string);
  }
   return;

  case kDUMMY_TYPE:
# line 1444 "FUnparse.puma"
   return;

  case kVAR_OBJ:
# line 1447 "FUnparse.puma"
  {
# line 1448 "FUnparse.puma"
   GetString (t->VAR_OBJ.Ident, string);
# line 1449 "FUnparse.puma"
   fprintf (f, "%s", string);
  }
   return;

  }

# line 1452 "FUnparse.puma"
  {
# line 1453 "FUnparse.puma"
   fprintf (f, "<unknown_structure>");
# line 1454 "FUnparse.puma"
   WriteTree (f, t);
  }
   return;

;
}

static int Priority
# if defined __STDC__ | defined __cplusplus
(register tTree yyP1)
# else
(yyP1)
 register tTree yyP1;
# endif
{

  switch (yyP1->Kind) {
  case kOP_DEFINED:
# line 1476 "FUnparse.puma"
   return 1;

  case kOP_EQV:
# line 1478 "FUnparse.puma"
   return 2;

  case kOP_NEQV:
# line 1479 "FUnparse.puma"
   return 2;

  case kOP_OR:
# line 1481 "FUnparse.puma"
   return 3;

  case kOP_XOR:
# line 1482 "FUnparse.puma"
   return 3;

  case kOP_AND:
# line 1484 "FUnparse.puma"
   return 4;

  case kOP1_NOT:
# line 1486 "FUnparse.puma"
   return 5;

  case kOP_EQ:
# line 1488 "FUnparse.puma"
   return 6;

  case kOP_NE:
# line 1489 "FUnparse.puma"
   return 6;

  case kOP_LE:
# line 1490 "FUnparse.puma"
   return 6;

  case kOP_LT:
# line 1491 "FUnparse.puma"
   return 6;

  case kOP_GE:
# line 1492 "FUnparse.puma"
   return 6;

  case kOP_GT:
# line 1493 "FUnparse.puma"
   return 6;

  case kOP_CONCAT:
# line 1495 "FUnparse.puma"
   return 7;

  case kOP_PLUS:
# line 1497 "FUnparse.puma"
   return 8;

  case kOP_MINUS:
# line 1498 "FUnparse.puma"
   return 8;

  case kOP1_SIGN:
# line 1499 "FUnparse.puma"
   return 8;

  case kOP_TIMES:
# line 1501 "FUnparse.puma"
   return 9;

  case kOP_DIVIDE:
# line 1502 "FUnparse.puma"
   return 9;

  case kOP_EXPO:
# line 1504 "FUnparse.puma"
   return 10;

  }

 yyAbort ("Priority");
}

static void ComUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 1514 "FUnparse.puma"
 unsigned char string [256];
  if (t == NoTree) return;
  if (t->Kind == kDECL_EMPTY) {
# line 1516 "FUnparse.puma"
   return;

  }
  if (t->Kind == kDECL_LIST) {
  if (t->DECL_LIST.Next->Kind == kDECL_EMPTY) {
# line 1519 "FUnparse.puma"
  {
# line 1520 "FUnparse.puma"
   ComUnparse (t->DECL_LIST.Elem);
  }
   return;

  }
# line 1523 "FUnparse.puma"
  {
# line 1524 "FUnparse.puma"
   ComUnparse (t->DECL_LIST.Elem);
# line 1525 "FUnparse.puma"
   fprintf (f, ",");
# line 1526 "FUnparse.puma"
   ComUnparse (t->DECL_LIST.Next);
  }
   return;

  }
  if (t->Kind == kVAR_DECL) {
  if (t->VAR_DECL.VAL->Kind == kARRAY_TYPE) {
# line 1529 "FUnparse.puma"
  {
# line 1530 "FUnparse.puma"
   GetString (t->VAR_DECL.Name, string);
# line 1531 "FUnparse.puma"
   fprintf (f, " %s (", string);
# line 1532 "FUnparse.puma"
   Unparse (t->VAR_DECL.VAL->ARRAY_TYPE.ARRAY_INDEX_TYPES);
# line 1533 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  }
# line 1536 "FUnparse.puma"
  {
# line 1537 "FUnparse.puma"
   GetString (t->VAR_DECL.Name, string);
# line 1538 "FUnparse.puma"
   fprintf (f, " %s", string);
  }
   return;

  }
# line 1541 "FUnparse.puma"
  {
# line 1542 "FUnparse.puma"
   fprintf (f, "<unknown_common_structure>");
  }
   return;

;
}

static void UnparseElse
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t == NoTree) return;
  if (t->Kind == kACF_EMPTY) {
# line 1553 "FUnparse.puma"
   return;

  }
  if (t->Kind == kACF_LIST) {
  if (t->ACF_LIST.Elem->Kind == kACF_IF) {
  if (equalint (t->ACF_LIST.Elem->ACF_IF.Label, 0)) {
  if (t->ACF_LIST.Next->Kind == kACF_EMPTY) {
# line 1559 "FUnparse.puma"
  {
# line 1563 "FUnparse.puma"
   ind ();
# line 1564 "FUnparse.puma"
   fprintf (f, " ELSE IF (");
# line 1565 "FUnparse.puma"
   Unparse (t->ACF_LIST.Elem->ACF_IF.IF_EXP);
# line 1566 "FUnparse.puma"
   fprintf (f, ") THEN");
# line 1567 "FUnparse.puma"
   LCR (t->ACF_LIST.Elem->ACF_IF.Line);
# line 1568 "FUnparse.puma"
 indent = indent + IndentLength;
# line 1569 "FUnparse.puma"
   Unparse (t->ACF_LIST.Elem->ACF_IF.THEN_PART);
# line 1570 "FUnparse.puma"
 indent = indent - IndentLength;
# line 1571 "FUnparse.puma"
   UnparseElse (t->ACF_LIST.Elem->ACF_IF.ELSE_PART);
  }
   return;

  }
  }
  }
  }
# line 1574 "FUnparse.puma"
  {
# line 1575 "FUnparse.puma"
   ind ();
# line 1576 "FUnparse.puma"
   fprintf (f, " ELSE\n");
# line 1577 "FUnparse.puma"
 indent = indent + IndentLength;
# line 1578 "FUnparse.puma"
   Unparse (t);
# line 1579 "FUnparse.puma"
 indent = indent - IndentLength;
  }
   return;

;
}

static void UnparseDoRange
# if defined __STDC__ | defined __cplusplus
(register tTree slice)
# else
(slice)
 register tTree slice;
# endif
{
  if (slice == NoTree) return;
  if (slice->Kind == kSLICE_EXP) {
  if (slice->SLICE_EXP.INC->Kind == kDUMMY_EXP) {
# line 1590 "FUnparse.puma"
  {
# line 1591 "FUnparse.puma"
   Unparse (slice->SLICE_EXP.START);
# line 1592 "FUnparse.puma"
   fprintf (f, ",");
# line 1593 "FUnparse.puma"
   Unparse (slice->SLICE_EXP.STOP);
  }
   return;

  }
# line 1596 "FUnparse.puma"
  {
# line 1597 "FUnparse.puma"
   Unparse (slice->SLICE_EXP.START);
# line 1598 "FUnparse.puma"
   fprintf (f, ",");
# line 1599 "FUnparse.puma"
   Unparse (slice->SLICE_EXP.STOP);
# line 1600 "FUnparse.puma"
   fprintf (f, ",");
# line 1601 "FUnparse.puma"
   Unparse (slice->SLICE_EXP.INC);
  }
   return;

  }
;
}

static void ExpUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree t, register int leftprio, register int rightprio)
# else
(t, leftprio, rightprio)
 register tTree t;
 register int leftprio;
 register int rightprio;
# endif
{
# line 1625 "FUnparse.puma"

char string [100];

  if (t == NoTree) return;

  switch (t->Kind) {
  case kOP_EXP:
# line 1629 "FUnparse.puma"
 {
  int myleftprio;
  int myrightprio;
  {
# line 1631 "FUnparse.puma"

# line 1632 "FUnparse.puma"

# line 1634 "FUnparse.puma"
   myleftprio = Priority (t->OP_EXP.EXP_OP);
# line 1635 "FUnparse.puma"
   myrightprio = myleftprio;
# line 1637 "FUnparse.puma"
 if (t->OP_EXP.EXP_OP->Kind == kOP_EXPO) myleftprio += 1;
# line 1639 "FUnparse.puma"
 if ((leftprio >= myleftprio) || (rightprio > myrightprio))
      { fprintf (f, "(");
        ExpUnparse (t, 0, 0);
        fprintf (f, ")");
      }
     else
      { ExpUnparse (t->OP_EXP.OPND1, leftprio, myleftprio);
        OpUnparse (t->OP_EXP.EXP_OP);
        ExpUnparse (t->OP_EXP.OPND2, myrightprio, rightprio);
      }

  }
   return;
 }

  case kOP1_EXP:
# line 1652 "FUnparse.puma"
 {
  int priority;
  {
# line 1654 "FUnparse.puma"

# line 1656 "FUnparse.puma"
 if (t->OP1_EXP.EXP_OP1->Kind == kOP_DEFINED) priority = 12;
        else priority = Priority (t->OP1_EXP.EXP_OP1);

# line 1660 "FUnparse.puma"
 if (rightprio > priority)
      { fprintf (f, "(");
        ExpUnparse (t, 0, 0);
        fprintf (f, ")");
      }
     else
      { OpUnparse (t->OP1_EXP.EXP_OP1);
        ExpUnparse (t->OP1_EXP.OPND, priority, rightprio);
      }

  }
   return;
 }

  case kDUMMY_EXP:
# line 1672 "FUnparse.puma"
  {
# line 1673 "FUnparse.puma"
   fprintf (f, "*");
  }
   return;

  case kCONST_EXP:
# line 1676 "FUnparse.puma"
  {
# line 1677 "FUnparse.puma"
   Unparse (t->CONST_EXP.C);
  }
   return;

  case kVAR_EXP:
# line 1680 "FUnparse.puma"
  {
# line 1681 "FUnparse.puma"
   Unparse (t->VAR_EXP.V);
  }
   return;

  case kTYPE_EXP:
# line 1684 "FUnparse.puma"
  {
# line 1685 "FUnparse.puma"
   GetString (t->TYPE_EXP.ID->TYPE_OBJ.Ident, string);
# line 1686 "FUnparse.puma"
   fprintf (f, "%s (", string);
# line 1687 "FUnparse.puma"
   Unparse (t->TYPE_EXP.ELEMENTS);
# line 1688 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  case kARRAY_EXP:
# line 1691 "FUnparse.puma"
  {
# line 1692 "FUnparse.puma"
   fprintf (f, "[");
# line 1693 "FUnparse.puma"
   Unparse (t->ARRAY_EXP.ELEMENTS);
# line 1694 "FUnparse.puma"
   fprintf (f, "]");
  }
   return;

  case kSLICE_EXP:
# line 1697 "FUnparse.puma"
  {
# line 1698 "FUnparse.puma"
 if (t->SLICE_EXP.START->Kind != kDUMMY_EXP)
              ExpUnparse (t->SLICE_EXP.START,0,0);
# line 1700 "FUnparse.puma"
   fprintf (f, ":");
# line 1701 "FUnparse.puma"
 if (t->SLICE_EXP.STOP->Kind != kDUMMY_EXP)
              ExpUnparse (t->SLICE_EXP.STOP,0,0);
# line 1703 "FUnparse.puma"
 if (t->SLICE_EXP.INC->Kind != kDUMMY_EXP)
            { fprintf (f,":");
              ExpUnparse (t->SLICE_EXP.INC,0,0);
            }

  }
   return;

  case kFUNC_CALL_EXP:
# line 1710 "FUnparse.puma"
  {
# line 1712 "FUnparse.puma"
   Unparse (t->FUNC_CALL_EXP.FUNC_ID);
# line 1713 "FUnparse.puma"
   fprintf (f, "(");
# line 1714 "FUnparse.puma"
   Unparse (t->FUNC_CALL_EXP.FUNC_PARAMS);
# line 1715 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  case kDO_EXP:
  if (t->DO_EXP.RANGE->SLICE_EXP.INC->Kind == kDUMMY_EXP) {
# line 1718 "FUnparse.puma"
  {
# line 1719 "FUnparse.puma"
   fprintf (f, "(");
# line 1720 "FUnparse.puma"
   Unparse (t->DO_EXP.BODY);
# line 1721 "FUnparse.puma"
   fprintf (f, ", ");
# line 1722 "FUnparse.puma"
   Unparse (t->DO_EXP.DO_ID);
# line 1723 "FUnparse.puma"
   fprintf (f, "=");
# line 1724 "FUnparse.puma"
   Unparse (t->DO_EXP.RANGE->SLICE_EXP.START);
# line 1725 "FUnparse.puma"
   fprintf (f, ",");
# line 1726 "FUnparse.puma"
   Unparse (t->DO_EXP.RANGE->SLICE_EXP.STOP);
# line 1727 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  }
# line 1730 "FUnparse.puma"
  {
# line 1731 "FUnparse.puma"
   fprintf (f, "(");
# line 1732 "FUnparse.puma"
   Unparse (t->DO_EXP.BODY);
# line 1733 "FUnparse.puma"
   fprintf (f, ", ");
# line 1734 "FUnparse.puma"
   Unparse (t->DO_EXP.DO_ID);
# line 1735 "FUnparse.puma"
   fprintf (f, "=");
# line 1736 "FUnparse.puma"
   Unparse (t->DO_EXP.RANGE->SLICE_EXP.START);
# line 1737 "FUnparse.puma"
   fprintf (f, ",");
# line 1738 "FUnparse.puma"
   Unparse (t->DO_EXP.RANGE->SLICE_EXP.STOP);
# line 1739 "FUnparse.puma"
   fprintf (f, ",");
# line 1740 "FUnparse.puma"
   Unparse (t->DO_EXP.RANGE->SLICE_EXP.INC);
# line 1741 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  case kNAMED_EXP:
# line 1744 "FUnparse.puma"
  {
# line 1745 "FUnparse.puma"
   GetString (t->NAMED_EXP.Name, string);
# line 1746 "FUnparse.puma"
   fprintf (f, "%s=", string);
# line 1747 "FUnparse.puma"
   Unparse (t->NAMED_EXP.VAL);
  }
   return;

  }

# line 1750 "FUnparse.puma"
  {
# line 1751 "FUnparse.puma"
   fprintf (f, "<unknown_exp>");
  }
   return;

;
}

static void OpUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 1756 "FUnparse.puma"

char string [100];

  if (t == NoTree) return;

  switch (t->Kind) {
  case kOP_EQ:
# line 1760 "FUnparse.puma"
  {
# line 1760 "FUnparse.puma"
   fprintf (f, " .eq. ");
  }
   return;

  case kOP_NE:
# line 1761 "FUnparse.puma"
  {
# line 1761 "FUnparse.puma"
   fprintf (f, " .ne. ");
  }
   return;

  case kOP_LE:
# line 1762 "FUnparse.puma"
  {
# line 1762 "FUnparse.puma"
   fprintf (f, " .le. ");
  }
   return;

  case kOP_LT:
# line 1763 "FUnparse.puma"
  {
# line 1763 "FUnparse.puma"
   fprintf (f, " .lt. ");
  }
   return;

  case kOP_GE:
# line 1764 "FUnparse.puma"
  {
# line 1764 "FUnparse.puma"
   fprintf (f, " .ge. ");
  }
   return;

  case kOP_GT:
# line 1765 "FUnparse.puma"
  {
# line 1765 "FUnparse.puma"
   fprintf (f, " .gt. ");
  }
   return;

  case kOP_PLUS:
# line 1766 "FUnparse.puma"
  {
# line 1766 "FUnparse.puma"
   fprintf (f, "+");
  }
   return;

  case kOP_MINUS:
# line 1767 "FUnparse.puma"
  {
# line 1767 "FUnparse.puma"
   fprintf (f, "-");
  }
   return;

  case kOP_OR:
# line 1768 "FUnparse.puma"
  {
# line 1768 "FUnparse.puma"
   fprintf (f, " .or. ");
  }
   return;

  case kOP_XOR:
# line 1769 "FUnparse.puma"
  {
# line 1769 "FUnparse.puma"
   fprintf (f, " .xor. ");
  }
   return;

  case kOP_CONCAT:
# line 1770 "FUnparse.puma"
  {
# line 1770 "FUnparse.puma"
   fprintf (f, " //");
  }
   return;

  case kOP_TIMES:
# line 1771 "FUnparse.puma"
  {
# line 1771 "FUnparse.puma"
   fprintf (f, "*");
  }
   return;

  case kOP_DIVIDE:
# line 1772 "FUnparse.puma"
  {
# line 1772 "FUnparse.puma"
   fprintf (f, "/");
  }
   return;

  case kOP_DIV:
# line 1773 "FUnparse.puma"
  {
# line 1773 "FUnparse.puma"
   fprintf (f, " div ");
  }
   return;

  case kOP_AND:
# line 1774 "FUnparse.puma"
  {
# line 1774 "FUnparse.puma"
   fprintf (f, " .and. ");
  }
   return;

  case kOP_EQV:
# line 1775 "FUnparse.puma"
  {
# line 1775 "FUnparse.puma"
   fprintf (f, " .eqv. ");
  }
   return;

  case kOP_NEQV:
# line 1776 "FUnparse.puma"
  {
# line 1776 "FUnparse.puma"
   fprintf (f, " .neqv. ");
  }
   return;

  case kOP_EXPO:
# line 1777 "FUnparse.puma"
  {
# line 1777 "FUnparse.puma"
   fprintf (f, "**");
  }
   return;

  case kOP_MOD:
# line 1778 "FUnparse.puma"
  {
# line 1778 "FUnparse.puma"
   fprintf (f, " mod ");
  }
   return;

  case kOP_IN:
# line 1779 "FUnparse.puma"
  {
# line 1779 "FUnparse.puma"
   fprintf (f, " in ");
  }
   return;

  case kOP1_NOT:
# line 1781 "FUnparse.puma"
  {
# line 1781 "FUnparse.puma"
   fprintf (f, " .not. ");
  }
   return;

  case kOP1_SIGN:
# line 1782 "FUnparse.puma"
  {
# line 1782 "FUnparse.puma"
   fprintf (f, "-");
  }
   return;

  case kOP_DEFINED:
# line 1784 "FUnparse.puma"
  {
# line 1786 "FUnparse.puma"
   GetString (t->OP_DEFINED.opname, string);
# line 1787 "FUnparse.puma"
   fprintf (f, " %s ", string);
  }
   return;

  }

# line 1790 "FUnparse.puma"
  {
# line 1790 "FUnparse.puma"
   fprintf (f, "<op?>");
  }
   return;

;
}

static void FormatUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 1801 "FUnparse.puma"
 unsigned char string[256];
  if (t == NoTree) return;
  if (t->Kind == kBTP_LIST) {
  if (t->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 1803 "FUnparse.puma"
  {
# line 1804 "FUnparse.puma"
   FormatUnparse (t->BTP_LIST.Elem);
  }
   return;

  }
  if (t->BTP_LIST.Next->Kind == kBTP_LIST) {
# line 1807 "FUnparse.puma"
  {
# line 1808 "FUnparse.puma"
   FormatUnparse (t->BTP_LIST.Elem);
# line 1809 "FUnparse.puma"
   fprintf (f, "\n", string);
# line 1810 "FUnparse.puma"
   cont_ind ();
# line 1811 "FUnparse.puma"
   FormatUnparse (t->BTP_LIST.Next);
  }
   return;

  }
  }
  if (t->Kind == kFORMAT_PARAM) {
# line 1814 "FUnparse.puma"
  {
# line 1815 "FUnparse.puma"
   StGetString (t->FORMAT_PARAM.S, string);
# line 1816 "FUnparse.puma"
   fprintf (f, "%s", string);
  }
   return;

  }
;
}

static void LayoutUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 1827 "FUnparse.puma"
 unsigned char string[256];
  if (t == NoTree) return;

  switch (t->Kind) {
  case kHOST_DISTRIBUTION:
# line 1829 "FUnparse.puma"
  {
# line 1830 "FUnparse.puma"
   fprintf (f, "(:HOST)");
  }
   return;

  case kREPL_DISTRIBUTION:
# line 1833 "FUnparse.puma"
  {
# line 1834 "FUnparse.puma"
   fprintf (f, "(:REPLICATED)");
  }
   return;

  case kNODE_DISTRIBUTION:
# line 1837 "FUnparse.puma"
  {
# line 1838 "FUnparse.puma"
   fprintf (f, "(");
# line 1839 "FUnparse.puma"
   LayoutUnparse (t->NODE_DISTRIBUTION.MAPPING);
# line 1840 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  case kDIST_LIST:
  if (t->DIST_LIST.Next->Kind == kDIST_EMPTY) {
# line 1843 "FUnparse.puma"
  {
# line 1844 "FUnparse.puma"
   LayoutUnparse (t->DIST_LIST.Elem);
  }
   return;

  }
# line 1847 "FUnparse.puma"
  {
# line 1848 "FUnparse.puma"
   LayoutUnparse (t->DIST_LIST.Elem);
# line 1849 "FUnparse.puma"
   fprintf (f, ",");
# line 1850 "FUnparse.puma"
   LayoutUnparse (t->DIST_LIST.Next);
  }
   return;

  case kBLOCK_DISTRIBUTION:
  if (t->BLOCK_DISTRIBUTION.SIZE->Kind == kDUMMY_EXP) {
# line 1853 "FUnparse.puma"
  {
# line 1854 "FUnparse.puma"
   fprintf (f, "BLOCK");
  }
   return;

  }
# line 1857 "FUnparse.puma"
  {
# line 1858 "FUnparse.puma"
   fprintf (f, "BLOCK(");
# line 1859 "FUnparse.puma"
   Unparse (t->BLOCK_DISTRIBUTION.SIZE);
# line 1860 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  case kCYCLIC_DISTRIBUTION:
  if (t->CYCLIC_DISTRIBUTION.SIZE->Kind == kDUMMY_EXP) {
# line 1863 "FUnparse.puma"
  {
# line 1864 "FUnparse.puma"
   fprintf (f, "CYCLIC");
  }
   return;

  }
# line 1867 "FUnparse.puma"
  {
# line 1868 "FUnparse.puma"
   fprintf (f, "CYCLIC(");
# line 1869 "FUnparse.puma"
   Unparse (t->CYCLIC_DISTRIBUTION.SIZE);
# line 1870 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  case kSERIAL_DISTRIBUTION:
# line 1873 "FUnparse.puma"
  {
# line 1874 "FUnparse.puma"
   fprintf (f, "*");
  }
   return;

  }

# line 1877 "FUnparse.puma"
  {
# line 1878 "FUnparse.puma"
   fprintf (f, "<unknown-layout>");
  }
   return;

;
}

static bool IsItAllocatable
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t == NoTree) return false;
  if (t->Kind == kARRAY_TYPE) {
# line 1889 "FUnparse.puma"
  {
# line 1890 "FUnparse.puma"
   if (! (IsItAllocatable (t->ARRAY_TYPE.ARRAY_INDEX_TYPES))) goto yyL1;
  }
   return true;
yyL1:;

  }
  if (t->Kind == kTYPE_LIST) {
# line 1893 "FUnparse.puma"
  {
# line 1894 "FUnparse.puma"
   if (! (IsItAllocatable (t->TYPE_LIST.Elem))) goto yyL2;
  {
# line 1895 "FUnparse.puma"
   if (! (IsItAllocatable (t->TYPE_LIST.Next))) goto yyL2;
  }
  }
   return true;
yyL2:;

  }
  if (t->Kind == kTYPE_EMPTY) {
# line 1898 "FUnparse.puma"
   return true;

  }
  if (t->Kind == kDYNAMIC) {
# line 1901 "FUnparse.puma"
   return true;

  }
  return false;
}

static int UP_List_Length
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kDECL_LIST) {
# line 1912 "FUnparse.puma"
   return (1 + UP_List_Length (t->DECL_LIST.Next));

  }
  if (t->Kind == kDECL_EMPTY) {
# line 1916 "FUnparse.puma"
   return 0;

  }
  if (t->Kind == kBTP_LIST) {
# line 1920 "FUnparse.puma"
   return (1 + UP_List_Length (t->BTP_LIST.Next));

  }
  if (t->Kind == kBTP_EMPTY) {
# line 1924 "FUnparse.puma"
   return 0;

  }
 yyAbort ("UP_List_Length");
}

static void FormalParamUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 1936 "FUnparse.puma"

unsigned char string[256];

  if (t == NoTree) return;
  if (t->Kind == kDECL_EMPTY) {
# line 1940 "FUnparse.puma"
   return;

  }
  if (t->Kind == kDECL_LIST) {
  if (t->DECL_LIST.Next->Kind == kDECL_EMPTY) {
# line 1943 "FUnparse.puma"
  {
# line 1944 "FUnparse.puma"
   FormalParamUnparse (t->DECL_LIST.Elem);
  }
   return;

  }
# line 1947 "FUnparse.puma"
  {
# line 1948 "FUnparse.puma"
   FormalParamUnparse (t->DECL_LIST.Elem);
# line 1949 "FUnparse.puma"
   fprintf (f, ", ");
# line 1950 "FUnparse.puma"
 if (((UP_List_Length (t->DECL_LIST.Next) + 1) % 8) == 0)

            { fprintf (f, "\n");
              fprintf (f, "     $  ");
            }

# line 1956 "FUnparse.puma"
   FormalParamUnparse (t->DECL_LIST.Next);
  }
   return;

  }
  if (t->Kind == kVAR_PARAM_DECL) {
# line 1959 "FUnparse.puma"
  {
# line 1960 "FUnparse.puma"
   GetString (t->VAR_PARAM_DECL.Name, string);
# line 1961 "FUnparse.puma"
   fprintf (f, "%s", string);
  }
   return;

  }
  if (t->Kind == kRET_PARAM_DECL) {
# line 1964 "FUnparse.puma"
  {
# line 1965 "FUnparse.puma"
   fprintf (f, "*");
  }
   return;

  }
# line 1968 "FUnparse.puma"
  {
# line 1969 "FUnparse.puma"
   fprintf (f, "<unknown_formal_param>");
  }
   return;

;
}

static void ParamUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 1980 "FUnparse.puma"

unsigned char string[256];

  if (t == NoTree) return;
  if (t->Kind == kBTP_LIST) {
  if (t->BTP_LIST.Next->Kind == kBTP_LIST) {
# line 1984 "FUnparse.puma"
  {
# line 1985 "FUnparse.puma"
   Unparse (t->BTP_LIST.Elem);
# line 1986 "FUnparse.puma"
   fprintf (f, ",");
# line 1987 "FUnparse.puma"
 if (((UP_List_Length (t->BTP_LIST.Next) + 1) % 8) == 0)

            { fprintf (f, "\n");
              fprintf (f, "     $  ");
            }

# line 1993 "FUnparse.puma"
   ParamUnparse (t->BTP_LIST.Next);
  }
   return;

  }
  if (t->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 1996 "FUnparse.puma"
  {
# line 1997 "FUnparse.puma"
   Unparse (t->BTP_LIST.Elem);
  }
   return;

  }
  }
;
}

static void AttributeUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 2010 "FUnparse.puma"

unsigned char string[256];

  if (t == NoTree) return;

  switch (t->Kind) {
  case kDECL_EMPTY:
# line 2014 "FUnparse.puma"
   return;

  case kDECL_LIST:
# line 2017 "FUnparse.puma"
  {
# line 2018 "FUnparse.puma"
   fprintf (f, ", ");
# line 2019 "FUnparse.puma"
   AttributeUnparse (t->DECL_LIST.Elem);
# line 2020 "FUnparse.puma"
   AttributeUnparse (t->DECL_LIST.Next);
  }
   return;

  case kDIMENSION_DECL:
# line 2023 "FUnparse.puma"
  {
# line 2024 "FUnparse.puma"
   fprintf (f, "DIMENSION(");
# line 2025 "FUnparse.puma"
   Unparse (t->DIMENSION_DECL.INDEXES);
# line 2026 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  case kTYPESPEC_DECL:
# line 2029 "FUnparse.puma"
  {
# line 2030 "FUnparse.puma"
   Unparse (t->TYPESPEC_DECL.VAL);
  }
   return;

  case kINIT_DATA_DECL:
  if (t->INIT_DATA_DECL.VAL->Kind == kDUMMY_EXP) {
# line 2033 "FUnparse.puma"
  {
# line 2034 "FUnparse.puma"
   fprintf (f, "DATA");
  }
   return;

  }
# line 2037 "FUnparse.puma"
  {
# line 2038 "FUnparse.puma"
   fprintf (f, "INIT = ");
# line 2039 "FUnparse.puma"
   Unparse (t->INIT_DATA_DECL.VAL);
  }
   return;

  case kALLOCATABLE_DECL:
# line 2042 "FUnparse.puma"
  {
# line 2043 "FUnparse.puma"
   fprintf (f, "ALLOCATABLE");
  }
   return;

  case kEXTERNAL_DECL:
# line 2046 "FUnparse.puma"
  {
# line 2047 "FUnparse.puma"
   fprintf (f, "EXTERNAL");
  }
   return;

  case kINTENT_DECL:
  if (equalint (t->INTENT_DECL.intent, 0)) {
# line 2050 "FUnparse.puma"
  {
# line 2051 "FUnparse.puma"
   fprintf (f, "INTENT(IN)");
  }
   return;

  }
  if (equalint (t->INTENT_DECL.intent, 1)) {
# line 2054 "FUnparse.puma"
  {
# line 2055 "FUnparse.puma"
   fprintf (f, "INTENT(OUT)");
  }
   return;

  }
  if (equalint (t->INTENT_DECL.intent, 2)) {
# line 2058 "FUnparse.puma"
  {
# line 2059 "FUnparse.puma"
   fprintf (f, "INTENT(INOUT)");
  }
   return;

  }
  break;
  case kINTRINSIC_DECL:
# line 2062 "FUnparse.puma"
  {
# line 2063 "FUnparse.puma"
   fprintf (f, "INTRINSIC");
  }
   return;

  case kOPTIONAL_DECL:
# line 2066 "FUnparse.puma"
  {
# line 2067 "FUnparse.puma"
   fprintf (f, "OPTIONAL");
  }
   return;

  case kPOINTER_DECL:
# line 2070 "FUnparse.puma"
  {
# line 2071 "FUnparse.puma"
   fprintf (f, "POINTER");
  }
   return;

  case kSAVE_DECL:
# line 2074 "FUnparse.puma"
  {
# line 2075 "FUnparse.puma"
   fprintf (f, "SAVE");
  }
   return;

  case kTARGET_DECL:
# line 2078 "FUnparse.puma"
  {
# line 2079 "FUnparse.puma"
   fprintf (f, "TARGET");
  }
   return;

  case kPARAMETER_DECL:
# line 2082 "FUnparse.puma"
  {
# line 2083 "FUnparse.puma"
   fprintf (f, "PARAMETER");
  }
   return;

  case kPUBLIC_DECL:
# line 2086 "FUnparse.puma"
  {
# line 2087 "FUnparse.puma"
   fprintf (f, "PUBLIC");
  }
   return;

  case kPRIVATE_DECL:
# line 2090 "FUnparse.puma"
  {
# line 2091 "FUnparse.puma"
   fprintf (f, "PRIVATE");
  }
   return;

  case kTEMPLATE_DECL:
  if (t->TEMPLATE_DECL.DIMENSIONS->Kind == kTYPE_EMPTY) {
# line 2094 "FUnparse.puma"
  {
# line 2095 "FUnparse.puma"
   fprintf (f, "TEMPLATE");
  }
   return;

  }
# line 2098 "FUnparse.puma"
  {
# line 2099 "FUnparse.puma"
   fprintf (f, "TEMPLATE (");
# line 2100 "FUnparse.puma"
   Unparse (t->TEMPLATE_DECL.DIMENSIONS);
# line 2101 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  case kPROCESSORS_DECL:
  if (t->PROCESSORS_DECL.DIMENSIONS->Kind == kTYPE_EMPTY) {
# line 2104 "FUnparse.puma"
  {
# line 2105 "FUnparse.puma"
   fprintf (f, "PROCESSORS");
  }
   return;

  }
# line 2108 "FUnparse.puma"
  {
# line 2109 "FUnparse.puma"
   fprintf (f, "PROCESSORS (");
# line 2110 "FUnparse.puma"
   Unparse (t->PROCESSORS_DECL.DIMENSIONS);
# line 2111 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  case kALIGN_DECL:
  if (t->ALIGN_DECL.ALIGN_SOURCE->Kind == kBTE_EMPTY) {
# line 2114 "FUnparse.puma"
  {
# line 2115 "FUnparse.puma"
   fprintf (f, "ALIGN WITH ");
# line 2116 "FUnparse.puma"
   AlignSpecUnparse (t->ALIGN_DECL.ALIGN_SPEC);
  }
   return;

  }
# line 2119 "FUnparse.puma"
  {
# line 2120 "FUnparse.puma"
   fprintf (f, "ALIGN (");
# line 2121 "FUnparse.puma"
   Unparse (t->ALIGN_DECL.ALIGN_SOURCE);
# line 2122 "FUnparse.puma"
   fprintf (f, ") WITH ");
# line 2123 "FUnparse.puma"
   AlignSpecUnparse (t->ALIGN_DECL.ALIGN_SPEC);
  }
   return;

  case kDYNAMIC_DECL:
# line 2126 "FUnparse.puma"
  {
# line 2127 "FUnparse.puma"
   fprintf (f, "DYNAMIC", string);
  }
   return;

  case kDISTRIBUTE_DECL:
# line 2130 "FUnparse.puma"
  {
# line 2131 "FUnparse.puma"
   fprintf (f, "DISTRIBUTE ");
# line 2132 "FUnparse.puma"
   LayoutUnparse (t->DISTRIBUTE_DECL.DISTRIBUTION);
# line 2133 "FUnparse.puma"
 if (t->DISTRIBUTE_DECL.target != NoId())
            { GetString (t->DISTRIBUTE_DECL.target, string);
              fprintf (f," ONTO %s", string);
            }

  }
   return;

  }

# line 2140 "FUnparse.puma"
  {
# line 2141 "FUnparse.puma"
   fprintf (f, "<attribute>");
  }
   return;

;
}

static void AlignSpecUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 2156 "FUnparse.puma"

unsigned char string[256];

  if (t == NoTree) return;
  if (t->Kind == kDUMMY_VAR) {
# line 2160 "FUnparse.puma"
  {
# line 2161 "FUnparse.puma"
   fprintf (f, "*");
  }
   return;

  }
  if (t->Kind == kINDEXED_VAR) {
  if (t->INDEXED_VAR.IND_EXPS->Kind == kBTE_EMPTY) {
# line 2164 "FUnparse.puma"
  {
# line 2165 "FUnparse.puma"
   fprintf (f, "*");
# line 2166 "FUnparse.puma"
   Unparse (t->INDEXED_VAR.IND_VAR);
  }
   return;

  }
  }
# line 2169 "FUnparse.puma"
  {
# line 2170 "FUnparse.puma"
   Unparse (t);
  }
   return;

;
}

static void UseNameUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 2175 "FUnparse.puma"

unsigned char string[256];

  if (t == NoTree) return;
  if (t->Kind == kDECL_LIST) {
  if (t->DECL_LIST.Next->Kind == kDECL_EMPTY) {
# line 2179 "FUnparse.puma"
  {
# line 2180 "FUnparse.puma"
   UseNameUnparse (t->DECL_LIST.Elem);
  }
   return;

  }
# line 2183 "FUnparse.puma"
  {
# line 2184 "FUnparse.puma"
   UseNameUnparse (t->DECL_LIST.Elem);
# line 2185 "FUnparse.puma"
   fprintf (f, ", ");
# line 2186 "FUnparse.puma"
   UseNameUnparse (t->DECL_LIST.Next);
  }
   return;

  }
  if (t->Kind == kPRIVATE_DECL) {
# line 2189 "FUnparse.puma"
  {
# line 2190 "FUnparse.puma"
   fprintf (f, "PRIVATE");
  }
   return;

  }
  if (t->Kind == kPUBLIC_DECL) {
# line 2193 "FUnparse.puma"
  {
# line 2194 "FUnparse.puma"
   fprintf (f, "PUBLIC");
  }
   return;

  }
  if (t->Kind == kNAME_DECL) {
# line 2197 "FUnparse.puma"
  {
# line 2198 "FUnparse.puma"
   GetString (t->NAME_DECL.Name, string);
# line 2199 "FUnparse.puma"
   fprintf (f, "%s", string);
  }
   return;

  }
  if (t->Kind == kRENAME_DECL) {
# line 2201 "FUnparse.puma"
  {
# line 2202 "FUnparse.puma"
   GetString (t->RENAME_DECL.Name, string);
# line 2203 "FUnparse.puma"
   fprintf (f, "%s => ", string);
# line 2204 "FUnparse.puma"
   GetString (t->RENAME_DECL.oldname, string);
# line 2205 "FUnparse.puma"
   fprintf (f, "%s", string);
  }
   return;

  }
;
}

static void GenSpecUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 2210 "FUnparse.puma"

unsigned char string[256];

  if (t == NoTree) return;
  if (t->Kind == kNO_GENERIC_SPEC) {
# line 2214 "FUnparse.puma"
   return;

  }
  if (t->Kind == kID_GENERIC_SPEC) {
# line 2217 "FUnparse.puma"
  {
# line 2218 "FUnparse.puma"
   GetString (t->ID_GENERIC_SPEC.name, string);
# line 2219 "FUnparse.puma"
   fprintf (f, " %s", string);
  }
   return;

  }
  if (t->Kind == kOP_GENERIC_SPEC) {
# line 2222 "FUnparse.puma"
  {
# line 2223 "FUnparse.puma"
   fprintf (f, " OPERATOR (");
# line 2224 "FUnparse.puma"
   Unparse (t->OP_GENERIC_SPEC.OPERATOR);
# line 2225 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  }
  if (t->Kind == kASSIGN_GENERIC_SPEC) {
# line 2228 "FUnparse.puma"
  {
# line 2229 "FUnparse.puma"
   fprintf (f, "ASSIGNMENT (=)");
  }
   return;

  }
;
}

void BeginUnparse ()
{
# line 110 "FUnparse.puma"

  f = fopen ("unparse.f","w");
  indent = 0;

}

void CloseUnparse ()
{
# line 116 "FUnparse.puma"

  fclose (f);

}
