/********     Vtest C Program Source Code File (.C)	       ********/
/*								      */
/* PROGRAM NAME: Vtest	      Application (Vtest)		      */
/* -------------						      */
/* Generated by GPF (Gui Programming Facility) Version 2.1 Level(B2)  */
/*								      */
/* SUBSYSTEM:							      */
/* ----------							      */
/* Presentation Manager (32-Bit) - IBM C VisualAge		      */
/*								      */
/* DATABASE NAME: No DBM					      */
/* -------------						      */
/*								      */
/* DATE AND TIME: Fri Nov  9 19:01:03 2001			      */
/* -------------						      */
/*								      */
/* COPYRIGHT:							      */
/* ----------							      */
/* (C) 2001 Elipse Limited					      */
/*								      */
/* REVISION LEVEL: 1.0						      */
/* ---------------						      */
/*								      */
/* WHAT YOU NEED TO COMPILE THIS PROGRAM:			      */
/* --------------------------------------			      */
/*								      */
/*  REQUIRED FILES:						      */
/*  ---------------						      */
/*								      */
/*    Vtest.C	      - Source code				      */
/*    Vtest.Cmd       - Command file to build this program	      */
/*    Vtest.Mak       - Make file for this program		      */
/*    Vtest.Def       - Module definition file			      */
/*    Vtest.Ext       - External definition file		      */
/*    Vtest.H	      - Application header file 		      */
/*    Vtest.Ids       - Pm header file				      */
/*    Vtest.L	      - Linker automatic response file		      */
/*    Vtest.Rc	      - Resource file				      */
/*								      */
/*    OS2.H	      - Presentation Manager include file	      */
/*    STDLIB.H	      - Miscellaneous function declarations	      */
/*    STDIO.H	      - Declarations for standard I/O routines	      */
/*    STRING.H	      - String function declarations		      */
/*    MALLOC.H	      - Definitions for memory allocation functions   */
/*    PROCESS.H       - Definitions for process control functions     */
/*								      */
/*  REQUIRED LIBRARIES: 					      */
/*  ------------------- 					      */
/*								      */
/*    OS2386.LIB      - Presentation  Manager/OS2 library	      */
/*								      */
/*  REQUIRED PROGRAMS:						      */
/*  ------------------						      */
/*								      */
/*    C Compiler (32-Bit)					      */
/*    Linker (32-Bit)						      */
/*    Resource Compiler (32-Bit)				      */
/*								      */
/**********************************************************************/

/**********************************************************************/
/*								      */
/* Include relevant sections of the DOS header file.		      */
/*								      */
/**********************************************************************/

/*====================================================================*/
/*								      */
/*   #define:		     To include:			      */
/*								      */
/* + INCL_DOSPROCESS	     Process and thread support 	      */
/* + INCL_DOSFILEMGR	     File Management			      */
/* + INCL_DOSMEMMGR	     Memory Management			      */
/* + INCL_DOSSEMAPHORES      Semaphore support			      */
/* + INCL_DOSDATETIME	     Date/Time and Timer support	      */
/*   INCL_DOSMODULEMGR	     Module manager			      */
/* + INCL_DOSRESOURCES	     Resource support			      */
/*   INCL_DOSNLS	     National Language Support		      */
/*   INCL_DOSSIGNALS	     Signals				      */
/*   INCL_DOSMISC	     Miscellaneous			      */
/*   INCL_DOSMONITORS	     Monitors				      */
/*   INCL_DOSQUEUES	     Queues				      */
/*   INCL_DOSSESMGR	     Session Manager Support		      */
/*   INCL_DOSDEVICES	     Device specific, ring 2 support	      */
/*   INCL_DOSNMPIPES	     Named Pipes Support		      */
/*   INCL_DOSPROFILE	     DosProfile API			      */
/*   INCL_DOSMVDM	     MVDM support			      */
/*   INCL_DOSEXCEPTIONS      Exception Management Support	      */
/**********************************************************************/

/**********************************************************************/
/*								      */
/* Include relevant sections of the PM header file.		      */
/*								      */
/**********************************************************************/

/*====================================================================*/
/*								      */
/*   #define:		     To include:			      */
/*								      */
/* + INCL_WINWINDOWMGR	     General window management		      */
/* + INCL_WINMESSAGEMGR      Message management 		      */
/* + INCL_WININPUT	     Mouse and keyboard input		      */
/* + INCL_WINDIALOGS	     Dialog boxes			      */
/* + INCL_WINSTATICS	     Static controls			      */
/* + INCL_WINBUTTONS	     Button controls			      */
/* + INCL_WINENTRYFIELDS     Entry Fields			      */
/*   INCL_WINMLE	     Multiple Line Entry Fields 	      */
/* + INCL_WINLISTBOXES	     List box controls			      */
/* + INCL_WINMENUS	     Menu controls			      */
/* + INCL_WINSCROLLBARS      Scroll bar controls		      */
/* + INCL_WINFRAMEMGR	     Frame manager			      */
/*   INCL_WINFRAMECTLS	     Frame controls (title bars & size border)*/
/*   INCL_WINRECTANGLES      Rectangle routines 		      */
/*   INCL_WINSYS	     System values (and colors) 	      */
/*   INCL_WINTIMER	     Timer routines			      */
/* + INCL_WINACCELERATORS    Keyboard accelerators		      */
/*   INCL_WINTRACKRECT	     WinTrackRect() function		      */
/*   INCL_WINCLIPBOARD	     Clipboard manager			      */
/* + INCL_WINCURSORS	     Text cursors			      */
/* + INCL_WINPOINTERS	     Mouse pointers			      */
/*   INCL_WINHOOKS	     Hook manager			      */
/* + INCL_WINSWITCHLIST      Shell Switch List API		      */
/*   INCL_WINPROGRAMLIST     Shell Program List API		      */
/*   INCL_WINSHELLDATA	     Shell Data (?)			      */
/*   INCL_WINCOUNTRY	     Country support			      */
/*   INCL_WINATOM	     Atom Manager			      */
/*   INCL_WINCATCHTHROW      WinCatch/WinThrow support		      */
/*   INCL_WINERRORS	     Error code definitions		      */
/*   INCL_NLS		     DBCS window manager definition	      */
/* + INCL_WINHELP	     Help Manager definitions		      */
/*   INCL_WINSEI	     Set Error Info API 		      */
/*   INCL_WINLOAD	     Load/Delete Library/Procedure	      */
/*   INCL_WINTYPES	     Definitions for Datatypes		      */
/*   INCL_WINSTDDLGS	     OS/2 Standard Dialog definitions	      */
/*								      */
/* ===================================================================*/
/*								      */
/* INCL_GPI		   Include all of the GPI		      */
/* INCL_GPICONTROL	   Basic PS control			      */
/* INCL_GPICORRELATION	   Picking, Boundary and Correlation	      */
/* INCL_GPISEGMENTS	   Segment Control and Drawing		      */
/* INCL_GPISEGEDITING	   Segment Editing via Elements 	      */
/* INCL_GPITRANSFORMS	   Transform and Transform Conversion	      */
/* INCL_GPIPATHS	   Paths and Clipping with Paths	      */
/* INCL_GPILOGCOLORTABLE   Logical Color Tables 		      */
/* INCL_GPIPRIMITIVES	   Drawing Primitives and Primitive Attributes*/
/* INCL_GPILCIDS	   Phyical and Logical Fonts with Lcids       */
/* INCL_GPIBITMAPS	   Bitmaps and Pel Operations		      */
/* INCL_GPIREGIONS	   Regions and Clipping with Regions	      */
/* INCL_GPIMETAFILES	   Metafiles				      */
/* INCL_GPIDEFAULTS	   Default Primitive Attributes 	      */
/* INCL_GPIERRORS	   defined if INCL_ERRORS defined	      */
/*								      */
/**********************************************************************/

#define INCL_DOS		/*   Need DOS support		      */
#define INCL_DOSERRORS
#define INCL_DOSEXCEPTIONS	/*   Exception Management Support     */

#define INCL_WINWINDOWMGR	/*   General window management	      */
#define INCL_WINMESSAGEMGR	/*   Message management 	      */
#define INCL_WININPUT		/*   Mouse and keyboard input	      */
#define INCL_WINDIALOGS 	/*   Dialog boxes		      */
#define INCL_WINSTATICS 	/*   Static controls		      */
#define INCL_WINBUTTONS 	/*   Button controls		      */
#define INCL_WINENTRYFIELDS	/*   Entry Fields		      */
#define INCL_WINMLE		/*   Multiple Line Entry Fields       */
#define INCL_WINLISTBOXES	/*   List box controls		      */
#define INCL_WINMENUS		/*   Menu controls		      */
#define INCL_WINSCROLLBARS	/*   Scroll bar controls	      */
#define INCL_WINFRAMEMGR	/*   Frame manager		      */
#define INCL_WINRECTANGLES	/*   Rectangle routines 	      */
#define INCL_WINSYS		/*   System values (and colors)       */
#define INCL_WINACCELERATORS	/*   Keyboard accelerators	      */
#define INCL_WINCLIPBOARD	/*   Clipboard manager		      */
#define INCL_WINCURSORS 	/*   Text cursors		      */
#define INCL_WINPOINTERS	/*   Mouse pointers		      */
#define INCL_WINSWITCHLIST	/*   Shell Switch List API	      */
#define INCL_WINPROGRAMLIST	/*   Shell Program List API	      */
#define INCL_WINSHELLDATA	/*   Shell Data (?)		      */
#define INCL_WINERRORS		/*   Error code definitions	      */
#define INCL_WINHELP		/*   Help Manager definitions	      */
#define INCL_WINTIMER		/*   Timer routines		      */
#define INCL_WINSTDDLGS 	/*   OS/2 Standard Dialog definitions */

#define INCL_GPIPRIMITIVES	/*   Drawing Primitives and Attributes*/
#define INCL_GPILCIDS		/*   Phyical and Logical Fonts Lcids  */
#define INCL_GPIBITMAPS 	/*   Bitmaps and Pel Operations       */

#include <os2.h>		/* Presentation Manager include file  */

/**********************************************************************/
/*								      */
/* Include C library routine header files			      */
/*								      */
/**********************************************************************/

#include <stdlib.h>	 /* Miscellaneous function declarations       */
#include <stdio.h>	 /* Declarations for standard I/O routines    */
#include <string.h>	 /* String function declarations	      */
#include <malloc.h>	 /* Definitions for memory allocation	      */
#include <process.h>	 /* Definitions for process control functions */

/**********************************************************************/
/*								      */
/*  Miscellaneous constants					      */
/*								      */
/**********************************************************************/

#define EXTRAWORDS (4 * sizeof(PVOID))	/* Extra window words	      */
#define GPF_P2C_LEVEL 2 		/* GpfP2C.lib Level	      */
#define COMMAND       0 /* Process commands received from the user    */
#define EXTERN
#define STACKSIZE 40960

/**********************************************************************/
/*								      */
/* Miscellaneous constants Ids					      */
/*								      */
/**********************************************************************/

#include "Vtest.Ids"

/**********************************************************************/
/*								      */
/* Function prototypes for C functions				      */
/*								      */
/**********************************************************************/

#include "Vtest.Ext"

/**********************************************************************/
/*								      */
/* STATIC Function prototypes for private C functions		      */
/*								      */
/**********************************************************************/

static	VOID InitializeApplication( VOID );
static	VOID EndApplication( VOID );
static	VOID ActionPushButtonSend( PGPFPARMS pGpfParms );
static	VOID ActionPushButtonExit( PGPFPARMS pGpfParms );
static	MRESULT ProcessMainWindow( PGPFPARMS pGpfParms );
static	VOID CommandMainWindow( PGPFPARMS pGpfParms );

/**********************************************************************/
/*								      */
/* Miscellaneous constants Vtest.H				      */
/*								      */
/**********************************************************************/

#include "Vtest.H"


/****************** Start of main procedure ***************************/
/**********************************************************************/
/*								      */
/*  FUNCTION: main						      */
/*								      */
/*  This is a typical PM main function. 			      */
/*  It initializes PM, creates a message queue, loads some strings ,  */
/*  registers some window classes, creates a main window, gets and    */
/*  dispatches messages to its window procedure until the time to     */
/*  quit, and then tidies up before terminating.		      */
/*								      */
/*  It sets the values of the following globals:-		      */
/*								      */
/*  habMainTask, hwndFrameMainWindow, hwndMainWindow		      */
/*								      */
/**********************************************************************/

INT _CENTRY main( LONG argc, PCHAR *argv )
{
 QMSG	  qmsg; 		      /* Message structure	      */
 PID	  Pid;			      /* Process Id		      */
 TID	  Tid;			      /* Thread Id		      */
 HELPINIT hinit;		      /* Help init		      */
 HPOINTER hptrIcon;		      /* Handle of the Icon	      */

  Argc = argc;
  Argv = argv;

  hmodVtest	  = (HMODULE)NULL;   /* hMod Inline		      */
  hwndHelp	  = (HWND)0;	     /* Help Hwnd		      */
  szTaskList	  = (PCHAR)"Vtest";
  EndOfAppl	  = FALSE;	     /* Switch Accept End Application */
  Vtest_Level = (PCHAR)"1.0";

  /********************************************************************/
  /* Initialize PM and Create application msg queue		      */
  /********************************************************************/
				      /* Initialize PM		      */
  habMainTask = WinInitialize( 0 );
				      /* Create application msg queue */
  hmqMainTask = WinCreateMsgQueue( habMainTask, 1024 );

  WinSetPointer( HWND_DESKTOP,
		 WinQuerySysPointer( HWND_DESKTOP, SPTR_WAIT,FALSE ) );

  /********************************************************************/
  /* Query System preferences set by the user from the Control Panel  */
  /********************************************************************/

  LogoTimer = PrfQueryProfileInt( HINI_PROFILE,
		   (PSZ)"PM_ControlPanel", (PSZ)"LogoDisplayTime", -1 );
  PrfQueryProfileString( HINI_PROFILE, (PSZ)"PM_National", (PSZ)"sDecimal",
				 (PSZ)".", sDecimal, sizeof(sDecimal) );
  strncpy( Swctl.szSwtitle, szTaskList, sizeof(Swctl.szSwtitle)-1 );

  /********************************************************************/
  /*   Initialize Application					      */
  /********************************************************************/

  InitializeApplication();

  /********************************************************************/
  /* Initialize the help manager initialization structure, create an  */
  /* instance of the help manager, and associate that instance with   */
  /* the frame. 						      */
  /********************************************************************/
				 /* size of initialization structure  */
  hinit.cb			 = sizeof(hinit);
				 /* store HM return code from init.   */
  hinit.ulReturnCode		 = (ULONG)NULL;
				 /* no tutorial program 	      */
  hinit.pszTutorialName 	 = (PSZ)NULL;
				 /* indicates help table is defined   */
				 /* in the RC file.		      */
  hinit.phtHelpTable		 = (PHELPTABLE)(0xFFFF0000 |
				   ID_VTEST);
				  /* help table in Exe or a DLL       */
  hinit.hmodHelpTableModule	 = hmodVtest;
  hinit.hmodAccelActionBarModule = (HMODULE)NULL;
  hinit.idAccelTable		 = (USHORT)NULL;
				  /* action bar is not tailored       */
  hinit.idActionBar		 = (USHORT)NULL;
				  /* help window title		      */
  hinit.pszHelpWindowTitle	 = (PSZ)szTaskList;
				 /* help panels ID is not displayed   */
  hinit.fShowPanelId		 = CMIC_HIDE_PANEL_ID;
				  /* library with help panels	      */
  hinit.pszHelpLibraryName	 = (PSZ)"Vtest.Hlp";

  /********************************************************************/
  /* Control Gpf Library Level					      */
  /********************************************************************/
  if (GpfP2CLevel() != GPF_P2C_LEVEL)
     {
      WinMessageBox( HWND_DESKTOP, HWND_DESKTOP,
		     (PSZ) "Gpf Verion Error",
		     (PSZ) "Invalid P2C Level",
		     1,
		     MB_OK | MB_APPLMODAL | MB_MOVEABLE );
      WinDestroyMsgQueue( hmqMainTask );
      WinTerminate( habMainTask );
      DosExit( EXIT_PROCESS, 0 );
     }
  /********************************************************************/
  /* Create Instance of IPF, pass Anchor Block handle and address of  */
  /* of IPF initialization structure, and check  that creation was    */
  /* successful.						      */
  /********************************************************************/
  hwndHelp = WinCreateHelpInstance( habMainTask, &hinit );
  if (!hwndHelp)
     {
      WinMessageBox( HWND_DESKTOP, HWND_DESKTOP,
		     (PSZ) "Help Not Available",
		     (PSZ) "Help Creation Error",
		     1,
		     MB_OK | MB_APPLMODAL | MB_MOVEABLE );
     }
  else
     {
      if (hinit.ulReturnCode)
	 {
	  WinMessageBox( HWND_DESKTOP, HWND_DESKTOP,
			 (PSZ) "Help Terminated Due to Error",
			 (PSZ) "Help Creation Error",
			 1,
			 MB_OK | MB_APPLMODAL | MB_MOVEABLE );
	  WinDestroyHelpInstance( hwndHelp );
	  hwndHelp = (HWND)NULL;
	 }
     }

  /********************************************************************/
  /*   Create the window "MainWindow".				      */
  /********************************************************************/
  CreateMainWindow( (PVOID) NULL );

  /********************************************************************/
  /* Make sure the window was created.				      */
  /********************************************************************/
  if ((!hwndFrameMainWindow) || (!hwndMainWindow))
     {
      WinDestroyMsgQueue( hmqMainTask );
      WinTerminate( habMainTask );
      DosExit( EXIT_PROCESS, 0 );
     }

  hptrIcon = (HPOINTER) WinSendMsg( hwndFrameMainWindow,
			     WM_QUERYICON, (MPARAM)NULL, (MPARAM)NULL );
  /********************************************************************/
  /* Set the window title (Task List)				      */
  /********************************************************************/
  WinQueryWindowProcess( hwndFrameMainWindow, &Pid, &Tid );
  Swctl.hwnd = hwndFrameMainWindow;
  Swctl.hwndIcon = hptrIcon;
  Swctl.hprog = (HPROGRAM)NULL;
  Swctl.idProcess = Pid;
  Swctl.idSession = (USHORT)NULL;
  Swctl.uchVisibility = SWL_VISIBLE;
  Swctl.fbJump = SWL_JUMPABLE;
  strncpy( Swctl.szSwtitle, szTaskList, sizeof(Swctl.szSwtitle)-1 );
  hSwitch = WinAddSwitchEntry( &Swctl );

  /********************************************************************/
  /*   Show the window "MainWindow".				      */
  /********************************************************************/
  ShowMainWindow( (PVOID) NULL );		/* Show Main Window   */

  /********************************************************************/
  /* Main message-processing loop - get and dispatch messages until   */
  /* WM_QUIT received and Accepted (EndOfAppl = TRUE)		      */
  /********************************************************************/

  while(!EndOfAppl)
       {
	if (! WinGetMsg( habMainTask, &qmsg, (HWND)NULL, 0, 0 ) )
	    EndApplication();
	else
	    WinDispatchMsg( habMainTask, &qmsg );
       }

  /********************************************************************/
  /* Tidy up and terminate					      */
  /********************************************************************/

  WinDestroyWindow( hwndFrameMainWindow );
  if (hwndHelp != (HWND)NULL)
      WinDestroyHelpInstance( hwndHelp );
  WinDestroyMsgQueue( hmqMainTask );
  WinTerminate( habMainTask );

  /********************************************************************/
  /* Dos Exit							      */
  /********************************************************************/
  DosExit( EXIT_PROCESS, 0 );
  return(0);
}
/**********************************************************************/
/* End of main procedure					      */
/**********************************************************************/
/**********************************************************************/


/**********************************************************************/
/**********************************************************************/
/*								      */
/*  WinProc: GpfDefWindowProc					      */
/*								      */
/*  Controls the "DefaultWindowProc" Area.			      */
/*								      */
/*								      */
/**********************************************************************/

MRESULT EXPENTRY GpfDefWindowProc(
			  HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
  LONG	    Color;		   /* Work BackGround Color	      */
  PGPFPARMS pGpfParms;		   /* Far Pointer		      */
  SHORT     Short;		   /* Work Short		      */

  /********************************************************************/
  /* Initialize Gpf Parameters					      */
  /********************************************************************/
  pGpfParms = (PGPFPARMS) WinQueryWindowULong( hwnd, QWL_USER );
  if (!pGpfParms)
      return WinDefWindowProc( hwnd, msg, mp1, mp2 );

  switch(msg)
  {

	/**************************************************************/
	/* Things to do when the Window is first initalized	      */
	/**************************************************************/
   case WM_INITDLG:
	/**************************************************************/
	/*  Save CreateUserParms				      */
	/**************************************************************/
	pGpfParms->pCrtParms = (PVOID)mp2;
	/**************************************************************/
	/*  Associate Help Instance				      */
	/**************************************************************/
	WinAssociateHelpInstance( hwndHelp, GpfGetHwndFrame( hwnd ) );
	/**************************************************************/
	/*  Save Default Button 				      */
	/**************************************************************/
	pGpfParms->hwndDefaultBtn = GpfQueryDefaultButton( hwnd );
	/**************************************************************/
	/*  Set Default BackGroundColor 			      */
	/**************************************************************/
	pGpfParms->BgColor = SYSCLR_WINDOW;
	/**************************************************************/
	/*  Query Presentation Parameters BackGroundColor	      */
	/**************************************************************/
	if (WinQueryPresParam( hwnd, PP_BACKGROUNDCOLOR,
			       (ULONG)NULL, (PULONG)NULL,
			       4L, &Color, (USHORT)NULL ) )
	    pGpfParms->BgColor = Color;
	/**************************************************************/
	/*  Query Presentation Parameters BackGroundColor Index       */
	/**************************************************************/
	if (WinQueryPresParam( hwnd, (ULONG)NULL,
			       PP_BACKGROUNDCOLORINDEX, (PULONG)NULL,
			       4L, &Color, QPF_ID1COLORINDEX))
	   pGpfParms->BgColor = Color;
	/**************************************************************/
	/*  Set Default ForeGroundColor 			      */
	/**************************************************************/
	pGpfParms->FgColor = SYSCLR_WINDOWTEXT;
	/**************************************************************/
	/*  Query Presentation Parameters ForeGroundColor	      */
	/**************************************************************/
	if (WinQueryPresParam( hwnd, PP_FOREGROUNDCOLOR,
			       (ULONG)NULL, (PULONG)NULL,
			       4L, &Color, (USHORT)NULL ) )
	    pGpfParms->FgColor = Color;
	/**************************************************************/
	/*  Query Presentation Parameters ForeGroundColor Index       */
	/**************************************************************/
	if (WinQueryPresParam( hwnd, (ULONG)NULL,
			       PP_FOREGROUNDCOLORINDEX, (PULONG)NULL,
		       4L, &Color, QPF_ID1COLORINDEX ) )
	   pGpfParms->FgColor = Color;
	/**************************************************************/
	/*  Return pGpfParms Mresult				      */
	/**************************************************************/
	return (pGpfParms->mresult);

	/**************************************************************/
	/* The application has asked for the window to be destroyed.  */
	/**************************************************************/
   case WM_DESTROY:
	GpfDestroyTemplate( hwnd );	       /* Destroy Template    */
	WinSetWindowULong( hwnd, QWL_USER, (ULONG)NULL );
				 /* Extract selector from far pointer */
	free( pGpfParms );		       /* FreeMain (GpfParms) */
	break;

	/**************************************************************/
	/* Let frame control erase background for us		      */
	/**************************************************************/
   case WM_ERASEBACKGROUND:
		    /* The client window is cleared to SYSCLR_WINDOW. */
	return (MRESULT)(FALSE);	   /*  No background windows. */

       /***************************************************************/
       /* The window needs painting.				      */
       /***************************************************************/
   case WM_PAINT:
	Short = pGpfParms->ShortMsgId;		       /* Save	MsgId */
	pGpfParms->ShortMsgId = -1;		       /* Reset MsgId */
	GpfSendMsgInformation( pGpfParms, Short );
	return WinDefWindowProc( hwnd, msg, mp1, mp2 );

	/**************************************************************/
	/*  Resize & Reposition all the BASE windows.		      */
	/*  WM_SIZE message was generated when window was created.    */
	/**************************************************************/
   case WM_SIZE:
	if (pGpfParms->Options & GPF_OP_ADJUSTSIZE)
	    GpfAdjustControlSize( hwnd, mp1, mp2 ); /* Adjust Size    */
	return WinDefWindowProc( hwnd, msg, mp1, mp2 );

	/**************************************************************/
	/* Receive Char ( Set Tabulation )			      */
	/**************************************************************/
   case WM_CHAR:
	pGpfParms->mresult = GpfSetTabulation( hwnd, msg, mp1, mp2 );
	Short = WinQueryWindowUShort( WinQueryFocus( HWND_DESKTOP ),
				      QWS_ID );
	if (!pGpfParms->mresult)
	   {
	    if (pGpfParms->pGpfPage)
		WinSendMsg(pGpfParms->pGpfPage->hwndNoteBook,
			   msg, mp1, mp2 );
	   }
	GpfSendMsgInformation( pGpfParms, Short );
	return (pGpfParms->mresult);

	/**************************************************************/
	/* Process MouseMove for Information Msg		      */
	/**************************************************************/
   case WM_MOUSEMOVE:
	Short = WinQueryWindowUShort( GpfGetHwndFrame( hwnd ),QWS_ID );
	GpfSendMsgInformation( pGpfParms, Short );
	return WinDefWindowProc( hwnd, msg, mp1, mp2 );

	/**************************************************************/
	/* Process ControlPointer for Information Msg		      */
	/**************************************************************/
   case WM_CONTROLPOINTER:
	if (WinWindowFromID( hwnd, SHORT1FROMMP(mp1) ) )
	    GpfSendMsgInformation( pGpfParms, SHORT1FROMMP(mp1));
	return WinDefWindowProc( hwnd, msg, mp1, mp2 );

	/**************************************************************/
	/* Process MenuSelected for Information Msg		      */
	/**************************************************************/
   case WM_MENUSELECT:
	GpfSendMsgInformation( pGpfParms, SHORT1FROMMP(mp1));
	return WinDefWindowProc( hwnd, msg, mp1, mp2 );

	/**************************************************************/
	/* Process MenuEnd for Information Msg			      */
	/**************************************************************/
   case WM_MENUEND:
	if (SHORT1FROMMP(mp1) == FID_MENU)
	   {
	    pGpfParms->ShortMsgId = -1; 	       /* Reset MsgId */
	    GpfSendMsgInformation( pGpfParms, 0);
	   }
	return WinDefWindowProc( hwnd, msg, mp1, mp2 );

	/**************************************************************/
	/* Things to do when the Window is Moved		      */
	/**************************************************************/
   case WM_MOVE:
	return WinDefWindowProc( hwnd, msg, mp1, mp2 );

       /***************************************************************/
       /*  The List Box needs to know how big to make an Item.	      */
       /***************************************************************/
   case WM_MEASUREITEM:
	return (MRESULT)GpfMeasureItem( hwnd, mp1, mp2 );

	/**************************************************************/
	/*  The List Box wants us to Draw an Item		      */
	/**************************************************************/
   case WM_DRAWITEM:
	return (MRESULT)GpfDrawItem( hwnd, mp1, mp2 );

	/**************************************************************/
	/* Things to do when the Window is End LogoTimer	      */
	/**************************************************************/
   case WM_TIMER:
	if (SHORT1FROMMP(mp1) != TID_USERMAX)	/* LogoTimer...       */
	    break;				/* No... Ignore Timer */
	WinStopTimer( WinQueryAnchorBlock( hwnd ),
		     hwnd, TID_USERMAX );	/* Stop LogoTimer     */
	/**************************************************************/
	/* Simulate CANCEL - Post WM_CLOSE to Window		      */
	/**************************************************************/
	WinPostMsg( hwnd, WM_CLOSE, (MPARAM)NULL, (MPARAM)NULL );
	break;

   case HM_HELPSUBITEM_NOT_FOUND:
	/**************************************************************/
	/* Help manager couldn't find a help panel for an item.       */
	/* Returning FALSE will display the extended help for that    */
	/* window.						      */
	/* Returning TRUE Tells the Help Manager to do nothing.       */
	/**************************************************************/
	Short = WinQueryWindowUShort( GpfGetHwndFrame( hwnd ),QWS_ID );
	if (SHORT1FROMMP(mp1) == 0xFFFD)		 /* HLPM_MENU */
	   {
	    if (WinSendMsg( hwndHelp, HM_DISPLAY_HELP,
			    MPFROMSHORT(SHORT1FROMMP(mp2)),
			    MPFROMSHORT(HM_RESOURCEID) ))
		if (WinSendMsg( hwndHelp, HM_DISPLAY_HELP,
				MPFROMSHORT(Short),
				MPFROMSHORT(HM_RESOURCEID) ))
		    WinSendMsg( hwndHelp, HM_DISPLAY_HELP,
				MPFROMSHORT( ID_VTEST ),
				MPFROMSHORT(HM_RESOURCEID) );
	   }
	else
	   {
	    if (WinSendMsg( hwndHelp, HM_DISPLAY_HELP,
			    MPFROMSHORT(SHORT1FROMMP(mp2)),
			    MPFROMSHORT(HM_RESOURCEID) ))
	       GpfDisplayHelp( WinQueryFocus( HWND_DESKTOP ));
	   }
	return (MRESULT)(TRUE);

   case HM_QUERY_KEYS_HELP:
	/**************************************************************/
	/* Return Keys help panel ID for the help manager	      */
	/**************************************************************/
	/**************************************************************/
	/*     QUERY_KEYS_HELP					      */
	/*							      */
	/* If the user requests KEYS HELP from the help pull-down,    */
	/* IPF sends the HM_QUERY_KEYS_HELP message to the application*/
	/* which should return the panel id of the keys_help panel,   */
	/* or a 0 to tell IPF to do nothing.			      */
	/**************************************************************/
	return (MRESULT)(ID_VTEST - 1);

    case HM_EXT_HELP_UNDEFINED:
	 /*************************************************************/
	 /* This message is sent to the application by Help Manager   */
	 /* to notify it that an extended help panel has not been     */
	 /* defined.						      */
	 /*************************************************************/
	 WinSendMsg( hwndHelp, HM_DISPLAY_HELP,
		     MPFROMSHORT( ID_VTEST ),
		     MPFROMSHORT( HM_RESOURCEID ) );
	 return ((MRESULT) FALSE);

    case HM_ERROR:
	 /*************************************************************/
	 /* If an error occurs using IPF, an HM_ERROR msg will be     */
	 /* sent to the application.				      */
	 /*************************************************************/
	 if ( (ULONG) mp1 == HMERR_NO_MEMORY )
	    {
	     WinMessageBox( HWND_DESKTOP, hwnd,
			    (PSZ) "Help Terminated Due to Error",
			    (PSZ) "Help Error",
			    1,
			    MB_OK | MB_APPLMODAL | MB_MOVEABLE );
	     WinDestroyHelpInstance( hwndHelp );
	     hwndHelp = (HWND)NULL;
	    }
	 return ((MRESULT) FALSE);

       /***************************************************************/
       /* Other messages are handled by the default window procedure. */
       /***************************************************************/
   default:
	/* Pass all other messages to the default window procedure    */
	return WinDefWindowProc( hwnd, msg, mp1, mp2 );
  }
  return ((MRESULT) FALSE);
}
/**********************************************************************/
/* End of window procedure - WinProc: GpfDefWindowProc		      */
/**********************************************************************/
/**********************************************************************/


/**********************************************************************/
/**********************************************************************/
/*								      */
/*  FUNCTION : GpfDisplayHelp					      */
/*								      */
/**********************************************************************/

VOID APIENTRY GpfDisplayHelp( HWND hwnd )
{
  HWND	    hwndDesktop;	/* hwnd Desktop 	       */
  HWND	    hwndWrk;		/* hwnd Work		       */
  USHORT    uShort;		/* Work uShort		       */
  HAB	    hab;		/* Anchor block handle	       */

   hab = WinQueryAnchorBlock(hwnd);
   if ((!hab) || (!hwndHelp))	/* Verify hwnd, hab, and hwndHelp     */
       return;
   hwndWrk = hwnd;
   hwndDesktop = WinQueryDesktopWindow(hab,(HDC)NULL);
   while(hwndWrk != hwndDesktop)
	{
	 uShort = WinQueryWindowUShort(hwndWrk,QWS_ID);
	 if ( uShort != FID_CLIENT )
	    {
	     if (!WinSendMsg( hwndHelp, HM_DISPLAY_HELP,
			      MPFROMSHORT(uShort),
			      MPFROMSHORT(HM_RESOURCEID) ))
		 return;
	    }
	 hwndWrk = WinQueryWindow( hwndWrk, QW_PARENT);
	}
   WinSendMsg( hwndHelp, HM_DISPLAY_HELP,
	       MPFROMSHORT( ID_VTEST ),
	       MPFROMSHORT( HM_RESOURCEID ) );
   return;
}
/**********************************************************************/
/* End of GpfDisplayHelp Function				      */
/**********************************************************************/
/**********************************************************************/



/******************* Start of GpfSendMsg Function *********************/
/**********************************************************************/
/*								      */
/* FUNCTION : GpfSendMsg					      */
/*								      */
/* Display, and operate the message box window			      */
/**********************************************************************/
SHORT APIENTRY GpfSendMsg( SHORT Id )
{
 CHAR	   String[256];
 HWND	   SysModalWindow;
 HWND	   hwndActive;		   /* Query Active Window (ApplModal) */
 USHORT    Reply = 0;
 SHORT	   Alarm = -1;
 SHORT	   Style = 0;
 PCHAR	   Token1 = 0;
 PCHAR	   Token2 = 0;

 /*********************************************************************/
 /* Save Window (System Modal)					      */
 /*********************************************************************/
 SysModalWindow = WinQuerySysModalWindow( HWND_DESKTOP );

 /*********************************************************************/
 /* Load Msg strings						      */
 /*********************************************************************/
 WinLoadString( habMainTask, hmodVtest,
		Id, sizeof(String),(PSZ)String );

 Token1 = strchr( String, ':' );
 if (Token1)
    {
     *Token1 = 0;
     Alarm = atoi( String );
     Token2 = strchr( ++Token1, ' ' );
     if (Token2)
	{
	 *(Token2++) = 0;
	 Style = atoi( Token1 );
	 /*************************************************************/
	 /* Set Alarm						      */
	 /*************************************************************/
	 if (Alarm != -1)
	     WinAlarm( HWND_DESKTOP, Alarm );
	 /*************************************************************/
	 /* Query HwndOwner					      */
	 /*************************************************************/
	 hwndActive = WinQueryActiveWindow( HWND_DESKTOP );
	 /*************************************************************/
	 /* Now, display the message, save the button press for a     */
	 /* return code.					      */
	 /* Pop up a Message box.				      */
	 /*************************************************************/
	 Reply = WinMessageBox( HWND_DESKTOP, hwndActive,
			(PSZ) Token2, (PSZ)Swctl.szSwtitle, Id, Style );
	 /*************************************************************/
	 /* Restore Window (System Modal)			      */
	 /*************************************************************/
	 WinSetSysModalWindow( HWND_DESKTOP, SysModalWindow );
	 /*************************************************************/
	 /* Reset Information Message				      */
	 /*************************************************************/
	 hwndActive = WinWindowFromID( hwndActive, FID_CLIENT );
	 WinPostMsg( hwndActive, WM_MOUSEMOVE,
		     (MPARAM) NULL, (MPARAM) NULL );
	}
    }
 return(Reply);
}

/**********************************************************************/
/* End of GpfSendMsg Function					      */
/**********************************************************************/
/**********************************************************************/




/**********************************************************************/
/**********************************************************************/
/*								      */
/*   STATIC PRIVATE FUNCTION: Initialize Application		      */
/*								      */
/**********************************************************************/

static VOID InitializeApplication( VOID )
 {
	GpfInitThread(habMainTask,hmqMainTask);
	GpfGetVunitHunit(&Vunits,&Hunits);
	return;

 }
/**********************************************************************/
/* End of Private Function: Initialize Application		      */
/**********************************************************************/
/**********************************************************************/



/**********************************************************************/
/**********************************************************************/
/*								      */
/*   STATIC PRIVATE FUNCTION: End Application			      */
/*								      */
/**********************************************************************/

static VOID EndApplication( VOID )
 {
	EndOfAppl = TRUE;
	return;
 }
/**********************************************************************/
/* End of Private Function: End Application			      */
/**********************************************************************/
/**********************************************************************/


/**********************************************************************/
/**********************************************************************/
/*								      */
/*   FUNCTION: ShowMainWindow					      */
/*								      */
/*   Show Window "MainWindow".					      */
/*								      */
/**********************************************************************/

BOOL APIENTRY ShowMainWindow( PVOID pCrtParms )
 {
  GpfExecAsyncProc((PFNASYNCPROC)AsynShowMainWindow,
		    pCrtParms,hmqMainTask);
  return(FALSE);
 }
/**********************************************************************/
/* End of ShowMainWindow Function				      */
/**********************************************************************/
/**********************************************************************/



/**********************************************************************/
/**********************************************************************/
/*								      */
/*   FUNCTION: AsynShowMainWindow				      */
/*								      */
/*   AsynShow Window "MainWindow".				      */
/*								      */
/**********************************************************************/

VOID APIENTRY AsynShowMainWindow( PVOID pCrtParms )
 {
			     /* Make sure the window was not created. */
   if (!hwndFrameMainWindow)
	CreateMainWindow( pCrtParms );

   WinSetWindowPos( hwndFrameMainWindow,
		    HWND_TOP, 0, 0, 0, 0,
		    SWP_ZORDER | SWP_ACTIVATE | SWP_SHOW );
   WinShowWindow( hwndMainWindow, TRUE );

   return;
 }
/**********************************************************************/
/* End of AsynShowMainWindow Function				      */
/**********************************************************************/
/**********************************************************************/



/**********************************************************************/
/**********************************************************************/
/*								      */
/*   FUNCTION: DismissMainWindow				      */
/*								      */
/*   Dismiss Window Hide - Window "MainWindow". 		      */
/*								      */
/**********************************************************************/

VOID APIENTRY DismissMainWindow( BOOL Rcode )
 {

   Rcode = Rcode;  /* Null , For Delete Unreferenced Formal Parameter */
						       /* Hide Window */
   WinSetWindowPos( hwndFrameMainWindow,
		    (HWND)NULL, 0, 0, 0, 0,
		    SWP_DEACTIVATE | SWP_HIDE );
   WinShowWindow( hwndMainWindow, FALSE );

   return;
 }
/**********************************************************************/
/* End of DismissMainWindow Function				      */
/**********************************************************************/
/**********************************************************************/



/**********************************************************************/
/**********************************************************************/
/*								      */
/*   FUNCTION: CreateMainWindow 				      */
/*								      */
/*   Create the window "MainWindow" And Controls.		      */
/*								      */
/**********************************************************************/

HWND APIENTRY CreateMainWindow( PVOID pCrtParms )
 {
  /********************************************************************/
  /*   Register the window class "MainWindow".			      */
  /********************************************************************/
  WinRegisterClass(			     /* Register window class */
	  habMainTask,			     /* Anchor block handle   */
	  (PSZ)"MainWindow",		     /* Window class name     */
	  (PFNWP)fnwpMainWindow,	     /* Address window proc   */
	  CS_CLIPSIBLINGS | CS_SAVEBITS |    /* Class style	      */
	  CS_MOVENOTIFY |		     /* Class style	      */
	  CS_SIZEREDRAW | CS_SYNCPAINT,      /* Class style	      */
	  EXTRAWORDS			     /* Extra window words    */
	  );

  /********************************************************************/
  /*   Create the window "MainWindow".				      */
  /********************************************************************/
  hwndFrameMainWindow = 			      /* Save Hwnd    */
  GpfCreateTemplate( ID_MAINWINDOW,		      /* Ressource Id */
		     hmodVtest, 		      /* Ressource Md */
		     HWND_DESKTOP,		      /* Hwnd Parent  */
		     HWND_DESKTOP,		      /* Hwnd Owner   */
		     pCrtParms, 		      /* User Parms   */
		     0,0L);			      /* Reserved     */
  return (hwndFrameMainWindow);
 }
/**********************************************************************/
/* End of CreateMainWindow Function				      */
/**********************************************************************/
/**********************************************************************/




/**********************************************************************/
/**********************************************************************/
/*								      */
/*  WinProc: fnwpMainWindow					      */
/*								      */
/*  Controls the "MainWindow" Area.				      */
/*								      */
/*								      */
/**********************************************************************/

MRESULT  EXPENTRY fnwpMainWindow(
		  HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
  PGPFPARMS pGpfParms;		/* Far Pointer			*/
  MPARAM    SvMp2;		/* 2nd (packed) parms		*/
  MPARAM    SvMp1;		/* 1st (packed) parms		*/
  ULONG     SvMsg;		/* message number		*/
  MRESULT   SvMresult;		/* Mresult			*/
  USHORT    SvCommand;		/* Command From mp1 (SHORT 1)	*/
  USHORT    SvNotify;		/* Notify  From mp1 (SHORT 2)	*/
  HWND	    SvHwndControl;	/* Control hwnd 		*/
  LONG	    SvVsComponentId;	/* ValueSet Component ID	*/
  MRESULT   PmMresult;

  /*******************************************************************/
  /* Query Gpf Parameters					     */
  /*******************************************************************/
  pGpfParms = (PGPFPARMS) WinQueryWindowULong( hwnd, QWL_USER );
  if ((!pGpfParms) && (msg == WM_CREATE))
     {
      pGpfParms = malloc( sizeof(GPFPARMS) );	      /* Set Pointer*/
      WinSetWindowULong( hwnd, QWL_USER, (ULONG)pGpfParms );
      memset( pGpfParms, 0, sizeof(GPFPARMS) );       /* Clear Area */
      pGpfParms->cb = sizeof(GPFPARMS); 	      /* Set sizeof */
     }

  if (!pGpfParms)
      return GpfDefWindowProc( hwnd, msg, mp1, mp2 );

  /********************************************************************/
  /* Save Gpf Parameters					      */
  /********************************************************************/
  SvMsg = pGpfParms->msg;
  SvMp1 = pGpfParms->mp1;
  SvMp2 = pGpfParms->mp2;
  SvMresult = pGpfParms->mresult;
  SvCommand = pGpfParms->Command;
  SvNotify  = pGpfParms->Notify;
  SvHwndControl = pGpfParms->hwndControl;
  SvVsComponentId = pGpfParms->VsComponentId;

  /********************************************************************/
  /* Initialize Gpf Parameters					      */
  /********************************************************************/
  pGpfParms->hwnd    = hwnd;	       /* window handle 	      */
  pGpfParms->msg     = msg;	       /* message number	      */
  pGpfParms->mp1     = mp1;	       /* 1st (packed) parms	      */
  pGpfParms->mp2     = mp2;	       /* 2nd (packed) parms	      */
  pGpfParms->mresult = (MRESULT) FALSE; /* Mresult		      */
  pGpfParms->Command = 0;	       /* Command From mp1 (SHORT 1)  */
  pGpfParms->Notify  = 0;	       /* Notify  From mp1 (SHORT 2)  */
  PmMresult = ProcessMainWindow( pGpfParms );

  /*******************************************************************/
  /* Query Gpf Parameters					     */
  /*******************************************************************/
  pGpfParms = (PGPFPARMS) WinQueryWindowULong( hwnd, QWL_USER );
  if (pGpfParms)
     {
      /****************************************************************/
      /* Restore Gpf Parameters 				      */
      /****************************************************************/
      pGpfParms->msg   = SvMsg;
      pGpfParms->mp1   = SvMp1;
      pGpfParms->mp2   = SvMp2;
      pGpfParms->mresult   = SvMresult;
      pGpfParms->Command = SvCommand;
      pGpfParms->Notify  = SvNotify;
      pGpfParms->hwndControl  = SvHwndControl;
      pGpfParms->VsComponentId	= SvVsComponentId;
     }

  return PmMresult;
}
/**********************************************************************/
/* End of window procedure - WinProc: fnwpMainWindow		      */
/**********************************************************************/
/**********************************************************************/



/**********************************************************************/
/**********************************************************************/
/*								      */
/*  FUNCTION : ProcessMainWindow				      */
/*								      */
/*  Process "MainWindow".					      */
/*								      */
/**********************************************************************/

static MRESULT ProcessMainWindow( PGPFPARMS pGpfParms )
{

  switch(pGpfParms->msg)
  {
	/**************************************************************/
	/* Things to do when the Window is first initalized	      */
	/* This message occurs when a dialog box is being created.    */
	/**************************************************************/
   case WM_INITDLG:
	/**************************************************************/
	/*  Initialize Window 'MainWindow'			      */
	/**************************************************************/
	GpfDefWindowProc( pGpfParms->hwnd, pGpfParms->msg,
			  pGpfParms->mp1, pGpfParms->mp2 );
	/**************************************************************/
	/*  Return pGpfParms Mresult				      */
	/**************************************************************/
	return (pGpfParms->mresult);

	/**************************************************************/
	/* The application has asked for the window to be created.    */
	/**************************************************************/
   case WM_CREATE:
	pGpfParms->Options |= GPF_OP_MAINWINDOW; /* Set MainWindow    */
	pGpfParms->Options |= GPF_OP_ADJUSTSIZE; /* Set AdjustSize    */
	hwndMainWindow = pGpfParms->hwnd;		 /* Save Hwnd */
	hwndFrameMainWindow = GpfGetHwndFrame( pGpfParms->hwnd );
	pGpfParms->hmod = hmodVtest;
	pGpfParms->hab	= habMainTask;	       /* Anchor block handle */
	break;

	/**************************************************************/
	/* The application has asked for the window to be destroyed.  */
	/* Always sent to the window being destroyed after the window */
	/* has been hidden on the device, but before its children     */
	/* have been destroyed. The message is sent first to the      */
	/* window being destroyed, then to the children as they are   */
	/* destroyed. Therefore, during processing the WM_DESTROY it  */
	/* can be assumed that all the children still exist.	      */
	/**************************************************************/
   case WM_DESTROY:
	hwndFrameMainWindow = (HWND)NULL;	    /* Reset HwndFrm  */
	hwndMainWindow = (HWND)NULL;		    /* Reset Hwnd     */
	/* Destroy Template , Help Instance and GpfParms	      */
	return GpfDefWindowProc( pGpfParms->hwnd, pGpfParms->msg,
				 pGpfParms->mp1, pGpfParms->mp2 );

	/**************************************************************/
	/* The window needs painting.				      */
	/**************************************************************/
   case WM_PAINT:
	/**************************************************************/
	/* Obtain a cache PS					      */
	/**************************************************************/
	pGpfParms->hps = WinBeginPaint( pGpfParms->hwnd,
					pGpfParms->hpsBeginPaint,
					(PRECTL)&pGpfParms->rcl );
	WinFillRect(pGpfParms->hps,&pGpfParms->rcl,pGpfParms->BgColor);
	WinEndPaint( pGpfParms->hps );		/* Release cache PS   */
	return GpfDefWindowProc( pGpfParms->hwnd, pGpfParms->msg,
				 pGpfParms->mp1, pGpfParms->mp2 );

	/**************************************************************/
	/* Process ScrollBar received from the user		      */
	/**************************************************************/
   case WM_VSCROLL:
   case WM_HSCROLL:
	/* Set Command From mp1 */
	pGpfParms->Command = SHORT1FROMMP( pGpfParms->mp1 );
	/* Set Notify From mp2	*/
	pGpfParms->Notify = SHORT2FROMMP( pGpfParms->mp2 );
	if ((pGpfParms->Command != FID_VERTSCROLL) &&
	    (pGpfParms->Command != FID_HORZSCROLL))
	   CommandMainWindow( pGpfParms );    /* Process the command  */
	return (pGpfParms->mresult);

	/**************************************************************/
	/* Process Controls received from the user		      */
	/**************************************************************/
   case WM_CONTROL:
	/* Set Command From mp1 */
	pGpfParms->Command = SHORT1FROMMP( pGpfParms->mp1 );
	/* Set Notify From mp1	*/
	pGpfParms->Notify = SHORT2FROMMP( pGpfParms->mp1 );
	CommandMainWindow( pGpfParms );       /* Process the command  */
	return (pGpfParms->mresult);

	/**************************************************************/
	/* This message occurs when a control has a significant event */
	/* to its owner or when a key stroke has been		      */
	/* translated by an accelerator table into a WM_COMMAND.      */
	/**************************************************************/
   case WM_SYSCOMMAND:
   case WM_HELP:
   case WM_COMMAND:
	/* Set Command From mp1 */
	pGpfParms->Command = SHORT1FROMMP(pGpfParms->mp1);
	pGpfParms->Notify = COMMAND;	      /* Set Notify From mp1  */
	CommandMainWindow( pGpfParms );       /* Process the command  */
	if (!(pGpfParms->Flag & GPF_FL_PROCESSED))
	    return GpfDefWindowProc( pGpfParms->hwnd, pGpfParms->msg,
				     pGpfParms->mp1, pGpfParms->mp2 );
	return (pGpfParms->mresult);

	/**************************************************************/
	/* This message is sent to a frame window to indicate that    */
	/* the window is being closed by the user.		      */
	/**************************************************************/
   case WM_CLOSE:
	pGpfParms->Command = DID_CANCEL;      /* simulate CANCEL      */
	pGpfParms->Notify = COMMAND;	      /* Set Notify	      */
	CommandMainWindow( pGpfParms );       /* Process the command  */
	if (!(pGpfParms->Flag & GPF_FL_PROCESSED))
	    WinPostMsg( pGpfParms->hwnd,      /* Cause termination    */
			WM_QUIT, (MPARAM) NULL, (MPARAM) NULL);
	return (pGpfParms->mresult);

	/**************************************************************/
	/* All other messages are passed to the default procedure.    */
	/**************************************************************/
   default:
	/* Pass all other messages to the default window procedure    */
	return GpfDefWindowProc( pGpfParms->hwnd, pGpfParms->msg,
				 pGpfParms->mp1, pGpfParms->mp2 );
  }
  return ((MRESULT) FALSE);
}
/**********************************************************************/
/* End of ProcessMainWindow Function				      */
/**********************************************************************/
/**********************************************************************/




/**********************************************************************/
/**********************************************************************/
/*								      */
/*   STATIC PRIVATE FUNCTION: CommandMainWindow 		      */
/*								      */
/*   Takes appropriate action when a WM_COMMAND/WM_CONTROL message is */
/*   received by the window procedure.				      */
/*   Window "MainWindow".					      */
/*								      */
/**********************************************************************/

static VOID CommandMainWindow ( PGPFPARMS pGpfParms )
{
  pGpfParms->Flag |=  GPF_FL_PROCESSED;      /* Set Processed Flag    */
  pGpfParms->hwndControl = WinWindowFromID( pGpfParms->hwnd,
					    pGpfParms->Command );
  /* Switch according to Control chosen 			      */
  switch( pGpfParms->Command )
  {
    /******************************************************************/
    /* Name  "PushButtonSend".					      */
    /* Text  "~Send".						      */
    /******************************************************************/
    case ID_PUSHBUTTONSEND:
	 ActionPushButtonSend( pGpfParms );
	 return;
    /******************************************************************/
    /* Name  "PushButtonExit".					      */
    /* Text  "E~xit".						      */
    /******************************************************************/
    case ID_PUSHBUTTONEXIT:
	 ActionPushButtonExit( pGpfParms );
	 return;
  }
  /* Take no action for any other selections			      */
  pGpfParms->Flag &= ~GPF_FL_PROCESSED;      /* Reset Processed Flag  */
  return;
}
/**********************************************************************/
/* End of Private Function: CommandMainWindow			      */
/**********************************************************************/
/**********************************************************************/


/**********************************************************************/
/**********************************************************************/
/*								      */
/*   STATIC PRIVATE FUNCTION: ActionPushButtonSend		      */
/*								      */
/*   Takes appropriate action when a WM_COMMAND/WM_CONTROL message is */
/*   received by the window procedure.				      */
/*   Window "MainWindow".					      */
/*								      */
/**********************************************************************/

static VOID ActionPushButtonSend( PGPFPARMS pGpfParms )
{
  /* Switch according to Control chosen 			      */
  switch( pGpfParms->Notify )
  {
   case COMMAND:
   case BN_CLICKED:
   case BN_DBLCLICKED:
	send_data( pGpfParms );
	return;
  }
  /* Take no action for any other selections			      */
  return;

}
/**********************************************************************/
/* End of Private Function					      */
/**********************************************************************/
/**********************************************************************/


/**********************************************************************/
/**********************************************************************/
/*								      */
/*   STATIC PRIVATE FUNCTION: ActionPushButtonExit		      */
/*								      */
/*   Takes appropriate action when a WM_COMMAND/WM_CONTROL message is */
/*   received by the window procedure.				      */
/*   Window "MainWindow".					      */
/*								      */
/**********************************************************************/

static VOID ActionPushButtonExit( PGPFPARMS pGpfParms )
{
  /* Switch according to Control chosen 			      */
  switch( pGpfParms->Notify )
  {
   case COMMAND:
   case BN_CLICKED:
   case BN_DBLCLICKED:
	/**************************************************************/
	/* Exit selected					      */
	/**************************************************************/
	WinPostMsg( hwndMainWindow, WM_QUIT,
		    (MPARAM) NULL, (MPARAM) NULL );
	return;
  }
  /* Take no action for any other selections			      */
  return;

}
/**********************************************************************/
/* End of Private Function					      */
/**********************************************************************/
/**********************************************************************/

