/* Picosintetizzatore (dimostrativo delle funzioni di RxWav)       */
/* --------------------------------------------------------------- */
/* Descrizione:                                                    */
/* il presente programma ha lo scopo di dimostrare le funzioni     */
/* di sintesi di segnali presenti in RxWav: interpreta uno         */
/* script file, vedi "Suite2.mus", e lo trasforma in un file       */
/* audio (.wav)                                                    */
/* La sintassi e' molto semplice:                                  */
/*   mus file_di_script.mus file_di_output.wav  [inizio fine]      */
/*                                                                 */
/* Il formato del file .mus credo che risulti essere autodocu-     */
/* mentante.                                                       */
/*                                                                 */
/* --------------------------------------------------------------- */
/* Prova a:                                                        */
/* ---> ascoltare Suite2.mp3 e a risintetizzarla con Mus.cmd       */
/* ---> cambiare l'intonazione della scala ....                    */
/* ---> modificare i parametri di sintesi ...                      */
/*                                                                 */
/* --------------------------------------------------------------- */
/* Buon divertimento                                               */
/*   G.V.                             (27/4/2000)                  */
/* --------------------------------------------------------------- */

parse arg FileInput FileOutput BattutaInizio BattutaFine
if FileInput = '' then ErrFine(100)
if FileOutput = '' then ErrFine(200)
if BattutaInizio = '' then BattutaInizio = 1
if BattutaFine = '' then BattutaFine = 999

call LeggiParametri(FileInput)

rcy = Scala(TipoScala)
if rcy > 4 then ErrFine(103)


MaxOffset = 0
Voce = 1
Ottava = 1
Durata = 'CROMA'

LINEIN(FileInput,1,0)
do while LINES(FileInput)
   parse upper value LINEIN(FileInput) with riga
   if SUBSTR(riga,1,1) = '.' then do
      riga = SUBSTR(riga,2)
      parse value riga with tNota ',' tOttava ',' tDurata ',' tVoce ',' tVolume
      if tVoce \= '' then do
         Voce = tVoce
         end
      if tNota \= '' then Nota = tNota
      if tOttava \= '' then Ottava = tOttava
      if tDurata \= '' then do
         Durata = tDurata
         end
      if tVolume \= '' then Volume = tVolume
      SELECT
         WHEN VALUE('Nota') = 'LA'    THEN freq = LA
         WHEN VALUE('Nota') = 'LAD'   THEN freq = LAD
         WHEN VALUE('Nota') = 'SIB'   THEN freq = SIB
         WHEN VALUE('Nota') = 'SI'    THEN freq = SI
         WHEN VALUE('Nota') = 'DO'    THEN freq = DO
         WHEN VALUE('Nota') = 'DOD'   THEN freq = DOD
         WHEN VALUE('Nota') = 'REB'   THEN freq = REB
         WHEN VALUE('Nota') = 'RE'    THEN freq = RE
         WHEN VALUE('Nota') = 'RED'   THEN freq = RED
         WHEN VALUE('Nota') = 'MIB'   THEN freq = MIB
         WHEN VALUE('Nota') = 'MI'    THEN freq = MI
         WHEN VALUE('Nota') = 'FA'    THEN freq = FA
         WHEN VALUE('Nota') = 'FAD'   THEN freq = FAD
         WHEN VALUE('Nota') = 'SOLB'  THEN freq = SOLB
         WHEN VALUE('Nota') = 'SOL'   THEN freq = SOL
         WHEN VALUE('Nota') = 'SOLD'  THEN freq = SOLD
         WHEN VALUE('Nota') = 'LAB'   THEN freq = LAB
         WHEN VALUE('Nota') = 'PAUSA' THEN freq = 0
         OTHERWISE
           say 'Valore sconosciuto !'
           say '  Voce    :' Voce
           say '  Battuta :' NBatt
           return 12
         END
      end
   if SUBSTR(riga,1,1) = '\' then do
      parse value riga with '\' NBatt
      Offset = (NBatt - BattutaInizio) * DurataBattuta + 10
      end
   end

/* BEEP(440,300) */
MaxOffset = 0
Voce = 1
Ottava = 1
Durata = 'CROMA'

LINEIN(FileInput,1,0)
do while LINES(FileInput)
   parse upper value LINEIN(FileInput) with riga
   if SUBSTR(riga,1,1) = '.' then do
      riga = SUBSTR(riga,2)
      parse value riga with tNota ',' tOttava ',' tDurata ',' tVoce ',' tVolume
      if tVoce \= '' then do
         Voce = tVoce
         say Voce '^ voce <========================'
         end
      if tNota \= '' then Nota = tNota
      if tOttava \= '' then Ottava = tOttava
      if tDurata \= '' then do
         Durata = tDurata
         if Offset > 0 then say '    ' Durata
         end
      if tVolume \= '' then Volume = tVolume
      SELECT
         WHEN VALUE('Nota') = 'LA'    THEN freq = LA
         WHEN VALUE('Nota') = 'LAD'   THEN freq = LAD
         WHEN VALUE('Nota') = 'SIB'   THEN freq = SIB
         WHEN VALUE('Nota') = 'SI'    THEN freq = SI
         WHEN VALUE('Nota') = 'DO'    THEN freq = DO
         WHEN VALUE('Nota') = 'DOD'   THEN freq = DOD
         WHEN VALUE('Nota') = 'REB'   THEN freq = REB
         WHEN VALUE('Nota') = 'RE'    THEN freq = RE
         WHEN VALUE('Nota') = 'RED'   THEN freq = RED
         WHEN VALUE('Nota') = 'MIB'   THEN freq = MIB
         WHEN VALUE('Nota') = 'MI'    THEN freq = MI
         WHEN VALUE('Nota') = 'FA'    THEN freq = FA
         WHEN VALUE('Nota') = 'FAD'   THEN freq = FAD
         WHEN VALUE('Nota') = 'SOLB'  THEN freq = SOLB
         WHEN VALUE('Nota') = 'SOL'   THEN freq = SOL
         WHEN VALUE('Nota') = 'SOLD'  THEN freq = SOLD
         WHEN VALUE('Nota') = 'LAB'   THEN freq = LAB
         WHEN VALUE('Nota') = 'PAUSA' THEN freq = 0
         OTHERWISE
           say 'Valore sconosciuto !'
           return 12
         END
      if (NBatt >= BattutaInizio) & (NBatt <= BattutaFine) then do
         rcy = EseguiNota(DurataBreve, Offset, freq, Ottava, Durata, Sinistro, Destro, Voce, WTrac)
         if Offset > 0 then say '               ' Nota '  Ottava #' Ottava
         if Offset > MaxOffset then MaxOffset = Offset
         end
      end
   if SUBSTR(riga,1,1) = '\' then do
      parse value riga with '\' NBatt
      Offset = (NBatt - BattutaInizio) * DurataBattuta + 10
      if Offset > 0 then do
         say ''
         say '***> Battuta' NBatt '    offset' Offset 'ms.'
         end
      end
   end




/*
BEEP(440,300)
BEEP(660,300)
BEEP(880,300)
*/
rcy = Term(FileOutput)
if rcy > 4 then ErrFine(102)
call play 'FILE=' || FileOutput
say 'Finito !!!'

return 0












/*******************************************************************/
ErrFine:
parse arg ErrLev
say 'Errore:' ErrLev
pull kato
exit





/*******************************************************************/
EseguiNota: procedure expose Offset
parse arg DurataBreve, Offset, freq, Ottava, Valore, Sinistro, Destro, Voce, WTrac

SELECT
   WHEN Valore = 'SEMIBREVE'      THEN MSec = DurataBreve
   WHEN Valore = 'MINIMA'         THEN MSec = DurataBreve / 2
   WHEN Valore = 'SEMIMINIMA'     THEN MSec = DurataBreve / 4
   WHEN Valore = 'CROMA'          THEN MSec = DurataBreve / 8
   WHEN Valore = 'SEMICROMA'      THEN MSec = DurataBreve / 16
   WHEN Valore = 'BISCROMA'       THEN MSec = DurataBreve / 32
   WHEN Valore = 'SEMIBISCROMA'   THEN MSec = DurataBreve / 64
   OTHERWISE
     say 'Valore sconosciuto !'
     return 12
   END

SELECT
   WHEN Ottava = 1 THEN freq = freq / 8
   WHEN Ottava = 2 THEN freq = freq / 4
   WHEN Ottava = 3 THEN freq = freq / 2
   WHEN Ottava = 4 THEN freq = freq
   WHEN Ottava = 5 THEN freq = freq * 2
   WHEN Ottava = 6 THEN freq = freq * 4
   WHEN Ottava = 7 THEN freq = freq * 8
   OTHERWISE
     say 'Ottava fouori range !'
     return 12
   END

rcy = 0
if freq > 0 then do
   if voce = 0 then rcy = Str01(freq, 50, MSec, Offset, Sinistro, Destro, 50, WTrac)
   if voce = 1 then rcy = Str01(freq, 25, MSec, Offset, Sinistro, Destro, 30, WTrac)
   if voce = 2 then rcy = Str01(freq, 31, MSec, Offset, Sinistro, Destro, 70, WTrac)
   end
if rcy > 0 then ErrFine(108)
Offset = Offset + MSec

return 0


/*******************************************************************/
LeggiParametri: procedure expose DurataBreve DurataBattuta TipoScala Destro Sinistro WTrac
parse arg FileInput

TipoScala = 'Temperata'
DurataBase = 1000 / 44.1
Battuta = 1
DurataTot = 1

LINEIN(FileInput,1,0)
do while LINES(FileInput)
   parse upper value LINEIN(FileInput) with riga
   if SUBSTR(riga,1,1) = ':' then do
      if POS('SEMIMINIMA', riga)>0 then do
         parse value riga with '=' DurataBase
         DurataBreve = 60000 / DurataBase * 4
         end
      if POS('CROMA', riga)>0 then do
         parse value riga with '=' DurataBase
         DurataBreve = 60000 / DurataBase * 8
         end
      if POS('SEMICROMA', riga)>0 then do
         parse value riga with '=' DurataBase
         DurataBreve = 60000 / DurataBase * 16
         end
      if POS('BATTUTA', riga)>0 then parse value riga with '=' Battuta
      if POS('SCALA', riga)>0 then parse value riga with '=' TipoScala
      if POS('DURATA', riga)>0 then parse value riga with '=' DurataTot
      end
   end

DurataBattuta = (60000 / DurataBase) * Battuta;

rcy = Init(DurataTot)
if rcy > 4 then ErrFine(109)

say 'Parametri:'
say '   Durata battuta = ' DurataBattuta
say '   Durata base    = ' DurataBase
say '   Durata breve   = ' DurataBreve
say '   Durata totale  = ' DurataTot
say '   Tipo scala     = ' TipoScala

return 0



/*******************************************************************/
Init: procedure expose Destro Sinistro WTrac
parse arg DimTraccie

rcy = RxFuncAdd('WavLoadFuncs', 'RxWav', 'WavLoadFuncs')
if rcy>1 then return 12

call WavLoadFuncs

WTrac = WavAllocTrac(441000)

Sinistro = WavAllocTrac(DimTraccie * 44100)
Destro = WavAllocTrac(DimTraccie * 44100)
say 'Inizializzazione completata'
say '    ws=' WTrac
say '    sx=' Sinistro
say '    dx=' Destro

return 0

/*******************************************************************/
Term:
parse arg NomeFile

say 'Scrive file' NomeFile
say 'Durata in secondi ' (MaxOffset / 1000)
say 'Sinistro:' Sinistro
rcy = WavWriteStereo( NomeFile, Sinistro , Destro,( MaxOffset * 44.1) + 100)
if rcy>1 then ErrFine(301)

/* call WavDropFuncs */

return 0

/*******************************************************************/
Scala:procedure expose la lad sib si do dod reb re red mib mi fa fad solb sol sold lab pausa
parse upper arg TipoScala

 SELECT
    WHEN TipoScala = 'TEMPERATA'
       THEN do
          la  = 440
          lad = 466.1638
          sib = 466.1638
          si  = 493.8833
          do  = 523.2512
          dod = 554.3652
          reb = 554.3652
          re  = 587.3295
          red = 622.254
          mib = 622.254
          mi  = 659.2551
          fa  = 698.4565
          fad = 739.9888
          solb = 739.9888
          sol = 783.9908
          sold = 830.6094
          lab = 830.6094
          end
    WHEN TipoScala = 'NATURALE'
       THEN do
          la  = 468.6181
          lad = 499.0975
          si  = 531.5593
          do  = 566.1326
          dod = 602.9544
          re  = 642.1713
          red = 683.9388
          mi  = 728.4229
          fa  = 775.8003
          fad = 826.2592
          sol = 880
          sold = 937.2361
          sib = lad
          reb = dod
          mib = red
          solb = fad
          lab = sold
          end
 OTHERWISE
    say 'Tipo di scala sconosciuto !'
    return 12
 END

pausa = 0

return 0



